/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.models;

import com.sun.org.apache.xerces.internal.impl.dtd.models.CMNode;
import com.sun.org.apache.xerces.internal.impl.xs.XSComplexTypeDecl;
import com.sun.org.apache.xerces.internal.impl.xs.XSDeclarationPool;
import com.sun.org.apache.xerces.internal.impl.xs.XSElementDecl;
import com.sun.org.apache.xerces.internal.impl.xs.XSModelGroupImpl;
import com.sun.org.apache.xerces.internal.impl.xs.XSParticleDecl;
import com.sun.org.apache.xerces.internal.impl.xs.models.CMNodeFactory;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSAllCM;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMBinOp;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMLeaf;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMUniOp;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSCMValidator;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSDFACM;
import com.sun.org.apache.xerces.internal.impl.xs.models.XSEmptyCM;

public class CMBuilder {
    private XSDeclarationPool fDeclPool = null;
    private static XSEmptyCM fEmptyCM = new XSEmptyCM();
    private int fLeafCount;
    private int fParticleCount;
    private CMNodeFactory fNodeFactory;

    public CMBuilder(CMNodeFactory cMNodeFactory) {
        this.fNodeFactory = cMNodeFactory;
    }

    public void setDeclPool(XSDeclarationPool xSDeclarationPool) {
        this.fDeclPool = xSDeclarationPool;
    }

    public XSCMValidator getContentModel(XSComplexTypeDecl xSComplexTypeDecl, boolean bl) {
        short s = xSComplexTypeDecl.getContentType();
        if (s == 1 || s == 0) {
            return null;
        }
        XSParticleDecl xSParticleDecl = (XSParticleDecl)xSComplexTypeDecl.getParticle();
        if (xSParticleDecl == null) {
            return fEmptyCM;
        }
        XSCMValidator xSCMValidator = null;
        xSCMValidator = xSParticleDecl.fType == 3 && ((XSModelGroupImpl)xSParticleDecl.fValue).fCompositor == 103 ? this.createAllCM(xSParticleDecl) : this.createDFACM(xSParticleDecl, bl);
        this.fNodeFactory.resetNodeCount();
        if (xSCMValidator == null) {
            xSCMValidator = fEmptyCM;
        }
        return xSCMValidator;
    }

    XSCMValidator createAllCM(XSParticleDecl xSParticleDecl) {
        if (xSParticleDecl.fMaxOccurs == 0) {
            return null;
        }
        XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
        XSAllCM xSAllCM = new XSAllCM(xSParticleDecl.fMinOccurs == 0, xSModelGroupImpl.fParticleCount);
        for (int i = 0; i < xSModelGroupImpl.fParticleCount; ++i) {
            xSAllCM.addElement((XSElementDecl)xSModelGroupImpl.fParticles[i].fValue, xSModelGroupImpl.fParticles[i].fMinOccurs == 0);
        }
        return xSAllCM;
    }

    XSCMValidator createDFACM(XSParticleDecl xSParticleDecl, boolean bl) {
        CMNode cMNode;
        this.fLeafCount = 0;
        this.fParticleCount = 0;
        CMNode cMNode2 = cMNode = this.useRepeatingLeafNodes(xSParticleDecl) ? this.buildCompactSyntaxTree(xSParticleDecl) : this.buildSyntaxTree(xSParticleDecl, bl, true);
        if (cMNode == null) {
            return null;
        }
        return new XSDFACM(cMNode, this.fLeafCount);
    }

    private CMNode buildSyntaxTree(XSParticleDecl xSParticleDecl, boolean bl, boolean bl2) {
        int n = xSParticleDecl.fMaxOccurs;
        int n2 = xSParticleDecl.fMinOccurs;
        boolean bl3 = false;
        if (bl) {
            if (n2 > 1) {
                if (n > n2 || xSParticleDecl.getMaxOccursUnbounded()) {
                    n2 = 1;
                    bl3 = true;
                } else {
                    n2 = 2;
                    bl3 = true;
                }
            }
            if (n > 1) {
                n = 2;
                bl3 = true;
            }
        }
        short s = xSParticleDecl.fType;
        CMNode cMNode = null;
        if (s == 2 || s == 1) {
            cMNode = this.fNodeFactory.getCMLeafNode(xSParticleDecl.fType, xSParticleDecl.fValue, this.fParticleCount++, this.fLeafCount++);
            if ((cMNode = this.expandContentModel(cMNode, n2, n, bl2)) != null) {
                cMNode.setIsCompactUPAModel(bl3);
            }
        } else if (s == 3) {
            XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
            CMNode cMNode2 = null;
            boolean bl4 = false;
            for (int i = 0; i < xSModelGroupImpl.fParticleCount; ++i) {
                cMNode2 = this.buildSyntaxTree(xSModelGroupImpl.fParticles[i], bl, bl2 && n2 == 1 && n == 1 && (xSModelGroupImpl.fCompositor == 102 || xSModelGroupImpl.fParticleCount == 1));
                if (cMNode2 == null) continue;
                bl3 |= cMNode2.isCompactedForUPA();
                if (cMNode == null) {
                    cMNode = cMNode2;
                    continue;
                }
                cMNode = this.fNodeFactory.getCMBinOpNode(xSModelGroupImpl.fCompositor, cMNode, cMNode2);
                bl4 = true;
            }
            if (cMNode != null) {
                if (xSModelGroupImpl.fCompositor == 101 && !bl4 && xSModelGroupImpl.fParticleCount > 1) {
                    cMNode = this.fNodeFactory.getCMUniOpNode(5, cMNode);
                }
                cMNode = this.expandContentModel(cMNode, n2, n, false);
                cMNode.setIsCompactUPAModel(bl3);
            }
        }
        return cMNode;
    }

    private CMNode expandContentModel(CMNode cMNode, int n, int n2, boolean bl) {
        CMNode cMNode2 = null;
        if (n == 1 && n2 == 1) {
            cMNode2 = cMNode;
        } else if (n == 0 && n2 == 1) {
            cMNode2 = this.fNodeFactory.getCMUniOpNode(5, cMNode);
        } else if (n == 0 && n2 == -1) {
            cMNode2 = this.fNodeFactory.getCMUniOpNode(4, cMNode);
        } else if (n == 1 && n2 == -1) {
            cMNode2 = this.fNodeFactory.getCMUniOpNode(6, cMNode);
        } else if (bl && cMNode.type() == 1 || cMNode.type() == 2) {
            cMNode2 = this.fNodeFactory.getCMUniOpNode(n == 0 ? 4 : 6, cMNode);
            cMNode2.setUserData(new int[]{n, n2});
        } else if (n2 == -1) {
            cMNode2 = this.fNodeFactory.getCMUniOpNode(6, cMNode);
            cMNode2 = this.fNodeFactory.getCMBinOpNode(102, this.multiNodes(cMNode, n - 1, true), cMNode2);
        } else {
            if (n > 0) {
                cMNode2 = this.multiNodes(cMNode, n, false);
            }
            if (n2 > n) {
                cMNode = this.fNodeFactory.getCMUniOpNode(5, cMNode);
                cMNode2 = cMNode2 == null ? this.multiNodes(cMNode, n2 - n, false) : this.fNodeFactory.getCMBinOpNode(102, cMNode2, this.multiNodes(cMNode, n2 - n, true));
            }
        }
        return cMNode2;
    }

    private CMNode multiNodes(CMNode cMNode, int n, boolean bl) {
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return bl ? this.copyNode(cMNode) : cMNode;
        }
        int n2 = n / 2;
        return this.fNodeFactory.getCMBinOpNode(102, this.multiNodes(cMNode, n2, bl), this.multiNodes(cMNode, n - n2, true));
    }

    private CMNode copyNode(CMNode cMNode) {
        int n = cMNode.type();
        if (n == 101 || n == 102) {
            XSCMBinOp xSCMBinOp = (XSCMBinOp)cMNode;
            cMNode = this.fNodeFactory.getCMBinOpNode(n, this.copyNode(xSCMBinOp.getLeft()), this.copyNode(xSCMBinOp.getRight()));
        } else if (n == 4 || n == 6 || n == 5) {
            XSCMUniOp xSCMUniOp = (XSCMUniOp)cMNode;
            cMNode = this.fNodeFactory.getCMUniOpNode(n, this.copyNode(xSCMUniOp.getChild()));
        } else if (n == 1 || n == 2) {
            XSCMLeaf xSCMLeaf = (XSCMLeaf)cMNode;
            cMNode = this.fNodeFactory.getCMLeafNode(xSCMLeaf.type(), xSCMLeaf.getLeaf(), xSCMLeaf.getParticleId(), this.fLeafCount++);
        }
        return cMNode;
    }

    private CMNode buildCompactSyntaxTree(XSParticleDecl xSParticleDecl) {
        int n = xSParticleDecl.fMaxOccurs;
        int n2 = xSParticleDecl.fMinOccurs;
        short s = xSParticleDecl.fType;
        CMNode cMNode = null;
        if (s == 2 || s == 1) {
            return this.buildCompactSyntaxTree2(xSParticleDecl, n2, n);
        }
        if (s == 3) {
            XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
            if (xSModelGroupImpl.fParticleCount == 1 && (n2 != 1 || n != 1)) {
                return this.buildCompactSyntaxTree2(xSModelGroupImpl.fParticles[0], n2, n);
            }
            CMNode cMNode2 = null;
            int n3 = 0;
            for (int i = 0; i < xSModelGroupImpl.fParticleCount; ++i) {
                cMNode2 = this.buildCompactSyntaxTree(xSModelGroupImpl.fParticles[i]);
                if (cMNode2 == null) continue;
                ++n3;
                cMNode = cMNode == null ? cMNode2 : this.fNodeFactory.getCMBinOpNode(xSModelGroupImpl.fCompositor, cMNode, cMNode2);
            }
            if (cMNode != null && xSModelGroupImpl.fCompositor == 101 && n3 < xSModelGroupImpl.fParticleCount) {
                cMNode = this.fNodeFactory.getCMUniOpNode(5, cMNode);
            }
        }
        return cMNode;
    }

    private CMNode buildCompactSyntaxTree2(XSParticleDecl xSParticleDecl, int n, int n2) {
        CMNode cMNode = null;
        if (n == 1 && n2 == 1) {
            cMNode = this.fNodeFactory.getCMLeafNode(xSParticleDecl.fType, xSParticleDecl.fValue, this.fParticleCount++, this.fLeafCount++);
        } else if (n == 0 && n2 == 1) {
            cMNode = this.fNodeFactory.getCMLeafNode(xSParticleDecl.fType, xSParticleDecl.fValue, this.fParticleCount++, this.fLeafCount++);
            cMNode = this.fNodeFactory.getCMUniOpNode(5, cMNode);
        } else if (n == 0 && n2 == -1) {
            cMNode = this.fNodeFactory.getCMLeafNode(xSParticleDecl.fType, xSParticleDecl.fValue, this.fParticleCount++, this.fLeafCount++);
            cMNode = this.fNodeFactory.getCMUniOpNode(4, cMNode);
        } else if (n == 1 && n2 == -1) {
            cMNode = this.fNodeFactory.getCMLeafNode(xSParticleDecl.fType, xSParticleDecl.fValue, this.fParticleCount++, this.fLeafCount++);
            cMNode = this.fNodeFactory.getCMUniOpNode(6, cMNode);
        } else {
            cMNode = this.fNodeFactory.getCMRepeatingLeafNode(xSParticleDecl.fType, xSParticleDecl.fValue, n, n2, this.fParticleCount++, this.fLeafCount++);
            cMNode = n == 0 ? this.fNodeFactory.getCMUniOpNode(4, cMNode) : this.fNodeFactory.getCMUniOpNode(6, cMNode);
        }
        return cMNode;
    }

    private boolean useRepeatingLeafNodes(XSParticleDecl xSParticleDecl) {
        int n = xSParticleDecl.fMaxOccurs;
        int n2 = xSParticleDecl.fMinOccurs;
        short s = xSParticleDecl.fType;
        if (s == 3) {
            XSModelGroupImpl xSModelGroupImpl = (XSModelGroupImpl)xSParticleDecl.fValue;
            if (n2 != 1 || n != 1) {
                if (xSModelGroupImpl.fParticleCount == 1) {
                    XSParticleDecl xSParticleDecl2 = xSModelGroupImpl.fParticles[0];
                    short s2 = xSParticleDecl2.fType;
                    return (s2 == 1 || s2 == 2) && xSParticleDecl2.fMinOccurs == 1 && xSParticleDecl2.fMaxOccurs == 1;
                }
                return xSModelGroupImpl.fParticleCount == 0;
            }
            for (int i = 0; i < xSModelGroupImpl.fParticleCount; ++i) {
                if (this.useRepeatingLeafNodes(xSModelGroupImpl.fParticles[i])) continue;
                return false;
            }
        }
        return true;
    }
}

