/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantCP;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantFieldref;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantInterfaceMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantInvokeDynamic;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodHandle;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodType;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantModule;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantPackage;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.MethodGen;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import java.util.HashMap;
import java.util.Map;

public class ConstantPoolGen {
    public static final int CONSTANT_POOL_SIZE = 65536;
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private int size;
    private Constant[] constants;
    private int index = 1;
    private static final String METHODREF_DELIM = ":";
    private static final String IMETHODREF_DELIM = "#";
    private static final String FIELDREF_DELIM = "&";
    private static final String NAT_DELIM = "%";
    private final Map<String, Index> stringTable = new HashMap<String, Index>();
    private final Map<String, Index> classTable = new HashMap<String, Index>();
    private final Map<String, Index> utf8Table = new HashMap<String, Index>();
    private final Map<String, Index> natTable = new HashMap<String, Index>();
    private final Map<String, Index> cpTable = new HashMap<String, Index>();

    public ConstantPoolGen(Constant[] constantArray) {
        StringBuilder stringBuilder = new StringBuilder(256);
        this.size = Math.min(Math.max(256, constantArray.length + 64), 65536);
        this.constants = new Constant[this.size];
        System.arraycopy(constantArray, 0, this.constants, 0, constantArray.length);
        if (constantArray.length > 0) {
            this.index = constantArray.length;
        }
        for (int i = 1; i < this.index; ++i) {
            Object object;
            Object object2;
            Object object3;
            Constant constant;
            Constant constant2 = this.constants[i];
            if (constant2 instanceof ConstantString) {
                constant = (ConstantString)constant2;
                object3 = (ConstantUtf8)this.constants[((ConstantString)constant).getStringIndex()];
                object2 = ((ConstantUtf8)object3).getBytes();
                if (this.stringTable.containsKey(object2)) continue;
                this.stringTable.put((String)object2, new Index(i));
                continue;
            }
            if (constant2 instanceof ConstantClass) {
                constant = (ConstantClass)constant2;
                object3 = (ConstantUtf8)this.constants[((ConstantClass)constant).getNameIndex()];
                object2 = ((ConstantUtf8)object3).getBytes();
                if (this.classTable.containsKey(object2)) continue;
                this.classTable.put((String)object2, new Index(i));
                continue;
            }
            if (constant2 instanceof ConstantNameAndType) {
                constant = (ConstantNameAndType)constant2;
                object3 = (ConstantUtf8)this.constants[((ConstantNameAndType)constant).getNameIndex()];
                object2 = (ConstantUtf8)this.constants[((ConstantNameAndType)constant).getSignatureIndex()];
                stringBuilder.append(((ConstantUtf8)object3).getBytes());
                stringBuilder.append(NAT_DELIM);
                stringBuilder.append(((ConstantUtf8)object2).getBytes());
                object = stringBuilder.toString();
                stringBuilder.delete(0, stringBuilder.length());
                if (this.natTable.containsKey(object)) continue;
                this.natTable.put((String)object, new Index(i));
                continue;
            }
            if (constant2 instanceof ConstantUtf8) {
                constant = (ConstantUtf8)constant2;
                object3 = ((ConstantUtf8)constant).getBytes();
                if (this.utf8Table.containsKey(object3)) continue;
                this.utf8Table.put((String)object3, new Index(i));
                continue;
            }
            if (constant2 instanceof ConstantCP) {
                constant = (ConstantCP)constant2;
                if (constant2 instanceof ConstantInvokeDynamic) {
                    object3 = Integer.toString(((ConstantInvokeDynamic)constant).getBootstrapMethodAttrIndex());
                } else {
                    object = (ConstantClass)this.constants[((ConstantCP)constant).getClassIndex()];
                    object2 = (ConstantUtf8)this.constants[((ConstantClass)object).getNameIndex()];
                    object3 = ((ConstantUtf8)object2).getBytes().replace('/', '.');
                }
                object = (ConstantNameAndType)this.constants[((ConstantCP)constant).getNameAndTypeIndex()];
                object2 = (ConstantUtf8)this.constants[((ConstantNameAndType)object).getNameIndex()];
                String string = ((ConstantUtf8)object2).getBytes();
                object2 = (ConstantUtf8)this.constants[((ConstantNameAndType)object).getSignatureIndex()];
                String string2 = ((ConstantUtf8)object2).getBytes();
                String string3 = METHODREF_DELIM;
                if (constant2 instanceof ConstantInterfaceMethodref) {
                    string3 = IMETHODREF_DELIM;
                } else if (constant2 instanceof ConstantFieldref) {
                    string3 = FIELDREF_DELIM;
                }
                stringBuilder.append((String)object3);
                stringBuilder.append(string3);
                stringBuilder.append(string);
                stringBuilder.append(string3);
                stringBuilder.append(string2);
                String string4 = stringBuilder.toString();
                stringBuilder.delete(0, stringBuilder.length());
                if (this.cpTable.containsKey(string4)) continue;
                this.cpTable.put(string4, new Index(i));
                continue;
            }
            if (constant2 != null && !(constant2 instanceof ConstantInteger) && !(constant2 instanceof ConstantLong) && !(constant2 instanceof ConstantFloat) && !(constant2 instanceof ConstantDouble) && !(constant2 instanceof ConstantMethodType) && !(constant2 instanceof ConstantMethodHandle) && !(constant2 instanceof ConstantModule) && !(constant2 instanceof ConstantPackage)) assert (false) : "Unexpected constant type: " + constant2.getClass().getName();
        }
    }

    public ConstantPoolGen(ConstantPool constantPool) {
        this(constantPool.getConstantPool());
    }

    public ConstantPoolGen() {
        this.size = 256;
        this.constants = new Constant[this.size];
    }

    protected void adjustSize() {
        if (this.index + 3 >= 65536) {
            throw new RuntimeException("The number of constants " + (this.index + 3) + " is over the size of the constant pool: " + 65535);
        }
        if (this.index + 3 >= this.size) {
            Constant[] constantArray = this.constants;
            this.size *= 2;
            this.size = Math.min(this.size, 65536);
            this.constants = new Constant[this.size];
            System.arraycopy(constantArray, 0, this.constants, 0, this.index);
        }
    }

    public int lookupString(String string) {
        Index index = this.stringTable.get(string);
        return index != null ? index.index : -1;
    }

    public int addString(String string) {
        int n = this.lookupString(string);
        if (n != -1) {
            return n;
        }
        int n2 = this.addUtf8(string);
        this.adjustSize();
        ConstantString constantString = new ConstantString(n2);
        n = this.index;
        this.constants[this.index++] = constantString;
        if (!this.stringTable.containsKey(string)) {
            this.stringTable.put(string, new Index(n));
        }
        return n;
    }

    public int lookupClass(String string) {
        Index index = this.classTable.get(string.replace('.', '/'));
        return index != null ? index.index : -1;
    }

    private int addClass_(String string) {
        int n = this.lookupClass(string);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        ConstantClass constantClass = new ConstantClass(this.addUtf8(string));
        n = this.index;
        this.constants[this.index++] = constantClass;
        if (!this.classTable.containsKey(string)) {
            this.classTable.put(string, new Index(n));
        }
        return n;
    }

    public int addClass(String string) {
        return this.addClass_(string.replace('.', '/'));
    }

    public int addClass(ObjectType objectType) {
        return this.addClass(objectType.getClassName());
    }

    public int addArrayClass(ArrayType arrayType) {
        return this.addClass_(arrayType.getSignature());
    }

    public int lookupInteger(int n) {
        for (int i = 1; i < this.index; ++i) {
            ConstantInteger constantInteger;
            if (!(this.constants[i] instanceof ConstantInteger) || (constantInteger = (ConstantInteger)this.constants[i]).getBytes() != n) continue;
            return i;
        }
        return -1;
    }

    public int addInteger(int n) {
        int n2 = this.lookupInteger(n);
        if (n2 != -1) {
            return n2;
        }
        this.adjustSize();
        n2 = this.index;
        this.constants[this.index++] = new ConstantInteger(n);
        return n2;
    }

    public int lookupFloat(float f) {
        int n = Float.floatToIntBits(f);
        for (int i = 1; i < this.index; ++i) {
            ConstantFloat constantFloat;
            if (!(this.constants[i] instanceof ConstantFloat) || Float.floatToIntBits((constantFloat = (ConstantFloat)this.constants[i]).getBytes()) != n) continue;
            return i;
        }
        return -1;
    }

    public int addFloat(float f) {
        int n = this.lookupFloat(f);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        n = this.index;
        this.constants[this.index++] = new ConstantFloat(f);
        return n;
    }

    public int lookupUtf8(String string) {
        Index index = this.utf8Table.get(string);
        return index != null ? index.index : -1;
    }

    public int addUtf8(String string) {
        int n = this.lookupUtf8(string);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        n = this.index;
        this.constants[this.index++] = new ConstantUtf8(string);
        if (!this.utf8Table.containsKey(string)) {
            this.utf8Table.put(string, new Index(n));
        }
        return n;
    }

    public int lookupLong(long l) {
        for (int i = 1; i < this.index; ++i) {
            ConstantLong constantLong;
            if (!(this.constants[i] instanceof ConstantLong) || (constantLong = (ConstantLong)this.constants[i]).getBytes() != l) continue;
            return i;
        }
        return -1;
    }

    public int addLong(long l) {
        int n = this.lookupLong(l);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        n = this.index;
        this.constants[this.index] = new ConstantLong(l);
        this.index += 2;
        return n;
    }

    public int lookupDouble(double d) {
        long l = Double.doubleToLongBits(d);
        for (int i = 1; i < this.index; ++i) {
            ConstantDouble constantDouble;
            if (!(this.constants[i] instanceof ConstantDouble) || Double.doubleToLongBits((constantDouble = (ConstantDouble)this.constants[i]).getBytes()) != l) continue;
            return i;
        }
        return -1;
    }

    public int addDouble(double d) {
        int n = this.lookupDouble(d);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        n = this.index;
        this.constants[this.index] = new ConstantDouble(d);
        this.index += 2;
        return n;
    }

    public int lookupNameAndType(String string, String string2) {
        Index index = this.natTable.get(string + NAT_DELIM + string2);
        return index != null ? index.index : -1;
    }

    public int addNameAndType(String string, String string2) {
        int n = this.lookupNameAndType(string, string2);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        int n2 = this.addUtf8(string);
        int n3 = this.addUtf8(string2);
        n = this.index;
        this.constants[this.index++] = new ConstantNameAndType(n2, n3);
        String string3 = string + NAT_DELIM + string2;
        if (!this.natTable.containsKey(string3)) {
            this.natTable.put(string3, new Index(n));
        }
        return n;
    }

    public int lookupMethodref(String string, String string2, String string3) {
        Index index = this.cpTable.get(string + METHODREF_DELIM + string2 + METHODREF_DELIM + string3);
        return index != null ? index.index : -1;
    }

    public int lookupMethodref(MethodGen methodGen) {
        return this.lookupMethodref(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public int addMethodref(String string, String string2, String string3) {
        int n = this.lookupMethodref(string, string2, string3);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        int n2 = this.addNameAndType(string2, string3);
        int n3 = this.addClass(string);
        n = this.index;
        this.constants[this.index++] = new ConstantMethodref(n3, n2);
        String string4 = string + METHODREF_DELIM + string2 + METHODREF_DELIM + string3;
        if (!this.cpTable.containsKey(string4)) {
            this.cpTable.put(string4, new Index(n));
        }
        return n;
    }

    public int addMethodref(MethodGen methodGen) {
        return this.addMethodref(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public int lookupInterfaceMethodref(String string, String string2, String string3) {
        Index index = this.cpTable.get(string + IMETHODREF_DELIM + string2 + IMETHODREF_DELIM + string3);
        return index != null ? index.index : -1;
    }

    public int lookupInterfaceMethodref(MethodGen methodGen) {
        return this.lookupInterfaceMethodref(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public int addInterfaceMethodref(String string, String string2, String string3) {
        int n = this.lookupInterfaceMethodref(string, string2, string3);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        int n2 = this.addClass(string);
        int n3 = this.addNameAndType(string2, string3);
        n = this.index;
        this.constants[this.index++] = new ConstantInterfaceMethodref(n2, n3);
        String string4 = string + IMETHODREF_DELIM + string2 + IMETHODREF_DELIM + string3;
        if (!this.cpTable.containsKey(string4)) {
            this.cpTable.put(string4, new Index(n));
        }
        return n;
    }

    public int addInterfaceMethodref(MethodGen methodGen) {
        return this.addInterfaceMethodref(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public int lookupFieldref(String string, String string2, String string3) {
        Index index = this.cpTable.get(string + FIELDREF_DELIM + string2 + FIELDREF_DELIM + string3);
        return index != null ? index.index : -1;
    }

    public int addFieldref(String string, String string2, String string3) {
        int n = this.lookupFieldref(string, string2, string3);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        int n2 = this.addClass(string);
        int n3 = this.addNameAndType(string2, string3);
        n = this.index;
        this.constants[this.index++] = new ConstantFieldref(n2, n3);
        String string4 = string + FIELDREF_DELIM + string2 + FIELDREF_DELIM + string3;
        if (!this.cpTable.containsKey(string4)) {
            this.cpTable.put(string4, new Index(n));
        }
        return n;
    }

    public Constant getConstant(int n) {
        return this.constants[n];
    }

    public void setConstant(int n, Constant constant) {
        this.constants[n] = constant;
    }

    public ConstantPool getConstantPool() {
        return new ConstantPool(this.constants);
    }

    public int getSize() {
        return this.index;
    }

    public ConstantPool getFinalConstantPool() {
        Constant[] constantArray = new Constant[this.index];
        System.arraycopy(this.constants, 0, constantArray, 0, this.index);
        return new ConstantPool(constantArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < this.index; ++i) {
            stringBuilder.append(i).append(")").append(this.constants[i]).append("\n");
        }
        return stringBuilder.toString();
    }

    public int addConstant(Constant constant, ConstantPoolGen constantPoolGen) {
        Constant[] constantArray = constantPoolGen.getConstantPool().getConstantPool();
        switch (constant.getTag()) {
            case 8: {
                ConstantString constantString = (ConstantString)constant;
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantString.getStringIndex()];
                return this.addString(constantUtf8.getBytes());
            }
            case 7: {
                ConstantClass constantClass = (ConstantClass)constant;
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantClass.getNameIndex()];
                return this.addClass(constantUtf8.getBytes());
            }
            case 12: {
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)constant;
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantNameAndType.getNameIndex()];
                ConstantUtf8 constantUtf82 = (ConstantUtf8)constantArray[constantNameAndType.getSignatureIndex()];
                return this.addNameAndType(constantUtf8.getBytes(), constantUtf82.getBytes());
            }
            case 1: {
                return this.addUtf8(((ConstantUtf8)constant).getBytes());
            }
            case 6: {
                return this.addDouble(((ConstantDouble)constant).getBytes());
            }
            case 4: {
                return this.addFloat(((ConstantFloat)constant).getBytes());
            }
            case 5: {
                return this.addLong(((ConstantLong)constant).getBytes());
            }
            case 3: {
                return this.addInteger(((ConstantInteger)constant).getBytes());
            }
            case 9: 
            case 10: 
            case 11: {
                ConstantCP constantCP = (ConstantCP)constant;
                ConstantClass constantClass = (ConstantClass)constantArray[constantCP.getClassIndex()];
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)constantArray[constantCP.getNameAndTypeIndex()];
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantClass.getNameIndex()];
                String string = constantUtf8.getBytes().replace('/', '.');
                constantUtf8 = (ConstantUtf8)constantArray[constantNameAndType.getNameIndex()];
                String string2 = constantUtf8.getBytes();
                constantUtf8 = (ConstantUtf8)constantArray[constantNameAndType.getSignatureIndex()];
                String string3 = constantUtf8.getBytes();
                switch (constant.getTag()) {
                    case 11: {
                        return this.addInterfaceMethodref(string, string2, string3);
                    }
                    case 10: {
                        return this.addMethodref(string, string2, string3);
                    }
                    case 9: {
                        return this.addFieldref(string, string2, string3);
                    }
                }
                throw new IllegalArgumentException("Unknown constant type " + constant);
            }
        }
        throw new IllegalArgumentException("Unknown constant type " + constant);
    }

    private static class Index {
        final int index;

        Index(int n) {
            this.index = n;
        }
    }
}

