/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import sun.security.ssl.Alert;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.Ciphertext;
import sun.security.ssl.ClientAuthType;
import sun.security.ssl.ContentType;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.Plaintext;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLEngineInputRecord;
import sun.security.ssl.SSLEngineOutputRecord;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLTransport;
import sun.security.ssl.TransportContext;
import sun.security.ssl.Utilities;

final class SSLEngineImpl
extends SSLEngine
implements SSLTransport {
    private final SSLContextImpl sslContext;
    final TransportContext conContext;

    SSLEngineImpl(SSLContextImpl sSLContextImpl) {
        this(sSLContextImpl, null, -1);
    }

    SSLEngineImpl(SSLContextImpl sSLContextImpl, String string, int n) {
        super(string, n);
        this.sslContext = sSLContextImpl;
        HandshakeHash handshakeHash = new HandshakeHash();
        this.conContext = new TransportContext(sSLContextImpl, this, new SSLEngineInputRecord(handshakeHash), new SSLEngineOutputRecord(handshakeHash));
        if (string != null) {
            this.conContext.sslConfig.serverNames = Utilities.addToSNIServerNameList(this.conContext.sslConfig.serverNames, string);
        }
    }

    @Override
    public synchronized void beginHandshake() throws SSLException {
        if (this.conContext.isUnsureMode) {
            throw new IllegalStateException("Client/Server mode has not yet been set.");
        }
        try {
            this.conContext.kickstart();
        }
        catch (IOException iOException) {
            throw this.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Couldn't kickstart handshaking", iOException);
        }
        catch (Exception exception) {
            throw this.conContext.fatal(Alert.INTERNAL_ERROR, "Fail to begin handshake", exception);
        }
    }

    @Override
    public synchronized SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer byteBuffer) throws SSLException {
        return this.wrap(byteBufferArray, n, n2, new ByteBuffer[]{byteBuffer}, 0, 1);
    }

    public synchronized SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer[] byteBufferArray2, int n3, int n4) throws SSLException {
        if (this.conContext.isUnsureMode) {
            throw new IllegalStateException("Client/Server mode has not yet been set.");
        }
        this.checkTaskThrown();
        SSLEngineImpl.checkParams(byteBufferArray, n, n2, byteBufferArray2, n3, n4);
        try {
            return this.writeRecord(byteBufferArray, n, n2, byteBufferArray2, n3, n4);
        }
        catch (SSLProtocolException sSLProtocolException) {
            throw this.conContext.fatal(Alert.UNEXPECTED_MESSAGE, sSLProtocolException);
        }
        catch (IOException iOException) {
            throw this.conContext.fatal(Alert.INTERNAL_ERROR, "problem wrapping app data", iOException);
        }
        catch (Exception exception) {
            throw this.conContext.fatal(Alert.INTERNAL_ERROR, "Fail to wrap application data", exception);
        }
    }

    private SSLEngineResult writeRecord(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer[] byteBufferArray2, int n3, int n4) throws IOException {
        int n5;
        SSLEngineResult.Status status;
        int n6;
        if (this.conContext.needHandshakeFinishedStatus) {
            this.conContext.needHandshakeFinishedStatus = false;
            return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.FINISHED, 0, 0);
        }
        if (this.isOutboundDone()) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, this.getHandshakeStatus(), 0, 0);
        }
        HandshakeContext handshakeContext = this.conContext.handshakeContext;
        SSLEngineResult.HandshakeStatus handshakeStatus = null;
        if (!(this.conContext.isNegotiated || this.conContext.isBroken || this.conContext.isInboundClosed() || this.conContext.isOutboundClosed())) {
            this.conContext.kickstart();
            handshakeStatus = this.getHandshakeStatus();
            if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                return new SSLEngineResult(SSLEngineResult.Status.OK, handshakeStatus, 0, 0);
            }
        }
        if (handshakeStatus == null) {
            handshakeStatus = this.getHandshakeStatus();
        }
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, handshakeStatus, 0, 0);
        }
        int n7 = 0;
        for (n6 = n3; n6 < n3 + n4; ++n6) {
            n7 += byteBufferArray2[n6].remaining();
        }
        if (n7 < this.conContext.conSession.getPacketBufferSize()) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), 0, 0);
        }
        n6 = 0;
        for (int i = n; i < n + n2; ++i) {
            n6 += byteBufferArray[i].remaining();
        }
        Ciphertext ciphertext = null;
        try {
            if (!this.conContext.outputRecord.isEmpty()) {
                ciphertext = this.encode(null, 0, 0, byteBufferArray2, n3, n4);
            }
            if (ciphertext == null && n6 != 0) {
                ciphertext = this.encode(byteBufferArray, n, n2, byteBufferArray2, n3, n4);
            }
        }
        catch (IOException iOException) {
            if (iOException instanceof SSLException) {
                throw iOException;
            }
            throw new SSLException("Write problems", iOException);
        }
        SSLEngineResult.Status status2 = status = this.isOutboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
        if (ciphertext != null && ciphertext.handshakeStatus != null) {
            handshakeStatus = ciphertext.handshakeStatus;
        } else {
            handshakeStatus = this.getHandshakeStatus();
            if (ciphertext == null && !this.conContext.isNegotiated && this.conContext.isInboundClosed() && handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                status = SSLEngineResult.Status.CLOSED;
            }
        }
        int n8 = n6;
        for (n5 = n; n5 < n + n2; ++n5) {
            n8 -= byteBufferArray[n5].remaining();
        }
        n5 = n7;
        for (int i = n3; i < n3 + n4; ++i) {
            n5 -= byteBufferArray2[i].remaining();
        }
        return new SSLEngineResult(status, handshakeStatus, n8, n5);
    }

    private Ciphertext encode(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer[] byteBufferArray2, int n3, int n4) throws IOException {
        Ciphertext ciphertext = null;
        try {
            ciphertext = this.conContext.outputRecord.encode(byteBufferArray, n, n2, byteBufferArray2, n3, n4);
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            throw this.conContext.fatal(Alert.HANDSHAKE_FAILURE, sSLHandshakeException);
        }
        catch (IOException iOException) {
            throw this.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
        }
        if (ciphertext == null) {
            return null;
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this.tryToFinishHandshake(ciphertext.contentType);
        if (handshakeStatus == null) {
            handshakeStatus = this.conContext.getHandshakeStatus();
        }
        if (this.conContext.outputRecord.seqNumIsHuge() || this.conContext.outputRecord.writeCipher.atKeyLimit()) {
            handshakeStatus = this.tryKeyUpdate(handshakeStatus);
        }
        ciphertext.handshakeStatus = handshakeStatus;
        return ciphertext;
    }

    private SSLEngineResult.HandshakeStatus tryToFinishHandshake(byte by) {
        SSLEngineResult.HandshakeStatus handshakeStatus = null;
        if (by == ContentType.HANDSHAKE.id && this.conContext.outputRecord.isEmpty()) {
            if (this.conContext.handshakeContext == null) {
                handshakeStatus = SSLEngineResult.HandshakeStatus.FINISHED;
            } else if (this.conContext.isPostHandshakeContext()) {
                handshakeStatus = this.conContext.finishPostHandshake();
            } else if (this.conContext.handshakeContext.handshakeFinished) {
                handshakeStatus = this.conContext.finishHandshake();
            }
        }
        return handshakeStatus;
    }

    private SSLEngineResult.HandshakeStatus tryKeyUpdate(SSLEngineResult.HandshakeStatus handshakeStatus) throws IOException {
        if (!(this.conContext.handshakeContext != null || this.conContext.isOutboundClosed() || this.conContext.isInboundClosed() || this.conContext.isBroken)) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.finest("trigger key update", new Object[0]);
            }
            this.beginHandshake();
            return this.conContext.getHandshakeStatus();
        }
        return handshakeStatus;
    }

    private static void checkParams(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer[] byteBufferArray2, int n3, int n4) {
        int n5;
        if (byteBufferArray == null || byteBufferArray2 == null) {
            throw new IllegalArgumentException("source or destination buffer is null");
        }
        if (n3 < 0 || n4 < 0 || n3 > byteBufferArray2.length - n4) {
            throw new IndexOutOfBoundsException("index out of bound of the destination buffers");
        }
        if (n < 0 || n2 < 0 || n > byteBufferArray.length - n2) {
            throw new IndexOutOfBoundsException("index out of bound of the source buffers");
        }
        for (n5 = n3; n5 < n3 + n4; ++n5) {
            if (byteBufferArray2[n5] == null) {
                throw new IllegalArgumentException("destination buffer[" + n5 + "] == null");
            }
            if (!byteBufferArray2[n5].isReadOnly()) continue;
            throw new ReadOnlyBufferException();
        }
        for (n5 = n; n5 < n + n2; ++n5) {
            if (byteBufferArray[n5] != null) continue;
            throw new IllegalArgumentException("source buffer[" + n5 + "] == null");
        }
    }

    @Override
    public synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n, int n2) throws SSLException {
        return this.unwrap(new ByteBuffer[]{byteBuffer}, 0, 1, byteBufferArray, n, n2);
    }

    public synchronized SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer[] byteBufferArray2, int n3, int n4) throws SSLException {
        if (this.conContext.isUnsureMode) {
            throw new IllegalStateException("Client/Server mode has not yet been set.");
        }
        this.checkTaskThrown();
        SSLEngineImpl.checkParams(byteBufferArray, n, n2, byteBufferArray2, n3, n4);
        try {
            return this.readRecord(byteBufferArray, n, n2, byteBufferArray2, n3, n4);
        }
        catch (SSLProtocolException sSLProtocolException) {
            throw this.conContext.fatal(Alert.UNEXPECTED_MESSAGE, sSLProtocolException.getMessage(), sSLProtocolException);
        }
        catch (IOException iOException) {
            throw this.conContext.fatal(Alert.INTERNAL_ERROR, "problem unwrapping net record", iOException);
        }
        catch (Exception exception) {
            throw this.conContext.fatal(Alert.INTERNAL_ERROR, "Fail to unwrap network record", exception);
        }
    }

    private SSLEngineResult readRecord(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer[] byteBufferArray2, int n3, int n4) throws IOException {
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.isInboundDone()) {
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, this.getHandshakeStatus(), 0, 0);
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = null;
        if (!(this.conContext.isNegotiated || this.conContext.isBroken || this.conContext.isInboundClosed() || this.conContext.isOutboundClosed())) {
            this.conContext.kickstart();
            handshakeStatus = this.getHandshakeStatus();
            if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                return new SSLEngineResult(SSLEngineResult.Status.OK, handshakeStatus, 0, 0);
            }
        }
        if (handshakeStatus == null) {
            handshakeStatus = this.getHandshakeStatus();
        }
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, handshakeStatus, 0, 0);
        }
        int n9 = 0;
        for (n8 = n; n8 < n + n2; ++n8) {
            n9 += byteBufferArray[n8].remaining();
        }
        if (n9 == 0) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, handshakeStatus, 0, 0);
        }
        n8 = this.conContext.inputRecord.bytesInCompletePacket(byteBufferArray, n, n2);
        if (n8 > this.conContext.conSession.getPacketBufferSize()) {
            n7 = 33093;
            if (n8 <= n7) {
                this.conContext.conSession.expandBufferSizes();
            }
            if (n8 > (n7 = this.conContext.conSession.getPacketBufferSize())) {
                throw new SSLProtocolException("Input record too big: max = " + n7 + " len = " + n8);
            }
        }
        n7 = 0;
        for (n6 = n3; n6 < n3 + n4; ++n6) {
            n7 += byteBufferArray2[n6].remaining();
        }
        if (this.conContext.isNegotiated && (n6 = this.conContext.inputRecord.estimateFragmentSize(n8)) > n7) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, handshakeStatus, 0, 0);
        }
        if (n8 == -1 || n9 < n8) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_UNDERFLOW, handshakeStatus, 0, 0);
        }
        Plaintext plaintext = null;
        try {
            plaintext = this.decode(byteBufferArray, n, n2, byteBufferArray2, n3, n4);
        }
        catch (IOException iOException) {
            if (iOException instanceof SSLException) {
                throw iOException;
            }
            throw new SSLException("readRecord", iOException);
        }
        SSLEngineResult.Status status = this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK;
        handshakeStatus = plaintext.handshakeStatus != null ? plaintext.handshakeStatus : this.getHandshakeStatus();
        int n10 = n9;
        for (n5 = n; n5 < n + n2; ++n5) {
            n10 -= byteBufferArray[n5].remaining();
        }
        n5 = n7;
        for (int i = n3; i < n3 + n4; ++i) {
            n5 -= byteBufferArray2[i].remaining();
        }
        return new SSLEngineResult(status, handshakeStatus, n10, n5);
    }

    private Plaintext decode(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer[] byteBufferArray2, int n3, int n4) throws IOException {
        Plaintext plaintext = SSLTransport.decode(this.conContext, byteBufferArray, n, n2, byteBufferArray2, n3, n4);
        if (plaintext != Plaintext.PLAINTEXT_NULL) {
            SSLEngineResult.HandshakeStatus handshakeStatus = this.tryToFinishHandshake(plaintext.contentType);
            plaintext.handshakeStatus = handshakeStatus == null ? this.conContext.getHandshakeStatus() : handshakeStatus;
            if (this.conContext.inputRecord.seqNumIsHuge() || this.conContext.inputRecord.readCipher.atKeyLimit()) {
                plaintext.handshakeStatus = this.tryKeyUpdate(plaintext.handshakeStatus);
            }
        }
        return plaintext;
    }

    @Override
    public synchronized Runnable getDelegatedTask() {
        if (this.conContext.handshakeContext != null && !this.conContext.handshakeContext.taskDelegated && !this.conContext.handshakeContext.delegatedActions.isEmpty()) {
            this.conContext.handshakeContext.taskDelegated = true;
            return new DelegatedTask(this);
        }
        return null;
    }

    @Override
    public synchronized void closeInbound() throws SSLException {
        try {
            if (this.isInboundDone()) {
                return;
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.finest("Closing inbound of SSLEngine", new Object[0]);
            }
            if (!this.conContext.isInputCloseNotified && (this.conContext.isNegotiated || this.conContext.handshakeContext != null)) {
                throw new SSLException("closing inbound before receiving peer's close_notify");
            }
        }
        finally {
            this.conContext.closeInbound();
        }
    }

    @Override
    public synchronized boolean isInboundDone() {
        return this.conContext.isInboundClosed();
    }

    @Override
    public synchronized void closeOutbound() {
        if (this.conContext.isOutboundClosed()) {
            return;
        }
        if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
            SSLLogger.finest("Closing outbound of SSLEngine", new Object[0]);
        }
        this.conContext.closeOutbound();
    }

    @Override
    public synchronized boolean isOutboundDone() {
        return this.conContext.isOutboundDone();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return CipherSuite.namesOf(this.sslContext.getSupportedCipherSuites());
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return CipherSuite.namesOf(this.conContext.sslConfig.enabledCipherSuites);
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        this.conContext.sslConfig.enabledCipherSuites = CipherSuite.validValuesOf(stringArray);
    }

    @Override
    public String[] getSupportedProtocols() {
        return ProtocolVersion.toStringArray(this.sslContext.getSupportedProtocolVersions());
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return ProtocolVersion.toStringArray(this.conContext.sslConfig.enabledProtocols);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException("Protocols cannot be null");
        }
        this.conContext.sslConfig.enabledProtocols = ProtocolVersion.namesOf(stringArray);
    }

    @Override
    public synchronized SSLSession getSession() {
        return this.conContext.conSession;
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return this.conContext.handshakeContext == null ? null : this.conContext.handshakeContext.handshakeSession;
    }

    @Override
    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.conContext.getHandshakeStatus();
    }

    @Override
    public synchronized void setUseClientMode(boolean bl) {
        this.conContext.setUseClientMode(bl);
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.conContext.sslConfig.isClientMode;
    }

    @Override
    public synchronized void setNeedClientAuth(boolean bl) {
        this.conContext.sslConfig.clientAuthType = bl ? ClientAuthType.CLIENT_AUTH_REQUIRED : ClientAuthType.CLIENT_AUTH_NONE;
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.conContext.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_REQUIRED;
    }

    @Override
    public synchronized void setWantClientAuth(boolean bl) {
        this.conContext.sslConfig.clientAuthType = bl ? ClientAuthType.CLIENT_AUTH_REQUESTED : ClientAuthType.CLIENT_AUTH_NONE;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.conContext.sslConfig.clientAuthType == ClientAuthType.CLIENT_AUTH_REQUESTED;
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean bl) {
        this.conContext.sslConfig.enableSessionCreation = bl;
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.conContext.sslConfig.enableSessionCreation;
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return this.conContext.sslConfig.getSSLParameters();
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sSLParameters) {
        this.conContext.sslConfig.setSSLParameters(sSLParameters);
        if (this.conContext.sslConfig.maximumPacketSize != 0) {
            this.conContext.outputRecord.changePacketSize(this.conContext.sslConfig.maximumPacketSize);
        }
    }

    @Override
    public synchronized String getApplicationProtocol() {
        return this.conContext.applicationProtocol;
    }

    @Override
    public synchronized String getHandshakeApplicationProtocol() {
        return this.conContext.handshakeContext == null ? null : this.conContext.handshakeContext.applicationProtocol;
    }

    @Override
    public synchronized void setHandshakeApplicationProtocolSelector(BiFunction<SSLEngine, List<String>, String> biFunction) {
        this.conContext.sslConfig.engineAPSelector = biFunction;
    }

    @Override
    public synchronized BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector() {
        return this.conContext.sslConfig.engineAPSelector;
    }

    @Override
    public boolean useDelegatedTask() {
        return true;
    }

    private synchronized void checkTaskThrown() throws SSLException {
        Exception exception = null;
        HandshakeContext handshakeContext = this.conContext.handshakeContext;
        if (handshakeContext != null && handshakeContext.delegatedThrown != null) {
            exception = handshakeContext.delegatedThrown;
            handshakeContext.delegatedThrown = null;
        }
        if (this.conContext.delegatedThrown != null) {
            if (exception != null) {
                if (this.conContext.delegatedThrown == exception) {
                    this.conContext.delegatedThrown = null;
                }
            } else {
                exception = this.conContext.delegatedThrown;
                this.conContext.delegatedThrown = null;
            }
        }
        if (exception == null) {
            return;
        }
        if (exception instanceof SSLException) {
            throw (SSLException)exception;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw SSLEngineImpl.getTaskThrown(exception);
    }

    private static SSLException getTaskThrown(Exception exception) {
        String string = exception.getMessage();
        if (string == null) {
            string = "Delegated task threw Exception or Error";
        }
        if (exception instanceof RuntimeException) {
            throw new RuntimeException(string, exception);
        }
        if (exception instanceof SSLHandshakeException) {
            return (SSLHandshakeException)new SSLHandshakeException(string).initCause(exception);
        }
        if (exception instanceof SSLKeyException) {
            return (SSLKeyException)new SSLKeyException(string).initCause(exception);
        }
        if (exception instanceof SSLPeerUnverifiedException) {
            return (SSLPeerUnverifiedException)new SSLPeerUnverifiedException(string).initCause(exception);
        }
        if (exception instanceof SSLProtocolException) {
            return (SSLProtocolException)new SSLProtocolException(string).initCause(exception);
        }
        if (exception instanceof SSLException) {
            return (SSLException)exception;
        }
        return new SSLException(string, exception);
    }

    private static class DelegatedTask
    implements Runnable {
        private final SSLEngineImpl engine;

        DelegatedTask(SSLEngineImpl sSLEngineImpl) {
            this.engine = sSLEngineImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SSLEngineImpl sSLEngineImpl = this.engine;
            synchronized (sSLEngineImpl) {
                HandshakeContext handshakeContext;
                block14: {
                    handshakeContext = this.engine.conContext.handshakeContext;
                    if (handshakeContext == null || handshakeContext.delegatedActions.isEmpty()) {
                        return;
                    }
                    try {
                        AccessController.doPrivileged(new DelegatedAction(handshakeContext), this.engine.conContext.acc);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (this.engine.conContext.delegatedThrown == null) {
                            this.engine.conContext.delegatedThrown = exception;
                        }
                        if ((handshakeContext = this.engine.conContext.handshakeContext) != null) {
                            handshakeContext.delegatedThrown = exception;
                        } else if (this.engine.conContext.closeReason != null) {
                            this.engine.conContext.closeReason = SSLEngineImpl.getTaskThrown(exception);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        if (this.engine.conContext.delegatedThrown == null) {
                            this.engine.conContext.delegatedThrown = runtimeException;
                        }
                        if ((handshakeContext = this.engine.conContext.handshakeContext) != null) {
                            handshakeContext.delegatedThrown = runtimeException;
                        }
                        if (this.engine.conContext.closeReason == null) break block14;
                        this.engine.conContext.closeReason = runtimeException;
                    }
                }
                handshakeContext = this.engine.conContext.handshakeContext;
                if (handshakeContext != null) {
                    handshakeContext.taskDelegated = false;
                }
            }
        }

        private static class DelegatedAction
        implements PrivilegedExceptionAction<Void> {
            final HandshakeContext context;

            DelegatedAction(HandshakeContext handshakeContext) {
                this.context = handshakeContext;
            }

            @Override
            public Void run() throws Exception {
                while (!this.context.delegatedActions.isEmpty()) {
                    Map.Entry<Byte, ByteBuffer> entry = this.context.delegatedActions.poll();
                    if (entry == null) continue;
                    this.context.dispatch((byte)entry.getKey(), entry.getValue());
                }
                return null;
            }
        }
    }
}

