/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.content.keyvalues;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.keyvalues.KeyValueContent;
import com.sun.org.apache.xml.internal.security.utils.I18n;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DSAKeyValue
extends SignatureElementProxy
implements KeyValueContent {
    public DSAKeyValue(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public DSAKeyValue(Document document, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        super(document);
        this.addReturnToSelf();
        this.addBigIntegerElement(bigInteger, "P");
        this.addBigIntegerElement(bigInteger2, "Q");
        this.addBigIntegerElement(bigInteger3, "G");
        this.addBigIntegerElement(bigInteger4, "Y");
    }

    public DSAKeyValue(Document document, Key key) throws IllegalArgumentException {
        super(document);
        this.addReturnToSelf();
        if (!(key instanceof DSAPublicKey)) {
            Object[] objectArray = new Object[]{"DSAKeyValue", key.getClass().getName()};
            throw new IllegalArgumentException(I18n.translate("KeyValue.IllegalArgument", objectArray));
        }
        DSAParams dSAParams = ((DSAPublicKey)key).getParams();
        this.addBigIntegerElement(dSAParams.getP(), "P");
        this.addBigIntegerElement(dSAParams.getQ(), "Q");
        this.addBigIntegerElement(dSAParams.getG(), "G");
        this.addBigIntegerElement(((DSAPublicKey)key).getY(), "Y");
    }

    @Override
    public PublicKey getPublicKey() throws XMLSecurityException {
        try {
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(this.getBigIntegerFromChildElement("Y", "http://www.w3.org/2000/09/xmldsig#"), this.getBigIntegerFromChildElement("P", "http://www.w3.org/2000/09/xmldsig#"), this.getBigIntegerFromChildElement("Q", "http://www.w3.org/2000/09/xmldsig#"), this.getBigIntegerFromChildElement("G", "http://www.w3.org/2000/09/xmldsig#"));
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return keyFactory.generatePublic(dSAPublicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw new XMLSecurityException(generalSecurityException);
        }
    }

    @Override
    public String getBaseLocalName() {
        return "DSAKeyValue";
    }
}

