/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.KeyTab;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.krb5.SubjectComber;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;

public final class ServiceCreds {
    private KerberosPrincipal kp;
    private Set<KerberosPrincipal> allPrincs;
    private List<KeyTab> ktabs;
    private List<KerberosKey> kk;
    private KerberosTicket tgt;
    private boolean destroyed;

    private ServiceCreds() {
    }

    public static ServiceCreds getInstance(Subject subject, String string) {
        ServiceCreds serviceCreds = new ServiceCreds();
        serviceCreds.allPrincs = subject.getPrincipals(KerberosPrincipal.class);
        for (KerberosKey object : SubjectComber.findMany(subject, string, null, KerberosKey.class)) {
            serviceCreds.allPrincs.add(object.getPrincipal());
        }
        if (string != null) {
            serviceCreds.kp = new KerberosPrincipal(string);
        } else if (serviceCreds.allPrincs.size() == 1) {
            boolean bl = false;
            for (KeyTab keyTab : SubjectComber.findMany(subject, null, null, KeyTab.class)) {
                if (keyTab.isBound()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                serviceCreds.kp = serviceCreds.allPrincs.iterator().next();
                string = serviceCreds.kp.getName();
            }
        }
        serviceCreds.ktabs = SubjectComber.findMany(subject, string, null, KeyTab.class);
        serviceCreds.kk = SubjectComber.findMany(subject, string, null, KerberosKey.class);
        serviceCreds.tgt = SubjectComber.find(subject, null, string, KerberosTicket.class);
        if (serviceCreds.ktabs.isEmpty() && serviceCreds.kk.isEmpty() && serviceCreds.tgt == null) {
            return null;
        }
        serviceCreds.destroyed = false;
        return serviceCreds;
    }

    public String getName() {
        if (this.destroyed) {
            throw new IllegalStateException("This object is destroyed");
        }
        return this.kp == null ? null : this.kp.getName();
    }

    public KerberosKey[] getKKeys() {
        if (this.destroyed) {
            throw new IllegalStateException("This object is destroyed");
        }
        KerberosPrincipal kerberosPrincipal = this.kp;
        if (kerberosPrincipal == null && !this.allPrincs.isEmpty()) {
            kerberosPrincipal = this.allPrincs.iterator().next();
        }
        if (kerberosPrincipal == null) {
            for (KeyTab keyTab : this.ktabs) {
                PrincipalName principalName = Krb5Util.snapshotFromJavaxKeyTab(keyTab).getOneName();
                if (principalName == null) continue;
                kerberosPrincipal = new KerberosPrincipal(principalName.getName());
                break;
            }
        }
        if (kerberosPrincipal != null) {
            return this.getKKeys(kerberosPrincipal);
        }
        return new KerberosKey[0];
    }

    public KerberosKey[] getKKeys(KerberosPrincipal kerberosPrincipal) {
        if (this.destroyed) {
            throw new IllegalStateException("This object is destroyed");
        }
        ArrayList<KerberosKey> arrayList = new ArrayList<KerberosKey>();
        if (this.kp != null && !kerberosPrincipal.equals(this.kp)) {
            return new KerberosKey[0];
        }
        for (KerberosKey object : this.kk) {
            if (!object.getPrincipal().equals(kerberosPrincipal)) continue;
            arrayList.add(object);
        }
        for (KeyTab keyTab : this.ktabs) {
            if (keyTab.getPrincipal() == null && keyTab.isBound() && !this.allPrincs.contains(kerberosPrincipal)) continue;
            for (KerberosKey kerberosKey : keyTab.getKeys(kerberosPrincipal)) {
                arrayList.add(kerberosKey);
            }
        }
        return arrayList.toArray(new KerberosKey[arrayList.size()]);
    }

    public EncryptionKey[] getEKeys(PrincipalName principalName) {
        if (this.destroyed) {
            throw new IllegalStateException("This object is destroyed");
        }
        KerberosKey[] kerberosKeyArray = this.getKKeys(new KerberosPrincipal(principalName.getName()));
        if (kerberosKeyArray.length == 0) {
            kerberosKeyArray = this.getKKeys();
        }
        EncryptionKey[] encryptionKeyArray = new EncryptionKey[kerberosKeyArray.length];
        for (int i = 0; i < encryptionKeyArray.length; ++i) {
            encryptionKeyArray[i] = new EncryptionKey(kerberosKeyArray[i].getEncoded(), kerberosKeyArray[i].getKeyType(), new Integer(kerberosKeyArray[i].getVersionNumber()));
        }
        return encryptionKeyArray;
    }

    public Credentials getInitCred() {
        if (this.destroyed) {
            throw new IllegalStateException("This object is destroyed");
        }
        if (this.tgt == null) {
            return null;
        }
        try {
            return Krb5Util.ticketToCreds(this.tgt);
        }
        catch (IOException | KrbException exception) {
            return null;
        }
    }

    public void destroy() {
        this.destroyed = true;
        this.kp = null;
        this.ktabs.clear();
        this.kk.clear();
        this.tgt = null;
    }
}

