/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.ro;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ro extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Omsk = new String[] {
               "Ora standard din Omsk",
               "OST",
               "Ora de var\u0103 din Omsk",
               "OST",
               "Ora din Omsk",
               "OT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Ora standard a insulelor Aleutine \u015fi a Hawaiului",
               "HAST",
               "Ora de var\u0103 a insulelor Aleutine \u015fi a Hawaiului",
               "HADT",
               "Ora insulelor Aleutine \u015fi a Hawaiului",
               "HAT",
            };
        final String[] Yakutsk = new String[] {
               "Ora standard din Yakutsk",
               "YST",
               "Ora de var\u0103 din Yakutsk",
               "YST",
               "Ora din Yakutsk",
               "YT",
            };
        final String[] Sakhalin = new String[] {
               "Ora standard din Sahalin",
               "SST",
               "Ora de var\u0103 din Sahalin",
               "SST",
               "Ora din Sahalin",
               "ST",
            };
        final String[] Paraguay = new String[] {
               "Ora standard a Paraguay",
               "PST",
               "Ora de var\u0103 a Paraguay",
               "PST",
               "Ora Paraguay",
               "PT",
            };
        final String[] Japan = new String[] {
               "Ora standard a Japoniei",
               "JST",
               "Ora de var\u0103 a Japoniei",
               "JDT",
               "Ora Japoniei",
               "JT",
            };
        final String[] Vladivostok = new String[] {
               "Ora standard din Vladivostok",
               "VST",
               "Ora de var\u0103 din Vladivostok",
               "VST",
               "Ora din Vladivostok",
               "VT",
            };
        final String[] Europe_Western = new String[] {
               "Ora standard a Europei Occidentale",
               "WEST",
               "Ora de var\u0103 a Europei Occidentale",
               "WEST",
               "Ora Europei Occidentale",
               "WET",
            };
        final String[] Bangladesh = new String[] {
               "Ora standard din Bangladesh",
               "BST",
               "Ora de var\u0103 din Bangladesh",
               "BST",
               "Ora din Bangladesh",
               "BT",
            };
        final String[] East_Timor = new String[] {
               "Ora Timorului de Est",
               "ETT",
               "East Timor Summer Time",
               "ETST",
               "East Timor Time",
               "ETT",
            };
        final String[] Greenland_Western = new String[] {
               "Ora standard a Groenlandei occidentale",
               "WGST",
               "Ora de var\u0103 a Groenlandei occidentale",
               "WGST",
               "Ora Groenlandei occidentale",
               "WGT",
            };
        final String[] Colombia = new String[] {
               "Ora standard a Columbiei",
               "CST",
               "Ora de var\u0103 a Columbiei",
               "CST",
               "Ora Columbiei",
               "CT",
            };
        final String[] Suriname = new String[] {
               "Ora Surinamului",
               "ST",
               "Suriname Summer Time",
               "SST",
               "Suriname Time",
               "ST",
            };
        final String[] Hovd = new String[] {
               "Ora standard din Hovd",
               "HST",
               "Ora de var\u0103 din Hovd",
               "HST",
               "Ora din Hovd",
               "HT",
            };
        final String[] Amazon = new String[] {
               "Ora standard Amazon",
               "AST",
               "Ora de var\u0103 Amazon",
               "AST",
               "Ora Amazon",
               "AT",
            };
        final String[] Mongolia = new String[] {
               "Ora standard din Ulan Bator",
               "UBST",
               "Ora de var\u0103 din Ulan Bator",
               "UBST",
               "Ora Ulan Bator",
               "UBT",
            };
        final String[] Argentina_Western = new String[] {
               "Ora Argentinei Occidentale",
               "WAST",
               "Ora de var\u0103 vestic\u0103 din Argentina",
               "WAST",
               "Ora regiunii vestice din Argentina",
               "WAT",
            };
        final String[] America_Pacific = new String[] {
               "Ora standard \u00een zona Pacific",
               "PST",
               "Ora de var\u0103 \u00een zona Pacific",
               "PDT",
               "Ora zonei Pacific",
               "PT",
            };
        final String[] French_Guiana = new String[] {
               "Ora Guianei Franceze",
               "FGT",
               "French Guiana Summer Time",
               "FGST",
               "French Guiana Time",
               "FGT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Ora standard a Groenlandei orientale",
               "EGST",
               "Ora de var\u0103 a Groenlandei orientale",
               "EGST",
               "Ora Groenlandei orientale",
               "EGT",
            };
        final String[] Volgograd = new String[] {
               "Ora standard din Volgograd",
               "VST",
               "Ora de var\u0103 din Volgograd",
               "VST",
               "Ora din Volgograd",
               "VT",
            };
        final String[] Korea = new String[] {
               "Ora standard a Coreei",
               "KST",
               "Ora de var\u0103 a Coreei",
               "KDT",
               "Ora Coreei",
               "KT",
            };
        final String[] Argentina = new String[] {
               "Ora standard Argentinei",
               "AST",
               "Ora de var\u0103 a Argentinei",
               "AST",
               "Ora Argentinei",
               "AT",
            };
        final String[] Lord_Howe = new String[] {
               "Ora standard Lord Howe",
               "LHST",
               "Ora de var\u0103 Lord Howe",
               "LHDT",
               "Ora Lord Howe",
               "LHT",
            };
        final String[] Syowa = new String[] {
               "Ora Syowa",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Arabian = new String[] {
               "Ora standard arab\u0103",
               "AST",
               "Ora de var\u0103 arab\u0103",
               "ADT",
               "Ora arab\u0103",
               "AT",
            };
        final String[] Australia_Eastern = new String[] {
               "Ora standard a Australiei Orientale",
               "AEST",
               "Ora de var\u0103 a Australiei Orientale",
               "AEDT",
               "Ora Australiei Orientale",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "Ora standard din Irkutsk",
               "IST",
               "Ora de var\u0103 din Irkutsk",
               "IST",
               "Ora din Irkutsk",
               "IT",
            };
        final String[] Indian_Ocean = new String[] {
               "Ora Oceanului Indian",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Choibalsan = new String[] {
               "Ora standard din Choibalsan",
               "CST",
               "Ora de var\u0103 din Choibalsan",
               "CST",
               "Ora din Choibalsan",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Ora standard oriental\u0103",
               "EST",
               "Ora de var\u0103 oriental\u0103",
               "EDT",
               "Ora oriental\u0103",
               "ET",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Ora standard a Australiei Central Occidentale",
               "ACWST",
               "Ora de var\u0103 a Australiei Central Occidentale",
               "ACWDT",
               "Ora Australiei Central Occidentale",
               "ACWT",
            };
        final String[] Australia_Western = new String[] {
               "Ora standard a Australiei Occidentale",
               "AWST",
               "Ora de var\u0103 a Australiei Occidentale",
               "AWDT",
               "Ora Australiei Occidentale",
               "WAT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Ora standard din Krasnoiarsk",
               "KST",
               "Ora de var\u0103 din Krasnoiarsk",
               "KST",
               "Ora din Krasnoiarsk",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ora regiunii estice din Indonezia",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Venezuela = new String[] {
               "Ora Venezuelei",
               "VT",
               "Venezuela Summer Time",
               "VST",
               "Venezuela Time",
               "VT",
            };
        final String[] Bhutan = new String[] {
               "Ora Bhutanului",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Noronha = new String[] {
               "Ora standard din Fernando de Noronha",
               "FNST",
               "Ora de var\u0103 din Fernando de Noronha",
               "FNST",
               "Ora din Fernando de Noronha",
               "FNT",
            };
        final String[] Novosibirsk = new String[] {
               "Ora standard din Novosibirsk",
               "NST",
               "Ora de var\u0103 din Novosibirsk",
               "NST",
               "Ora din Novosibirsk",
               "NT",
            };
        final String[] America_Mountain = new String[] {
               "Ora standard \u00een zona montan\u0103",
               "MST",
               "Ora de var\u0103 \u00een zona montan\u0103",
               "MDT",
               "Ora zonei montane",
               "MT",
            };
        final String[] Vostok = new String[] {
               "Ora Vostok",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Alaska = new String[] {
               "Ora standard Alaska",
               "AKST",
               "Ora de var\u0103 Alaska",
               "AKDT",
               "Ora Alaska",
               "AKT",
            };
        final String[] Armenia = new String[] {
               "Ora standard Armeniei",
               "AST",
               "Ora de var\u0103 a Armeniei",
               "AST",
               "Ora Armeniei",
               "AT",
            };
        final String[] Australia_Central = new String[] {
               "Ora standard a Australiei Centrale",
               "ACST",
               "Ora de var\u0103 a Australiei Centrale",
               "ACDT",
               "Ora Australiei Centrale",
               "CAT",
            };
        final String[] Ecuador = new String[] {
               "Ora Ecuadorului",
               "ET",
               "Ecuador Summer Time",
               "EST",
               "Ecuador Time",
               "ET",
            };
        final String[] Magadan = new String[] {
               "Ora standard din Magadan",
               "MST",
               "Ora de var\u0103 din Magadan",
               "MST",
               "Ora din Magadan",
               "MT",
            };
        final String[] Davis = new String[] {
               "Ora Davis",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Cuba = new String[] {
               "Ora standard a Cubei",
               "CST",
               "Ora de var\u0103 a Cubei",
               "CDT",
               "Ora Cubei",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "Ora standard Africii Occidentale",
               "WAST",
               "Ora de var\u0103 a Africii Occidentale",
               "WAST",
               "Ora Africii Occidentale",
               "WAT",
            };
        final String[] Moscow = new String[] {
               "Ora standard din Moscova",
               "MST",
               "Ora de var\u0103 din Moscova",
               "MST",
               "Ora din Moscova",
               "MT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Ora estic\u0103 din Kazahstan",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Brasilia = new String[] {
               "Ora standard a Brasiliei",
               "BST",
               "Ora de var\u0103 a Brasiliei",
               "BST",
               "Ora Brasiliei",
               "BT",
            };
        final String[] Afghanistan = new String[] {
               "Ora Afganistanului",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Indonesia_Western = new String[] {
               "Ora regiunii vestice din Indonezia",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Brunei = new String[] {
               "Ora Brunei Darussalam",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] Africa_Central = new String[] {
               "Ora Africii Centrale",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Indonesia_Central = new String[] {
               "Ora regiunii centrale din Indonezia",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Georgia = new String[] {
               "Ora standard a Georgiei",
               "GST",
               "Ora de var\u0103 a Georgiei",
               "GST",
               "Ora Georgiei",
               "GT",
            };
        final String[] Bolivia = new String[] {
               "Ora Boliviei",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Peru = new String[] {
               "Ora standard din Peru",
               "PST",
               "Ora de var\u0103 din Peru",
               "PST",
               "Ora din Peru",
               "PT",
            };
        final String[] Newfoundland = new String[] {
               "Ora standard din Newfoundland",
               "NST",
               "Ora de var\u0103 din Newfoundland",
               "NDT",
               "Ora din Newfoundland",
               "NT",
            };
        final String[] America_Central = new String[] {
               "Ora standard central\u0103",
               "CST",
               "Ora de var\u0103 central\u0103",
               "CDT",
               "Ora Central\u0103",
               "CT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ora Africii Orientale",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Azerbaijan = new String[] {
               "Ora standard a Azerbaidjanului",
               "AST",
               "Ora de var\u0103 a Azerbaidjanului",
               "AST",
               "Ora Azerbaidjanului",
               "AT",
            };
        final String[] Guyana = new String[] {
               "Ora Guianei",
               "GT",
               "Guyana Summer Time",
               "GST",
               "Guyana Time",
               "GT",
            };
        final String[] Yekaterinburg = new String[] {
               "Ora standard din Ekaterinburg",
               "YST",
               "Ora de var\u0103 din Ekaterinburg",
               "YST",
               "Ora din Ekaterinburg",
               "YT",
            };
        final String[] China = new String[] {
               "Ora standard a Chinei",
               "CST",
               "Ora de var\u0103 a Chinei",
               "CDT",
               "Ora Chinei",
               "CT",
            };
        final String[] Africa_Southern = new String[] {
               "Ora Africii Meridionale",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Macquarie = new String[] {
               "Ora din Macquarie",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] Chile = new String[] {
               "Ora standard din Chile",
               "CST",
               "Ora de var\u0103 din Chile",
               "CST",
               "Ora din Chile",
               "CT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Ora vestic\u0103 din Kazahstan",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Israel = new String[] {
               "Ora standard a Israelului",
               "IST",
               "Ora de var\u0103 a Israelului",
               "IDT",
               "Ora Israelului",
               "IT",
            };
        final String[] Mawson = new String[] {
               "Ora Mawson",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Ora standard Pierre \u0219i Miquelon",
               "PMST",
               "Ora de var\u0103 Pierre \u0219i Miquelon",
               "PMDT",
               "Ora Pierre \u0219i Miquelon",
               "PMT",
            };
        final String[] Rothera = new String[] {
               "Ora Rothera",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Europe_Central = new String[] {
               "Ora standard a Europei Centrale",
               "CEST",
               "Ora de var\u0103 a Europei Centrale",
               "CEST",
               "Ora Europei Centrale",
               "CET",
            };
        final String[] India = new String[] {
               "Ora standard a Indiei",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] DumontDUrville = new String[] {
               "Ora Dumont-d'Urville",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Europe_Eastern = new String[] {
               "Ora standard a Europei de Est",
               "EEST",
               "Ora de var\u0103 a Europei de Est",
               "EEST",
               "Ora Europei de Est",
               "EET",
            };
        final String[] Atlantic = new String[] {
               "Ora standard \u00een zona Atlantic",
               "AST",
               "Ora de var\u0103 \u00een zona Atlantic",
               "ADT",
               "Ora Atlantic",
               "AT",
            };
        final String[] Uruguay = new String[] {
               "Ora standard a statului Uruguay",
               "UST",
               "Ora de var\u0103 a statului Uruguay",
               "UST",
               "Ora statului Uruguay",
               "UT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Douala", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "Asia/Yerevan", Armenia },
            { "America/Bogota", Colombia },
            { "Asia/Colombo", India },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Blantyre", Africa_Central },
            { "Europe/Volgograd", Volgograd },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Resolute", America_Central },
            { "America/Anguilla", Atlantic },
            { "America/Regina", America_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Simferopol", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/North_Dakota/Center", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Bahia_Banderas", America_Central },
            { "Asia/Hebron", Europe_Eastern },
            { "Australia/Broken_Hill", Australia_Central },
            { "Antarctica/Casey", Australia_Western },
            { "PST8PDT", America_Pacific },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Africa/Tunis", Europe_Central },
            { "Africa/Maseru", Africa_Southern },
            { "America/Asuncion", Paraguay },
            { "America/Indiana/Winamac", America_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Africa/Niamey", Africa_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Asia/Brunei", Brunei },
            { "Africa/Djibouti", Africa_Eastern },
            { "Asia/Tbilisi", Georgia },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "Asia/Oral", Kazakhstan_Western },
            { "Africa/Lusaka", Africa_Central },
            { "America/Tortola", Atlantic },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Moncton", Atlantic },
            { "America/Maceio", Brasilia },
            { "America/Belize", America_Central },
            { "America/Cuiaba", Amazon },
            { "Atlantic/Canary", Europe_Western },
            { "America/Rankin_Inlet", America_Central },
            { "Antarctica/Rothera", Rothera },
            { "America/Glace_Bay", Atlantic },
            { "America/Cambridge_Bay", America_Mountain },
            { "Australia/Brisbane", Australia_Eastern },
            { "America/Grenada", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Antarctica/Vostok", Vostok },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Africa/Nairobi", Africa_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Caracas", Venezuela },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Maputo", Africa_Central },
            { "America/Metlakatla", America_Pacific },
            { "Asia/Baghdad", Arabian },
            { "Asia/Dhaka", Bangladesh },
            { "Africa/Cairo", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "Indian/Comoro", Africa_Eastern },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "Asia/Dili", East_Timor },
            { "America/Indiana/Marengo", America_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Indian/Chagos", Indian_Ocean },
            { "Europe/Luxembourg", Europe_Central },
            { "Asia/Makassar", Indonesia_Central },
            { "Australia/Currie", Australia_Eastern },
            { "America/Cancun", America_Central },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Seoul", Korea },
            { "Europe/Rome", Europe_Central },
            { "America/Lima", Peru },
            { "America/Dawson_Creek", America_Mountain },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Anadyr", Magadan },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Hermosillo", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/Boise", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Africa/Algiers", Europe_Central },
            { "America/Iqaluit", America_Eastern },
            { "America/Araguaina", Brasilia },
            { "America/St_Lucia", Atlantic },
            { "Asia/Yakutsk", Yakutsk },
            { "America/Panama", America_Eastern },
            { "Europe/Gibraltar", Europe_Central },
            { "America/Scoresbysund", Greenland_Eastern },
            { "America/Aruba", Atlantic },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Paramaribo", Suriname },
            { "Australia/Lindeman", Australia_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "Australia/Perth", Australia_Western },
            { "America/Edmonton", America_Mountain },
            { "Antarctica/Syowa", Syowa },
            { "America/Creston", America_Mountain },
            { "America/Noronha", Noronha },
            { "America/La_Paz", Bolivia },
            { "America/Dominica", Atlantic },
            { "Antarctica/Macquarie", Macquarie },
            { "MST7MDT", America_Mountain },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Luanda", Africa_Western },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "America/Guadeloupe", Atlantic },
            { "Africa/Bangui", Africa_Western },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/Eirunepe", Amazon },
            { "Africa/Lubumbashi", Africa_Central },
            { "Antarctica/Palmer", Chile },
            { "America/Monterrey", America_Central },
            { "Europe/Samara", Moscow },
            { "Europe/Monaco", Europe_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Yakutat", Alaska },
            { "America/St_Vincent", Atlantic },
            { "Europe/Vienna", Europe_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Asia/Qatar", Arabian },
            { "Africa/Gaborone", Africa_Central },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Lisbon", Europe_Western },
            { "America/Montevideo", Uruguay },
            { "Europe/Zurich", Europe_Central },
            { "America/Winnipeg", America_Central },
            { "America/Guyana", Guyana },
            { "America/Santarem", Brasilia },
            { "Asia/Macau", China },
            { "Asia/Vladivostok", Vladivostok },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Africa/Ndjamena", Africa_Western },
            { "America/Tijuana", America_Pacific },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Thule", Atlantic },
            { "Europe/Copenhagen", Europe_Central },
            { "Asia/Thimphu", Bhutan },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Chihuahua", America_Mountain },
            { "America/Yellowknife", America_Mountain },
            { "Africa/Windhoek", Africa_Western },
            { "America/Cayman", America_Eastern },
            { "Antarctica/Davis", Davis },
            { "Europe/Berlin", Europe_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Omsk", Omsk },
            { "Europe/Chisinau", Europe_Eastern },
            { "Asia/Choibalsan", Choibalsan },
            { "Europe/Prague", Europe_Central },
            { "Africa/Harare", Africa_Central },
            { "America/Toronto", America_Eastern },
            { "America/Montserrat", Atlantic },
            { "America/Miquelon", Pierre_Miquelon },
            { "Asia/Pyongyang", Korea },
            { "America/Porto_Velho", Amazon },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Mexico_City", America_Central },
            { "America/El_Salvador", America_Central },
            { "Asia/Kashgar", China },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Port_of_Spain", Atlantic },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Managua", America_Central },
            { "EST5EDT", America_Eastern },
            { "America/Nome", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Rio_Branco", Amazon },
            { "Europe/Podgorica", Europe_Central },
            { "America/Santiago", Chile },
            { "America/Vancouver", America_Pacific },
            { "Asia/Bahrain", Arabian },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Guatemala", America_Central },
            { "Europe/Oslo", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Harbin", China },
            { "Africa/Johannesburg", Africa_Southern },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Ojinaga", America_Mountain },
            { "America/Barbados", Atlantic },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Asia/Urumqi", China },
            { "America/Louisville", America_Eastern },
            { "Asia/Gaza", Europe_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "Asia/Kuwait", Arabian },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Blanc-Sablon", Atlantic },
            { "Africa/Juba", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Europe/Malta", Europe_Central },
            { "Europe/Madrid", Europe_Central },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Magadan", Magadan },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Mbabane", Africa_Southern },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Jujuy", Argentina },
            { "America/Buenos_Aires", Argentina },
            { "Asia/Calcutta", India },
            { "America/Puerto_Rico", Atlantic },
            { "Europe/Athens", Europe_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Havana", Cuba },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "America/Menominee", America_Central },
            { "America/Juneau", Alaska },
            { "America/Mendoza", Argentina },
            { "America/Martinique", Atlantic },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Godthab", Greenland_Western },
            { "Africa/Libreville", Africa_Western },
            { "America/St_Thomas", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "America/Shiprock", America_Mountain },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Europe/Riga", Europe_Eastern },
            { "America/Guayaquil", Ecuador },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Kigali", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Antarctica/Mawson", Mawson },
            { "America/Goose_Bay", Atlantic },
            { "Europe/Tirane", Europe_Central },
            { "America/Nipigon", America_Eastern },
            { "Asia/Chongqing", China },
            { "America/Cayenne", French_Guiana },
            { "Australia/Darwin", Australia_Central },
            { "Europe/Skopje", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Asia/Riyadh", Arabian },
            { "Asia/Aden", Arabian },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Atlantic/Madeira", Europe_Western },
        };
        return data;
    }
}
