/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.supdate;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import fr.theshark34.supdate.SUpdate;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;

public class ServerRequester {
    private SUpdate sUpdate;
    private boolean rewrite;

    public ServerRequester(SUpdate sUpdate) {
        this.sUpdate = sUpdate;
    }

    public void sendRequest(String request) throws IOException {
        this.send(request, null, null, null, false);
    }

    public Object sendRequest(String request, Class<?> model) throws IOException {
        return this.send(request, model, null, null, false);
    }

    public Object sendRequest(String request, Type type) throws IOException {
        return this.send(request, null, type, null, false);
    }

    public void sendPostRequest(String request) throws IOException {
        this.send(request, null, null, null, true);
    }

    public Object sendPostRequest(String request, Class<?> model) throws IOException {
        return this.send(request, model, null, null, true);
    }

    public Object sendPostRequest(String request, Type type) throws IOException {
        return this.send(request, null, type, null, true);
    }

    public Object sendPostRequest(String request, Class<?> model, byte[] postData) throws IOException {
        return this.send(request, model, null, postData, true);
    }

    public Object sendPostRequest(String request, Type type, byte[] postData) throws IOException {
        return this.send(request, null, type, postData, true);
    }

    private Object send(String request, Class<?> model, Type type, byte[] postData, boolean post) throws IOException {
        Object createdObject;
        String currentLine;
        URL requestUrl = new URL(this.sUpdate.getServerUrl() + (this.sUpdate.getServerUrl().endsWith("/") ? "" : "/") + (this.rewrite ? "index.php/" : "") + request);
        HttpURLConnection connection = (HttpURLConnection)requestUrl.openConnection();
        connection.addRequestProperty("User-Agent", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko) Chrome/43.0.2357.124 Safari/537.36");
        if (post) {
            connection.setRequestMethod("POST");
        }
        if (postData != null) {
            connection.setDoOutput(true);
            OutputStream output = connection.getOutputStream();
            output.write(postData);
        }
        if (model == null && type == null) {
            return null;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        String response = "";
        while ((currentLine = br.readLine()) != null) {
            response = response + currentLine;
        }
        Gson gson = new Gson();
        try {
            createdObject = gson.fromJson(response, (Type)(model == null ? type : model));
        }
        catch (JsonSyntaxException e) {
            return response;
        }
        if (createdObject == null) {
            return response;
        }
        return createdObject;
    }

    public void setRewriteEnabled(boolean enabled) {
        this.rewrite = enabled;
    }

    public boolean isRewriteEnabled() {
        return this.rewrite;
    }
}

