/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.internal;

import fr.theshark34.openlauncherlib.LaunchException;
import fr.theshark34.openlauncherlib.internal.ClassInitializer;
import fr.theshark34.openlauncherlib.internal.InternalLaunchProfile;
import fr.theshark34.openlauncherlib.internal.JarLoader;
import fr.theshark34.openlauncherlib.internal.UnknownMainClassException;
import fr.theshark34.openlauncherlib.internal.UnknownMethodException;
import fr.theshark34.openlauncherlib.util.LogUtil;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Date;

public class InternalLauncher
implements ClassInitializer {
    private InternalLaunchProfile profile;
    private ClassInitializer initializer;

    public InternalLauncher(InternalLaunchProfile profile) {
        this(profile, null);
    }

    public InternalLauncher(InternalLaunchProfile profile, ClassInitializer initializer) {
        this.profile = profile;
        this.initializer = initializer != null ? initializer : this;
    }

    public Object launch() throws LaunchException {
        Class<?> theClass;
        LogUtil.info("hi-int");
        LogUtil.info("launching", ":", new Date(System.currentTimeMillis()).toString());
        long start = System.currentTimeMillis();
        if (this.profile.getClasspath() != null) {
            for (File f : this.profile.getClasspath()) {
                LogUtil.info("loading", ":", f.getAbsolutePath());
                JarLoader.addToClasspath(f);
            }
        }
        try {
            theClass = ClassLoader.getSystemClassLoader().loadClass(this.profile.getTargetClass());
        }
        catch (Exception e) {
            if (!(e instanceof SecurityException) || !e.getMessage().contains("signer information does not match signer information of other classes in the same package")) {
                throw new UnknownMainClassException(this.profile.getTargetClass(), e);
            }
            LogUtil.err("security");
            return null;
        }
        LogUtil.info("init", ":", this.profile.getTargetClass());
        Method method = null;
        try {
            Method[] methods;
            for (Method m : methods = theClass.getDeclaredMethods()) {
                if (!m.getName().equals(this.profile.getTargetMethod()) || !Arrays.equals(m.getParameterTypes(), this.profile.getParametersTypes())) continue;
                method = m;
                break;
            }
            if (method == null) {
                throw new UnknownMethodException(this.profile.getTargetMethod());
            }
        }
        catch (Exception e) {
            throw e instanceof UnknownMethodException ? (UnknownMethodException)e : new UnknownMethodException(this.profile.getTargetMethod(), e);
        }
        Object initClass = null;
        if (!Modifier.isStatic(method.getModifiers())) {
            try {
                initClass = this.initializer.init(theClass);
            }
            catch (Throwable t) {
                throw new LaunchException("Can't initialize the main class", t);
            }
        }
        method.setAccessible(true);
        long totalTime = System.currentTimeMillis() - start;
        int seconds = (int)(totalTime / 1000L) % 60;
        int minutes = (int)(totalTime / 60000L % 60L);
        int hours = (int)(totalTime / 3600000L % 24L);
        String strTime = hours + " hours " + minutes + " minutes " + seconds + " seconds and " + totalTime % 1000L + " milliseconds.";
        LogUtil.info("total", ":", strTime);
        LogUtil.info("start", this.profile.getTargetClass(), "->", this.profile.getTargetMethod(), "(" + Arrays.toString(this.profile.getParametersTypes()) + ")");
        try {
            return method.invoke(initClass, this.profile.getParameters());
        }
        catch (InvocationTargetException e) {
            Throwable thrown = e.getTargetException();
            if (thrown instanceof ExceptionInInitializerError) {
                ExceptionInInitializerError initError = (ExceptionInInitializerError)thrown;
                thrown = initError.getException();
            }
            throw new LaunchException("Invoked method returned an exception", thrown);
        }
        catch (IllegalAccessException e) {
            throw new LaunchException("This is not supposed to happen", e);
        }
    }

    public InternalLaunchProfile getProfile() {
        return this.profile;
    }

    public void setProfile(InternalLaunchProfile profile) {
        this.profile = profile;
    }

    public ClassInitializer getInitializer() {
        return this.initializer;
    }

    public void setInitializer(ClassInitializer initializer) {
        this.initializer = initializer;
    }

    @Override
    public Object init(Class<?> toInit) throws IllegalAccessException, InstantiationException {
        return toInit.newInstance();
    }
}

