/*
 * Decompiled with CFR 0.152.
 */
package fr.pepefab.ucnoel2025.Database;

import fr.pepefab.ucnoel2025.Database.DatabaseManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class QuotidienDatabase {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getQuestId(String pseudo) {
        String query = "SELECT questId FROM journalierObjectif WHERE pseudo = ?";
        try (Connection connection = DatabaseManager.getInstance().getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.setString(1, pseudo);
            try (ResultSet rs = statement.executeQuery();){
                if (!rs.next()) return 0;
                int n = rs.getInt("questId");
                return n;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getPokemonQuantity(String pseudo) {
        String query = "SELECT pokemonQuantity FROM journalierObjectif WHERE pseudo = ?";
        try (Connection connection = DatabaseManager.getInstance().getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.setString(1, pseudo);
            try (ResultSet rs = statement.executeQuery();){
                if (!rs.next()) return 0;
                int n = rs.getInt("pokemonQuantity");
                return n;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static void setPokemonQuantity(String pseudo, int amount) {
        String query = "UPDATE journalierObjectif SET pokemonQuantity = pokemonQuantity + ? WHERE pseudo = ?";
        try (Connection connection = DatabaseManager.getInstance().getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.setInt(1, amount);
            statement.setString(2, pseudo);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void initializePlayer(String pseudo, int questId, int pokemonAmount) {
        String query = "INSERT IGNORE INTO journalierObjectif (pseudo, questId, pokemonQuantity) VALUES (?, ?, ?)";
        try (Connection connection = DatabaseManager.getInstance().getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.setString(1, pseudo);
            statement.setInt(2, questId);
            statement.setInt(3, pokemonAmount);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void forceUpdatePlayer(String pseudo, int questId, int pokemonAmount) {
        String query = "INSERT INTO journalierObjectif (pseudo, questId, pokemonQuantity) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE questId = VALUES(questId), pokemonQuantity = VALUES(pokemonQuantity)";
        try (Connection connection = DatabaseManager.getInstance().getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.setString(1, pseudo);
            statement.setInt(2, questId);
            statement.setInt(3, pokemonAmount);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void resetAllPokemon() {
        String query = "TRUNCATE TABLE journalierObjectif";
        try (Connection connection = DatabaseManager.getInstance().getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

