/*
 * Decompiled with CFR 0.152.
 */
package fr.pepefab.ucnoel2025.Database;

import fr.pepefab.ucnoel2025.Database.DatabaseManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class LancerBouleDatabase {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getQuantity(String pseudo) {
        String query = "SELECT quantity FROM lancerBouleObjectif WHERE pseudo = ?";
        try (Connection connection = DatabaseManager.getInstance().getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.setString(1, pseudo);
            try (ResultSet rs = statement.executeQuery();){
                if (!rs.next()) return 0;
                int n = rs.getInt("quantity");
                return n;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static List<String> getPokemonList(String pseudo) {
        String query = "SELECT pokemonList FROM lancerBouleObjectif WHERE pseudo = ?";
        ArrayList<String> list = new ArrayList<String>();
        try (Connection connection = DatabaseManager.getInstance().getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.setString(1, pseudo);
            try (ResultSet rs = statement.executeQuery();){
                String raw;
                if (rs.next() && (raw = rs.getString("pokemonList")) != null && !raw.isEmpty()) {
                    for (String entry : raw.split(";")) {
                        String trimmed = entry.trim();
                        if (trimmed.isEmpty()) continue;
                        list.add(trimmed);
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void addPokemonToList(String pseudo, String pokemon) {
        String query = "UPDATE lancerBouleObjectif SET pokemonList = CONCAT(    CASE WHEN pokemonList = '' THEN '' ELSE CONCAT(pokemonList, ';') END, ?) WHERE pseudo = ?";
        try (Connection connection = DatabaseManager.getInstance().getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.setString(1, pokemon);
            statement.setString(2, pseudo);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getObjectifValue(String pseudo, String column) {
        String query = "SELECT " + column + " FROM lancerBouleObjectif WHERE pseudo = ?";
        try (Connection connection = DatabaseManager.getInstance().getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.setString(1, pseudo);
            try (ResultSet rs = statement.executeQuery();){
                if (!rs.next()) return 0;
                int n = rs.getInt(column);
                return n;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static void setObjectifValue(String pseudo, String column, int value) {
        String query = "UPDATE lancerBouleObjectif SET " + column + " = " + column + " + ? WHERE pseudo = ?";
        try (Connection connection = DatabaseManager.getInstance().getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.setInt(1, value);
            statement.setString(2, pseudo);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

