/*
 * Decompiled with CFR 0.152.
 */
package fr.pepefab.ucnoel2025.Database;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import fr.pepefab.ucnoel2025.Config.ConnectionBDDConfig;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class DatabaseManager {
    private static HikariDataSource dataSource;
    private static final DatabaseManager INSTANCE;

    public static void init() throws SQLException {
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(ConnectionBDDConfig.INSTANCE.jdbcUrl);
        config.setUsername(ConnectionBDDConfig.INSTANCE.username);
        config.setPassword(ConnectionBDDConfig.INSTANCE.password);
        config.setMaximumPoolSize(40);
        config.setMinimumIdle(2);
        config.setConnectionTestQuery("SELECT 1");
        config.setPoolName("UC-Noel2025");
        config.setIdleTimeout(300000L);
        config.setMaxLifetime(1800000L);
        config.setLeakDetectionThreshold(15000L);
        dataSource = new HikariDataSource(config);
        DatabaseManager.createTableKillObjectif();
        DatabaseManager.createTableCraftObjectif();
        DatabaseManager.createTableCatchObjectif();
        DatabaseManager.createTableClassement();
        DatabaseManager.createTableObjectifJournalier();
        DatabaseManager.createTableLegendaryObjectif();
        DatabaseManager.createTableHaveTakeRecompenses();
        DatabaseManager.createTableLancerBouleObjectif();
    }

    public static DatabaseManager getInstance() {
        return INSTANCE;
    }

    public Connection getConnection() throws SQLException {
        return dataSource.getConnection();
    }

    public static void close() {
        if (dataSource != null) {
            dataSource.close();
        }
    }

    public static void initBDDPlayer(String playerName, String columnName) {
        String query = "INSERT IGNORE INTO " + columnName + " (pseudo) VALUES (?)";
        try (Connection connection = DatabaseManager.getInstance().getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.setString(1, playerName);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static void createTableKillObjectif() throws SQLException {
        String query = "CREATE TABLE IF NOT EXISTS killObjectif (pseudo VARCHAR(30) PRIMARY KEY,glace INT NOT NULL DEFAULT 0,objectifIsFinish INT NOT NULL DEFAULT 0)";
        try (Connection connection = dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.executeUpdate();
        }
    }

    private static void createTableCraftObjectif() throws SQLException {
        String query = "CREATE TABLE IF NOT EXISTS craftObjectif (pseudo VARCHAR(30) PRIMARY KEY,bougies INT NOT NULL DEFAULT 0,objectifIsFinish INT NOT NULL DEFAULT 0)";
        try (Connection connection = dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.executeUpdate();
        }
    }

    private static void createTableCatchObjectif() throws SQLException {
        String query = "CREATE TABLE IF NOT EXISTS captureObjectif (pseudo VARCHAR(30) PRIMARY KEY,pomdepik INT NOT NULL DEFAULT 0,cadoizo INT NOT NULL DEFAULT 0,crabominable INT NOT NULL DEFAULT 0,objectifIsFinish INT NOT NULL DEFAULT 0)";
        try (Connection connection = dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.executeUpdate();
        }
    }

    private static void createTableLancerBouleObjectif() throws SQLException {
        String query = "CREATE TABLE IF NOT EXISTS lancerBouleObjectif (pseudo VARCHAR(30) PRIMARY KEY,pokemonList VARCHAR(7000) NOT NULL DEFAULT '',quantity INT NOT NULL DEFAULT 0,objectifIsFinish INT NOT NULL DEFAULT 0)";
        try (Connection connection = dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.executeUpdate();
        }
    }

    private static void createTableClassement() throws SQLException {
        String query = "CREATE TABLE IF NOT EXISTS classement (id INTEGER PRIMARY KEY AUTO_INCREMENT,pseudo VARCHAR(40),date VARCHAR(255))";
        try (Connection connection = dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.executeUpdate();
        }
    }

    private static void createTableObjectifJournalier() throws SQLException {
        String query = "CREATE TABLE IF NOT EXISTS journalierObjectif (pseudo VARCHAR(30) PRIMARY KEY,questID INT NOT NULL,pokemonQuantity INT NOT NULL DEFAULT 0)";
        try (Connection connection = dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.executeUpdate();
        }
    }

    private static void createTableLegendaryObjectif() throws SQLException {
        String query = "CREATE TABLE IF NOT EXISTS legendaryObjectif (pseudo VARCHAR(30) PRIMARY KEY,objectifIsFinish INT NOT NULL DEFAULT 0)";
        try (Connection connection = dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.executeUpdate();
        }
    }

    private static void createTableHaveTakeRecompenses() throws SQLException {
        String query = "CREATE TABLE IF NOT EXISTS haveTakeRecompenses (pseudo VARCHAR(30) PRIMARY KEY,haveTakeRecompensePrincipal INT NOT NULL DEFAULT 0,haveTakeRecompenseJournalier INT NOT NULL DEFAULT 0)";
        try (Connection connection = dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.executeUpdate();
        }
    }

    static {
        INSTANCE = new DatabaseManager();
    }
}

