/*
 * Decompiled with CFR 0.152.
 */
package fr.pepefab.ucnoel2025.Database;

import fr.pepefab.ucnoel2025.Database.DatabaseManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ClassementDatabase {
    public static void insertPlayer(String pseudo) {
        String query = "INSERT INTO classement (pseudo, date) VALUES (?, ?)";
        Date currentDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy '\u00e0' HH:mm");
        String formattedDate = dateFormat.format(currentDate);
        try (Connection connection = DatabaseManager.getInstance().getConnection();
             PreparedStatement statement = connection.prepareStatement(query);){
            statement.setString(1, pseudo);
            statement.setString(2, formattedDate);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static List<String> getClassementList() {
        ArrayList<String> classementList = new ArrayList<String>();
        String query = "SELECT id, pseudo, date FROM classement ORDER BY id ASC LIMIT 10";
        try (Connection connection = DatabaseManager.getInstance().getConnection();
             PreparedStatement statement = connection.prepareStatement(query);
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                int id = resultSet.getInt("id");
                String pseudo = resultSet.getString("pseudo");
                String date = resultSet.getString("date");
                String formatted = "#" + id + " \u00a7b" + pseudo + " \u00a77- \u00a7b" + date;
                classementList.add(formatted);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return classementList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getLastID() {
        String query = "SELECT id FROM classement ORDER BY id DESC LIMIT 1";
        try (Connection connection = DatabaseManager.getInstance().getConnection();
             PreparedStatement statement = connection.prepareStatement(query);
             ResultSet resultSet = statement.executeQuery();){
            if (!resultSet.next()) return 0;
            int n = resultSet.getInt("id");
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0;
    }
}

