/*
 * Decompiled with CFR 0.152.
 */
package cobblemonultra.pepefab.ucarmor.HUD;

import cobblemonultra.pepefab.ucarmor.HUD.LegendaryTimerPayload.LegendaryClientData;
import cobblemonultra.pepefab.ucarmor.HUD.LegendaryTimerPayload.RequestLegendaryTimePayload;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_8710;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class LegendaryTimerHUD {
    private static final class_2960 HUD_IMAGE = class_2960.method_60655((String)"ucarmor", (String)"textures/images/legendary.png");
    private static long zeroSinceMs = 0L;

    public static void register() {
        HudRenderCallback.EVENT.register(LegendaryTimerHUD::render);
    }

    private static void render(class_332 drawContext, class_9779 tickCounter) {
        int color;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1690.field_1842) {
            return;
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int marginRight = 10;
        int marginBottom = 18;
        int imageWidth = 9;
        int imageHeight = 9;
        Optional<Long> timestampOpt = LegendaryClientData.REMAINING_TIMESTAMP;
        long remainingSeconds = LegendaryTimerHUD.getRemainingSeconds(timestampOpt);
        if (timestampOpt.isPresent() && remainingSeconds == 0L) {
            long now = System.currentTimeMillis();
            if (zeroSinceMs == 0L) {
                zeroSinceMs = now;
            } else {
                long elapsed = now - zeroSinceMs;
                if (elapsed >= 4000L && !LegendaryClientData.requestedRefresh) {
                    ClientPlayNetworking.send((class_8710)new RequestLegendaryTimePayload());
                    LegendaryClientData.requestedRefresh = true;
                }
            }
        } else {
            zeroSinceMs = 0L;
        }
        String text = LegendaryTimerHUD.formatSeconds(remainingSeconds);
        if (remainingSeconds > 0L && remainingSeconds <= 14L) {
            int ticks = client.field_1724.field_6012;
            boolean visibleState = ticks / 10 % 2 == 0;
            int red = 0xFF6B6B;
            int white = 0xFFFFFF;
            color = visibleState ? red : white;
        } else {
            color = 0xFFFFFF;
        }
        int textWidth = client.field_1772.method_1727(text);
        int spacing = 3;
        float scale = 0.65f;
        int totalWidth = imageWidth + spacing + (int)((float)textWidth * scale);
        int baseX = screenWidth - marginRight - totalWidth;
        int baseY = screenHeight - marginBottom - imageHeight;
        drawContext.method_25290(HUD_IMAGE, baseX, baseY, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight);
        int textX = baseX + imageWidth + spacing;
        int textY = baseY + 2;
        drawContext.method_51448().method_22903();
        drawContext.method_51448().method_46416((float)textX, (float)textY, 0.0f);
        drawContext.method_51448().method_22905(scale, scale, 1.0f);
        drawContext.method_51433(client.field_1772, text, 0, 0, color, false);
        drawContext.method_51448().method_22909();
    }

    private static long getRemainingSeconds(Optional<Long> timestampOpt) {
        if (timestampOpt.isEmpty()) {
            return 0L;
        }
        long future = timestampOpt.get();
        long now = System.currentTimeMillis();
        long diff = (future - now) / 1000L;
        return Math.max(diff, 0L);
    }

    private static String formatSeconds(long diff) {
        if (diff <= 0L) {
            return "00:00";
        }
        long minutes = diff / 60L;
        long seconds = diff % 60L;
        if (minutes > 59L) {
            minutes = 59L;
            seconds = 59L;
        }
        return String.format("%02d:%02d", minutes, seconds);
    }
}

