/*
 * Decompiled with CFR 0.152.
 */
package xyz.pepefab.ucclassement.Utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public final class PlayerHeadsUtil {
    private static final Map<String, class_2960> READY = new ConcurrentHashMap<String, class_2960>();
    private static final Set<String> LOADING = ConcurrentHashMap.newKeySet();
    private static final int TEX_SIZE = 110;
    private static final HttpClient HTTP = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(3L)).build();

    public static void renderPlayerHead(class_332 ctx, String playerName, int x, int y, int size) {
        class_310 mc = class_310.method_1551();
        String key = playerName.toLowerCase(Locale.ROOT);
        class_2960 tex = READY.get(key);
        if (tex == null || mc.method_1531().method_4619(tex) == null) {
            if (LOADING.add(key)) {
                ((CompletableFuture)PlayerHeadsUtil.fetchHeadPng(playerName).thenAccept(bytes -> {
                    if (bytes == null) {
                        LOADING.remove(key);
                        return;
                    }
                    class_2960 id = class_2960.method_60655((String)"uc-classement", (String)("head_" + String.valueOf(UUID.randomUUID())));
                    mc.execute(() -> {
                        try (ByteArrayInputStream in = new ByteArrayInputStream((byte[])bytes);){
                            class_1011 img = class_1011.method_4309((InputStream)in);
                            mc.method_1531().method_4616(id, (class_1044)new class_1043(img));
                            READY.put(key, id);
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            LOADING.remove(key);
                        }
                    });
                })).exceptionally(ex -> {
                    LOADING.remove(key);
                    return null;
                });
            }
            return;
        }
        PlayerHeadsUtil.drawHead(ctx, tex, x, y, size);
    }

    private static CompletableFuture<byte[]> fetchHeadPng(String name) {
        String u = URLEncoder.encode(name, StandardCharsets.UTF_8);
        return PlayerHeadsUtil.fetchUrl("https://minotar.net/cube/" + u + "/110");
    }

    private static CompletableFuture<byte[]> fetchUrl(String url) {
        HttpRequest req = HttpRequest.newBuilder(URI.create(url)).timeout(Duration.ofSeconds(4L)).header("User-Agent", "UCClassement/1.0 (+fabric)").GET().build();
        return ((CompletableFuture)HTTP.sendAsync(req, HttpResponse.BodyHandlers.ofByteArray()).thenApply(resp -> resp.statusCode() / 100 == 2 ? (byte[])resp.body() : null)).exceptionally(ex -> null);
    }

    private static void drawHead(class_332 ctx, class_2960 tex, int x, int y, int size) {
        ctx.method_25293(tex, x, y, size, size, 0.0f, 0.0f, 110, 110, 110, 110);
    }
}

