/*
 * Decompiled with CFR 0.152.
 */
package xyz.pepefab.ucclassement;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.pepefab.ucclassement.Common.ClassementDataPayload;
import xyz.pepefab.ucclassement.Common.ClassementUpdateTimePayload;
import xyz.pepefab.ucclassement.Common.ClassementValuePlayerPayload;
import xyz.pepefab.ucclassement.Common.DataCache.ClassementCache;
import xyz.pepefab.ucclassement.Common.RequestToClientIntPayload;
import xyz.pepefab.ucclassement.Common.RequestToServerPayload;
import xyz.pepefab.ucclassement.Config.Config;
import xyz.pepefab.ucclassement.Database.DatabaseManager;
import xyz.pepefab.ucclassement.Database.RequestCatchBDD;
import xyz.pepefab.ucclassement.Database.RequestEvolveBDD;
import xyz.pepefab.ucclassement.Database.RequestFishingBDD;
import xyz.pepefab.ucclassement.Database.RequestKillBDD;
import xyz.pepefab.ucclassement.Listeners.CatchListeners;
import xyz.pepefab.ucclassement.Listeners.EvolveListeners;
import xyz.pepefab.ucclassement.Listeners.FishingListeners;
import xyz.pepefab.ucclassement.Listeners.KillListeners;
import xyz.pepefab.ucclassement.Listeners.OnPlayerConnectListeners;
import xyz.pepefab.ucclassement.Utils.AsyncExecutor;

public class Main
implements ModInitializer {
    public static final String MOD_ID = "uc-classement";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"uc-classement");
    private ScheduledExecutorService scheduler;
    public static String lastClassementUpdate;

    public void onInitialize() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            return;
        }
        Config.load();
        RequestToServerPayload.registerCommon();
        RequestToClientIntPayload.registerCommon();
        ClassementDataPayload.registerCommon();
        ClassementUpdateTimePayload.registerCommon();
        ClassementValuePlayerPayload.registerCommon();
        try {
            DatabaseManager.init();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.NORMAL, CatchListeners::captureEvent);
        CobblemonEvents.BATTLE_FAINTED.subscribe(Priority.NORMAL, KillListeners::onPlayerKillPokemon);
        CobblemonEvents.EVOLUTION_COMPLETE.subscribe(Priority.NORMAL, EvolveListeners::onPlayerEvolvePokemon);
        CobblemonEvents.BOBBER_SPAWN_POKEMON_POST.subscribe(Priority.NORMAL, FishingListeners::onPlayerSpawnPokemonFishing);
        OnPlayerConnectListeners.onPlayerConnection();
        ServerLifecycleEvents.SERVER_STARTED.register(this::onServerStarted);
        ServerLifecycleEvents.SERVER_STOPPING.register(minecraftServer -> {
            DatabaseManager.close();
            AsyncExecutor.SQL_EXECUTOR.shutdown();
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"classement").requires(source -> source.method_9259(0))).executes(ctx -> {
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            String playerName = player.method_5477().getString();
            AsyncExecutor.SQL_EXECUTOR.execute(() -> {
                List<ClassementDataPayload.ClassementEntry> converted0 = ClassementCache.getClassementEvolutions().stream().map(e -> new ClassementDataPayload.ClassementEntry(e.position(), e.pseudo(), e.valeur())).toList();
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClassementDataPayload("Pok\u00e9mon Evolu\u00e9", converted0));
                List<ClassementDataPayload.ClassementEntry> converted1 = ClassementCache.getClassementCaptures().stream().map(e -> new ClassementDataPayload.ClassementEntry(e.position(), e.pseudo(), e.valeur())).toList();
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClassementDataPayload("Pok\u00e9mon Captur\u00e9", converted1));
                List<ClassementDataPayload.ClassementEntry> converted2 = ClassementCache.getClassementTues().stream().map(e -> new ClassementDataPayload.ClassementEntry(e.position(), e.pseudo(), e.valeur())).toList();
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClassementDataPayload("Pok\u00e9mon Tu\u00e9", converted2));
                List<ClassementDataPayload.ClassementEntry> converted3 = ClassementCache.getClassementDW().stream().map(e -> new ClassementDataPayload.ClassementEntry(e.position(), e.pseudo(), e.valeur())).toList();
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClassementDataPayload("Pok\u00e9mon DW Captur\u00e9", converted3));
                List<ClassementDataPayload.ClassementEntry> converted4 = ClassementCache.getClassementDitto().stream().map(e -> new ClassementDataPayload.ClassementEntry(e.position(), e.pseudo(), e.valeur())).toList();
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClassementDataPayload("Ditto Captur\u00e9", converted4));
                List<ClassementDataPayload.ClassementEntry> converted5 = ClassementCache.getClassementLegendary().stream().map(e -> new ClassementDataPayload.ClassementEntry(e.position(), e.pseudo(), e.valeur())).toList();
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClassementDataPayload("Pok\u00e9mon L\u00e9gendaire Captur\u00e9", converted5));
                List<ClassementDataPayload.ClassementEntry> converted6 = ClassementCache.getClassementPeche().stream().map(e -> new ClassementDataPayload.ClassementEntry(e.position(), e.pseudo(), e.valeur())).toList();
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClassementDataPayload("Pok\u00e9mon P\u00each\u00e9", converted6));
                List<ClassementDataPayload.ClassementEntry> converted7 = ClassementCache.getClassementShiny().stream().map(e -> new ClassementDataPayload.ClassementEntry(e.position(), e.pseudo(), e.valeur())).toList();
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClassementDataPayload("Pok\u00e9mon Shiny Captur\u00e9", converted7));
                Main.updateTime(player);
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClassementValuePlayerPayload("Pok\u00e9mon Evolu\u00e9", RequestEvolveBDD.getQuantity((String)playerName, (String)"pokemonNumber")));
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClassementValuePlayerPayload("Pok\u00e9mon Captur\u00e9", RequestCatchBDD.getQuantity((String)playerName, (String)"pokemonNumber")));
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClassementValuePlayerPayload("Pok\u00e9mon Tu\u00e9", RequestKillBDD.getQuantity((String)playerName, (String)"pokemonNumber")));
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClassementValuePlayerPayload("Pok\u00e9mon DW Captur\u00e9", RequestCatchBDD.getQuantity((String)playerName, (String)"dwNumber")));
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClassementValuePlayerPayload("Ditto Captur\u00e9", RequestCatchBDD.getQuantity((String)playerName, (String)"dittoNumber")));
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClassementValuePlayerPayload("Pok\u00e9mon L\u00e9gendaire Captur\u00e9", RequestCatchBDD.getQuantity((String)playerName, (String)"legendaryNumber")));
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClassementValuePlayerPayload("Pok\u00e9mon P\u00each\u00e9", RequestFishingBDD.getQuantity((String)playerName, (String)"pokemonNumber")));
                ServerPlayNetworking.send((class_3222)player, (class_8710)new ClassementValuePlayerPayload("Pok\u00e9mon Shiny Captur\u00e9", RequestCatchBDD.getQuantity((String)playerName, (String)"shinyNumber")));
            });
            return 1;
        })));
    }

    private void onServerStarted(MinecraftServer server) {
        LOGGER.info("[UC-Classement] - Mise en cache des donn\u00e9es");
        AsyncExecutor.SQL_EXECUTOR.execute(() -> {
            Main.listDatabaseUpdated();
            lastClassementUpdate = LocalTime.now().format(DateTimeFormatter.ofPattern("HH:mm"));
        });
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.scheduleAtFixedRate(Main.updateClassementOneHour(), 5L, 1L, TimeUnit.HOURS);
    }

    private static Runnable updateClassementOneHour() {
        return () -> {
            Main.listDatabaseUpdated();
            lastClassementUpdate = LocalTime.now().format(DateTimeFormatter.ofPattern("HH:mm"));
            LOGGER.info("[UC-Classement] - Mise \u00e0 jour des classements en cache");
        };
    }

    private static void listDatabaseUpdated() {
        try (Connection connection = DatabaseManager.getInstance().getConnection();){
            RequestCatchBDD.loadClassementPokemonCatch((Connection)connection);
            RequestCatchBDD.loadClassementPokemonDittoCatch((Connection)connection);
            RequestCatchBDD.loadClassementPokemonDWCatch((Connection)connection);
            RequestCatchBDD.loadClassementPokemonLegendaryCatch((Connection)connection);
            RequestCatchBDD.loadClassementPokemonShinyCatch((Connection)connection);
            RequestEvolveBDD.loadClassementEvolutions((Connection)connection);
            RequestFishingBDD.loadClassementPeche((Connection)connection);
            RequestKillBDD.loadClassementPokemonKill((Connection)connection);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static void updateTime(class_3222 player) {
        String message = "Derni\u00e8re mise \u00e0 jour \u00e0 " + lastClassementUpdate;
        ClassementUpdateTimePayload payload = new ClassementUpdateTimePayload(message);
        ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
    }
}

