/*
 * Decompiled with CFR 0.152.
 */
package xyz.pepefab.ucclassement.Config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import xyz.pepefab.ucclassement.Main;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_DIR = new File("config/UC-Classement");
    private static final File CONFIG_FILE = new File(CONFIG_DIR, "config.json");
    public static Config INSTANCE = new Config();
    public String jdbcUrl = "jdbc:mariadb://127.0.0.1:3306/database";
    public String username = "username";
    public String password = "password";

    public static void load() {
        try {
            if (!CONFIG_DIR.exists()) {
                CONFIG_DIR.mkdirs();
            }
            if (!CONFIG_FILE.exists()) {
                Config.save();
                return;
            }
            FileReader reader = new FileReader(CONFIG_FILE);
            INSTANCE = (Config)GSON.fromJson((Reader)reader, Config.class);
            reader.close();
        }
        catch (IOException e) {
            Main.LOGGER.error("Erreur lors du chargement de la config: " + e.getMessage());
        }
    }

    public static void save() {
        try {
            if (!CONFIG_DIR.exists()) {
                CONFIG_DIR.mkdirs();
            }
            FileWriter writer = new FileWriter(CONFIG_FILE);
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            Main.LOGGER.error("Erreur lors de la sauvegarde de la config: " + e.getMessage());
        }
    }
}

