/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.fabric.datapack.showdown;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.data.DataRegistry;
import com.cobblemon.mod.common.api.reactive.SimpleObservable;
import com.cobblemon.mod.common.battles.runner.graal.GraalShowdownService;
import com.cobblemon.mod.relocations.graalvm.polyglot.Value;
import com.github.yajatkaul.mega_showdown.MegaShowdown;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Unit;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;

public class HeldItems
implements DataRegistry {
    private static final class_2960 ID = class_2960.method_60655((String)"mega_showdown", (String)"mega_showdown/showdown/held_items");
    private static final SimpleObservable<HeldItems> OBSERVABLE = new SimpleObservable();
    private final Map<String, String> heldItemsScripts = new HashMap<String, String>();
    public static final HeldItems INSTANCE = new HeldItems();

    private HeldItems() {
        OBSERVABLE.subscribe(Priority.NORMAL, this::heldItemsLoad);
    }

    public void heldItemsLoad(HeldItems heldItem) {
        Cobblemon.INSTANCE.getShowdownThread().queue(showdownService -> {
            if (showdownService instanceof GraalShowdownService) {
                GraalShowdownService service = (GraalShowdownService)showdownService;
                Value receiveHeldItemDataFn = service.context.getBindings("js").getMember("receiveHeldItemData");
                for (Map.Entry<String, String> entry : INSTANCE.getHeldItemsScripts().entrySet()) {
                    String itemId = entry.getKey();
                    String js = entry.getValue().replace("\n", " ");
                    receiveHeldItemDataFn.execute(new Object[]{itemId, js});
                }
            }
            return Unit.INSTANCE;
        });
    }

    public Map<String, String> getHeldItemsScripts() {
        return this.heldItemsScripts;
    }

    @NotNull
    public class_2960 getId() {
        return ID;
    }

    @NotNull
    public class_3264 getType() {
        return class_3264.field_14190;
    }

    @NotNull
    public SimpleObservable<? extends DataRegistry> getObservable() {
        return OBSERVABLE;
    }

    public void reload(@NotNull class_3300 resourceManager) {
        this.heldItemsScripts.clear();
        resourceManager.method_14488("mega_showdown/showdown/held_items", path -> path.method_12832().endsWith(".js")).forEach((id, resource) -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.method_14482(), StandardCharsets.UTF_8));){
                String js = reader.lines().collect(Collectors.joining("\n"));
                String itemId = new File(id.method_12832()).getName().replace(".js", "");
                this.heldItemsScripts.put(itemId, js);
            }
            catch (IOException e) {
                MegaShowdown.LOGGER.error("Failed to load held item script: {} {}", id, (Object)e);
            }
        });
        OBSERVABLE.emit((Object[])new HeldItems[]{this});
    }

    public void sync(@NotNull class_3222 serverPlayer) {
    }
}

