/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.codec.particles;

import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.github.yajatkaul.mega_showdown.MegaShowdown;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.codec.particles.AnimationData;
import com.github.yajatkaul.mega_showdown.codec.particles.SoundCodec;
import com.github.yajatkaul.mega_showdown.utils.AspectUtils;
import com.github.yajatkaul.mega_showdown.utils.PokemonBehaviourHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import kotlin.Unit;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public record SnowStormParticle(Optional<List<String>> source_apply, Optional<List<String>> target_apply, Optional<List<String>> source_revert, Optional<List<String>> target_revert, Optional<String> particle_apply, Optional<Float> apply_after, Optional<String> particle_revert, Optional<Float> revert_after, Optional<SoundCodec> sound_apply, Optional<SoundCodec> sound_revert, Optional<AnimationData> animations) {
    public static final Codec<SnowStormParticle> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)Codec.STRING).optionalFieldOf("source_apply").forGetter(SnowStormParticle::source_apply), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("target_apply").forGetter(SnowStormParticle::target_apply), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("source_revert").forGetter(SnowStormParticle::source_revert), (App)Codec.list((Codec)Codec.STRING).optionalFieldOf("target_revert").forGetter(SnowStormParticle::target_revert), (App)Codec.STRING.optionalFieldOf("particle_apply").forGetter(SnowStormParticle::particle_apply), (App)Codec.FLOAT.optionalFieldOf("apply_after").forGetter(SnowStormParticle::apply_after), (App)Codec.STRING.optionalFieldOf("particle_revert").forGetter(SnowStormParticle::particle_revert), (App)Codec.FLOAT.optionalFieldOf("revert_after").forGetter(SnowStormParticle::revert_after), (App)SoundCodec.CODEC.optionalFieldOf("sound_apply").forGetter(SnowStormParticle::sound_apply), (App)SoundCodec.CODEC.optionalFieldOf("sound_revert").forGetter(SnowStormParticle::sound_revert), (App)AnimationData.CODEC.optionalFieldOf("animations").forGetter(SnowStormParticle::animations)).apply((Applicative)instance, SnowStormParticle::new));

    public void apply(PokemonEntity context, List<String> aspects, PokemonEntity other) {
        this.processTransformation(context, aspects, other, null, true);
    }

    public void revert(PokemonEntity context, List<String> aspects, PokemonEntity other) {
        this.processTransformation(context, aspects, other, null, false);
    }

    public void applyBattle(PokemonEntity context, List<String> aspects, PokemonEntity other, BattlePokemon battlePokemon, float battle_pause, boolean loop) {
        battlePokemon.actor.getBattle().dispatchWaitingToFront(battle_pause, () -> Unit.INSTANCE);
        this.processTransformation(context, aspects, other, battlePokemon, true);
    }

    public void revertBattle(PokemonEntity context, List<String> aspects, PokemonEntity other, BattlePokemon battlePokemon, float battle_pause) {
        battlePokemon.actor.getBattle().dispatchWaitingToFront(battle_pause, () -> Unit.INSTANCE);
        this.processTransformation(context, aspects, other, battlePokemon, false);
    }

    private void processTransformation(PokemonEntity context, List<String> aspects, PokemonEntity other, BattlePokemon battlePokemon, boolean isApply) {
        Optional<Float> delay;
        context.method_5977(true);
        class_2487 pokemonPersistentData = context.getPokemon().getPersistentData();
        pokemonPersistentData.method_10556("form_changing", true);
        AspectUtils.appendRevertDataPokemon(Effect.empty(), aspects, context.getPokemon(), "aspects");
        Optional<String> particle = isApply ? this.particle_apply : this.particle_revert;
        Optional<List<String>> sourceParticles = isApply ? this.source_apply : this.source_revert;
        Optional<List<String>> targetParticles = isApply ? this.target_apply : this.target_revert;
        Optional<Float> optional = delay = isApply ? this.apply_after : this.revert_after;
        if (particle.isEmpty()) {
            this.applyAspectsAndCleanup(context, aspects, pokemonPersistentData, battlePokemon);
            return;
        }
        this.animations.ifPresent(animation -> {
            if (isApply) {
                animation.applyAnimations(context);
            } else {
                animation.revertAnimations(context);
            }
        });
        class_2960 particleId = class_2960.method_12829((String)particle.get());
        if (particleId == null) {
            MegaShowdown.LOGGER.error("Invalid snowstorm {} particle{}", (Object)(isApply ? "apply" : "revert"), (Object)(battlePokemon != null ? " during battle" : ""));
            return;
        }
        PokemonBehaviourHelper.Companion.snowStormPartileSpawner(context, particleId, sourceParticles.orElse(null), other, targetParticles.orElse(null));
        this.playSound(context, isApply);
        delay.ifPresentOrElse(delayValue -> context.after(delayValue.floatValue(), () -> {
            this.applyAspectsAndCleanup(context, aspects, pokemonPersistentData, battlePokemon);
            return Unit.INSTANCE;
        }), () -> this.applyAspectsAndCleanup(context, aspects, pokemonPersistentData, battlePokemon));
    }

    private void applyAspectsAndCleanup(PokemonEntity context, List<String> aspects, class_2487 pokemonPersistentData, BattlePokemon battlePokemon) {
        AspectUtils.applyAspects(context.getPokemon(), aspects);
        if (battlePokemon != null) {
            AspectUtils.updatePackets(battlePokemon);
        }
        this.resetFormChangingState(context, pokemonPersistentData);
    }

    private void resetFormChangingState(PokemonEntity context, class_2487 pokemonPersistentData) {
        context.method_5977(false);
        pokemonPersistentData.method_10551("form_changing");
        pokemonPersistentData.method_10551("aspects");
    }

    private void playSound(PokemonEntity context, boolean isApply) {
        Optional<SoundCodec> sound = isApply ? this.sound_apply : this.sound_revert;
        sound.ifPresent(soundCodec -> soundCodec.play(context));
    }
}

