/*
 * Decompiled with CFR 0.152.
 */
package com.cuitemdroplist.server;

import com.cobblemon.mod.common.api.drop.DropEntry;
import com.cobblemon.mod.common.api.drop.DropTable;
import com.cobblemon.mod.common.api.drop.ItemDropEntry;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Species;
import com.cuitemdroplist.CuItemDropList;
import com.cuitemdroplist.config.ConfigManager;
import com.cuitemdroplist.data.CustomDropOther;
import com.cuitemdroplist.data.ItemDropData;
import com.cuitemdroplist.data.TypeDropSource;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.ranges.IntRange;

public class DropDataCache {
    private static final Map<String, ItemDropData> CACHE = new ConcurrentHashMap<String, ItemDropData>();
    private static volatile boolean initialized = false;
    private static boolean ucGeneralAvailable = false;

    public static void initialize() {
        String itemId;
        if (initialized) {
            return;
        }
        ConfigManager.initialize();
        ucGeneralAvailable = DropDataCache.checkUCGeneralAvailability();
        HashMap<String, List<ItemDropData.DropSource>> itemToSources = new HashMap<String, List<ItemDropData.DropSource>>();
        HashMap<String, List<TypeDropSource>> itemToTypeSources = new HashMap<String, List<TypeDropSource>>();
        for (Species species : PokemonSpecies.INSTANCE.getSpecies()) {
            String speciesId = species.getResourceIdentifier().toString();
            DropTable dropTable = species.getDrops();
            if (dropTable == null) continue;
            for (DropEntry dropEntry : dropTable.getEntries()) {
                ItemDropEntry itemDrop;
                String itemId2;
                if (!(dropEntry instanceof ItemDropEntry) || (itemId2 = (itemDrop = (ItemDropEntry)dropEntry).getItem().toString()).isEmpty()) continue;
                int minQuantity = 1;
                int maxQuantity = 1;
                try {
                    IntRange quantityRange = itemDrop.getQuantityRange();
                    if (quantityRange != null) {
                        minQuantity = quantityRange.getFirst();
                        maxQuantity = quantityRange.getLast();
                    } else {
                        minQuantity = itemDrop.getQuantity();
                        maxQuantity = itemDrop.getQuantity();
                    }
                }
                catch (Exception e) {
                    minQuantity = itemDrop.getQuantity();
                    maxQuantity = itemDrop.getQuantity();
                }
                double percentage = itemDrop.getPercentage();
                ItemDropData.DropSource source = new ItemDropData.DropSource(speciesId, minQuantity, maxQuantity, percentage, "normal", "");
                itemToSources.computeIfAbsent(itemId2, k -> new ArrayList()).add(source);
            }
        }
        DropDataCache.loadSpawnPoolDrops(itemToSources);
        if (ucGeneralAvailable) {
            DropDataCache.loadCustomDrops(itemToSources);
            DropDataCache.loadTypeLootDrops(itemToTypeSources);
        }
        for (Map.Entry entry : itemToSources.entrySet()) {
            itemId = (String)entry.getKey();
            List typeSources = itemToTypeSources.getOrDefault(itemId, new ArrayList());
            CACHE.put(itemId, new ItemDropData(itemId, itemId, (List)entry.getValue(), typeSources, new ArrayList<String>(), null, null));
        }
        for (Map.Entry entry : itemToTypeSources.entrySet()) {
            if (CACHE.containsKey(entry.getKey())) continue;
            itemId = (String)entry.getKey();
            CACHE.put(itemId, new ItemDropData(itemId, itemId, new ArrayList<ItemDropData.DropSource>(), (List)entry.getValue(), new ArrayList<String>(), null, null));
        }
        int customIndex = 0;
        for (CustomDropOther custom : ConfigManager.getCustomDropsOther()) {
            if (!custom.hasName() || custom.items == null) continue;
            String customId = "cuitemdroplist:custom_" + customIndex;
            CACHE.put(customId, new ItemDropData(customId, custom.items, new ArrayList<ItemDropData.DropSource>(), new ArrayList<TypeDropSource>(), custom.methode, custom.items_name, custom.color_item_name));
            ++customIndex;
        }
        initialized = true;
    }

    private static void loadSpawnPoolDrops(Map<String, List<ItemDropData.DropSource>> itemToSources) {
        try {
            Gson gson = new Gson();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            int loaded = 0;
            int dropsFound = 0;
            for (Species species : PokemonSpecies.INSTANCE.getSpecies()) {
                String speciesName = species.getResourceIdentifier().method_12832();
                int dexNumber = species.getNationalPokedexNumber();
                String filename = String.format("%04d_%s.json", dexNumber, speciesName);
                try {
                    InputStream stream = classLoader.getResourceAsStream("data/cobblemon/spawn_pool_world/" + filename);
                    try {
                        if (stream == null) continue;
                        String content = new String(stream.readAllBytes());
                        int beforeSize = itemToSources.values().stream().mapToInt(List::size).sum();
                        DropDataCache.processSpawnPoolJson(content, gson, itemToSources);
                        int afterSize = itemToSources.values().stream().mapToInt(List::size).sum();
                        if (afterSize <= beforeSize) continue;
                        ++loaded;
                        dropsFound += afterSize - beforeSize;
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            CuItemDropList.LOGGER.error("Error loading spawn pools: " + e.getMessage());
        }
    }

    private static void processSpawnPoolJson(String content, Gson gson, Map<String, List<ItemDropData.DropSource>> itemToSources) {
        try {
            JsonObject root = (JsonObject)gson.fromJson(content, JsonObject.class);
            if (!root.has("spawns")) {
                return;
            }
            JsonArray spawns = root.getAsJsonArray("spawns");
            for (JsonElement spawnElement : spawns) {
                JsonObject spawn = spawnElement.getAsJsonObject();
                if (!spawn.has("pokemon") || !spawn.has("drops")) continue;
                Object pokemonName = spawn.get("pokemon").getAsString();
                if (!((String)pokemonName).contains(":")) {
                    pokemonName = "cobblemon:" + (String)pokemonName;
                }
                String dimension = DropDataCache.extractDimensionFromSpawn(spawn);
                JsonObject drops = spawn.getAsJsonObject("drops");
                if (!drops.has("entries")) continue;
                int minQty = 1;
                int maxQty = 1;
                JsonArray entries = drops.getAsJsonArray("entries");
                for (JsonElement entryElement : entries) {
                    double percentage;
                    JsonObject entry = entryElement.getAsJsonObject();
                    if (!entry.has("item")) continue;
                    Object itemId = entry.get("item").getAsString();
                    if (!((String)itemId).contains(":")) {
                        itemId = "minecraft:" + ((String)itemId).toLowerCase();
                    } else {
                        String[] parts = ((String)itemId).split(":", 2);
                        itemId = parts[0].toLowerCase() + ":" + parts[1].toLowerCase();
                    }
                    if (entry.has("quantityRange")) {
                        String range = entry.get("quantityRange").getAsString();
                        String[] rangeParts = range.split("-");
                        minQty = Integer.parseInt(rangeParts[0]);
                        maxQty = Integer.parseInt(rangeParts[1]);
                        percentage = 100.0;
                    } else {
                        if (!entry.has("percentage")) continue;
                        percentage = entry.get("percentage").getAsDouble();
                    }
                    List<ItemDropData.DropSource> existingSources = itemToSources.get(itemId);
                    boolean alreadyExists = false;
                    if (existingSources != null) {
                        for (ItemDropData.DropSource existing : existingSources) {
                            if (!existing.getPokemonName().equals(pokemonName)) continue;
                            alreadyExists = true;
                            break;
                        }
                    }
                    if (alreadyExists) continue;
                    ItemDropData.DropSource source = new ItemDropData.DropSource((String)pokemonName, minQty, maxQty, percentage, "spawn_pool", dimension);
                    itemToSources.computeIfAbsent((String)itemId, k -> new ArrayList()).add(source);
                }
            }
        }
        catch (Exception e) {
            CuItemDropList.LOGGER.error("Error processing spawn JSON: " + e.getMessage());
        }
    }

    private static String extractDimensionFromSpawn(JsonObject spawn) {
        try {
            JsonObject condition;
            if (spawn.has("condition") && (condition = spawn.getAsJsonObject("condition")).has("biomes")) {
                JsonArray biomes = condition.getAsJsonArray("biomes");
                for (JsonElement biome : biomes) {
                    String biomeStr = biome.getAsString().toLowerCase();
                    if (biomeStr.contains("is_nether") || biomeStr.contains("nether")) {
                        return "Nether";
                    }
                    if (biomeStr.contains("is_end") || biomeStr.contains("end")) {
                        return "End";
                    }
                    if (!biomeStr.contains("is_aether") && !biomeStr.contains("aether")) continue;
                    return "Aether";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private static boolean checkUCGeneralAvailability() {
        try {
            Class.forName("fr.pepefab.ucgeneralfabric.Config.Config");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static void loadCustomDrops(Map<String, List<ItemDropData.DropSource>> itemToSources) {
        try {
            Field captureField;
            List captureLoots;
            Class<?> configClass = Class.forName("fr.pepefab.ucgeneralfabric.Config.Config");
            Field instanceField = configClass.getField("INSTANCE");
            Object configInstance = instanceField.get(null);
            Field killField = configClass.getField("customLootsKillPokemon");
            List killLoots = (List)killField.get(configInstance);
            if (killLoots != null) {
                for (Object loot : killLoots) {
                    DropDataCache.processCustomLoot(loot, itemToSources, "kill");
                }
            }
            if ((captureLoots = (List)(captureField = configClass.getField("customLootsCapturePokemon")).get(configInstance)) != null) {
                for (Object loot : captureLoots) {
                    DropDataCache.processCustomLoot(loot, itemToSources, "capture");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void loadTypeLootDrops(Map<String, List<TypeDropSource>> itemToTypeSources) {
        try {
            Class<?> typeLootConfigClass = Class.forName("fr.pepefab.ucgeneralfabric.Config.PokemonLootTypesConfig");
            Field instanceField = typeLootConfigClass.getField("INSTANCE");
            Object configInstance = instanceField.get(null);
            Field entriesField = typeLootConfigClass.getField("entries");
            List entries = (List)entriesField.get(configInstance);
            if (entries == null || entries.isEmpty()) {
                return;
            }
            for (Object entry : entries) {
                DropDataCache.processTypeLoot(entry, itemToTypeSources);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void processCustomLoot(Object loot, Map<String, List<ItemDropData.DropSource>> itemToSources, String sourceType) {
        try {
            Class<?> lootClass = loot.getClass();
            Field pokemonField = lootClass.getField("pokemon");
            Field itemsField = lootClass.getField("items");
            Field quantityField = lootClass.getField("quantity");
            Field chanceField = lootClass.getField("chance");
            String pokemon = (String)pokemonField.get(loot);
            List items = (List)itemsField.get(loot);
            byte quantity = quantityField.getByte(loot);
            double chance = chanceField.getDouble(loot);
            String speciesId = DropDataCache.normalizeSpeciesId(pokemon);
            for (String itemId : items) {
                ItemDropData.DropSource source = new ItemDropData.DropSource(speciesId, quantity, chance * 100.0, sourceType);
                itemToSources.computeIfAbsent(itemId, k -> new ArrayList()).add(source);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void processTypeLoot(Object entry, Map<String, List<TypeDropSource>> itemToTypeSources) {
        try {
            Class<?> lootEntryClass = entry.getClass();
            Field typeField = lootEntryClass.getField("type");
            Field itemField = lootEntryClass.getField("item");
            Field chanceField = lootEntryClass.getField("chance");
            String type = (String)typeField.get(entry);
            List items = (List)itemField.get(entry);
            double chance = chanceField.getDouble(entry);
            if (type == null || items == null) {
                return;
            }
            for (String itemId : items) {
                TypeDropSource source = new TypeDropSource(type, 1, chance);
                itemToTypeSources.computeIfAbsent(itemId, k -> new ArrayList()).add(source);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String normalizeSpeciesId(String pokemon) {
        if (pokemon.contains(":")) {
            return pokemon;
        }
        return "cobblemon:" + pokemon.toLowerCase();
    }

    public static Collection<ItemDropData> getAllDropData() {
        return CACHE.values();
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static void clear() {
        CACHE.clear();
        initialized = false;
    }
}

