/*
 * Decompiled with CFR 0.152.
 */
package com.cuitemdroplist.network;

import com.cuitemdroplist.data.ItemDropData;
import com.cuitemdroplist.server.DropDataCache;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public class NetworkHandler {
    public static final class_8710.class_9154<DropDataPacket> PACKET_ID = new class_8710.class_9154(class_2960.method_60655((String)"cuitemdroplist", (String)"drop_data"));
    public static final class_8710.class_9154<OpenScreenPacket> OPEN_SCREEN_ID = new class_8710.class_9154(class_2960.method_60655((String)"cuitemdroplist", (String)"open_screen"));

    public static void registerPackets() {
        PayloadTypeRegistry.playS2C().register(PACKET_ID, DropDataPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(OPEN_SCREEN_ID, OpenScreenPacket.CODEC);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.field_14140;
            if (!DropDataCache.isInitialized()) {
                DropDataCache.initialize();
            }
            ArrayList<ItemDropData> data = new ArrayList<ItemDropData>(DropDataCache.getAllDropData());
            ServerPlayNetworking.send((class_3222)player, (class_8710)new DropDataPacket(data));
        });
    }

    public static void sendDropData(class_3222 player, List<ItemDropData> data) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new DropDataPacket(data));
    }

    public static void sendOpenScreenPacket(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new OpenScreenPacket());
    }

    public record DropDataPacket(List<ItemDropData> data) implements class_8710
    {
        public static final class_9139<class_2540, DropDataPacket> CODEC = new class_9139<class_2540, DropDataPacket>(){

            public DropDataPacket decode(class_2540 buf) {
                int size = buf.readInt();
                ArrayList<ItemDropData> data = new ArrayList<ItemDropData>(size);
                for (int i = 0; i < size; ++i) {
                    data.add(ItemDropData.read(buf));
                }
                return new DropDataPacket(data);
            }

            public void encode(class_2540 buf, DropDataPacket packet) {
                buf.method_53002(packet.data.size());
                for (ItemDropData item : packet.data) {
                    item.write(buf);
                }
            }
        };

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return PACKET_ID;
        }
    }

    public record OpenScreenPacket() implements class_8710
    {
        public static final class_9139<class_2540, OpenScreenPacket> CODEC = new class_9139<class_2540, OpenScreenPacket>(){

            public OpenScreenPacket decode(class_2540 buf) {
                return new OpenScreenPacket();
            }

            public void encode(class_2540 buf, OpenScreenPacket packet) {
            }
        };

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return OPEN_SCREEN_ID;
        }
    }
}

