/*
 * Decompiled with CFR 0.152.
 */
package com.cuitemdroplist.data;

import com.cuitemdroplist.data.TypeDropSource;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2540;

public class ItemDropData {
    private final String itemId;
    private final String displayItemId;
    private final List<DropSource> dropSources;
    private final List<TypeDropSource> typeDropSources;
    private final List<String> customMethods;
    private final String customName;
    private final String customColor;

    public ItemDropData(String itemId, List<DropSource> dropSources, List<TypeDropSource> typeDropSources) {
        this(itemId, itemId, dropSources, typeDropSources, new ArrayList<String>(), null, null);
    }

    public ItemDropData(String itemId, String displayItemId, List<DropSource> dropSources, List<TypeDropSource> typeDropSources, List<String> customMethods, String customName, String customColor) {
        this.itemId = itemId;
        this.displayItemId = displayItemId;
        this.dropSources = dropSources;
        this.typeDropSources = typeDropSources;
        this.customMethods = customMethods != null ? customMethods : new ArrayList();
        this.customName = customName;
        this.customColor = customColor;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getDisplayItemId() {
        return this.displayItemId;
    }

    public List<DropSource> getDropSources() {
        return this.dropSources;
    }

    public List<TypeDropSource> getTypeDropSources() {
        return this.typeDropSources;
    }

    public List<String> getCustomMethods() {
        return this.customMethods;
    }

    public String getCustomName() {
        return this.customName;
    }

    public String getCustomColor() {
        return this.customColor;
    }

    public boolean hasCustomName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public int getCustomColorInt() {
        char code;
        class_124 formatting;
        if (this.customColor == null || this.customColor.isEmpty()) {
            return 0xFFFFFF;
        }
        if (this.customColor.startsWith("\u00a7") && this.customColor.length() >= 2 && (formatting = class_124.method_544((char)(code = this.customColor.charAt(1)))) != null && formatting.method_532() != null) {
            return formatting.method_532();
        }
        try {
            String color = this.customColor.startsWith("#") ? this.customColor.substring(1) : this.customColor;
            return Integer.parseInt(color, 16);
        }
        catch (Exception e) {
            return 0xFFFFFF;
        }
    }

    public void write(class_2540 buf) {
        buf.method_10814(this.itemId);
        buf.method_10814(this.displayItemId);
        buf.method_53002(this.dropSources.size());
        for (DropSource dropSource : this.dropSources) {
            buf.method_10814(dropSource.getPokemonName());
            buf.method_53002(dropSource.getMinQuantity());
            buf.method_53002(dropSource.getMaxQuantity());
            buf.method_52940(dropSource.getDropRate());
            buf.method_10814(dropSource.getSourceType());
            buf.method_10814(dropSource.getDimension());
        }
        buf.method_53002(this.typeDropSources.size());
        for (TypeDropSource typeDropSource : this.typeDropSources) {
            buf.method_10814(typeDropSource.getType());
            buf.method_53002(typeDropSource.getQuantity());
            buf.method_52940(typeDropSource.getDropRate());
        }
        buf.method_53002(this.customMethods.size());
        for (String string : this.customMethods) {
            buf.method_10814(string);
        }
        buf.method_10814(this.customName != null ? this.customName : "");
        buf.method_10814(this.customColor != null ? this.customColor : "");
    }

    public static ItemDropData read(class_2540 buf) {
        String itemId = buf.method_19772();
        String displayItemId = buf.method_19772();
        int dropSourceCount = buf.readInt();
        ArrayList<DropSource> dropSources = new ArrayList<DropSource>();
        for (int i = 0; i < dropSourceCount; ++i) {
            String pokemonName = buf.method_19772();
            int minQuantity = buf.readInt();
            int maxQuantity = buf.readInt();
            double dropRate = buf.readDouble();
            String sourceType = buf.method_19772();
            String dimension = buf.method_19772();
            dropSources.add(new DropSource(pokemonName, minQuantity, maxQuantity, dropRate, sourceType, dimension));
        }
        int typeDropSourceCount = buf.readInt();
        ArrayList<TypeDropSource> typeDropSources = new ArrayList<TypeDropSource>();
        for (int i = 0; i < typeDropSourceCount; ++i) {
            String type = buf.method_19772();
            int quantity = buf.readInt();
            double dropRate = buf.readDouble();
            typeDropSources.add(new TypeDropSource(type, quantity, dropRate));
        }
        int customMethodCount = buf.readInt();
        ArrayList<String> customMethods = new ArrayList<String>();
        for (int i = 0; i < customMethodCount; ++i) {
            customMethods.add(buf.method_19772());
        }
        String customName = buf.method_19772();
        String customColor = buf.method_19772();
        return new ItemDropData(itemId, displayItemId, dropSources, typeDropSources, customMethods, customName.isEmpty() ? null : customName, customColor.isEmpty() ? null : customColor);
    }

    public static class DropSource {
        private final String pokemonName;
        private final int minQuantity;
        private final int maxQuantity;
        private final double dropRate;
        private final String sourceType;
        private final String dimension;

        public DropSource(String pokemonName, int quantity, double dropRate) {
            this(pokemonName, quantity, quantity, dropRate, "normal", "");
        }

        public DropSource(String pokemonName, int quantity, double dropRate, String sourceType) {
            this(pokemonName, quantity, quantity, dropRate, sourceType, "");
        }

        public DropSource(String pokemonName, int quantity, double dropRate, String sourceType, String dimension) {
            this(pokemonName, quantity, quantity, dropRate, sourceType, dimension);
        }

        public DropSource(String pokemonName, int minQuantity, int maxQuantity, double dropRate, String sourceType, String dimension) {
            this.pokemonName = pokemonName;
            this.minQuantity = minQuantity;
            this.maxQuantity = maxQuantity;
            this.dropRate = dropRate;
            this.sourceType = sourceType != null ? sourceType : "normal";
            this.dimension = dimension != null ? dimension : "";
        }

        public String getPokemonName() {
            return this.pokemonName;
        }

        public int getQuantity() {
            return this.minQuantity;
        }

        public int getMinQuantity() {
            return this.minQuantity;
        }

        public int getMaxQuantity() {
            return this.maxQuantity;
        }

        public double getDropRate() {
            return this.dropRate;
        }

        public String getSourceType() {
            return this.sourceType;
        }

        public String getDimension() {
            return this.dimension;
        }

        public String getDisplayName() {
            if (this.dimension != null && !this.dimension.isEmpty()) {
                return this.pokemonName + " (" + this.dimension + ")";
            }
            return this.pokemonName;
        }
    }
}

