/*
 * Decompiled with CFR 0.152.
 */
package com.cuitemdroplist.config;

import com.cuitemdroplist.CuItemDropList;
import com.cuitemdroplist.data.CustomDropOther;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = Paths.get("config", "CuItemDropList");
    private static final Path CONFIG_FILE = CONFIG_DIR.resolve("config.json");
    private static Config config;

    public static void initialize() {
        try {
            if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
                config = new Config();
                ConfigManager.config.customDropsOther = new ArrayList<CustomDropOther>();
                CustomDropOther example1 = new CustomDropOther();
                example1.items_name = "Cl\u00e9 Rare";
                example1.color_item_name = "\u00a76";
                example1.methode = List.of("Caisse l\u00e9gendaire", "Event mensuel");
                example1.items = "minecraft:cookie";
                ConfigManager.config.customDropsOther.add(example1);
                ConfigManager.save();
            } else {
                ConfigManager.load();
            }
        }
        catch (Exception e) {
            CuItemDropList.LOGGER.error("Error initializing config: " + e.getMessage());
            config = new Config();
            ConfigManager.config.customDropsOther = new ArrayList<CustomDropOther>();
        }
    }

    private static void load() {
        try (FileReader reader = new FileReader(CONFIG_FILE.toFile());){
            config = (Config)GSON.fromJson((Reader)reader, Config.class);
            if (config == null) {
                config = new Config();
                ConfigManager.config.customDropsOther = new ArrayList<CustomDropOther>();
            }
            if (ConfigManager.config.customDropsOther == null) {
                ConfigManager.config.customDropsOther = new ArrayList<CustomDropOther>();
            }
        }
        catch (Exception e) {
            CuItemDropList.LOGGER.error("Error loading config: " + e.getMessage());
            config = new Config();
            ConfigManager.config.customDropsOther = new ArrayList<CustomDropOther>();
        }
    }

    private static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE.toFile());){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (Exception e) {
            CuItemDropList.LOGGER.error("Error saving config: " + e.getMessage());
        }
    }

    public static List<CustomDropOther> getCustomDropsOther() {
        if (config == null) {
            ConfigManager.initialize();
        }
        return ConfigManager.config.customDropsOther != null ? ConfigManager.config.customDropsOther : new ArrayList<CustomDropOther>();
    }

    public static void reload() {
        ConfigManager.load();
    }

    public static class Config {
        public List<CustomDropOther> customDropsOther;
    }
}

