/*
 * Decompiled with CFR 0.152.
 */
package com.cuitemdroplist.command;

import com.cuitemdroplist.config.ConfigManager;
import com.cuitemdroplist.data.ItemDropData;
import com.cuitemdroplist.network.NetworkHandler;
import com.cuitemdroplist.server.DropDataCache;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class CommandHandler {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"drop").executes(context -> {
            class_1297 patt0$temp = ((class_2168)context.getSource()).method_9228();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                NetworkHandler.sendOpenScreenPacket(player);
                return 1;
            }
            return 0;
        }));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"cuitemdroplist").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> source.method_9259(2))).executes(CommandHandler::reloadAll)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(source -> source.method_9259(2))).executes(CommandHandler::reloadPlayer))));
    }

    private static int reloadAll(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7e[CuItemDropList] Reloading config & cache..."), true);
        long startTime = System.currentTimeMillis();
        ConfigManager.reload();
        DropDataCache.clear();
        DropDataCache.initialize();
        long duration = System.currentTimeMillis() - startTime;
        ArrayList<ItemDropData> data = new ArrayList<ItemDropData>(DropDataCache.getAllDropData());
        List players = source.method_9211().method_3760().method_14571();
        for (class_3222 player : players) {
            NetworkHandler.sendDropData(player, data);
        }
        int playerCount = players.size();
        source.method_9226(() -> class_2561.method_43470((String)String.format("\u00a7a[CuItemDropList] Config & cache reloaded! \u00a77(%dms, %d items, %d players synced)", duration, data.size(), playerCount)), true);
        return 1;
    }

    private static int reloadPlayer(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        try {
            class_3222 target = class_2186.method_9315(context, (String)"player");
            source.method_9226(() -> class_2561.method_43470((String)String.format("\u00a7e[CuItemDropList] Syncing data to %s...", target.method_5477().getString())), true);
            ArrayList<ItemDropData> data = new ArrayList<ItemDropData>(DropDataCache.getAllDropData());
            NetworkHandler.sendDropData(target, data);
            source.method_9226(() -> class_2561.method_43470((String)String.format("\u00a7a[CuItemDropList] Synced %d items to %s", data.size(), target.method_5477().getString())), true);
            return 1;
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7c[CuItemDropList] Player not found!"));
            return 0;
        }
    }
}

