/*
 * Decompiled with CFR 0.152.
 */
package com.cuitemdroplist.client.ui;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.Species;
import com.cuitemdroplist.client.ClientDropDataManager;
import com.cuitemdroplist.data.ItemDropData;
import com.cuitemdroplist.data.TypeDropSource;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_7923;

public class ItemSearchScreen
extends class_437 {
    private static final class_2960 GUI_TEXTURE = class_2960.method_60655((String)"cuitemdroplist", (String)"gui/dropitemgui.png");
    private static final int UI_WIDTH = 390;
    private static final int UI_HEIGHT = 230;
    private int uiLeft;
    private int uiTop;
    private final class_437 parent;
    private class_342 searchBox;
    private int leftScrollY = 0;
    private int rightScrollY = 0;
    private int leftMaxScroll = 0;
    private int rightMaxScroll = 0;
    private List<ItemDropData> allItems = new ArrayList<ItemDropData>();
    private List<ItemDropData> filteredItems = new ArrayList<ItemDropData>();
    private ItemDropData selectedItem = null;
    private static final int ITEM_HEIGHT = 28;
    private static final int ITEM_GAP = 2;
    private static final int LEFT_X_OFFSET = 20;
    private static final int LEFT_Y_OFFSET = 60;
    private static final int LEFT_WIDTH = 145;
    private static final int LEFT_HEIGHT = 158;
    private static final int SEPARATOR_OFFSET = 8;
    private static final int RIGHT_X_OFFSET = 6;
    private static final int RIGHT_WIDTH = 185;
    private static final int RIGHT_HEIGHT = 158;

    public ItemSearchScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"screen.cuitemdroplist.title"));
        this.parent = parent;
        this.loadAllItems();
    }

    protected void method_25426() {
        this.uiLeft = (this.field_22789 - 390) / 2;
        this.uiTop = (this.field_22790 - 230) / 2;
        int searchWidth = 290;
        int searchX = this.uiLeft + (390 - searchWidth) / 2;
        this.searchBox = new class_342(this.field_22793, searchX, this.uiTop + 25, searchWidth, 20, (class_2561)class_2561.method_43471((String)"screen.cuitemdroplist.search"));
        this.searchBox.method_1880(64);
        this.searchBox.method_47404((class_2561)class_2561.method_43471((String)"screen.cuitemdroplist.search_placeholder"));
        this.searchBox.method_1863(s -> this.onSearchChanged());
        this.method_37063((class_364)this.searchBox);
        this.filteredItems = new ArrayList<ItemDropData>(this.allItems);
    }

    private void loadAllItems() {
        if (!ClientDropDataManager.isSynced()) {
            return;
        }
        this.allItems = new ArrayList<ItemDropData>(ClientDropDataManager.getAllDropData());
        this.allItems.sort(Comparator.comparing(i -> this.getDisplayName((ItemDropData)i)));
    }

    private void onSearchChanged() {
        String query = this.searchBox.method_1882().toLowerCase().trim();
        if (query.isEmpty()) {
            this.filteredItems = new ArrayList<ItemDropData>(this.allItems);
        } else {
            String normalized = this.normalize(query);
            this.filteredItems = this.allItems.stream().filter(item -> {
                String displayName = this.normalize(this.getDisplayName((ItemDropData)item));
                if (displayName.contains(normalized)) {
                    return true;
                }
                if (!item.hasCustomName()) {
                    String itemName = this.normalize(this.getItemName(item.getDisplayItemId()));
                    return itemName.contains(normalized);
                }
                return false;
            }).collect(Collectors.toList());
        }
        this.leftScrollY = 0;
        this.leftMaxScroll = Math.max(0, this.filteredItems.size() * 30 - 158);
    }

    private String normalize(String s) {
        return Normalizer.normalize(s, Normalizer.Form.NFD).replaceAll("\\p{M}+", "").toLowerCase(Locale.ROOT).replace(" ", "");
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.method_25290(GUI_TEXTURE, this.uiLeft, this.uiTop, 0.0f, 0.0f, 390, 230, 390, 230);
        int titleWidth = this.field_22793.method_27525((class_5348)this.field_22785);
        int titleX = this.uiLeft + (390 - titleWidth) / 2;
        context.method_51439(this.field_22793, this.field_22785, titleX, this.uiTop + 12, 0xFFFFFF, false);
        int leftX = this.uiLeft + 20;
        int leftY = this.uiTop + 60;
        int separatorX = leftX + 145 + 8;
        int rightX = separatorX + 6;
        int rightY = leftY;
        context.method_25294(separatorX, leftY, separatorX + 1, leftY + 158, -7829368);
        super.method_25394(context, mouseX, mouseY, delta);
        this.renderLeftPanel(context, mouseX, mouseY, leftX, leftY);
        this.renderRightPanel(context, mouseX, mouseY, rightX, rightY);
    }

    private void renderLeftPanel(class_332 context, int mouseX, int mouseY, int leftX, int leftY) {
        context.method_44379(leftX, leftY, leftX + 145, leftY + 158);
        int y = leftY - this.leftScrollY;
        for (ItemDropData item : this.filteredItems) {
            class_1799 stack;
            boolean selected;
            if (y + 28 < leftY || y > leftY + 158) {
                y += 30;
                continue;
            }
            boolean hovered = mouseX >= leftX && mouseX < leftX + 145 && mouseY >= y && mouseY < y + 28;
            boolean bl = selected = item == this.selectedItem;
            int bgColor = selected ? -1439997991 : (hovered ? 0x66444444 : 0x33222222);
            context.method_25294(leftX, y, leftX + 145, y + 28, bgColor);
            if (!selected && !hovered) {
                context.method_25294(leftX, y + 28 - 1, leftX + 145, y + 28, 0x33FFFFFF);
            }
            if (!(stack = this.getItemStack(item.getDisplayItemId())).method_7960()) {
                context.method_51427(stack, leftX + 4, y + 6);
            } else {
                context.method_25294(leftX + 4, y + 6, leftX + 20, y + 22, -1438366652);
                context.method_51433(this.field_22793, "?", leftX + 10, y + 11, 0xFFFFFF, false);
            }
            String displayName = this.getDisplayName(item);
            int textColor = item.hasCustomName() ? 0xFF000000 | item.getCustomColorInt() : -1;
            context.method_51433(this.field_22793, displayName, leftX + 28, y + 10, textColor, false);
            y += 30;
        }
        context.method_44380();
        this.leftMaxScroll = Math.max(0, this.filteredItems.size() * 30 - 158);
    }

    private void renderRightPanel(class_332 context, int mouseX, int mouseY, int rightX, int rightY) {
        if (this.selectedItem == null) {
            return;
        }
        context.method_44379(rightX, rightY, rightX + 185, rightY + 158);
        int y = rightY - this.rightScrollY + 12;
        String displayItemId = this.selectedItem.getDisplayItemId();
        if (displayItemId == null) {
            context.method_44380();
            return;
        }
        class_1799 stack = this.getItemStack(displayItemId);
        if (!stack.method_7960()) {
            context.method_51427(stack, rightX + 12, y - 4);
        }
        String displayName = this.getDisplayName(this.selectedItem);
        int textColor = this.selectedItem.hasCustomName() ? 0xFF000000 | this.selectedItem.getCustomColorInt() : -1;
        context.method_51433(this.field_22793, displayName, rightX + 36, y, textColor, false);
        context.method_25294(rightX + 8, y += 20, rightX + 185 - 8, y + 1, 0x66FFFFFF);
        y += 8;
        List<ItemDropData.DropSource> pokemonSources = this.selectedItem.getDropSources();
        List<TypeDropSource> typeSources = this.selectedItem.getTypeDropSources();
        List<String> customMethods = this.selectedItem.getCustomMethods();
        if (!pokemonSources.isEmpty()) {
            String droppedBy = class_2561.method_43469((String)"screen.cuitemdroplist.dropped_by", (Object[])new Object[]{pokemonSources.size()}).getString();
            context.method_51433(this.field_22793, droppedBy, rightX + 12, y, 0xCCCCCC, false);
            y += 20;
            for (ItemDropData.DropSource drop : pokemonSources) {
                Object speciesName = this.getSpeciesName(drop.getPokemonName());
                if (!drop.getDimension().isEmpty()) {
                    speciesName = (String)speciesName + " (" + drop.getDimension() + ")";
                }
                context.method_51433(this.field_22793, "\u2022 " + (String)speciesName, rightX + 16, y, 0xFFFFFF, false);
                y += 14;
                String sourceTypeKey = "source." + drop.getSourceType();
                String sourceTypeText = class_2561.method_43471((String)sourceTypeKey).getString();
                if (!sourceTypeText.equals(sourceTypeKey)) {
                    context.method_51433(this.field_22793, "  " + sourceTypeText, rightX + 20, y, 0xFFAA55, false);
                    y += 12;
                }
                String qtyText = drop.getMaxQuantity() > drop.getMinQuantity() ? class_2561.method_43469((String)"screen.cuitemdroplist.quantity", (Object[])new Object[]{drop.getMinQuantity() + "-" + drop.getMaxQuantity()}).getString() : class_2561.method_43469((String)"screen.cuitemdroplist.quantity", (Object[])new Object[]{drop.getQuantity()}).getString();
                context.method_51433(this.field_22793, "  " + qtyText, rightX + 20, y, 0xAAAA55, false);
                String pctText = class_2561.method_43469((String)"screen.cuitemdroplist.percentage", (Object[])new Object[]{String.format("%.1f", drop.getDropRate())}).getString();
                context.method_51433(this.field_22793, "  " + pctText, rightX + 20, y += 12, 0x55AAFF, false);
                context.method_25294(rightX + 16, y += 18, rightX + 185 - 16, y + 1, 0x33FFFFFF);
                y += 6;
            }
        }
        if (!typeSources.isEmpty()) {
            if (!pokemonSources.isEmpty()) {
                y += 10;
            }
            String typeHeader = class_2561.method_43471((String)"screen.cuitemdroplist.dropped_by_type").getString();
            context.method_51433(this.field_22793, typeHeader, rightX + 12, y, 0xCCCCCC, false);
            y += 20;
            for (TypeDropSource typeSource : typeSources) {
                String translatedType = class_2561.method_43471((String)("type.cuitemdroplist." + typeSource.getType().toLowerCase())).getString();
                String typeText = class_2561.method_43469((String)"screen.cuitemdroplist.type_drop_text", (Object[])new Object[]{translatedType}).getString();
                context.method_51433(this.field_22793, typeText, rightX + 16, y, 0xFF88FF, false);
                String qtyText = class_2561.method_43469((String)"screen.cuitemdroplist.quantity", (Object[])new Object[]{typeSource.getQuantity()}).getString();
                context.method_51433(this.field_22793, "  " + qtyText, rightX + 20, y += 14, 0xAAAA55, false);
                String pctText = class_2561.method_43469((String)"screen.cuitemdroplist.percentage", (Object[])new Object[]{String.format("%.1f", typeSource.getDropRate())}).getString();
                context.method_51433(this.field_22793, "  " + pctText, rightX + 20, y += 12, 0x55AAFF, false);
                context.method_25294(rightX + 16, y += 18, rightX + 185 - 16, y + 1, 0x33FFFFFF);
                y += 6;
            }
        }
        if (!customMethods.isEmpty()) {
            if (!pokemonSources.isEmpty() || !typeSources.isEmpty()) {
                y += 10;
            }
            String methodHeader = class_2561.method_43471((String)"screen.cuitemdroplist.obtention_methods").getString();
            context.method_51433(this.field_22793, methodHeader, rightX + 12, y, 0xCCCCCC, false);
            y += 20;
            for (String method : customMethods) {
                context.method_51433(this.field_22793, "\u2022 " + method, rightX + 16, y, 0xAAFF55, false);
                y += 16;
            }
            y += 6;
        }
        context.method_44380();
        int contentHeight = 80 + pokemonSources.size() * 70 + typeSources.size() * 50 + customMethods.size() * 20;
        this.rightMaxScroll = Math.max(0, contentHeight - 158);
    }

    private class_1799 getItemStack(String itemId) {
        class_1792 altItem;
        class_2960 altId;
        String altItemId;
        class_2960 id = class_2960.method_12829((String)itemId);
        if (id == null) {
            return class_1799.field_8037;
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(id);
        if ((item == null || item == class_1802.field_8162) && (altItemId = itemId.contains("-") ? itemId.replace("-", "_") : (itemId.contains("_") ? itemId.replace("_", "-") : null)) != null && (altId = class_2960.method_12829((String)altItemId)) != null && (altItem = (class_1792)class_7923.field_41178.method_10223(altId)) != null && altItem != class_1802.field_8162) {
            item = altItem;
        }
        if (item == null || item == class_1802.field_8162) {
            return class_1799.field_8037;
        }
        class_1799 stack = new class_1799((class_1935)item);
        return stack;
    }

    private String getDisplayName(ItemDropData data) {
        if (data.hasCustomName()) {
            return data.getCustomName();
        }
        return this.getItemName(data.getDisplayItemId());
    }

    private String getItemName(String itemId) {
        class_1799 stack = this.getItemStack(itemId);
        if (!stack.method_7960()) {
            return stack.method_7964().getString();
        }
        String[] parts = itemId.split(":");
        if (parts.length > 1) {
            String itemName = parts[1].replace("_", " ").replace("-", " ");
            String[] words = itemName.split(" ");
            StringBuilder formatted = new StringBuilder();
            for (String word : words) {
                if (word.isEmpty()) continue;
                formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
            }
            return formatted.toString().trim();
        }
        return itemId;
    }

    private String getSpeciesName(String speciesId) {
        try {
            class_2960 id = class_2960.method_12829((String)speciesId);
            if (id != null) {
                Species species = PokemonSpecies.getByIdentifier((class_2960)id);
                if (species != null) {
                    return species.getTranslatedName().getString();
                }
            }
        }
        catch (Exception id) {
            // empty catch block
        }
        String[] parts = speciesId.split(":");
        if (parts.length > 1) {
            return this.capitalizeFirst(parts[1].replace("_", " "));
        }
        return this.capitalizeFirst(speciesId.replace("_", " "));
    }

    private String capitalizeFirst(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public boolean method_25402(double mx, double my, int button) {
        int relY;
        int index;
        int leftX = this.uiLeft + 20;
        int leftY = this.uiTop + 60;
        if (mx >= (double)leftX && mx < (double)(leftX + 145) && my >= (double)leftY && my < (double)(leftY + 158) && (index = (relY = (int)(my - (double)leftY + (double)this.leftScrollY)) / 30) >= 0 && index < this.filteredItems.size()) {
            this.selectedItem = this.filteredItems.get(index);
            this.rightScrollY = 0;
            return true;
        }
        return super.method_25402(mx, my, button);
    }

    public boolean method_25401(double mx, double my, double hScroll, double vScroll) {
        double delta = vScroll != 0.0 ? vScroll : hScroll;
        int leftX = this.uiLeft + 20;
        int leftY = this.uiTop + 60;
        int separatorX = leftX + 145 + 8;
        int rightX = separatorX + 6;
        int rightY = leftY;
        if (mx >= (double)leftX && mx < (double)(leftX + 145) && my >= (double)leftY && my < (double)(leftY + 158)) {
            this.leftScrollY = class_3532.method_15340((int)(this.leftScrollY - (int)(delta * 20.0)), (int)0, (int)this.leftMaxScroll);
            return true;
        }
        if (mx >= (double)rightX && mx < (double)(rightX + 185) && my >= (double)rightY && my < (double)(rightY + 158)) {
            this.rightScrollY = class_3532.method_15340((int)(this.rightScrollY - (int)(delta * 20.0)), (int)0, (int)this.rightMaxScroll);
            return true;
        }
        return super.method_25401(mx, my, hScroll, vScroll);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox.method_25370() && (keyCode == 257 || keyCode == 335)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float partialTick) {
    }

    public boolean method_25422() {
        return true;
    }
}

