/*
 * Decompiled with CFR 0.152.
 */
package com.cuitemdroplist.client;

import com.cuitemdroplist.data.ItemDropData;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClientDropDataManager {
    private static final Map<String, ItemDropData> DATA = new ConcurrentHashMap<String, ItemDropData>();
    private static volatile boolean synced = false;

    public static void initialize() {
        DATA.clear();
        synced = false;
    }

    public static void setDropData(Collection<ItemDropData> dropData) {
        DATA.clear();
        for (ItemDropData data : dropData) {
            DATA.put(data.getItemId(), data);
        }
        synced = true;
    }

    public static Collection<ItemDropData> getAllDropData() {
        return DATA.values();
    }

    public static ItemDropData getDropData(String itemId) {
        return DATA.get(itemId);
    }

    public static boolean isSynced() {
        return synced;
    }

    public static void clear() {
        DATA.clear();
        synced = false;
    }
}

