/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.client;

import io.wispforest.accessories.api.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.impl.SlotGroupImpl;
import io.wispforest.accessories.impl.SlotTypeImpl;
import io.wispforest.accessories.utils.CollectionUtils;
import io.wispforest.accessories.utils.EndecUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public record SyncData(List<SlotType> slotTypes, Map<class_1299<?>, List<String>> entitySlots, List<SlotGroup> slotGroups, List<String> uniqueGroups, Map<String, ExtraSlotTypeProperties> uniqueExtraProperties) {
    private static final Endec<Map<class_1299<?>, List<String>>> ENTITY_SLOTS_ENDEC = EndecUtils.map(LinkedHashMap::new, type -> class_7923.field_41177.method_10221(type).toString(), s -> (class_1299)class_7923.field_41177.method_10223(class_2960.method_60654((String)s)), Endec.STRING.listOf());
    public static StructEndec<SyncData> ENDEC = StructEndecBuilder.of((StructField)SlotTypeImpl.ENDEC.listOf().fieldOf("slotTypes", SyncData::slotTypes), (StructField)ENTITY_SLOTS_ENDEC.fieldOf("entitySlots", SyncData::entitySlots), (StructField)SlotGroupImpl.ENDEC.listOf().fieldOf("slotGroups", SyncData::slotGroups), (StructField)Endec.STRING.listOf().fieldOf("uniqueGroups", SyncData::uniqueGroups), (StructField)ExtraSlotTypeProperties.ENDEC.mapOf().fieldOf("uniqueExtraProperties", SyncData::uniqueExtraProperties), SyncData::new);

    public static SyncData create() {
        Map<String, SlotType> allSlotTypes = SlotTypeLoader.INSTANCE.getSlotTypes(false);
        LinkedHashMap entitySlots = new LinkedHashMap();
        for (Map.Entry<class_1299<?>, Map<String, SlotType>> entry : EntitySlotLoader.INSTANCE.getEntitySlotData(false).entrySet()) {
            entitySlots.put(entry.getKey(), List.copyOf(entry.getValue().keySet()));
        }
        List<SlotGroup> slotGroups = SlotGroupLoader.INSTANCE.getGroups(false, false);
        return new SyncData(List.copyOf(allSlotTypes.values()), entitySlots, slotGroups, List.copyOf(UniqueSlotHandling.getGroups(false)), ExtraSlotTypeProperties.getProperties(false));
    }

    @Environment(value=EnvType.CLIENT)
    public static void handlePacket(SyncData packet, class_1657 player) {
        LinkedHashMap<String, SlotType> slotTypes = new LinkedHashMap<String, SlotType>();
        for (SlotType slotType : packet.slotTypes()) {
            slotTypes.put(slotType.name(), slotType);
        }
        SlotTypeLoader.INSTANCE.setSlotType(slotTypes);
        UniqueSlotHandling.buildClientSlotReferences();
        LinkedHashMap entitySlotTypes = new LinkedHashMap();
        for (Map.Entry<class_1299<?>, List<String>> entry : packet.entitySlots().entrySet()) {
            LinkedHashMap<String, SlotType> map = entry.getValue().stream().map(slotTypes::get).collect(CollectionUtils.toLinkedMap(SlotType::name));
            entitySlotTypes.put(entry.getKey(), map);
        }
        EntitySlotLoader.INSTANCE.setEntitySlotData(entitySlotTypes);
        LinkedHashMap<String, SlotGroup> linkedHashMap = packet.slotGroups().stream().collect(CollectionUtils.toLinkedMap(SlotGroup::name));
        SlotGroupLoader.INSTANCE.setGroups(linkedHashMap);
        UniqueSlotHandling.setClientGroups(packet.uniqueGroups());
        ExtraSlotTypeProperties.setClientPropertyMap(packet.uniqueExtraProperties());
    }
}

