/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.client.rendering;

import com.mojang.datafixers.util.Pair;
import io.wispforest.accessories.api.client.Side;
import io.wispforest.accessories.mixin.client.ModelPartAccessor;
import io.wispforest.accessories.pond.ModelRootAccess;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ModelTransformUtils {
    private static final Map<class_2960, ModelPartTransformer> ADDITIONAL_TRANSFORMERS = new LinkedHashMap<class_2960, ModelPartTransformer>();

    @ApiStatus.Experimental
    public static void registerTransformer(class_2960 location, ModelPartTransformer modelTransformers) {
        if (ADDITIONAL_TRANSFORMERS.containsKey(location)) {
            throw new IllegalStateException("Already existing ModelTransformer exists!");
        }
        ADDITIONAL_TRANSFORMERS.put(location, modelTransformers);
    }

    @ApiStatus.Experimental
    public static boolean transformToFace(class_4587 poseStack, class_1309 livingEntity, class_3879 model, String modelPartName, Side side) {
        return ModelTransformUtils.transformToModelPart(poseStack, livingEntity, model, modelPartName, side.direction.method_10163().method_10263(), side.direction.method_10163().method_10264(), side.direction.method_10163().method_10260());
    }

    @ApiStatus.Experimental
    public static boolean transformToModelPart(class_4587 poseStack, class_1309 livingEntity, class_3879 model, String modelPartName) {
        return ModelTransformUtils.transformToModelPart(poseStack, livingEntity, model, modelPartName, 0, 0, 0);
    }

    @ApiStatus.Experimental
    public static boolean transformToModelPart(class_4587 poseStack, class_1309 livingEntity, class_3879 model, String modelPartName, @Nullable Number xPercent, @Nullable Number yPercent, @Nullable Number zPercent) {
        for (Map.Entry<class_2960, ModelPartTransformer> entry : ADDITIONAL_TRANSFORMERS.entrySet()) {
            boolean result = entry.getValue().transformToPart(poseStack, livingEntity, model, modelPartName, xPercent, yPercent, zPercent);
            if (!result) continue;
            return true;
        }
        class_630 modelPart = ModelTransformUtils.getPart(model, modelPartName);
        if (modelPart != null) {
            ModelTransformUtils.transformToModelPart(poseStack, modelPart, xPercent, yPercent, zPercent);
            return true;
        }
        return false;
    }

    @ApiStatus.Experimental
    @Nullable
    public static class_630 getPart(class_3879 model, String modelPartName) {
        ModelRootAccess access;
        Optional<class_630> possiblePart;
        if (model instanceof ModelRootAccess && (possiblePart = (access = (ModelRootAccess)model).accessories$getAnyDescendantWithName(modelPartName)).isPresent()) {
            return possiblePart.get();
        }
        return null;
    }

    public static void transformToFace(class_4587 poseStack, class_630 part, Side side) {
        ModelTransformUtils.transformToModelPart(poseStack, part, side.direction.method_10163().method_10263(), side.direction.method_10163().method_10264(), side.direction.method_10163().method_10260());
    }

    public static void transformToModelPart(class_4587 poseStack, class_630 part) {
        ModelTransformUtils.transformToModelPart(poseStack, part, 0, 0, 0);
    }

    public static void transformToModelPart(class_4587 poseStack, class_630 part, @Nullable Number xPercent, @Nullable Number yPercent, @Nullable Number zPercent) {
        part.method_22703(poseStack);
        Pair<class_243, class_243> aabb = ModelTransformUtils.getAABB(part);
        poseStack.method_22905(0.0625f, 0.0625f, 0.0625f);
        poseStack.method_22904(xPercent != null ? class_3532.method_16436((double)((-xPercent.doubleValue() + 1.0) / 2.0), (double)((class_243)aabb.getFirst()).field_1352, (double)((class_243)aabb.getSecond()).field_1352) : 0.0, yPercent != null ? class_3532.method_16436((double)((-yPercent.doubleValue() + 1.0) / 2.0), (double)((class_243)aabb.getFirst()).field_1351, (double)((class_243)aabb.getSecond()).field_1351) : 0.0, zPercent != null ? class_3532.method_16436((double)((-zPercent.doubleValue() + 1.0) / 2.0), (double)((class_243)aabb.getFirst()).field_1350, (double)((class_243)aabb.getSecond()).field_1350) : 0.0);
        poseStack.method_22905(8.0f, 8.0f, 8.0f);
        poseStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
    }

    private static Pair<class_243, class_243> getAABB(class_630 part) {
        class_243 min = new class_243(0.0, 0.0, 0.0);
        class_243 max = new class_243(0.0, 0.0, 0.0);
        if (part.getClass().getSimpleName().contains("EMFModelPart")) {
            ArrayList<class_630> parts = new ArrayList<class_630>();
            parts.add(part);
            parts.addAll(((ModelPartAccessor)part).getChildren().values());
            for (class_630 modelPart : parts) {
                for (class_630.class_628 cube : ((ModelPartAccessor)modelPart).getCubes()) {
                    min = new class_243(Math.min(min.field_1352, (double)Math.min(cube.field_3645 + modelPart.field_3657, cube.field_3648 + modelPart.field_3657)), Math.min(min.field_1351, (double)Math.min(cube.field_3644 + modelPart.field_3656, cube.field_3647 + modelPart.field_3656)), Math.min(min.field_1350, (double)Math.min(cube.field_3643 + modelPart.field_3655, cube.field_3646 + modelPart.field_3655)));
                    max = new class_243(Math.max(max.field_1352, (double)Math.max(cube.field_3645 + modelPart.field_3657, cube.field_3648 + modelPart.field_3657)), Math.max(max.field_1351, (double)Math.max(cube.field_3644 + modelPart.field_3656, cube.field_3647 + modelPart.field_3656)), Math.max(max.field_1350, (double)Math.max(cube.field_3643 + modelPart.field_3655, cube.field_3646 + modelPart.field_3655)));
                }
            }
        } else {
            for (class_630.class_628 cube : ((ModelPartAccessor)part).getCubes()) {
                min = new class_243(Math.min(min.field_1352, (double)Math.min(cube.field_3645, cube.field_3648)), Math.min(min.field_1351, (double)Math.min(cube.field_3644, cube.field_3647)), Math.min(min.field_1350, (double)Math.min(cube.field_3643, cube.field_3646)));
                max = new class_243(Math.max(max.field_1352, (double)Math.max(cube.field_3645, cube.field_3648)), Math.max(max.field_1351, (double)Math.max(cube.field_3644, cube.field_3647)), Math.max(max.field_1350, (double)Math.max(cube.field_3643, cube.field_3646)));
            }
        }
        return Pair.of((Object)min, (Object)max);
    }

    @ApiStatus.Experimental
    public static interface ModelPartTransformer {
        public boolean transformToPart(class_4587 var1, class_1309 var2, class_3879 var3, String var4, @Nullable Number var5, @Nullable Number var6, @Nullable Number var7);
    }
}

