/*
 * Decompiled with CFR 0.152.
 */
package com.cupokewiki.util;

import com.cupokewiki.CUPokeWiki;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class TranslationLoader {
    private static Map<String, String> frenchTranslations = new HashMap<String, String>();
    private static Map<String, String> englishTranslations = new HashMap<String, String>();
    private static boolean loaded = false;

    public static void loadTranslations() {
        if (loaded) {
            return;
        }
        try {
            TranslationLoader.loadCobblemonTranslations("fr_fr.json", frenchTranslations);
            TranslationLoader.loadCobblemonTranslations("en_us.json", englishTranslations);
            loaded = true;
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Failed to load translations", (Throwable)e);
        }
    }

    private static void loadCobblemonTranslations(String fileName, Map<String, String> targetMap) {
        block26: {
            try {
                Path cobblemonJar = (Path)((ModContainer)FabricLoader.getInstance().getModContainer("cobblemon").orElseThrow(() -> new RuntimeException("Cobblemon not found"))).getOrigin().getPaths().get(0);
                if (Files.isRegularFile(cobblemonJar, new LinkOption[0])) {
                    try (JarFile jar = new JarFile(cobblemonJar.toFile());){
                        JarEntry entry = jar.getJarEntry("assets/cobblemon/lang/" + fileName);
                        if (entry == null) break block26;
                        try (InputStream is = jar.getInputStream(entry);
                             InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                            for (Map.Entry e : json.entrySet()) {
                                targetMap.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString());
                            }
                            break block26;
                        }
                    }
                }
                Path langFile = cobblemonJar.resolve("assets/cobblemon/lang/" + fileName);
                if (!Files.exists(langFile, new LinkOption[0])) break block26;
                try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(langFile, new OpenOption[0]), StandardCharsets.UTF_8);){
                    JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    for (Map.Entry e : json.entrySet()) {
                        targetMap.put((String)e.getKey(), ((JsonElement)e.getValue()).getAsString());
                    }
                }
            }
            catch (Exception e) {
                CUPokeWiki.LOGGER.error("Failed to load {}", (Object)fileName, (Object)e);
            }
        }
    }

    public static String getFrenchTranslation(String key) {
        if (!loaded) {
            TranslationLoader.loadTranslations();
        }
        return frenchTranslations.get(key);
    }

    public static String getEnglishTranslation(String key) {
        if (!loaded) {
            TranslationLoader.loadTranslations();
        }
        return englishTranslations.get(key);
    }

    public static void reload() {
        loaded = false;
        frenchTranslations.clear();
        englishTranslations.clear();
        TranslationLoader.loadTranslations();
    }
}

