/*
 * Decompiled with CFR 0.152.
 */
package com.cupokewiki.util;

import com.cobblemon.mod.common.api.spawning.CobblemonSpawnPools;
import com.cupokewiki.CUPokeWiki;
import com.cupokewiki.data.LegendarySpawnHelper;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7924;

public class SpawnDataCollector {
    private static String normalizeName(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        return name.toLowerCase().replace("-", "").replace(".", "").replace(" ", "").replace("'", "").replace("'", "").replace("\u00e2\u20ac\u2122", "").trim();
    }

    private static String convertSpecialForm(String formName) {
        if (formName == null || formName.isEmpty()) {
            return formName;
        }
        String lower = formName.toLowerCase();
        if (lower.contains("bias")) {
            if (lower.contains("alola")) {
                return "alolan";
            }
            if (lower.contains("galar")) {
                return "galarian";
            }
            if (lower.contains("hisui")) {
                return "hisuian";
            }
            if (lower.contains("paldea")) {
                return "paldean";
            }
        }
        if (lower.startsWith("paldea-") && !lower.equals("paldean")) {
            return "paldean";
        }
        if (lower.endsWith("-striped")) {
            return lower.substring(0, lower.length() - 8);
        }
        return formName;
    }

    public static List<String> collectBiomesForSpecies(String speciesName, String formName, class_1937 world) {
        List<String> legendaryBiomes;
        ArrayList<String> biomes = new ArrayList<String>();
        try {
            CobblemonSpawnPools spawnPools = CobblemonSpawnPools.INSTANCE;
            Object worldPool = SpawnDataCollector.getWorldSpawnPool(spawnPools);
            if (worldPool == null) {
                return biomes;
            }
            Collection<?> spawns = SpawnDataCollector.getSpawnsFromPool(worldPool);
            if (spawns == null) {
                return biomes;
            }
            int matches = 0;
            String normalizedSearchName = SpawnDataCollector.normalizeName(speciesName);
            for (Object spawn : spawns) {
                boolean formMatch;
                boolean speciesMatch;
                String foundSpecies = SpawnDataCollector.extractSpeciesName(spawn);
                String foundForm = SpawnDataCollector.extractFormName(spawn);
                boolean bl = speciesMatch = foundSpecies != null && SpawnDataCollector.normalizeName(foundSpecies).equals(normalizedSearchName);
                if (formName == null) {
                    formMatch = foundForm == null || foundForm.isEmpty() || foundForm.equalsIgnoreCase("normal");
                } else {
                    String convertedSearchForm = SpawnDataCollector.convertSpecialForm(formName);
                    String convertedFoundForm = SpawnDataCollector.convertSpecialForm(foundForm);
                    String normalizedSearchForm = SpawnDataCollector.normalizeName(convertedSearchForm);
                    String normalizedFoundForm = SpawnDataCollector.normalizeName(convertedFoundForm);
                    formMatch = normalizedSearchForm.equals(normalizedFoundForm);
                }
                if (!speciesMatch || !formMatch) continue;
                ++matches;
                List<String> extractedBiomes = SpawnDataCollector.extractBiomes(spawn, null);
                for (String biome : extractedBiomes) {
                    if (biomes.contains(biome) || !SpawnDataCollector.isValidBiomeForWorld(biome, world)) continue;
                    biomes.add(biome);
                }
            }
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Exception in collectBiomesForSpecies for {}: {}", (Object)speciesName, (Object)e.getMessage());
        }
        Object legendaryKey = speciesName;
        if (formName != null && !formName.isEmpty() && !formName.equalsIgnoreCase("normal")) {
            legendaryKey = speciesName + "_" + formName.toLowerCase();
        }
        if (!(legendaryBiomes = LegendarySpawnHelper.getBiomesForLegendary((String)legendaryKey)).isEmpty()) {
            for (String biome : legendaryBiomes) {
                if (biomes.contains(biome)) continue;
                biomes.add(biome);
            }
        }
        return biomes;
    }

    public static List<String> collectTimeRangesForSpecies(String speciesName, String formName) {
        ArrayList<String> timeRanges = new ArrayList<String>();
        try {
            CobblemonSpawnPools spawnPools = CobblemonSpawnPools.INSTANCE;
            Object worldPool = SpawnDataCollector.getWorldSpawnPool(spawnPools);
            if (worldPool == null) {
                return timeRanges;
            }
            Collection<?> spawns = SpawnDataCollector.getSpawnsFromPool(worldPool);
            if (spawns == null) {
                return timeRanges;
            }
            String normalizedSearchName = SpawnDataCollector.normalizeName(speciesName);
            for (Object spawn : spawns) {
                boolean formMatch;
                boolean speciesMatch;
                String foundSpecies = SpawnDataCollector.extractSpeciesName(spawn);
                String foundForm = SpawnDataCollector.extractFormName(spawn);
                boolean bl = speciesMatch = foundSpecies != null && SpawnDataCollector.normalizeName(foundSpecies).equals(normalizedSearchName);
                if (formName == null) {
                    formMatch = foundForm == null || foundForm.isEmpty() || foundForm.equalsIgnoreCase("normal");
                } else {
                    String convertedSearchForm = SpawnDataCollector.convertSpecialForm(formName);
                    String convertedFoundForm = SpawnDataCollector.convertSpecialForm(foundForm);
                    String normalizedSearchForm = SpawnDataCollector.normalizeName(convertedSearchForm);
                    String normalizedFoundForm = SpawnDataCollector.normalizeName(convertedFoundForm);
                    formMatch = normalizedSearchForm.equals(normalizedFoundForm);
                }
                if (!speciesMatch || !formMatch) continue;
                List<String> extractedTimeRanges = SpawnDataCollector.extractTimeRanges(spawn);
                for (String timeRange : extractedTimeRanges) {
                    if (timeRanges.contains(timeRange)) continue;
                    timeRanges.add(timeRange);
                }
            }
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Exception in collectTimeRangesForSpecies", (Throwable)e);
        }
        return timeRanges;
    }

    private static List<String> extractTimeRanges(Object spawn) {
        ArrayList<String> timeRanges = new ArrayList<String>();
        try {
            Object condition = SpawnDataCollector.getConditionFromSpawn(spawn);
            if (condition == null) {
                return timeRanges;
            }
            ArrayList<Object> conditions = new ArrayList<Object>();
            if (condition instanceof List) {
                conditions.addAll((List)condition);
            } else {
                conditions.add(condition);
            }
            for (Object e : conditions) {
                String timeRangeName;
                Object timeRangeObj = SpawnDataCollector.extractTimeRangeFromCondition(e);
                if (timeRangeObj == null || (timeRangeName = SpawnDataCollector.getTimeRangeName(timeRangeObj)) == null || timeRanges.contains(timeRangeName)) continue;
                timeRanges.add(timeRangeName);
            }
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Exception in extractTimeRanges", (Throwable)e);
        }
        return timeRanges;
    }

    private static Object extractTimeRangeFromCondition(Object condition) {
        String[] fieldNames;
        String[] methodNames;
        for (String methodName : methodNames = new String[]{"getTimeRange", "timeRange", "getTimeRanges"}) {
            try {
                Method method = condition.getClass().getMethod(methodName, new Class[0]);
                Object result = method.invoke(condition, new Object[0]);
                if (result == null) continue;
                return result;
            }
            catch (Exception method) {
                // empty catch block
            }
        }
        for (String fieldName : fieldNames = new String[]{"timeRange", "timeRanges"}) {
            try {
                Field field = condition.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                Object result = field.get(condition);
                if (result == null) continue;
                return result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String getTimeRangeName(Object timeRangeObj) {
        block33: {
            if (timeRangeObj == null) {
                return null;
            }
            try {
                String className = timeRangeObj.getClass().getSimpleName();
                if (!className.equals("TimeRange")) break block33;
                Object rangesArray = null;
                try {
                    Field rangesField = timeRangeObj.getClass().getSuperclass().getDeclaredField("ranges");
                    rangesField.setAccessible(true);
                    rangesArray = rangesField.get(timeRangeObj);
                }
                catch (Exception e) {
                    CUPokeWiki.LOGGER.error("Failed to get ranges field", (Throwable)e);
                }
                if (rangesArray == null) {
                    try {
                        Method getRangesMethod = timeRangeObj.getClass().getSuperclass().getMethod("getRanges", new Class[0]);
                        rangesArray = getRangesMethod.invoke(timeRangeObj, new Object[0]);
                    }
                    catch (Exception e) {
                        CUPokeWiki.LOGGER.error("Failed to get ranges method", (Throwable)e);
                    }
                }
                if (rangesArray != null) {
                    int length;
                    ArrayList<Object> ranges = new ArrayList<Object>();
                    if (rangesArray.getClass().isArray()) {
                        length = Array.getLength(rangesArray);
                        for (int i = 0; i < length; ++i) {
                            ranges.add(Array.get(rangesArray, i));
                        }
                    } else if (rangesArray instanceof Iterable) {
                        for (Object range : (Iterable)rangesArray) {
                            ranges.add(range);
                        }
                    } else {
                        return null;
                    }
                    if ((length = ranges.size()) == 1) {
                        String r0 = ranges.get(0).toString();
                        if (r0.contains("0..23999")) {
                            return "any";
                        }
                        if (r0.contains("12542..23459")) {
                            return "night";
                        }
                        if (r0.contains("5000..6999")) {
                            return "noon";
                        }
                        if (r0.contains("17000..18999")) {
                            return "midnight";
                        }
                        if (r0.contains("7000..12999")) {
                            return "afternoon";
                        }
                        if (r0.contains("19000..22999")) {
                            return "predawn";
                        }
                        if (r0.contains("13000..16999")) {
                            return "evening";
                        }
                        if (r0.contains("11834..13701")) {
                            return "dusk";
                        }
                    } else if (length == 2) {
                        String r0 = ranges.get(0).toString();
                        String r1 = ranges.get(1).toString();
                        if (r0.contains("23460..23999") && r1.contains("0..12541")) {
                            return "day";
                        }
                        if (r0.contains("22300..23999") && r1.contains("0..999")) {
                            return "dawn";
                        }
                        if (r0.contains("23000..23999") && r1.contains("0..4999")) {
                            return "morning";
                        }
                        if (r0.contains("11834..13701")) {
                            return "dusk";
                        }
                    } else if (length == 3) {
                        String r0 = ranges.get(0).toString();
                        String r1 = ranges.get(1).toString();
                        String r2 = ranges.get(2).toString();
                        if (r0.contains("11834..13701") && r1.contains("22300..23999") && r2.contains("0..166")) {
                            return "twilight";
                        }
                    }
                }
            }
            catch (Exception e) {
                CUPokeWiki.LOGGER.error("Exception in getTimeRangeName", (Throwable)e);
            }
        }
        return null;
    }

    private static boolean isValidBiomeForWorld(String biomeStr, class_1937 world) {
        try {
            if (biomeStr.contains(":")) {
                String[] parts = biomeStr.split(":");
                String namespace = parts[0];
                if (namespace.equals("cobblemon") || namespace.equals("minecraft")) {
                    return true;
                }
                class_2378 biomeRegistry = world.method_30349().method_30530(class_7924.field_41236);
                for (class_2960 id : biomeRegistry.method_10235()) {
                    if (!id.method_12836().equals(namespace)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    private static Object getWorldSpawnPool(Object spawnPools) {
        try {
            Method method = spawnPools.getClass().getMethod("getWORLD_SPAWN_POOL", new Class[0]);
            Object pool = method.invoke(spawnPools, new Object[0]);
            if (pool != null) {
                return pool;
            }
        }
        catch (Exception method) {
            // empty catch block
        }
        try {
            Field field = spawnPools.getClass().getDeclaredField("WORLD_SPAWN_POOL");
            field.setAccessible(true);
            return field.get(spawnPools);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Collection<?> getSpawnsFromPool(Object pool) {
        Object result;
        try {
            Method method = pool.getClass().getMethod("getDetails", new Class[0]);
            result = method.invoke(pool, new Object[0]);
            if (result instanceof Collection) {
                return (Collection)result;
            }
        }
        catch (Exception method) {
            // empty catch block
        }
        try {
            Field field = pool.getClass().getDeclaredField("details");
            field.setAccessible(true);
            result = field.get(pool);
            if (result instanceof Collection) {
                return (Collection)result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String extractSpeciesName(Object spawn) {
        String[] fieldNames;
        String[] methodNames;
        for (String methodName : methodNames = new String[]{"getPokemon", "pokemon", "getSpecies"}) {
            try {
                Method method = spawn.getClass().getMethod(methodName, new Class[0]);
                Object result = method.invoke(spawn, new Object[0]);
                if (result instanceof String) {
                    String fullString = (String)result;
                    if (fullString.contains(" ")) {
                        return fullString.split(" ")[0];
                    }
                    return fullString;
                }
                if (result == null) continue;
                try {
                    Field speciesField = result.getClass().getDeclaredField("species");
                    speciesField.setAccessible(true);
                    Object speciesObj = speciesField.get(result);
                    if (speciesObj == null) continue;
                    return speciesObj.toString();
                }
                catch (Exception speciesField) {}
            }
            catch (Exception method) {
                // empty catch block
            }
        }
        for (String fieldName : fieldNames = new String[]{"pokemon", "species"}) {
            try {
                Field field = spawn.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                Object result = field.get(spawn);
                if (result instanceof String) {
                    String fullString = (String)result;
                    if (fullString.contains(" ")) {
                        return fullString.split(" ")[0];
                    }
                    return fullString;
                }
                if (result == null) continue;
                return result.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String extractFormFromPokemonString(String pokemonString) {
        if (pokemonString == null || !pokemonString.contains("=")) {
            return null;
        }
        if (pokemonString.contains("striped=")) {
            String value = pokemonString.substring(pokemonString.indexOf("striped=") + 8).split(" ")[0];
            return value + "-striped";
        }
        if (pokemonString.contains("sea=")) {
            String value = pokemonString.substring(pokemonString.indexOf("sea=") + 4).split(" ")[0];
            return value;
        }
        if (pokemonString.contains("region_bias=")) {
            String value = pokemonString.substring(pokemonString.indexOf("region_bias=") + 12).split(" ")[0];
            return value + "-bias";
        }
        if (pokemonString.contains("bull_breed=")) {
            return "paldean";
        }
        return null;
    }

    public static String extractFormName(Object spawn) {
        String[] methodNames;
        for (String methodName : methodNames = new String[]{"getPokemon", "pokemon"}) {
            try {
                String form;
                Object formObj;
                String pokemonString;
                String formFromString;
                Method method = spawn.getClass().getMethod(methodName, new Class[0]);
                Object pokemonProps = method.invoke(spawn, new Object[0]);
                if (pokemonProps instanceof String && (formFromString = SpawnDataCollector.extractFormFromPokemonString(pokemonString = (String)pokemonProps)) != null) {
                    return formFromString;
                }
                if (pokemonProps == null) continue;
                try {
                    Field formField = pokemonProps.getClass().getDeclaredField("form");
                    formField.setAccessible(true);
                    formObj = formField.get(pokemonProps);
                    if (formObj != null && !(form = formObj.toString()).isEmpty() && !form.equalsIgnoreCase("normal")) {
                        return form;
                    }
                }
                catch (Exception formField) {
                    // empty catch block
                }
                try {
                    Method getFormMethod = pokemonProps.getClass().getMethod("getForm", new Class[0]);
                    formObj = getFormMethod.invoke(pokemonProps, new Object[0]);
                    if (formObj != null && !(form = formObj.toString()).isEmpty() && !form.equalsIgnoreCase("normal")) {
                        return form;
                    }
                }
                catch (Exception getFormMethod) {
                    // empty catch block
                }
                try {
                    Field aspectsField = pokemonProps.getClass().getDeclaredField("aspects");
                    aspectsField.setAccessible(true);
                    Object aspectsObj = aspectsField.get(pokemonProps);
                    if (aspectsObj instanceof Collection) {
                        Collection aspects = (Collection)aspectsObj;
                        for (Object aspect : aspects) {
                            if (aspect == null) continue;
                            String aspectStr = aspect.toString().toLowerCase();
                            if (aspectStr.contains("alolan") || aspectStr.contains("alola")) {
                                return "alolan";
                            }
                            if (aspectStr.contains("galarian") || aspectStr.contains("galar")) {
                                return "galarian";
                            }
                            if (aspectStr.contains("hisuian") || aspectStr.contains("hisui")) {
                                return "hisuian";
                            }
                            if (!aspectStr.contains("paldean") && !aspectStr.contains("paldea")) continue;
                            return "paldean";
                        }
                    }
                }
                catch (Exception aspectsField) {
                    // empty catch block
                }
                try {
                    Field originalStringField = pokemonProps.getClass().getDeclaredField("originalString");
                    originalStringField.setAccessible(true);
                    Object originalStringObj = originalStringField.get(pokemonProps);
                    if (originalStringObj == null) continue;
                    String originalString = originalStringObj.toString().toLowerCase();
                    if (originalString.contains("sea=east")) {
                        return "east";
                    }
                    if (originalString.contains("sea=west")) {
                        return "west";
                    }
                    if (originalString.contains("striped=blue")) {
                        return "blue-striped";
                    }
                    if (originalString.contains("striped=red")) {
                        return "red-striped";
                    }
                    if (originalString.contains("striped=white")) {
                        return "white-striped";
                    }
                    if (originalString.contains("stripe_color=blue") || originalString.contains("stripe=blue")) {
                        return "blue-striped";
                    }
                    if (originalString.contains("stripe_color=white") || originalString.contains("stripe=white")) {
                        return "white-striped";
                    }
                    if (originalString.contains("form=droopy") || originalString.contains("droopy")) {
                        return "droopy";
                    }
                    if (originalString.contains("form=stretchy") || originalString.contains("stretchy")) {
                        return "stretchy";
                    }
                    if (!originalString.contains("family_size=four") && !originalString.contains("size=four")) continue;
                    return "four";
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String parseFormFromFullName(String fullName) {
        if (fullName == null || fullName.isEmpty()) {
            return null;
        }
        String lower = fullName.toLowerCase().trim();
        if (lower.contains(" alolan")) {
            return "alolan";
        }
        if (lower.contains(" galarian")) {
            return "galarian";
        }
        if (lower.contains(" hisuian")) {
            return "hisuian";
        }
        if (lower.contains(" paldean")) {
            return "paldean";
        }
        String[] parts = lower.split("\\s+");
        if (parts.length == 2) {
            String possibleForm = parts[1];
            if (possibleForm.equals("alola")) {
                return "alolan";
            }
            if (possibleForm.equals("galar")) {
                return "galarian";
            }
            if (possibleForm.equals("hisui")) {
                return "hisuian";
            }
            if (possibleForm.equals("paldea")) {
                return "paldean";
            }
            if (!possibleForm.equals("normal") && !possibleForm.isEmpty()) {
                return possibleForm;
            }
        }
        return null;
    }

    private static List<String> extractBiomes(Object spawn, String debugSpecies) {
        ArrayList<String> biomes = new ArrayList<String>();
        Object condition = SpawnDataCollector.getConditionFromSpawn(spawn);
        if (condition == null) {
            return biomes;
        }
        Object biomesObj = SpawnDataCollector.getBiomesFromCondition(condition);
        if (biomesObj == null) {
            return biomes;
        }
        if (biomesObj instanceof Collection) {
            for (Object biomeObj : (Collection)biomesObj) {
                if (biomeObj instanceof String) {
                    biomes.add((String)biomeObj);
                    continue;
                }
                String biomeName = SpawnDataCollector.extractBiomeName(biomeObj);
                if (biomeName == null || biomes.contains(biomeName)) continue;
                biomes.add(biomeName);
            }
        } else if (biomesObj instanceof String) {
            biomes.add((String)biomesObj);
        } else {
            String biomeName = SpawnDataCollector.extractBiomeName(biomesObj);
            if (biomeName != null) {
                biomes.add(biomeName);
            }
        }
        return biomes;
    }

    private static String extractBiomeName(Object biomeObj) {
        Object result;
        Field field2;
        int n;
        String[] fieldNames;
        Object result2;
        Method method2;
        String[] methodNames;
        String className = biomeObj.getClass().getSimpleName();
        if (className.contains("BiomeTag")) {
            for (String methodName : methodNames = new String[]{"getTag", "getTagKey", "getBiomeTag", "tag"}) {
                try {
                    method2 = biomeObj.getClass().getMethod(methodName, new Class[0]);
                    result2 = method2.invoke(biomeObj, new Object[0]);
                    if (result2 == null) continue;
                    String value = result2.toString();
                    if (value.contains(" / ") && (value = value.substring(value.indexOf(" / ") + 3)).endsWith("]")) {
                        value = value.substring(0, value.length() - 1);
                    }
                    return value;
                }
                catch (Exception method2) {
                    // empty catch block
                }
            }
            String[] stringArray = fieldNames = new String[]{"tag", "tagKey", "biomeTag"};
            n = stringArray.length;
            for (int methodName = 0; methodName < n; ++methodName) {
                String fieldName = stringArray[methodName];
                try {
                    field2 = biomeObj.getClass().getDeclaredField(fieldName);
                    field2.setAccessible(true);
                    result = field2.get(biomeObj);
                    if (result == null) continue;
                    String value = result.toString();
                    if (value.contains(" / ") && (value = value.substring(value.indexOf(" / ") + 3)).endsWith("]")) {
                        value = value.substring(0, value.length() - 1);
                    }
                    return value;
                }
                catch (Exception field2) {
                    // empty catch block
                }
            }
        }
        if (className.contains("BiomeIdentifier")) {
            fieldNames = methodNames = new String[]{"getIdentifier", "getBiome", "getBiomeId", "getId"};
            int n2 = fieldNames.length;
            for (n = 0; n < n2; ++n) {
                String methodName = fieldNames[n];
                try {
                    method2 = biomeObj.getClass().getMethod(methodName, new Class[0]);
                    result2 = method2.invoke(biomeObj, new Object[0]);
                    if (result2 == null) continue;
                    return result2.toString();
                }
                catch (Exception method3) {
                    // empty catch block
                }
            }
            for (String fieldName : fieldNames = new String[]{"identifier", "biome", "biomeId", "id"}) {
                try {
                    field2 = biomeObj.getClass().getDeclaredField(fieldName);
                    field2.setAccessible(true);
                    result = field2.get(biomeObj);
                    if (result == null) continue;
                    return result.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return biomeObj.toString();
    }

    private static Object getConditionFromSpawn(Object spawn) {
        Object result;
        Method method2;
        try {
            method2 = spawn.getClass().getMethod("getCompositeCondition", new Class[0]);
            result = method2.invoke(spawn, new Object[0]);
            if (result != null) {
                return result;
            }
        }
        catch (Exception method2) {
            // empty catch block
        }
        try {
            method2 = spawn.getClass().getMethod("getConditions", new Class[0]);
            result = method2.invoke(spawn, new Object[0]);
            if (result instanceof List && !((List)result).isEmpty()) {
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Object getBiomesFromCondition(Object condition) {
        if (condition instanceof List) {
            ArrayList<Object> allBiomes = new ArrayList<Object>();
            for (Object cond : (List)condition) {
                Object biomes = SpawnDataCollector.extractBiomesFromSingleCondition(cond);
                if (biomes == null) continue;
                if (biomes instanceof Collection) {
                    for (Object biome : (Collection)biomes) {
                        allBiomes.add(biome);
                    }
                    continue;
                }
                allBiomes.add(biomes);
            }
            return allBiomes;
        }
        return SpawnDataCollector.extractBiomesFromSingleCondition(condition);
    }

    private static Object extractBiomesFromSingleCondition(Object condition) {
        String[] fieldNames;
        String[] methodNames;
        for (String methodName : methodNames = new String[]{"getBiomes", "biomes", "getBiomeCondition", "getBiomeIdentifiers"}) {
            try {
                Method method = condition.getClass().getMethod(methodName, new Class[0]);
                Object result = method.invoke(condition, new Object[0]);
                if (result == null) continue;
                return result;
            }
            catch (Exception method) {
                // empty catch block
            }
        }
        for (String fieldName : fieldNames = new String[]{"biomes", "biomeTags", "biomeCondition", "biomeIdentifiers"}) {
            try {
                Field field = condition.getClass().getDeclaredField(fieldName);
                field.setAccessible(true);
                Object result = field.get(condition);
                if (result == null) continue;
                return result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

