/*
 * Decompiled with CFR 0.152.
 */
package com.cupokewiki.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class BiomeTagResolver {
    public static List<String> resolveBiomeTag(String tag, class_1937 world) {
        if (world == null) {
            return List.of();
        }
        try {
            class_2378 biomeRegistry = world.method_30349().method_30530(class_7924.field_41236);
            class_2960 tagId = BiomeTagResolver.parseTagIdentifier(tag);
            if (tagId == null) {
                return List.of();
            }
            class_6862 biomeTagKey = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)tagId);
            HashSet matchingBiomes = new HashSet();
            for (class_6880 entry : biomeRegistry.method_40286(biomeTagKey)) {
                entry.method_40230().ifPresent(key -> {
                    class_2960 biomeId = key.method_29177();
                    matchingBiomes.add(biomeId.toString());
                });
            }
            return matchingBiomes.stream().sorted().toList();
        }
        catch (Exception e) {
            return List.of();
        }
    }

    private static class_2960 parseTagIdentifier(String tag) {
        try {
            class_2960 parsed;
            String cleaned = tag.toLowerCase();
            if (cleaned.contains(":") && (parsed = class_2960.method_12829((String)cleaned)) != null) {
                return parsed;
            }
            if (cleaned.contains("/")) {
                String namespace = "cobblemon";
                if (cleaned.startsWith("minecraft/") || cleaned.startsWith("nether/") || cleaned.startsWith("end/") || cleaned.startsWith("overworld/")) {
                    return class_2960.method_60655((String)namespace, (String)cleaned);
                }
                String[] parts = cleaned.split("/");
                String lastPart = parts[parts.length - 1];
                if (lastPart.startsWith("is_")) {
                    return class_2960.method_60655((String)namespace, (String)cleaned);
                }
            }
            if (cleaned.startsWith("is_")) {
                return class_2960.method_60655((String)"cobblemon", (String)cleaned);
            }
            return class_2960.method_60655((String)"cobblemon", (String)("is_" + cleaned));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, List<String>> resolveAllBiomeTags(List<String> biomeTags, class_1937 world) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (String tag : biomeTags) {
            List<String> resolvedBiomes;
            Object categoryName;
            String lowerTag = tag.toLowerCase();
            boolean isDirectBiome = false;
            String cleaned = lowerTag;
            if (cleaned.contains("/")) {
                String[] parts = cleaned.split("/");
                cleaned = parts[parts.length - 1];
            }
            if (!cleaned.contains(":is_") && !cleaned.startsWith("is_") && lowerTag.contains(":")) {
                isDirectBiome = true;
            }
            if (isDirectBiome) {
                categoryName = "biome:" + tag;
                result.put((String)categoryName, List.of(tag));
                continue;
            }
            categoryName = BiomeTagResolver.extractCategoryName(tag);
            if (categoryName == null || (resolvedBiomes = BiomeTagResolver.resolveBiomeTag(tag, world)).isEmpty()) continue;
            result.put((String)categoryName, resolvedBiomes);
        }
        return result;
    }

    private static String extractCategoryName(String tag) {
        String cleaned = tag.toLowerCase();
        if (cleaned.contains("/")) {
            String[] parts = cleaned.split("/");
            cleaned = parts[parts.length - 1];
        }
        if (cleaned.contains(":is_")) {
            int isIndex = cleaned.indexOf(":is_");
            return cleaned.substring(isIndex + 4);
        }
        if (cleaned.startsWith("is_")) {
            return cleaned.substring(3);
        }
        return null;
    }
}

