/*
 * Decompiled with CFR 0.152.
 */
package com.cupokewiki.network;

import com.cupokewiki.CUPokeWiki;
import com.cupokewiki.data.PokemonSpawnData;
import com.cupokewiki.data.SpawnDataCache;
import com.cupokewiki.network.NetworkHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;

public class SyncSpawnDataPacket
implements class_8710 {
    public static final class_8710.class_9154<SyncSpawnDataPacket> ID = new class_8710.class_9154(NetworkHandler.SYNC_SPAWN_DATA);
    public static final class_9139<class_2540, SyncSpawnDataPacket> CODEC = class_9139.method_56438(SyncSpawnDataPacket::write, SyncSpawnDataPacket::read);
    private final Map<String, PokemonSpawnData> data;

    public SyncSpawnDataPacket(Map<String, PokemonSpawnData> data) {
        this.data = data;
    }

    public static void sendToClient(class_3222 player, MinecraftServer server) {
        Map<String, PokemonSpawnData> cache = SpawnDataCache.getServerCache();
        SyncSpawnDataPacket packet = new SyncSpawnDataPacket(cache);
        ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
    }

    private void write(class_2540 buf) {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(new GZIPOutputStream(byteOut));
            dataOut.writeInt(this.data.size());
            for (Map.Entry<String, PokemonSpawnData> entry : this.data.entrySet()) {
                dataOut.writeUTF(entry.getKey());
                SyncSpawnDataPacket.writeCompactSpawnData(dataOut, entry.getValue());
            }
            dataOut.close();
            byte[] compressed = byteOut.toByteArray();
            buf.method_53002(compressed.length);
            buf.method_52983(compressed);
        }
        catch (IOException e) {
            CUPokeWiki.LOGGER.error("Failed to compress spawn data", (Throwable)e);
            throw new RuntimeException("Failed to compress spawn data", e);
        }
    }

    private static void writeCompactSpawnData(DataOutputStream out, PokemonSpawnData data) throws IOException {
        out.writeUTF(data.getSpecies());
        out.writeBoolean(data.getForm() != null);
        if (data.getForm() != null) {
            out.writeUTF(data.getForm());
        }
        out.writeBoolean(data.getTranslatedNameFr() != null);
        if (data.getTranslatedNameFr() != null) {
            out.writeUTF(data.getTranslatedNameFr());
        }
        out.writeBoolean(data.getTranslatedNameEn() != null);
        if (data.getTranslatedNameEn() != null) {
            out.writeUTF(data.getTranslatedNameEn());
        }
        out.writeInt(data.getBiomes().size());
        for (String biome : data.getBiomes()) {
            out.writeUTF(biome);
        }
        out.writeInt(data.getEggGroups().size());
        for (String egg : data.getEggGroups()) {
            out.writeUTF(egg);
        }
        out.writeInt(data.getAbilities().size());
        for (PokemonSpawnData.AbilityData ability : data.getAbilities()) {
            out.writeUTF(ability.getName());
            out.writeUTF(ability.getDescription());
            out.writeBoolean(ability.isHidden());
        }
        out.writeInt(data.getTypes().size());
        for (String type : data.getTypes()) {
            out.writeUTF(type);
        }
        out.writeInt(data.getDexNumber());
        out.writeBoolean(data.getDescriptionSpawnNonNaturel() != null);
        if (data.getDescriptionSpawnNonNaturel() != null) {
            out.writeUTF(data.getDescriptionSpawnNonNaturel());
        }
        Map<String, List<String>> realBiomes = data.getRealBiomesByCategory();
        out.writeInt(realBiomes.size());
        for (Map.Entry<String, List<String>> entry : realBiomes.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeInt(entry.getValue().size());
            for (String biome : entry.getValue()) {
                out.writeUTF(biome);
            }
        }
        out.writeInt(data.getMoves().size());
        for (PokemonSpawnData.MoveData move : data.getMoves()) {
            out.writeUTF(move.getName());
            out.writeUTF(move.getType());
            out.writeUTF(move.getDamageCategory());
            out.writeInt(move.getPower());
            out.writeInt(move.getAccuracy());
            out.writeInt(move.getPp());
            out.writeUTF(move.getLearnMethod());
            out.writeInt(move.getLevel());
        }
        out.writeInt(data.getDrops().size());
        for (PokemonSpawnData.DropData drop : data.getDrops()) {
            out.writeUTF(drop.getItemId());
            out.writeInt(drop.getMinQuantity());
            out.writeInt(drop.getMaxQuantity());
            out.writeDouble(drop.getPercentage());
            out.writeUTF(drop.getSource());
        }
        out.writeInt(data.getEvolutions().size());
        for (PokemonSpawnData.EvolutionData evolution : data.getEvolutions()) {
            out.writeUTF(evolution.getEvolvedSpecies());
            out.writeBoolean(evolution.getEvolvedForm() != null);
            if (evolution.getEvolvedForm() != null) {
                out.writeUTF(evolution.getEvolvedForm());
            }
            String condition = evolution.getCondition();
            out.writeUTF(condition);
        }
        out.writeInt(data.getTimeRanges().size());
        for (String timeRange : data.getTimeRanges()) {
            out.writeUTF(timeRange);
        }
    }

    private static SyncSpawnDataPacket read(class_2540 buf) {
        try {
            int compressedLength = buf.readInt();
            byte[] compressed = new byte[compressedLength];
            buf.method_52979(compressed);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(compressed);
            DataInputStream dataIn = new DataInputStream(new GZIPInputStream(byteIn));
            int size = dataIn.readInt();
            HashMap<String, PokemonSpawnData> cache = new HashMap<String, PokemonSpawnData>();
            for (int i = 0; i < size; ++i) {
                String key = dataIn.readUTF();
                PokemonSpawnData data = SyncSpawnDataPacket.readCompactSpawnData(dataIn);
                cache.put(key, data);
            }
            dataIn.close();
            return new SyncSpawnDataPacket(cache);
        }
        catch (IOException e) {
            CUPokeWiki.LOGGER.error("Failed to decompress spawn data", (Throwable)e);
            throw new RuntimeException("Failed to decompress spawn data", e);
        }
    }

    private static PokemonSpawnData readCompactSpawnData(DataInputStream in) throws IOException {
        String species = in.readUTF();
        String form = in.readBoolean() ? in.readUTF() : null;
        String translatedNameFr = in.readBoolean() ? in.readUTF() : null;
        String translatedNameEn = in.readBoolean() ? in.readUTF() : null;
        int biomeCount = in.readInt();
        ArrayList<String> biomes = new ArrayList<String>();
        for (int i = 0; i < biomeCount; ++i) {
            biomes.add(in.readUTF());
        }
        int eggCount = in.readInt();
        ArrayList<String> eggGroups = new ArrayList<String>();
        for (int i = 0; i < eggCount; ++i) {
            eggGroups.add(in.readUTF());
        }
        int abilityCount = in.readInt();
        ArrayList<PokemonSpawnData.AbilityData> abilities = new ArrayList<PokemonSpawnData.AbilityData>();
        for (int i = 0; i < abilityCount; ++i) {
            abilities.add(new PokemonSpawnData.AbilityData(in.readUTF(), in.readUTF(), in.readBoolean()));
        }
        int typeCount = in.readInt();
        ArrayList<String> types = new ArrayList<String>();
        for (int i = 0; i < typeCount; ++i) {
            types.add(in.readUTF());
        }
        int dexNumber = in.readInt();
        String description = in.readBoolean() ? in.readUTF() : null;
        int categoryCount = in.readInt();
        HashMap<String, List<String>> realBiomesByCategory = new HashMap<String, List<String>>();
        for (int i = 0; i < categoryCount; ++i) {
            String category = in.readUTF();
            int biomeListCount = in.readInt();
            ArrayList<String> categoryBiomes = new ArrayList<String>();
            for (int j = 0; j < biomeListCount; ++j) {
                categoryBiomes.add(in.readUTF());
            }
            realBiomesByCategory.put(category, categoryBiomes);
        }
        int moveCount = in.readInt();
        ArrayList<PokemonSpawnData.MoveData> moves = new ArrayList<PokemonSpawnData.MoveData>();
        for (int i = 0; i < moveCount; ++i) {
            moves.add(new PokemonSpawnData.MoveData(in.readUTF(), in.readUTF(), in.readUTF(), in.readInt(), in.readInt(), in.readInt(), in.readUTF(), in.readInt()));
        }
        int dropCount = in.readInt();
        ArrayList<PokemonSpawnData.DropData> drops = new ArrayList<PokemonSpawnData.DropData>();
        for (int i = 0; i < dropCount; ++i) {
            drops.add(new PokemonSpawnData.DropData(in.readUTF(), in.readInt(), in.readInt(), in.readDouble(), in.readUTF()));
        }
        int evolutionCount = in.readInt();
        ArrayList<PokemonSpawnData.EvolutionData> evolutions = new ArrayList<PokemonSpawnData.EvolutionData>();
        for (int i = 0; i < evolutionCount; ++i) {
            String evolvedSpecies = in.readUTF();
            String evolvedForm = in.readBoolean() ? in.readUTF() : null;
            String condition = in.readUTF();
            evolutions.add(new PokemonSpawnData.EvolutionData(evolvedSpecies, evolvedForm, condition));
        }
        int timeRangeCount = in.readInt();
        ArrayList<String> timeRanges = new ArrayList<String>();
        for (int i = 0; i < timeRangeCount; ++i) {
            timeRanges.add(in.readUTF());
        }
        return new PokemonSpawnData(species, form, translatedNameFr, translatedNameEn, biomes, eggGroups, abilities, types, dexNumber, description, realBiomesByCategory, moves, drops, evolutions, timeRanges);
    }

    public Map<String, PokemonSpawnData> getData() {
        return this.data;
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return ID;
    }
}

