/*
 * Decompiled with CFR 0.152.
 */
package com.cupokewiki.network;

import com.cupokewiki.CUPokeWiki;
import com.cupokewiki.data.PokemonSpawnData;
import com.cupokewiki.data.SpawnDataCache;
import com.cupokewiki.gui.PokeWikiScreen;
import com.cupokewiki.gui.PokemonDetailScreen;
import com.cupokewiki.network.OpenWikiPacket;
import com.cupokewiki.network.SyncSpawnDataPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_2960;
import net.minecraft.class_437;

public class NetworkHandler {
    public static final class_2960 SYNC_SPAWN_DATA = class_2960.method_60655((String)"cupokewiki", (String)"sync_spawn_data");
    public static final class_2960 OPEN_WIKI = class_2960.method_60655((String)"cupokewiki", (String)"open_wiki");

    public static void registerServerPackets() {
        PayloadTypeRegistry.playS2C().register(SyncSpawnDataPacket.ID, SyncSpawnDataPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(OpenWikiPacket.ID, OpenWikiPacket.CODEC);
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClientPackets() {
        ClientPlayNetworking.registerGlobalReceiver(SyncSpawnDataPacket.ID, (payload, context) -> context.client().execute(() -> {
            SpawnDataCache.setClientCache(payload.getData());
            PokeWikiScreen.clearCache();
        }));
        ClientPlayNetworking.registerGlobalReceiver(OpenWikiPacket.ID, (payload, context) -> context.client().execute(() -> NetworkHandler.handleOpenWikiPacket(payload, context)));
    }

    @Environment(value=EnvType.CLIENT)
    private static void handleOpenWikiPacket(OpenWikiPacket payload, ClientPlayNetworking.Context context) {
        try {
            String pokemonKey = payload.getPokemonKey();
            if (pokemonKey == null) {
                context.client().method_1507((class_437)new PokeWikiScreen());
                return;
            }
            PokemonSpawnData pokemonData = SpawnDataCache.getClientCache().get(pokemonKey);
            if (pokemonData == null) {
                context.client().method_1507((class_437)new PokeWikiScreen());
                return;
            }
            PokeWikiScreen wikiScreen = new PokeWikiScreen();
            PokeWikiScreen.PokemonEntry entry = wikiScreen.findEntryByKey(pokemonKey);
            if (entry != null) {
                context.client().method_1507((class_437)new PokemonDetailScreen(entry, wikiScreen.getAllPokemonEntries()));
            } else {
                context.client().method_1507((class_437)new PokeWikiScreen());
            }
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Failed to open wiki screen", (Throwable)e);
        }
    }
}

