/*
 * Decompiled with CFR 0.152.
 */
package com.cupokewiki.gui;

import com.cobblemon.mod.common.client.gui.summary.widgets.ModelWidget;
import com.cobblemon.mod.common.pokemon.RenderablePokemon;
import com.cupokewiki.CUPokeWiki;
import com.cupokewiki.data.PokemonSpawnData;
import com.cupokewiki.gui.PokeWikiScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7923;

public class PokemonDetailScreen
extends class_437 {
    private static final class_2960 GUI_TEXTURE = class_2960.method_60655((String)"cupokewiki", (String)"textures/gui/cupokewikigui.png");
    private static final class_2960 CAUGHT_ICON = class_2960.method_60655((String)"cupokewiki", (String)"textures/gui/caught_icon.png");
    private static final int GUI_WIDTH = 390;
    private static final int GUI_HEIGHT = 230;
    private int guiLeft;
    private int guiTop;
    private class_342 searchField;
    private final PokeWikiScreen.PokemonEntry currentPokemon;
    private final List<PokeWikiScreen.PokemonEntry> allPokemon;
    private int leftListScroll = 0;
    private static final int LEFT_LIST_WIDTH = 40;
    private static final int ENTRY_HEIGHT = 40;
    private Map<String, RenderablePokemon> renderableCache;
    private PokemonSpawnData.AbilityData hoveredAbility = null;
    private InfoTab hoveredTab = null;
    private PokemonSpawnData.MoveData hoveredMove = null;
    private class_1799 hoveredItemStack = null;
    private List<String> biomeCategories = new ArrayList<String>();
    private String selectedBiomeCategory = null;
    private String hoveredBiomeCategory = null;
    private final Map<String, int[]> biomeClickZones = new HashMap<String, int[]>();
    private List<String> hiddenBiomes = new ArrayList<String>();
    private int hiddenBiomesTextX = 0;
    private int hiddenBiomesTextY = 0;
    private int hiddenBiomesTextWidth = 0;
    private int hiddenBiomesTextHeight = 0;
    private int biomeZoneScroll = 0;
    private final Map<String, ModelWidget> modelWidgetCache = new HashMap<String, ModelWidget>();
    private boolean draggingLeftScrollbar = false;
    private boolean draggingBiomeScrollbar = false;
    private int dragStartY = 0;
    private int dragStartScroll = 0;
    private InfoTab selectedTab = InfoTab.INFO;
    private static final class_2960 TAB_INFO_TEXTURE = class_2960.method_60655((String)"cupokewiki", (String)"textures/gui/tab_info.png");
    private static final class_2960 TAB_EVO_TEXTURE = class_2960.method_60655((String)"cupokewiki", (String)"textures/gui/tab_evo.png");
    private static final class_2960 TAB_DROPS_TEXTURE = class_2960.method_60655((String)"cupokewiki", (String)"textures/gui/tab_drops.png");
    private static final class_2960 TAB_MOVES_TEXTURE = class_2960.method_60655((String)"cupokewiki", (String)"textures/gui/tab_moves.png");
    private static final int TAB_WIDTH = 12;
    private static final int TAB_HEIGHT = 12;
    private int infoContentScroll = 0;
    private boolean draggingInfoScrollbar = false;

    public PokemonDetailScreen(PokeWikiScreen.PokemonEntry targetEntry, List<PokeWikiScreen.PokemonEntry> allEntries) {
        super((class_2561)class_2561.method_43470((String)targetEntry.getFullName()));
        this.renderableCache = new HashMap<String, RenderablePokemon>();
        this.allPokemon = new ArrayList<PokeWikiScreen.PokemonEntry>(allEntries);
        this.currentPokemon = targetEntry;
        this.centerScrollOnCurrent();
    }

    private void centerScrollOnCurrent() {
        int currentIndex = this.allPokemon.indexOf(this.currentPokemon);
        if (currentIndex >= 0) {
            int visibleEntries = 5;
            this.leftListScroll = Math.max(0, currentIndex - visibleEntries / 2);
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.guiLeft = (this.field_22789 - 390) / 2;
        this.guiTop = (this.field_22790 - 230) / 2;
        this.searchField = new class_342(this.field_22793, this.guiLeft + 40 + 27, this.guiTop + 15, 295, 20, (class_2561)class_2561.method_43470((String)"Rechercher..."));
        this.searchField.method_1880(32);
        this.searchField.method_47404((class_2561)class_2561.method_43471((String)"gui.cupokewiki.search.placeholder"));
        this.searchField.method_1863(this::onSearchChanged);
        this.searchField.method_1858(true);
        this.method_25429((class_364)this.searchField);
        this.prepareRenderables();
        this.extractBiomeCategories();
    }

    private void extractBiomeCategories() {
        String speciesName = this.currentPokemon.species.getName().toLowerCase();
        String formName = this.currentPokemon.formName != null ? this.currentPokemon.formName.toLowerCase() : "null";
        this.biomeCategories.clear();
        if (this.currentPokemon.spawnData == null || this.currentPokemon.spawnData.getBiomes().isEmpty()) {
            return;
        }
        HashSet<Object> categories = new HashSet<Object>();
        for (String biome : this.currentPokemon.spawnData.getBiomes()) {
            String biomeId;
            String cat;
            String[] parts;
            String lowerBiome = biome.toLowerCase();
            if (lowerBiome.contains("/")) {
                parts = lowerBiome.split("/");
                lowerBiome = parts[parts.length - 1];
            }
            if (lowerBiome.contains(":is_")) {
                cat = lowerBiome.substring(lowerBiome.indexOf(":is_") + 4);
                categories.add(cat);
                continue;
            }
            if (lowerBiome.startsWith("is_")) {
                cat = lowerBiome.substring(3);
                categories.add(cat);
                continue;
            }
            if (!lowerBiome.contains(":") || (parts = lowerBiome.split(":")).length < 2 || (biomeId = parts[1]).startsWith("is_")) continue;
            categories.add("biome:" + biome);
        }
        this.biomeCategories.addAll(categories);
        this.biomeCategories.sort(String::compareTo);
    }

    private void prepareRenderables() {
        this.renderableCache.clear();
        for (PokeWikiScreen.PokemonEntry entry : this.allPokemon) {
            this.createRenderable(entry);
        }
    }

    private boolean createRenderable(PokeWikiScreen.PokemonEntry entry) {
        try {
            String cacheKey = entry.getCacheKey();
            if (this.renderableCache.containsKey(cacheKey)) {
                return true;
            }
            HashSet<String> aspects = new HashSet<String>(entry.formAspects);
            RenderablePokemon renderable = new RenderablePokemon(entry.species, aspects, class_1799.field_8037);
            this.renderableCache.put(cacheKey, renderable);
            return true;
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Failed to create renderable for {}: {}", (Object)entry.getFullName(), (Object)e.getMessage());
            return false;
        }
    }

    private String getTranslatedName(PokeWikiScreen.PokemonEntry entry) {
        try {
            String translatedName = entry.species.getTranslatedName().getString();
            if (entry.formName != null && !entry.formName.isEmpty() && !entry.formName.equalsIgnoreCase("normal")) {
                Object formDisplayName = entry.formName;
                formDisplayName = ((String)formDisplayName).equalsIgnoreCase("alola") || ((String)formDisplayName).equalsIgnoreCase("alolan") ? "Alola" : (((String)formDisplayName).equalsIgnoreCase("galar") || ((String)formDisplayName).equalsIgnoreCase("galarian") ? "Galar" : (((String)formDisplayName).equalsIgnoreCase("hisui") || ((String)formDisplayName).equalsIgnoreCase("hisuian") ? "Hisui" : (((String)formDisplayName).equalsIgnoreCase("paldea") || ((String)formDisplayName).equalsIgnoreCase("paldean") ? "Paldea" : (((String)formDisplayName).toLowerCase().startsWith("mega") ? "Mega" + (((String)formDisplayName).length() > 4 ? ((String)formDisplayName).substring(4) : "") : (((String)formDisplayName).equalsIgnoreCase("gmax") || ((String)formDisplayName).equalsIgnoreCase("gigantamax") ? "Gigamax" : ((String)formDisplayName).substring(0, 1).toUpperCase() + ((String)formDisplayName).substring(1))))));
                return translatedName + " " + (String)formDisplayName;
            }
            return translatedName;
        }
        catch (Exception e) {
            return entry.getFullName();
        }
    }

    private void onSearchChanged(String query) {
        if (query.isEmpty()) {
            return;
        }
        String normalized = query.toLowerCase().trim();
        for (PokeWikiScreen.PokemonEntry entry : this.allPokemon) {
            String englishName = entry.getFullName().toLowerCase();
            String translatedName = this.getTranslatedName(entry).toLowerCase();
            if (!englishName.contains(normalized) && !translatedName.contains(normalized)) continue;
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new PokemonDetailScreen(entry, this.allPokemon));
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        try {
            context.method_25290(GUI_TEXTURE, this.guiLeft, this.guiTop, 0.0f, 0.0f, 390, 230, 390, 230);
        }
        catch (Exception e) {
            context.method_25294(this.guiLeft, this.guiTop, this.guiLeft + 390, this.guiTop + 230, -13948117);
        }
        this.renderLeftList(context, mouseX, mouseY, delta);
        this.searchField.method_25394(context, mouseX, mouseY, delta);
        this.renderMiddleSpawnZone(context, mouseX, mouseY, delta);
        this.renderRightInfoZone(context, mouseX, mouseY, delta);
        if (this.hoveredAbility != null) {
            String translatedDesc;
            ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
            String abilityKey = "cobblemon.ability." + this.hoveredAbility.getName().toLowerCase().replace(" ", "");
            Object translatedAbility = class_2561.method_43471((String)abilityKey).getString();
            if (((String)translatedAbility).equals(abilityKey)) {
                translatedAbility = this.hoveredAbility.getName();
            }
            tooltip.add(class_2561.method_43470((String)("\u00a7e" + (String)translatedAbility)));
            String description = this.hoveredAbility.getDescription();
            if (description.startsWith("cobblemon.ability.") && description.endsWith(".desc") && !(translatedDesc = class_2561.method_43471((String)description).getString()).equals(description)) {
                description = translatedDesc;
            }
            tooltip.add(class_2561.method_43470((String)("\u00a77" + description)));
            context.method_51434(this.field_22793, tooltip, mouseX, mouseY);
        }
        if (!this.hiddenBiomes.isEmpty()) {
            boolean isHovering;
            boolean bl = isHovering = mouseX >= this.hiddenBiomesTextX && mouseX <= this.hiddenBiomesTextX + this.hiddenBiomesTextWidth && mouseY >= this.hiddenBiomesTextY && mouseY <= this.hiddenBiomesTextY + this.hiddenBiomesTextHeight;
            if (isHovering) {
                ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
                tooltip.add(class_2561.method_43470((String)"\u00a7eAutres biomes:"));
                for (String biome : this.hiddenBiomes) {
                    tooltip.add(class_2561.method_43470((String)("\u00a77\u2022 " + biome)));
                }
                int tooltipX = mouseX;
                int tooltipY = mouseY;
                int tooltipWidth = 0;
                for (class_2561 class_25612 : tooltip) {
                    int w = this.field_22793.method_27525((class_5348)class_25612);
                    if (w <= tooltipWidth) continue;
                    tooltipWidth = w;
                }
                int n = tooltip.size();
                Objects.requireNonNull(this.field_22793);
                int tooltipHeight = n * (9 + 2) + 8;
                if (tooltipX + (tooltipWidth += 16) > this.field_22789) {
                    tooltipX = this.field_22789 - tooltipWidth - 4;
                }
                if (tooltipY + tooltipHeight > this.field_22790) {
                    tooltipY = this.field_22790 - tooltipHeight - 4;
                }
                context.method_51434(this.field_22793, tooltip, tooltipX, tooltipY);
            }
        }
        if (this.hoveredTab != null) {
            String tabName = switch (this.hoveredTab.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "Informations";
                case 1 -> "\u00c9volutions";
                case 2 -> "Drops";
                case 3 -> "Attaques";
            };
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)tabName), mouseX, mouseY);
        }
        if (this.hoveredMove != null) {
            String description;
            void var11_27;
            ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
            String translatedName = this.getTranslatedMoveName(this.hoveredMove.getName());
            tooltip.add(class_2561.method_43470((String)("\u00a7e" + translatedName)));
            String typeColor = this.getTypeColor(this.hoveredMove.getType());
            String typeText = this.hoveredMove.getType().substring(0, 1).toUpperCase() + this.hoveredMove.getType().substring(1);
            String tooltipHeight = this.hoveredMove.getDamageCategory();
            int n = -1;
            switch (tooltipHeight.hashCode()) {
                case -989077289: {
                    if (!tooltipHeight.equals("physical")) break;
                    boolean bl = false;
                    break;
                }
                case -2008465223: {
                    if (!tooltipHeight.equals("special")) break;
                    boolean bl = true;
                    break;
                }
                case -892481550: {
                    if (!tooltipHeight.equals("status")) break;
                    int n2 = 2;
                }
            }
            String categoryText = switch (var11_27) {
                case 0 -> " \u00a7f- \u00a7cPhysique";
                case 1 -> " \u00a7f- \u00a79Sp\u00e9ciale";
                case 2 -> "";
                default -> "";
            };
            tooltip.add(class_2561.method_43470((String)("\u00a77Type: " + typeColor + typeText + categoryText)));
            if (this.hoveredMove.getPower() > 0) {
                tooltip.add(class_2561.method_43470((String)("\u00a77Puissance: \u00a7f" + this.hoveredMove.getPower())));
            }
            if (this.hoveredMove.getAccuracy() > 0) {
                tooltip.add(class_2561.method_43470((String)("\u00a77Pr\u00e9cision: \u00a7f" + this.hoveredMove.getAccuracy() + "%")));
            }
            if (this.hoveredMove.getPp() > 0) {
                tooltip.add(class_2561.method_43470((String)("\u00a77PP: \u00a7f" + this.hoveredMove.getPp())));
            }
            if ((description = this.getMoveDescription(this.hoveredMove.getName())) != null && !description.isEmpty()) {
                tooltip.add(class_2561.method_43470((String)""));
                String[] stringArray = description.split(" ");
                StringBuilder currentLine = new StringBuilder("\u00a77");
                for (String word : stringArray) {
                    if (this.field_22793.method_1727(String.valueOf(currentLine) + word) > 150) {
                        tooltip.add(class_2561.method_43470((String)currentLine.toString()));
                        currentLine = new StringBuilder("\u00a77" + word + " ");
                        continue;
                    }
                    currentLine.append(word).append(" ");
                }
                if (currentLine.length() > 2) {
                    tooltip.add(class_2561.method_43470((String)currentLine.toString().trim()));
                }
            }
            context.method_51434(this.field_22793, tooltip, mouseX, mouseY);
        }
        if (this.hoveredItemStack != null) {
            context.method_51446(this.field_22793, this.hoveredItemStack, mouseX, mouseY);
        }
    }

    private void renderLeftList(class_332 context, int mouseX, int mouseY, float delta) {
        int scrollbarX = this.guiLeft + 18;
        int listX = this.guiLeft + 22;
        int listY = this.guiTop + 15;
        int listHeight = 200;
        int maxScroll = Math.max(0, this.allPokemon.size() - 5);
        if (maxScroll > 0) {
            this.renderScrollbar(context, scrollbarX, listY, listHeight, this.leftListScroll, maxScroll);
        }
        context.method_44379(listX, listY, listX + 40, listY + listHeight);
        int hoveredListIndex = -1;
        for (int i = 0; i < this.allPokemon.size(); ++i) {
            boolean isHovered;
            int y = listY + i * 40 - this.leftListScroll * 40;
            if (y + 40 < listY || y > listY + listHeight) continue;
            PokeWikiScreen.PokemonEntry entry = this.allPokemon.get(i);
            if (entry == this.currentPokemon) {
                context.method_25294(listX, y, listX + 40, y + 40, -2147418368);
            }
            boolean bl = isHovered = mouseX >= listX && mouseX < listX + 40 && mouseY >= y && mouseY < y + 40 && mouseY >= listY && mouseY < listY + listHeight;
            if (isHovered && entry != this.currentPokemon) {
                context.method_25294(listX, y, listX + 40, y + 40, -2130706433);
                hoveredListIndex = i;
            }
            this.renderModel(context, entry, listX, y, 40, 40, 1.0f, mouseX, mouseY, delta);
            if (!entry.isCaught()) continue;
            try {
                int iconSize = 10;
                int iconX = listX + 40 - iconSize - 2;
                int iconY = y + 2;
                context.method_25290(CAUGHT_ICON, iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
                continue;
            }
            catch (Exception e) {
                CUPokeWiki.LOGGER.warn("Failed to render caught icon for {}", (Object)entry.getFullName());
            }
        }
        context.method_44380();
        if (hoveredListIndex >= 0) {
            PokeWikiScreen.PokemonEntry hovered = this.allPokemon.get(hoveredListIndex);
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)("#" + hovered.dexNumber + " - " + this.getTranslatedName(hovered))), mouseX, mouseY);
        }
    }

    private void renderScrollbar(class_332 context, int x, int y, int height, int currentScroll, int maxScroll) {
        int barWidth = 3;
        int visibleEntries = height / 40;
        int totalEntries = this.allPokemon.size();
        int barHeight = Math.max(20, (int)((float)visibleEntries / (float)totalEntries * (float)height));
        int barY = y + (int)((float)currentScroll / (float)maxScroll * (float)(height - barHeight));
        context.method_25294(x, y, x + barWidth, y + height, 0x40FFFFFF);
        int barColor = this.draggingLeftScrollbar ? -256 : -1;
        context.method_25294(x, barY, x + barWidth, barY + barHeight, barColor);
    }

    private void renderMiddleSpawnZone(class_332 context, int mouseX, int mouseY, float delta) {
        List<String> biomesForCategory;
        int zoneX = this.guiLeft + 40 + 27;
        int zoneY = this.guiTop + 40;
        int zoneWidth = 145;
        int zoneHeight = 175;
        context.method_25294(zoneX, zoneY, zoneX + zoneWidth, zoneY + zoneHeight, Integer.MIN_VALUE);
        this.hiddenBiomes.clear();
        if (this.biomeCategories.isEmpty()) {
            String noSpawn = class_2561.method_43471((String)"gui.cupokewiki.detail.no_spawn_data").getString();
            String noSpawn2 = class_2561.method_43471((String)"gui.cupokewiki.detail.no_spawn_data_2").getString();
            int textWidth = this.field_22793.method_1727(noSpawn);
            int textWidth2 = this.field_22793.method_1727(noSpawn2);
            int messageY = zoneY + 25;
            context.method_51433(this.field_22793, noSpawn, zoneX + (zoneWidth - textWidth) / 2, messageY, 0x888888, false);
            context.method_51433(this.field_22793, noSpawn2, zoneX + (zoneWidth - textWidth2) / 2, messageY + 10, 0x888888, false);
            if (this.currentPokemon.spawnData != null && this.currentPokemon.spawnData.getDescriptionSpawnNonNaturel() != null) {
                String description = this.currentPokemon.spawnData.getDescriptionSpawnNonNaturel();
                int separatorY = messageY + 25;
                context.method_25294(zoneX + 10, separatorY, zoneX + zoneWidth - 10, separatorY + 1, -12303292);
                int descY = separatorY + 5;
                int maxWidth = zoneWidth - 10;
                List<String> wrappedLines = this.wrapText(description, maxWidth);
                for (String line : wrappedLines) {
                    if (descY >= zoneY + zoneHeight - 5) continue;
                    context.method_51433(this.field_22793, line, zoneX + 5, descY, 0xFFAA00, false);
                    descY += 9;
                }
            }
            return;
        }
        int titleY = zoneY + 5;
        context.method_25294(zoneX + 3, titleY, zoneX + 5, titleY + 10, -16733441);
        context.method_51433(this.field_22793, class_2561.method_43471((String)"gui.cupokewiki.detail.biomes").getString(), zoneX + 7, titleY, 0xFFFFFF, false);
        int contentStartY = titleY + 12;
        int availableHeight = zoneHeight - 17;
        int totalContentHeight = this.calculateTotalContentHeight(zoneWidth);
        int scrollbarX = zoneX + zoneWidth - 4;
        if (totalContentHeight > availableHeight) {
            this.renderBiomeScrollbar(context, scrollbarX, contentStartY, availableHeight, totalContentHeight);
        }
        context.method_44379(zoneX, contentStartY, zoneX + zoneWidth, zoneY + zoneHeight);
        this.hoveredBiomeCategory = null;
        int currentY = contentStartY - this.biomeZoneScroll;
        this.biomeClickZones.clear();
        int tagWidth = (zoneWidth - 15) / 2;
        int col = 0;
        HashMap<String, List<String>> realBiomes = this.currentPokemon.spawnData != null ? this.currentPokemon.spawnData.getRealBiomesByCategory() : new HashMap();
        ArrayList<String> validCategories = new ArrayList<String>();
        for (String category : this.biomeCategories) {
            biomesForCategory = this.getBiomesForCategory(realBiomes, category);
            if (biomesForCategory == null || biomesForCategory.isEmpty()) continue;
            validCategories.add(category);
        }
        block2: for (int i = 0; i < validCategories.size(); ++i) {
            boolean isEndOfRow;
            Object displayName;
            String category;
            category = (String)validCategories.get(i);
            biomesForCategory = this.getBiomesForCategory(realBiomes, category);
            if (category.startsWith("biome:")) {
                String biomePath = category.substring(6);
                displayName = this.getEnglishBiomeName(biomePath);
            } else {
                displayName = category.substring(0, 1).toUpperCase() + category.substring(1);
            }
            if (((String)displayName).length() > 9) {
                displayName = ((String)displayName).substring(0, 8) + ".";
            }
            int tagX = zoneX + 5 + col * (tagWidth + 5);
            if (currentY + 12 >= contentStartY && currentY <= contentStartY + availableHeight) {
                boolean isHovered = mouseX >= tagX && mouseX <= tagX + tagWidth && mouseY >= currentY && mouseY <= currentY + 12 && mouseY >= contentStartY && mouseY <= contentStartY + availableHeight;
                this.biomeClickZones.put(category, new int[]{tagX, currentY, tagX + tagWidth, currentY + 12});
                boolean isSelected = category.equals(this.selectedBiomeCategory);
                int bgColor = isSelected ? -16733696 : (isHovered ? -11184811 : -13421773);
                context.method_25294(tagX, currentY, tagX + tagWidth, currentY + 12, bgColor);
                int textWidth = this.field_22793.method_1727((String)displayName);
                int textX = tagX + (tagWidth - textWidth) / 2;
                int textColor = isSelected || isHovered ? 0xFFFFFF : 0xCCCCCC;
                context.method_51433(this.field_22793, (String)displayName, textX, currentY + 2, textColor, false);
                if (isHovered) {
                    this.hoveredBiomeCategory = category;
                }
            }
            boolean bl = isEndOfRow = ++col >= 2 || i == validCategories.size() - 1;
            if (!isEndOfRow) continue;
            col = 0;
            currentY += 14;
            int rowStart = i / 2 * 2;
            int rowEnd = Math.min(rowStart + 1, validCategories.size() - 1);
            for (int j = rowStart; j <= rowEnd; ++j) {
                String rowCategory = (String)validCategories.get(j);
                if (!rowCategory.equals(this.selectedBiomeCategory)) continue;
                if ((currentY += 2) >= contentStartY && currentY <= contentStartY + availableHeight) {
                    context.method_51448().method_22903();
                    context.method_51448().method_46416((float)(zoneX + 5), (float)currentY, 0.0f);
                    context.method_51448().method_22905(0.85f, 0.85f, 1.0f);
                    context.method_51433(this.field_22793, "\u00a77Spawn:", 0, 0, -1, false);
                    context.method_51448().method_22909();
                }
                currentY += 10;
                List<String> biomesForCat = this.getBiomesForCategory(realBiomes, rowCategory);
                if (biomesForCat != null && !biomesForCat.isEmpty()) {
                    currentY = rowCategory.equalsIgnoreCase("overworld") ? this.renderOverworldText(context, zoneX, currentY, contentStartY, availableHeight) : this.renderBiomeList(context, biomesForCat, zoneX, currentY, zoneWidth, contentStartY, availableHeight, mouseX, mouseY);
                    if (this.currentPokemon.spawnData != null) {
                        currentY = this.renderTimeRanges(context, zoneX, currentY, zoneWidth, contentStartY, availableHeight);
                    }
                }
                currentY += 2;
                continue block2;
            }
        }
        context.method_44380();
        if (this.currentPokemon.spawnData != null && this.currentPokemon.spawnData.getDescriptionSpawnNonNaturel() != null) {
            String description = this.currentPokemon.spawnData.getDescriptionSpawnNonNaturel();
            this.renderNonNaturalSpawnDescription(context, description, zoneX, zoneY, zoneWidth, zoneHeight, contentStartY, totalContentHeight);
        }
    }

    private int calculateTotalContentHeight(int zoneWidth) {
        List<String> biomesForCategory;
        int totalHeight = 10;
        int col = 0;
        HashMap<String, List<String>> realBiomes = this.currentPokemon.spawnData != null ? this.currentPokemon.spawnData.getRealBiomesByCategory() : new HashMap();
        ArrayList<String> validCategories = new ArrayList<String>();
        for (String category : this.biomeCategories) {
            biomesForCategory = this.getBiomesForCategory(realBiomes, category);
            if (biomesForCategory == null || biomesForCategory.isEmpty()) continue;
            validCategories.add(category);
        }
        for (int i = 0; i < validCategories.size(); ++i) {
            boolean isEndOfRow;
            String category;
            category = (String)validCategories.get(i);
            biomesForCategory = this.getBiomesForCategory(realBiomes, category);
            boolean bl = isEndOfRow = ++col >= 2 || i == validCategories.size() - 1;
            if (!isEndOfRow) continue;
            col = 0;
            totalHeight += 14;
            if (!category.equals(this.selectedBiomeCategory)) continue;
            totalHeight += 2;
            if (category.equalsIgnoreCase("overworld")) {
                Objects.requireNonNull(this.field_22793);
                totalHeight += (int)(9.0f * 0.85f) * 2;
            } else {
                List<String> formattedLines = this.formatBiomeLines(biomesForCategory, zoneWidth - 15);
                Objects.requireNonNull(this.field_22793);
                int lineHeight = (int)(9.0f * 0.85f);
                totalHeight += formattedLines.size() * lineHeight;
            }
            if (this.currentPokemon.spawnData != null) {
                Objects.requireNonNull(this.field_22793);
                int lineHeight = (int)(9.0f * 0.85f);
                totalHeight += 3 + lineHeight * 2;
            }
            totalHeight += 2;
        }
        if (this.currentPokemon.spawnData != null && this.currentPokemon.spawnData.getDescriptionSpawnNonNaturel() != null) {
            String description = this.currentPokemon.spawnData.getDescriptionSpawnNonNaturel();
            int maxWidth = zoneWidth - 10;
            List<String> wrappedLines = this.wrapText(description, maxWidth);
            int lineHeight = 9;
            totalHeight += 15 + wrappedLines.size() * lineHeight;
        }
        return totalHeight;
    }

    private int renderOverworldText(class_332 context, int zoneX, int currentY, int contentStartY, int availableHeight) {
        String overworldText = class_2561.method_43471((String)"gui.cupokewiki.detail.overworld").getString();
        String overworldText2 = class_2561.method_43471((String)"gui.cupokewiki.detail.overworld_2").getString();
        Objects.requireNonNull(this.field_22793);
        int lineHeight = (int)(9.0f * 0.85f);
        if (currentY + lineHeight >= contentStartY && currentY <= contentStartY + availableHeight) {
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)(zoneX + 5), (float)currentY, 0.0f);
            context.method_51448().method_22905(0.85f, 0.85f, 1.0f);
            context.method_51433(this.field_22793, overworldText, 0, 0, 0xFFAA00, false);
            context.method_51448().method_22909();
        }
        if ((currentY += lineHeight) + lineHeight >= contentStartY && currentY <= contentStartY + availableHeight) {
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)(zoneX + 5), (float)currentY, 0.0f);
            context.method_51448().method_22905(0.85f, 0.85f, 1.0f);
            context.method_51433(this.field_22793, overworldText2, 0, 0, 0xFFAA00, false);
            context.method_51448().method_22909();
        }
        return currentY += lineHeight;
    }

    private int renderBiomeList(class_332 context, List<String> biomesForCat, int zoneX, int currentY, int zoneWidth, int contentStartY, int availableHeight, int mouseX, int mouseY) {
        List<String> formattedLines = this.formatBiomeLines(biomesForCat, zoneWidth - 15);
        Objects.requireNonNull(this.field_22793);
        int lineHeight = (int)(9.0f * 0.85f);
        for (int k = 0; k < formattedLines.size(); ++k) {
            String line = formattedLines.get(k);
            if (currentY + lineHeight >= contentStartY && currentY <= contentStartY + availableHeight) {
                context.method_51448().method_22903();
                context.method_51448().method_46416((float)(zoneX + 5), (float)currentY, 0.0f);
                context.method_51448().method_22905(0.85f, 0.85f, 1.0f);
                context.method_51433(this.field_22793, line, 0, 0, -1, false);
                context.method_51448().method_22909();
            }
            currentY += lineHeight;
        }
        if (!this.hiddenBiomes.isEmpty() && formattedLines.size() > 0) {
            int lastLineY = currentY - lineHeight;
            String lastLine = formattedLines.get(formattedLines.size() - 1);
            String plusText = " \u00a7f(\u00a76+" + this.hiddenBiomes.size() + "\u00a7f)";
            String lastLineClean = lastLine.replaceAll("\u00a7.", "");
            String plusTextClean = plusText.replaceAll("\u00a7.", "");
            int lastLineWidth = this.field_22793.method_1727(lastLineClean);
            int plusWidth = this.field_22793.method_1727(plusTextClean);
            this.hiddenBiomesTextX = zoneX + 5 + (int)((float)lastLineWidth * 0.85f);
            this.hiddenBiomesTextY = lastLineY;
            this.hiddenBiomesTextWidth = (int)((float)plusWidth * 0.85f);
            this.hiddenBiomesTextHeight = lineHeight;
            if (lastLineY + lineHeight >= contentStartY && lastLineY <= contentStartY + availableHeight) {
                boolean isHovering = mouseX >= this.hiddenBiomesTextX && mouseX <= this.hiddenBiomesTextX + this.hiddenBiomesTextWidth && mouseY >= this.hiddenBiomesTextY && mouseY <= this.hiddenBiomesTextY + this.hiddenBiomesTextHeight && mouseY >= contentStartY && mouseY <= contentStartY + availableHeight;
                String colorCode = isHovering ? "\u00a7e" : "\u00a76";
                context.method_51448().method_22903();
                context.method_51448().method_46416((float)this.hiddenBiomesTextX, (float)lastLineY, 0.0f);
                context.method_51448().method_22905(0.85f, 0.85f, 1.0f);
                context.method_51433(this.field_22793, colorCode + "\u00a7n(" + this.hiddenBiomes.size() + ")", 0, 0, -1, false);
                context.method_51448().method_22909();
            }
        }
        return currentY;
    }

    private int renderTimeRanges(class_332 context, int zoneX, int currentY, int zoneWidth, int contentStartY, int availableHeight) {
        List<Object> timeRanges = this.currentPokemon.spawnData != null ? this.currentPokemon.spawnData.getTimeRanges() : new ArrayList();
        currentY += 3;
        Objects.requireNonNull(this.field_22793);
        int lineHeight = (int)(9.0f * 0.85f);
        if (timeRanges == null || timeRanges.isEmpty()) {
            if (currentY + lineHeight >= contentStartY && currentY <= contentStartY + availableHeight) {
                context.method_51448().method_22903();
                context.method_51448().method_46416((float)(zoneX + 5), (float)currentY, 0.0f);
                context.method_51448().method_22905(0.85f, 0.85f, 1.0f);
                context.method_51433(this.field_22793, "\u00a77Temps: \u00a76Spawn tout le temps", 0, 0, -1, false);
                context.method_51448().method_22909();
            }
            currentY += lineHeight;
        } else {
            if (currentY + lineHeight >= contentStartY && currentY <= contentStartY + availableHeight) {
                context.method_51448().method_22903();
                context.method_51448().method_46416((float)(zoneX + 5), (float)currentY, 0.0f);
                context.method_51448().method_22905(0.85f, 0.85f, 1.0f);
                context.method_51433(this.field_22793, "\u00a77Temps:", 0, 0, -1, false);
                context.method_51448().method_22909();
            }
            currentY += lineHeight;
            StringBuilder timeRangeText = new StringBuilder();
            for (int i = 0; i < timeRanges.size(); ++i) {
                String timeRange = (String)timeRanges.get(i);
                String translatedTime = this.translateTimeRange(timeRange);
                if (i > 0) {
                    timeRangeText.append("\u00a7f, ");
                }
                String colorCode = i % 2 == 0 ? "\u00a76" : "\u00a7e";
                timeRangeText.append(colorCode).append(translatedTime);
            }
            if (currentY + lineHeight >= contentStartY && currentY <= contentStartY + availableHeight) {
                context.method_51448().method_22903();
                context.method_51448().method_46416((float)(zoneX + 10), (float)currentY, 0.0f);
                context.method_51448().method_22905(0.85f, 0.85f, 1.0f);
                context.method_51433(this.field_22793, timeRangeText.toString(), 0, 0, -1, false);
                context.method_51448().method_22909();
            }
            currentY += lineHeight;
        }
        return currentY;
    }

    private String translateTimeRange(String timeRange) {
        String lower;
        if (timeRange == null) {
            return "";
        }
        return switch (lower = timeRange.toLowerCase()) {
            case "any" -> "Tout le temps";
            case "day" -> "Jour";
            case "night" -> "Nuit";
            case "noon" -> "Midi";
            case "midnight" -> "Minuit";
            case "dawn" -> "Aube";
            case "dusk" -> "Cr\u00e9puscule";
            case "twilight" -> "Cr\u00e9puscule";
            case "morning" -> "Matin";
            case "afternoon" -> "Apr\u00e8s-midi";
            case "predawn" -> "Avant l'aube";
            case "evening" -> "Soir\u00e9e";
            default -> timeRange.substring(0, 1).toUpperCase() + timeRange.substring(1);
        };
    }

    private void renderNonNaturalSpawnDescription(class_332 context, String description, int zoneX, int zoneY, int zoneWidth, int zoneHeight, int contentStartY, int totalContentHeight) {
        int bottomY;
        int titleEndY = zoneY + 19;
        int availableHeight = zoneHeight - 19;
        int contentEndY = contentStartY - this.biomeZoneScroll + totalContentHeight;
        int descStartY = contentEndY + 10;
        if ((descStartY = Math.max(descStartY, titleEndY + 10)) >= (bottomY = zoneY + zoneHeight - 5) - 25) {
            return;
        }
        int maxDescHeight = bottomY - descStartY;
        if (maxDescHeight > 20) {
            int currentY = descStartY;
            context.method_25294(zoneX + 3, currentY, zoneX + zoneWidth - 3, currentY + 1, -12303292);
            currentY += 3;
            int maxWidth = zoneWidth - 10;
            List<String> wrappedLines = this.wrapText(description, maxWidth);
            int lineHeight = 9;
            int availableLines = (maxDescHeight - 4) / lineHeight;
            int linesToShow = Math.min(wrappedLines.size(), availableLines);
            for (int i = 0; i < linesToShow; ++i) {
                Object line = wrappedLines.get(i);
                if (i == linesToShow - 1 && wrappedLines.size() > linesToShow) {
                    line = ((String)line).substring(0, Math.min(((String)line).length(), maxWidth / 6 - 3)) + "...";
                }
                context.method_51433(this.field_22793, (String)line, zoneX + 5, currentY, 0xFFAA00, false);
                currentY += lineHeight;
            }
        }
    }

    private void renderBiomeScrollbar(class_332 context, int x, int y, int height, int contentHeight) {
        int barWidth = 3;
        int maxScroll = Math.max(0, contentHeight - height);
        int barHeight = Math.max(20, (int)((float)height / (float)contentHeight * (float)height));
        int barY = y + (maxScroll > 0 ? (int)((float)this.biomeZoneScroll / (float)maxScroll * (float)(height - barHeight)) : 0);
        context.method_25294(x, y, x + barWidth, y + height, 0x40FFFFFF);
        int barColor = this.draggingBiomeScrollbar ? -256 : -1;
        context.method_25294(x, barY, x + barWidth, barY + barHeight, barColor);
    }

    private List<String> formatBiomeLines(List<String> biomePaths, int maxWidth) {
        int i;
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        this.hiddenBiomes.clear();
        int maxLines = 6;
        int biomesDisplayed = 0;
        for (i = 0; i < biomePaths.size() && lines.size() < maxLines; ++i) {
            String testLine;
            String biomePath = biomePaths.get(i);
            String biomeName = this.getEnglishBiomeName(biomePath);
            int colorIndex = i % 2;
            String colorCode = colorIndex == 0 ? "\u00a76" : "\u00a7e";
            String biomeWithColor = colorCode + biomeName;
            if (i < biomePaths.size() - 1) {
                biomeWithColor = biomeWithColor + "\u00a7f, ";
            }
            String string = testLine = currentLine.length() == 0 ? biomeWithColor : String.valueOf(currentLine) + biomeWithColor;
            if (this.field_22793.method_1727(testLine.replaceAll("\u00a7.", "")) <= maxWidth) {
                currentLine.append(biomeWithColor);
                ++biomesDisplayed;
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
            }
            if (lines.size() >= maxLines) break;
            currentLine = new StringBuilder(biomeWithColor);
            ++biomesDisplayed;
        }
        if (currentLine.length() > 0 && lines.size() < maxLines) {
            lines.add(currentLine.toString());
        }
        for (i = biomesDisplayed; i < biomePaths.size(); ++i) {
            String hiddenPath = biomePaths.get(i);
            String hiddenName = this.getEnglishBiomeName(hiddenPath);
            this.hiddenBiomes.add(hiddenName);
        }
        return lines;
    }

    private List<String> getBiomesForCategory(Map<String, List<String>> realBiomes, String category) {
        if (category.startsWith("biome:")) {
            List<String> found = realBiomes.get(category);
            if (found != null && !found.isEmpty()) {
                return found;
            }
            String biomePath = category.substring(6);
            return Collections.singletonList(biomePath);
        }
        List<String> biomesForCategory = realBiomes.get(category.toLowerCase());
        if (biomesForCategory == null || biomesForCategory.isEmpty()) {
            biomesForCategory = realBiomes.get("is_" + category.toLowerCase());
        }
        if (biomesForCategory == null || biomesForCategory.isEmpty()) {
            String withoutUnderscores = category.toLowerCase().replace("_", " ");
            biomesForCategory = realBiomes.get(withoutUnderscores);
        }
        return biomesForCategory;
    }

    private String getEnglishBiomeName(String path) {
        class_2960 id = path.contains(":") ? class_2960.method_60654((String)path) : class_2960.method_60655((String)"minecraft", (String)path);
        return Arrays.stream(id.method_12832().split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1)).collect(Collectors.joining(" "));
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            Object testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
            int width = this.field_22793.method_1727((String)testLine);
            if (width <= maxWidth) {
                if (currentLine.length() > 0) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private void renderRightInfoZone(class_332 context, int mouseX, int mouseY, float delta) {
        int zoneX = this.guiLeft + 40 + 27 + 150;
        int zoneY = this.guiTop + 40;
        int zoneWidth = 150;
        int zoneHeight = 175;
        context.method_25294(zoneX, zoneY, zoneX + zoneWidth, zoneY + zoneHeight, Integer.MIN_VALUE);
        int currentY = zoneY + 5;
        if (this.currentPokemon.spawnData != null) {
            int chipX = zoneX + 5;
            for (int i = 0; i < this.currentPokemon.spawnData.getTypes().size(); ++i) {
                String type = this.currentPokemon.spawnData.getTypes().get(i).toLowerCase();
                String typeKey = "cobblemon.type." + type;
                Object typeText = class_2561.method_43471((String)typeKey).getString();
                if (((String)typeText).equals(typeKey)) {
                    typeText = type.substring(0, 1).toUpperCase() + type.substring(1);
                }
                int textWidth = this.field_22793.method_1727((String)typeText);
                int chipWidth = textWidth + 10;
                class_2960 typeTexture = class_2960.method_60655((String)"cupokewiki", (String)("textures/buttons/tag_" + type + ".png"));
                try {
                    context.method_51448().method_22903();
                    context.method_51448().method_46416((float)chipX, (float)currentY, 0.0f);
                    context.method_51448().method_22905((float)chipWidth / 40.0f, 1.0f, 1.0f);
                    context.method_25290(typeTexture, 0, 0, 0.0f, 0.0f, 40, 14, 40, 14);
                    context.method_51448().method_22909();
                }
                catch (Exception e) {
                    context.method_25294(chipX, currentY, chipX + chipWidth, currentY + 14, -7829368);
                }
                int textX = chipX + (chipWidth - textWidth) / 2;
                context.method_51433(this.field_22793, (String)typeText, textX, currentY + 3, 0xFFFFFF, true);
                chipX += chipWidth + 3;
            }
        }
        String displayName = this.getTranslatedName(this.currentPokemon);
        int nameWidth = this.field_22793.method_1727(displayName);
        currentY += 18;
        if (nameWidth > zoneWidth - 10) {
            float scale = (float)(zoneWidth - 10) / (float)nameWidth;
            context.method_51448().method_22903();
            context.method_51448().method_46416((float)(zoneX + 5), (float)currentY, 0.0f);
            context.method_51448().method_22905(scale, scale, 1.0f);
            context.method_51433(this.field_22793, displayName, 0, 0, 0xFFFFFF, true);
            context.method_51448().method_22909();
        } else {
            int nameX = zoneX + (zoneWidth - nameWidth) / 2;
            context.method_51433(this.field_22793, displayName, nameX, currentY, 0xFFFFFF, true);
        }
        int tabsY = zoneY + 6;
        int tabsX = zoneX + zoneWidth - 12 - 5;
        this.renderInfoTabs(context, tabsX, tabsY, mouseX, mouseY);
        currentY += 12;
        if (this.currentPokemon.spawnData == null) {
            context.method_51433(this.field_22793, "Pas de donn\u00e9es de spawn", zoneX + 5, currentY, 0x888888, false);
            return;
        }
        int contentStartY = currentY;
        int contentHeight = zoneHeight - (contentStartY - zoneY);
        this.renderTabContent(context, zoneX, contentStartY, zoneWidth, contentHeight, mouseX, mouseY, delta);
    }

    private void renderInfoTabs(class_332 context, int tabX, int tabY, int mouseX, int mouseY) {
        this.hoveredTab = null;
        for (int i = 0; i < 4; ++i) {
            boolean isSelected;
            InfoTab tab = InfoTab.values()[i];
            int currentTabY = tabY + i * 14;
            boolean isHovered = mouseX >= tabX && mouseX < tabX + 12 && mouseY >= currentTabY && mouseY < currentTabY + 12;
            boolean bl = isSelected = this.selectedTab == tab;
            if (isHovered) {
                this.hoveredTab = tab;
            }
            int vOffset = isHovered || isSelected ? 12 : 0;
            class_2960 texture = switch (tab.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> TAB_INFO_TEXTURE;
                case 1 -> TAB_EVO_TEXTURE;
                case 2 -> TAB_DROPS_TEXTURE;
                case 3 -> TAB_MOVES_TEXTURE;
            };
            try {
                context.method_25290(texture, tabX, currentTabY, 0.0f, (float)vOffset, 12, 12, 12, 24);
                continue;
            }
            catch (Exception e) {
                int color = isHovered || isSelected ? -256 : -7829368;
                context.method_25294(tabX, currentTabY, tabX + 12, currentTabY + 12, color);
            }
        }
    }

    private void renderTabContent(class_332 context, int zoneX, int contentY, int zoneWidth, int contentHeight, int mouseX, int mouseY, float delta) {
        int scrollbarX = zoneX + zoneWidth - 4;
        int availableHeight = contentHeight - 5;
        int totalContentHeight = this.calculateTabContentHeight();
        if (this.selectedTab != InfoTab.INFO && totalContentHeight > availableHeight) {
            this.renderInfoScrollbar(context, scrollbarX, contentY, availableHeight, totalContentHeight);
        }
        context.method_44379(zoneX, contentY, zoneX + zoneWidth, contentY + contentHeight);
        int currentY = contentY - (this.selectedTab == InfoTab.INFO ? 0 : this.infoContentScroll);
        switch (this.selectedTab.ordinal()) {
            case 0: {
                currentY = this.renderInfoTab(context, zoneX, currentY, zoneWidth, contentY, availableHeight, mouseX, mouseY, delta);
                break;
            }
            case 1: {
                currentY = this.renderEvolutionsTab(context, zoneX, currentY, zoneWidth, contentY, availableHeight, mouseX, mouseY);
                break;
            }
            case 2: {
                currentY = this.renderDropsTab(context, zoneX, currentY, zoneWidth, contentY, availableHeight, mouseX, mouseY);
                break;
            }
            case 3: {
                currentY = this.renderMovesTab(context, zoneX, currentY, zoneWidth, contentY, availableHeight, mouseX, mouseY);
            }
        }
        context.method_44380();
    }

    private int calculateTabContentHeight() {
        return switch (this.selectedTab.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.calculateInfoHeight();
            case 1 -> this.calculateEvolutionsHeight();
            case 2 -> this.calculateDropsHeight();
            case 3 -> this.calculateMovesHeight();
        };
    }

    private int calculateInfoHeight() {
        return 0;
    }

    private int calculateEvolutionsHeight() {
        List<EvolutionInfo> evolutions = this.getEvolutions();
        if (evolutions.isEmpty()) {
            return 30;
        }
        int height = 15;
        for (EvolutionInfo evolution : evolutions) {
            String[] conditions;
            height += 10;
            for (String condition : conditions = evolution.condition.split(" \\| ")) {
                if (condition.startsWith("BIOME:") || condition.startsWith("BIOME_ANTI:")) {
                    String biomes = condition.contains("ANTI") ? condition.substring(11) : condition.substring(6);
                    String prefix = condition.contains("ANTI") ? "Hors biome " : "Biome ";
                    int maxWidth = 120;
                    String fullText = "  " + prefix + biomes;
                    if (this.field_22793.method_1727(fullText) <= maxWidth) {
                        height += 10;
                        continue;
                    }
                    height += 10;
                    String[] biomeList = biomes.split(", ");
                    int lineCount = 1;
                    StringBuilder currentLine = new StringBuilder("  ");
                    for (int i = 0; i < biomeList.length; ++i) {
                        String testLine = currentLine.toString() + biomeList[i];
                        if (i < biomeList.length - 1) {
                            testLine = testLine + ", ";
                        }
                        if (this.field_22793.method_1727(testLine) > maxWidth && currentLine.length() > 2) {
                            ++lineCount;
                            currentLine = new StringBuilder("  " + biomeList[i]);
                            if (i >= biomeList.length - 1) continue;
                            currentLine.append(", ");
                            continue;
                        }
                        currentLine.append(biomeList[i]);
                        if (i >= biomeList.length - 1) continue;
                        currentLine.append(", ");
                    }
                    height += lineCount * 10;
                    continue;
                }
                if (condition.trim().startsWith("ITEM:")) {
                    height += 10;
                    continue;
                }
                if (condition.trim().startsWith("Capacit\u00e9: ")) {
                    String moveName = condition.trim().substring(10);
                    String translatedName = this.getTranslatedMoveName(moveName);
                    String displayText = "  Doit conna\u00eetre " + translatedName;
                    int maxWidth = 135;
                    if (this.field_22793.method_1727(displayText) > maxWidth) {
                        height += 20;
                        continue;
                    }
                    height += 10;
                    continue;
                }
                if (condition.trim().startsWith("M\u00e9t\u00e9o: ")) {
                    height += 10;
                    continue;
                }
                if (condition.trim().contains(" > ") || condition.trim().startsWith("Stat: ") || condition.trim().equals("Stats sp\u00e9cifiques")) {
                    height += 10;
                    continue;
                }
                if (condition.trim().startsWith("Structure: ")) {
                    height += 10;
                    continue;
                }
                if (condition.trim().startsWith("Progr\u00e8s: ")) {
                    height += 10;
                    continue;
                }
                if (condition.trim().startsWith("Propri\u00e9t\u00e9s: ")) {
                    height += 10;
                    continue;
                }
                if (condition.trim().startsWith("MOVETYPE:") || condition.trim().startsWith("MOONPHASE:") || condition.trim().startsWith("TIME:") || condition.trim().startsWith("BIOMTAG:") || condition.trim().startsWith("BIOMTAG_ANTI:")) {
                    height += 10;
                    continue;
                }
                if (condition.trim().startsWith("REQ:")) {
                    String[] parts = condition.trim().split(":", 3);
                    if (parts.length >= 2) {
                        String reqType = parts[1];
                        String data = parts.length > 2 ? parts[2] : "";
                        String fullText = "  [" + reqType + "] " + data;
                        int maxWidth = 135;
                        if (this.field_22793.method_1727(fullText) > maxWidth) {
                            height += 10;
                            if (data.isEmpty()) continue;
                            String words = data.split(" ");
                            int lineCount = 1;
                            StringBuilder currentLine = new StringBuilder("  ");
                            for (String word : words) {
                                String testLine = currentLine.toString() + (currentLine.length() > 2 ? " " : "") + word;
                                if (this.field_22793.method_1727(testLine) > maxWidth && currentLine.length() > 2) {
                                    ++lineCount;
                                    currentLine = new StringBuilder("  " + word);
                                    continue;
                                }
                                if (currentLine.length() > 2) {
                                    currentLine.append(" ");
                                }
                                currentLine.append(word);
                            }
                            height += lineCount * 10;
                            continue;
                        }
                        height += 10;
                        continue;
                    }
                    height += 10;
                    continue;
                }
                if (condition.trim().equals("Tient un objet") || condition.trim().equals("Dans une structure") || condition.trim().equals("Capacit\u00e9 sp\u00e9cifique") || condition.trim().equals("M\u00e9t\u00e9o sp\u00e9cifique") || condition.trim().equals("Avec progr\u00e8s sp\u00e9cial") || condition.trim().equals("Propri\u00e9t\u00e9s sp\u00e9cifiques") || condition.trim().equals("Apr\u00e8s combat") || condition.trim().equals("Doit \u00eatre shiny") || condition.trim().equals("Doit \u00eatre m\u00e2le") || condition.trim().equals("Doit \u00eatre femelle") || condition.trim().equals("Stats sp\u00e9cifiques")) {
                    height += 10;
                    continue;
                }
                String displayText = "  " + condition.trim();
                int maxWidth = 135;
                if (this.field_22793.method_1727(displayText) > maxWidth) {
                    String[] words = condition.trim().split(" ");
                    int lineCount = 1;
                    StringBuilder currentLine = new StringBuilder("  ");
                    for (String word : words) {
                        String testLine = currentLine.toString() + (currentLine.length() > 2 ? " " : "") + word;
                        if (this.field_22793.method_1727(testLine) > maxWidth && currentLine.length() > 2) {
                            ++lineCount;
                            currentLine = new StringBuilder("  " + word);
                            continue;
                        }
                        if (currentLine.length() > 2) {
                            currentLine.append(" ");
                        }
                        currentLine.append(word);
                    }
                    height += lineCount * 10;
                    continue;
                }
                height += 10;
            }
            height += 5;
        }
        return height;
    }

    private int calculateDropsHeight() {
        List<PokemonSpawnData.DropData> drops = this.currentPokemon.spawnData.getDrops();
        if (drops.isEmpty()) {
            return 30;
        }
        return 3 + drops.size() * 18;
    }

    private int calculateMovesHeight() {
        List<PokemonSpawnData.MoveData> allMoves = this.currentPokemon.spawnData.getMoves();
        if (allMoves.isEmpty()) {
            return 30;
        }
        int height = 3;
        int levelMovesCount = 0;
        int tmMovesCount = 0;
        int eggMovesCount = 0;
        for (PokemonSpawnData.MoveData move : allMoves) {
            switch (move.getLearnMethod()) {
                case "level": {
                    ++levelMovesCount;
                    break;
                }
                case "tm": {
                    ++tmMovesCount;
                    break;
                }
                case "egg": {
                    ++eggMovesCount;
                }
            }
        }
        if (levelMovesCount > 0) {
            height += 12;
            height += levelMovesCount * 10;
            height += 3;
        }
        if (tmMovesCount > 0) {
            height += 12;
            height += tmMovesCount * 10;
            height += 3;
        }
        if (eggMovesCount > 0) {
            height += 12;
            height += eggMovesCount * 10;
        }
        return height;
    }

    private int renderInfoTab(class_332 context, int zoneX, int currentY, int zoneWidth, int contentStartY, int availableHeight, int mouseX, int mouseY, float delta) {
        int modelX = zoneX + 25;
        int modelY = currentY += 3;
        int baseWidth = 96;
        int baseHeight = 32;
        int baseX = modelX + (100 - baseWidth) / 2;
        int baseY = modelY + 47;
        String primaryType = "normal";
        if (this.currentPokemon.spawnData != null && !this.currentPokemon.spawnData.getTypes().isEmpty()) {
            primaryType = this.currentPokemon.spawnData.getTypes().get(0).toLowerCase();
        }
        class_2960 platformTexture = class_2960.method_60655((String)"cupokewiki", (String)("textures/gui/plat/platform_base_" + primaryType + ".png"));
        try {
            context.method_25290(platformTexture, baseX, baseY, 0.0f, 0.0f, baseWidth, baseHeight, baseWidth, baseHeight);
        }
        catch (Exception e) {
            class_2960 fallback = class_2960.method_60655((String)"cupokewiki", (String)"textures/gui/plat/platform_base.png");
            context.method_25290(fallback, baseX, baseY, 0.0f, 0.0f, baseWidth, baseHeight, baseWidth, baseHeight);
        }
        this.renderModel(context, this.currentPokemon, modelX, modelY, 100, 70, 2.0f, mouseX, mouseY, delta);
        currentY += 70;
        if (this.currentPokemon.spawnData == null) {
            return currentY;
        }
        if (!this.currentPokemon.spawnData.getEggGroups().isEmpty()) {
            String eggTitle = "Groupes d'\u0153uf:";
            context.method_25294(zoneX + 3, currentY, zoneX + 5, currentY + 10, -16733441);
            context.method_51433(this.field_22793, eggTitle, zoneX + 7, currentY, 0, false);
            currentY += 10;
            for (String eggGroup : this.currentPokemon.spawnData.getEggGroups()) {
                String translatedEggGroup = class_2561.method_43471((String)("cobblemon.egggroup." + eggGroup.toLowerCase())).getString();
                if (translatedEggGroup.startsWith("cobblemon.egggroup.")) {
                    translatedEggGroup = eggGroup;
                }
                if (currentY >= contentStartY && currentY <= contentStartY + availableHeight) {
                    context.method_51433(this.field_22793, "\u2022 " + translatedEggGroup, zoneX + 5, currentY, 0xCCCCCC, false);
                }
                currentY += 9;
            }
        }
        this.hoveredAbility = null;
        String talentTitle = "Talents:";
        context.method_25294(zoneX + 3, ++currentY, zoneX + 5, currentY + 10, -16733441);
        context.method_51433(this.field_22793, talentTitle, zoneX + 7, currentY, 0, false);
        for (int i = 0; i < this.currentPokemon.spawnData.getAbilities().size(); ++i) {
            int color;
            boolean isHovered;
            PokemonSpawnData.AbilityData ability = this.currentPokemon.spawnData.getAbilities().get(i);
            currentY += 10;
            String abilityKey = "cobblemon.ability." + ability.getName().toLowerCase().replace(" ", "");
            String translatedAbility = class_2561.method_43471((String)abilityKey).getString();
            if (translatedAbility.equals(abilityKey)) {
                translatedAbility = ability.getName();
            }
            String abilityName = translatedAbility + (ability.isHidden() ? " (HA)" : "");
            int textWidth = this.field_22793.method_1727(abilityName);
            boolean bl = isHovered = mouseX >= zoneX + 5 && mouseX <= zoneX + 5 + textWidth && mouseY >= currentY && mouseY <= currentY + 10 && mouseY >= contentStartY && mouseY <= contentStartY + availableHeight;
            int n = isHovered ? 0xFFFF00 : (color = ability.isHidden() ? 0xFF8800 : 0xFFFFFF);
            if (currentY >= contentStartY && currentY <= contentStartY + availableHeight) {
                context.method_51433(this.field_22793, abilityName, zoneX + 5, currentY, color, false);
            }
            if (!isHovered) continue;
            this.hoveredAbility = ability;
        }
        return currentY;
    }

    private int renderEvolutionsTab(class_332 context, int zoneX, int currentY, int zoneWidth, int contentStartY, int availableHeight, int mouseX, int mouseY) {
        this.hoveredItemStack = null;
        this.hoveredMove = null;
        context.method_25294(zoneX + 3, currentY += 3, zoneX + 5, currentY + 10, -16733441);
        context.method_51433(this.field_22793, "\u00c9volutions:", zoneX + 7, currentY, 0xFFFFFF, false);
        currentY += 12;
        List<EvolutionInfo> evolutions = this.getEvolutions();
        if (evolutions.isEmpty()) {
            context.method_51433(this.field_22793, "Aucune \u00e9volution", zoneX + 5, currentY, 0x888888, false);
            currentY += 10;
        } else {
            for (EvolutionInfo evolution : evolutions) {
                String[] conditions;
                if (currentY >= contentStartY && currentY <= contentStartY + availableHeight) {
                    context.method_51433(this.field_22793, "\u00a7e" + evolution.name, zoneX + 5, currentY, 0xFFFFFF, false);
                }
                currentY += 10;
                for (String condition : conditions = evolution.condition.split(" \\| ")) {
                    currentY = this.renderConditionLine(context, condition.trim(), zoneX, currentY, mouseX, mouseY);
                }
                currentY += 5;
            }
        }
        return currentY;
    }

    private int renderConditionLine(class_332 context, String line, int zoneX, int currentY, int mouseX, int mouseY) {
        String[] parts;
        if (line.startsWith("ITEM:")) {
            String itemId = line.substring(5);
            class_2960 identifier = itemId.contains(":") ? class_2960.method_60654((String)itemId) : class_2960.method_60654((String)("cobblemon:" + itemId));
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(identifier);
            if (!(item != null && item != class_1802.field_8162 || itemId.contains(":"))) {
                identifier = class_2960.method_60654((String)("minecraft:" + itemId));
                item = (class_1792)class_7923.field_41178.method_10223(identifier);
            }
            if (item != null && item != class_1802.field_8162) {
                class_1799 stack = new class_1799((class_1935)item);
                context.method_51433(this.field_22793, "  \u00a77Doit tenir :", zoneX + 5, currentY, 0xAAAAAA, false);
                int itemX = zoneX + 70;
                int itemY = currentY - 3;
                context.method_51427(stack, itemX, itemY);
                if (mouseX >= itemX && mouseX <= itemX + 16 && mouseY >= itemY && mouseY <= itemY + 16) {
                    this.hoveredItemStack = stack;
                }
                return currentY + 10;
            }
            context.method_51433(this.field_22793, "  \u00a77Doit tenir : " + itemId, zoneX + 5, currentY, 0xAAAAAA, false);
            return currentY + 10;
        }
        if (line.startsWith("MOVETYPE:")) {
            String type = line.substring(9);
            String typeKey = "cobblemon.type." + type;
            Object typeText = class_2561.method_43471((String)typeKey).getString();
            if (((String)typeText).equals(typeKey)) {
                typeText = type.substring(0, 1).toUpperCase() + type.substring(1);
            }
            String typeColor = this.getTypeColor(type);
            context.method_51433(this.field_22793, "  \u00a77Attaque type " + typeColor + (String)typeText, zoneX + 5, currentY, 0xAAAAAA, false);
            return currentY + 10;
        }
        if (line.startsWith("Capacit\u00e9: ")) {
            String moveName = line.substring(10);
            String translatedName = this.getTranslatedMoveName(moveName);
            int maxWidth = 135;
            String displayText = "  \u00a77Doit conna\u00eetre \u00a7e" + translatedName;
            if (this.field_22793.method_1727(displayText) > maxWidth) {
                int yOffset = currentY;
                context.method_51433(this.field_22793, "  \u00a77Doit conna\u00eetre", zoneX + 5, yOffset, 0xAAAAAA, false);
                String moveText = "  " + translatedName;
                int textWidth = this.field_22793.method_1727(moveText);
                boolean isHovered = mouseX >= zoneX + 5 && mouseX <= zoneX + 5 + textWidth && mouseY >= (yOffset += 10) && mouseY <= yOffset + 10;
                int color = isHovered ? 0xFFFF00 : 0xEEEE00;
                context.method_51433(this.field_22793, "  \u00a7e" + translatedName, zoneX + 5, yOffset, color, false);
                if (isHovered && this.currentPokemon.spawnData != null) {
                    for (PokemonSpawnData.MoveData move : this.currentPokemon.spawnData.getMoves()) {
                        if (!move.getName().equalsIgnoreCase(moveName)) continue;
                        this.hoveredMove = move;
                        break;
                    }
                }
                return yOffset + 10;
            }
            String moveText = "  Doit conna\u00eetre " + translatedName;
            int textWidth = this.field_22793.method_1727(moveText);
            boolean isHovered = mouseX >= zoneX + 5 && mouseX <= zoneX + 5 + textWidth && mouseY >= currentY && mouseY <= currentY + 10;
            int color = isHovered ? 0xFFFF00 : 0xAAAAAA;
            context.method_51433(this.field_22793, displayText, zoneX + 5, currentY, color, false);
            if (isHovered && this.currentPokemon.spawnData != null) {
                for (PokemonSpawnData.MoveData move : this.currentPokemon.spawnData.getMoves()) {
                    if (!move.getName().equalsIgnoreCase(moveName)) continue;
                    this.hoveredMove = move;
                    break;
                }
            }
            return currentY + 10;
        }
        if (line.startsWith("M\u00e9t\u00e9o: ")) {
            String weather = line.substring(7);
            String weatherDisplay = weather.substring(0, 1).toUpperCase() + weather.substring(1);
            context.method_51433(this.field_22793, "  \u00a77M\u00e9t\u00e9o: \u00a7b" + weatherDisplay, zoneX + 5, currentY, 0xAAAAAA, false);
            return currentY + 10;
        }
        if (line.contains(" > ")) {
            context.method_51433(this.field_22793, "  \u00a77" + line, zoneX + 5, currentY, 0xAAAAAA, false);
            return currentY + 10;
        }
        if (line.startsWith("Stat: ")) {
            context.method_51433(this.field_22793, "  \u00a77" + line, zoneX + 5, currentY, 0xAAAAAA, false);
            return currentY + 10;
        }
        if (line.equals("Stats sp\u00e9cifiques")) {
            context.method_51433(this.field_22793, "  \u00a77" + line, zoneX + 5, currentY, 0xAAAAAA, false);
            return currentY + 10;
        }
        if (line.startsWith("Structure: ")) {
            String structure = line.substring(11);
            String structDisplay = structure.substring(0, 1).toUpperCase() + structure.substring(1);
            context.method_51433(this.field_22793, "  \u00a77Structure: \u00a7d" + structDisplay, zoneX + 5, currentY, 0xAAAAAA, false);
            return currentY + 10;
        }
        if (line.startsWith("Progr\u00e8s: ")) {
            String advancement = line.substring(9);
            String advDisplay = advancement.substring(0, 1).toUpperCase() + advancement.substring(1);
            context.method_51433(this.field_22793, "  \u00a77Progr\u00e8s: \u00a7a" + advDisplay, zoneX + 5, currentY, 0xAAAAAA, false);
            return currentY + 10;
        }
        if (line.startsWith("Propri\u00e9t\u00e9s: ")) {
            String properties = line.substring(12);
            context.method_51433(this.field_22793, "  \u00a77" + properties, zoneX + 5, currentY, 0xAAAAAA, false);
            return currentY + 10;
        }
        if (line.equals("Tient un objet") || line.equals("Dans une structure") || line.equals("Capacit\u00e9 sp\u00e9cifique") || line.equals("M\u00e9t\u00e9o sp\u00e9cifique") || line.equals("Avec progr\u00e8s sp\u00e9cial") || line.equals("Propri\u00e9t\u00e9s sp\u00e9cifiques") || line.equals("Apr\u00e8s combat") || line.equals("Doit \u00eatre shiny") || line.equals("Doit \u00eatre m\u00e2le") || line.equals("Doit \u00eatre femelle") || line.equals("Stats sp\u00e9cifiques")) {
            context.method_51433(this.field_22793, "  \u00a77" + line, zoneX + 5, currentY, 0xAAAAAA, false);
            return currentY + 10;
        }
        if (line.startsWith("MOONPHASE:")) {
            String phase = line.substring(10);
            Object phaseText = phase.replace("_", " ").toLowerCase();
            phaseText = ((String)phaseText).substring(0, 1).toUpperCase() + ((String)phaseText).substring(1);
            context.method_51433(this.field_22793, "  \u00a77Phase lunaire: \u00a7d" + (String)phaseText, zoneX + 5, currentY, 0xAAAAAA, false);
            return currentY + 10;
        }
        if (line.startsWith("TIME:")) {
            String time = line.substring(5);
            Object timeText = time.replace("_", " ").toLowerCase();
            timeText = ((String)timeText).substring(0, 1).toUpperCase() + ((String)timeText).substring(1);
            context.method_51433(this.field_22793, "  \u00a77Heure: \u00a7e" + (String)timeText, zoneX + 5, currentY, 0xAAAAAA, false);
            return currentY + 10;
        }
        if (line.startsWith("BIOME:") || line.startsWith("BIOME_ANTI:")) {
            boolean anti = line.startsWith("BIOME_ANTI:");
            String biomes = anti ? line.substring(11) : line.substring(6);
            String prefix = anti ? "Hors biome " : "Biome ";
            int maxWidth = 120;
            int yOffset = currentY;
            String fullText = "  \u00a77" + prefix + "\u00a7e" + biomes;
            if (this.field_22793.method_1727(fullText) <= maxWidth) {
                context.method_51433(this.field_22793, fullText, zoneX + 5, yOffset, 0xAAAAAA, false);
                return yOffset + 10;
            }
            context.method_51433(this.field_22793, "  \u00a77" + prefix, zoneX + 5, yOffset, 0xAAAAAA, false);
            yOffset += 10;
            String[] biomeList = biomes.split(", ");
            StringBuilder currentLine = new StringBuilder();
            int biomeIndex = 0;
            for (int i = 0; i < biomeList.length; ++i) {
                String color;
                String string = color = biomeIndex % 2 == 0 ? "\u00a7e" : "\u00a76";
                if (currentLine.length() == 0) {
                    currentLine = new StringBuilder("  " + color + biomeList[i]);
                } else {
                    String testLine = currentLine.toString() + ", " + color + biomeList[i];
                    if (this.field_22793.method_1727(testLine) > maxWidth) {
                        context.method_51433(this.field_22793, currentLine.toString(), zoneX + 5, yOffset, 0xAAAAAA, false);
                        yOffset += 10;
                        currentLine = new StringBuilder("  " + color + biomeList[i]);
                    } else {
                        currentLine.append(", ").append(color).append(biomeList[i]);
                    }
                }
                ++biomeIndex;
            }
            if (currentLine.length() > 0) {
                context.method_51433(this.field_22793, currentLine.toString(), zoneX + 5, yOffset, 0xAAAAAA, false);
                yOffset += 10;
            }
            return yOffset;
        }
        if (line.startsWith("BIOMTAG:") || line.startsWith("BIOMTAG_ANTI:")) {
            String biomePath;
            boolean anti = line.startsWith("BIOMTAG_ANTI:");
            String displayName = biomePath = anti ? line.substring(13) : line.substring(8);
            if (biomePath.contains("/")) {
                String[] parts2 = biomePath.split("/");
                displayName = parts2[parts2.length - 1];
            } else if (biomePath.contains(":")) {
                displayName = biomePath.substring(biomePath.lastIndexOf(":") + 1);
            }
            displayName = displayName.replace("_", " ");
            String prefix = anti ? "Hors biome " : "Biome ";
            context.method_51433(this.field_22793, "  \u00a77" + prefix + "\u00a7b" + displayName, zoneX + 5, currentY, 0xAAAAAA, false);
            return currentY + 10;
        }
        if (line.startsWith("REQ:") && (parts = line.split(":", 3)).length >= 2) {
            String reqType = parts[1];
            String data = parts.length > 2 ? parts[2] : "";
            String fullText = "  \u00a76[" + reqType + "] \u00a7e" + data;
            int maxWidth = 135;
            if (this.field_22793.method_1727(fullText) > maxWidth) {
                context.method_51433(this.field_22793, "  \u00a76[" + reqType + "]", zoneX + 5, currentY, 0xFFAA00, false);
                currentY += 10;
                if (!data.isEmpty()) {
                    String[] words = data.split(" ");
                    StringBuilder currentLine = new StringBuilder("  \u00a7e");
                    int yOffset = currentY;
                    for (String word : words) {
                        String testLine = currentLine.toString() + (currentLine.length() > 4 ? " " : "") + word;
                        if (this.field_22793.method_1727(testLine) > maxWidth && currentLine.length() > 4) {
                            context.method_51433(this.field_22793, currentLine.toString(), zoneX + 5, yOffset, 0xFFAA00, false);
                            yOffset += 10;
                            currentLine = new StringBuilder("  \u00a7e" + word);
                            continue;
                        }
                        if (currentLine.length() > 4) {
                            currentLine.append(" ");
                        }
                        currentLine.append(word);
                    }
                    if (currentLine.length() > 4) {
                        context.method_51433(this.field_22793, currentLine.toString(), zoneX + 5, yOffset, 0xFFAA00, false);
                        yOffset += 10;
                    }
                    return yOffset;
                }
                return currentY;
            }
            context.method_51433(this.field_22793, fullText, zoneX + 5, currentY, 0xFFAA00, false);
            return currentY + 10;
        }
        int maxWidth = 135;
        String displayText = "  \u00a77" + line;
        if (this.field_22793.method_1727(displayText) > maxWidth) {
            String[] words = line.split(" ");
            StringBuilder currentLine = new StringBuilder("  \u00a77");
            int yOffset = currentY;
            for (String word : words) {
                String testLine = currentLine.toString() + (currentLine.length() > 4 ? " " : "") + word;
                if (this.field_22793.method_1727(testLine) > maxWidth && currentLine.length() > 4) {
                    context.method_51433(this.field_22793, currentLine.toString(), zoneX + 5, yOffset, 0xAAAAAA, false);
                    yOffset += 10;
                    currentLine = new StringBuilder("  \u00a77" + word);
                    continue;
                }
                if (currentLine.length() > 4) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
            }
            if (currentLine.length() > 4) {
                context.method_51433(this.field_22793, currentLine.toString(), zoneX + 5, yOffset, 0xAAAAAA, false);
                yOffset += 10;
            }
            return yOffset;
        }
        context.method_51433(this.field_22793, "  \u00a77" + line, zoneX + 5, currentY, 0xAAAAAA, false);
        return currentY + 10;
    }

    private int renderDropsTab(class_332 context, int zoneX, int currentY, int zoneWidth, int contentStartY, int availableHeight, int mouseX, int mouseY) {
        currentY += 3;
        this.hoveredItemStack = null;
        List<PokemonSpawnData.DropData> drops = this.currentPokemon.spawnData.getDrops();
        if (drops.isEmpty()) {
            context.method_51433(this.field_22793, "Aucun drop", zoneX + 5, currentY, 0x888888, false);
            return currentY + 10;
        }
        for (PokemonSpawnData.DropData drop : drops) {
            if (currentY >= contentStartY && currentY <= contentStartY + availableHeight) {
                try {
                    class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)drop.getItemId()));
                    if (item == null || item == class_1802.field_8162) continue;
                    class_1799 stack = new class_1799((class_1935)item);
                    int itemX = zoneX + 5;
                    int itemY = currentY - 3;
                    context.method_51427(stack, itemX, itemY);
                    if (mouseX >= itemX && mouseX <= itemX + 16 && mouseY >= itemY && mouseY <= itemY + 16) {
                        this.hoveredItemStack = stack;
                    }
                    String quantityText = drop.getMinQuantity() == drop.getMaxQuantity() ? "x" + drop.getMinQuantity() : "x" + drop.getMinQuantity() + "-" + drop.getMaxQuantity();
                    String percentText = String.format("%.1f%%", drop.getPercentage());
                    context.method_51433(this.field_22793, quantityText, zoneX + 25, currentY, 0xFFFFFF, false);
                    int afterQuantity = zoneX + 25 + this.field_22793.method_1727(quantityText) + 3;
                    context.method_51433(this.field_22793, "\u00a77(" + percentText + ")", afterQuantity, currentY, 0xAAAAAA, false);
                    if (!drop.getSource().isEmpty()) {
                        int afterPercent = afterQuantity + this.field_22793.method_1727("(" + percentText + ")") + 3;
                        String sourceColor = switch (drop.getSource()) {
                            case "Kill" -> "\u00a7c";
                            case "Capture" -> "\u00a7a";
                            case "Nether" -> "\u00a7c";
                            case "End" -> "\u00a75";
                            case "Overworld" -> "\u00a7a";
                            default -> "\u00a77";
                        };
                        context.method_51433(this.field_22793, sourceColor + drop.getSource(), afterPercent, currentY, 0xFFFFFF, false);
                    }
                    currentY += 18;
                }
                catch (Exception e) {
                    context.method_51433(this.field_22793, "\u00a7c" + drop.getItemId(), zoneX + 5, currentY, 0xFF5555, false);
                    currentY += 18;
                }
                continue;
            }
            currentY += 18;
        }
        return currentY;
    }

    private int renderMovesTab(class_332 context, int zoneX, int currentY, int zoneWidth, int contentStartY, int availableHeight, int mouseX, int mouseY) {
        int color;
        boolean isHovered;
        int textWidth;
        String translatedName;
        currentY += 3;
        this.hoveredMove = null;
        List<PokemonSpawnData.MoveData> allMoves = this.currentPokemon.spawnData.getMoves();
        if (allMoves.isEmpty()) {
            context.method_51433(this.field_22793, "Aucune attaque", zoneX + 5, currentY, 0x888888, false);
            return currentY + 10;
        }
        ArrayList<PokemonSpawnData.MoveData> levelMoves = new ArrayList<PokemonSpawnData.MoveData>();
        ArrayList<PokemonSpawnData.MoveData> tmMoves = new ArrayList<PokemonSpawnData.MoveData>();
        ArrayList<PokemonSpawnData.MoveData> eggMoves = new ArrayList<PokemonSpawnData.MoveData>();
        for (PokemonSpawnData.MoveData move : allMoves) {
            switch (move.getLearnMethod()) {
                case "level": {
                    levelMoves.add(move);
                    break;
                }
                case "tm": {
                    tmMoves.add(move);
                    break;
                }
                case "egg": {
                    eggMoves.add(move);
                }
            }
        }
        levelMoves.sort((a, b) -> Integer.compare(a.getLevel(), b.getLevel()));
        if (!levelMoves.isEmpty()) {
            context.method_25294(zoneX + 3, currentY, zoneX + 5, currentY + 10, -16733441);
            context.method_51433(this.field_22793, "Par niveau:", zoneX + 7, currentY, 0xFFFFFF, false);
            currentY += 12;
            for (PokemonSpawnData.MoveData move : levelMoves) {
                if (currentY >= contentStartY && currentY <= contentStartY + availableHeight) {
                    translatedName = this.getTranslatedMoveName(move.getName());
                    String displayText = "Niv." + move.getLevel() + " - " + translatedName;
                    textWidth = this.field_22793.method_1727(displayText);
                    isHovered = mouseX >= zoneX + 5 && mouseX <= zoneX + 5 + textWidth && mouseY >= currentY && mouseY <= currentY + 10 && mouseY >= contentStartY && mouseY <= contentStartY + availableHeight;
                    color = isHovered ? 0xFFFF00 : 0xCCCCCC;
                    context.method_51433(this.field_22793, displayText, zoneX + 5, currentY, color, false);
                    if (isHovered) {
                        this.hoveredMove = move;
                    }
                }
                currentY += 10;
            }
            currentY += 3;
        }
        if (!tmMoves.isEmpty()) {
            context.method_25294(zoneX + 3, currentY, zoneX + 5, currentY + 10, -16733441);
            context.method_51433(this.field_22793, "CT/CS:", zoneX + 7, currentY, 0xFFFFFF, false);
            currentY += 12;
            for (PokemonSpawnData.MoveData move : tmMoves) {
                if (currentY >= contentStartY && currentY <= contentStartY + availableHeight) {
                    translatedName = this.getTranslatedMoveName(move.getName());
                    String displayText = "\u2022 " + translatedName;
                    textWidth = this.field_22793.method_1727(displayText);
                    isHovered = mouseX >= zoneX + 5 && mouseX <= zoneX + 5 + textWidth && mouseY >= currentY && mouseY <= currentY + 10 && mouseY >= contentStartY && mouseY <= contentStartY + availableHeight;
                    color = isHovered ? 0xFFFF00 : 0xCCCCCC;
                    context.method_51433(this.field_22793, displayText, zoneX + 5, currentY, color, false);
                    if (isHovered) {
                        this.hoveredMove = move;
                    }
                }
                currentY += 10;
            }
            currentY += 3;
        }
        if (!eggMoves.isEmpty()) {
            context.method_25294(zoneX + 3, currentY, zoneX + 5, currentY + 10, -16733441);
            context.method_51433(this.field_22793, "\u0152uf:", zoneX + 7, currentY, 0xFFFFFF, false);
            currentY += 12;
            for (PokemonSpawnData.MoveData move : eggMoves) {
                if (currentY >= contentStartY && currentY <= contentStartY + availableHeight) {
                    translatedName = this.getTranslatedMoveName(move.getName());
                    String displayText = "\u2022 " + translatedName;
                    textWidth = this.field_22793.method_1727(displayText);
                    isHovered = mouseX >= zoneX + 5 && mouseX <= zoneX + 5 + textWidth && mouseY >= currentY && mouseY <= currentY + 10 && mouseY >= contentStartY && mouseY <= contentStartY + availableHeight;
                    color = isHovered ? 0xFFFF00 : 0xCCCCCC;
                    context.method_51433(this.field_22793, displayText, zoneX + 5, currentY, color, false);
                    if (isHovered) {
                        this.hoveredMove = move;
                    }
                }
                currentY += 10;
            }
            currentY += 3;
        }
        return currentY;
    }

    private void renderInfoScrollbar(class_332 context, int x, int y, int height, int contentHeight) {
        int barWidth = 3;
        int maxScroll = Math.max(0, contentHeight - height);
        int barHeight = Math.max(20, (int)((float)height / (float)contentHeight * (float)height));
        int barY = y + (maxScroll > 0 ? (int)((float)this.infoContentScroll / (float)maxScroll * (float)(height - barHeight)) : 0);
        context.method_25294(x, y, x + barWidth, y + height, 0x40FFFFFF);
        int barColor = this.draggingInfoScrollbar ? -256 : -1;
        context.method_25294(x, barY, x + barWidth, barY + barHeight, barColor);
    }

    private List<EvolutionInfo> getEvolutions() {
        ArrayList<EvolutionInfo> evolutions = new ArrayList<EvolutionInfo>();
        if (this.currentPokemon == null || this.currentPokemon.spawnData == null) {
            return evolutions;
        }
        for (PokemonSpawnData.EvolutionData evolutionData : this.currentPokemon.spawnData.getEvolutions()) {
            Object translatedName = this.getTranslatedSpeciesName(evolutionData.getEvolvedSpecies());
            String formName = evolutionData.getEvolvedForm();
            if (formName != null && !formName.isEmpty() && !formName.equalsIgnoreCase("normal")) {
                Object formDisplay = formName.substring(0, 1).toUpperCase() + formName.substring(1).toLowerCase();
                if (((String)formDisplay).contains("Alola")) {
                    formDisplay = "Alola";
                } else if (((String)formDisplay).contains("Galar")) {
                    formDisplay = "Galar";
                } else if (((String)formDisplay).contains("Hisui")) {
                    formDisplay = "Hisui";
                } else if (((String)formDisplay).contains("Paldea")) {
                    formDisplay = "Paldea";
                }
                translatedName = (String)translatedName + " (" + (String)formDisplay + ")";
            }
            evolutions.add(new EvolutionInfo((String)translatedName, evolutionData.getCondition()));
        }
        return evolutions;
    }

    private String getTranslatedSpeciesName(String speciesName) {
        try {
            String translationKey = "cobblemon.species." + speciesName.toLowerCase() + ".name";
            String translated = class_2561.method_43471((String)translationKey).getString();
            if (!translated.equals(translationKey)) {
                return translated;
            }
            return speciesName.substring(0, 1).toUpperCase() + speciesName.substring(1).toLowerCase();
        }
        catch (Exception e) {
            return speciesName;
        }
    }

    private void renderModel(class_332 context, PokeWikiScreen.PokemonEntry entry, int x, int y, int width, int height, float scale, int mouseX, int mouseY, float delta) {
        String cacheKey = entry.getCacheKey();
        RenderablePokemon renderable = this.renderableCache.get(cacheKey);
        if (renderable == null) {
            context.method_25294(x + 5, y + 5, x + width - 5, y + height - 5, 0x40FF0000);
            return;
        }
        String widgetKey = cacheKey + "_" + x + "_" + y + "_" + width + "_" + height;
        ModelWidget widget = this.modelWidgetCache.get(widgetKey);
        if (widget == null) {
            widget = new ModelWidget(x, y, width, height, renderable, scale, 25.0f, 0.0, false, false);
            this.modelWidgetCache.put(widgetKey, widget);
        }
        widget.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.searchField.method_25370() || mouseX >= (double)this.searchField.method_46426() && mouseX <= (double)(this.searchField.method_46426() + this.searchField.method_25368()) && mouseY >= (double)this.searchField.method_46427() && mouseY <= (double)(this.searchField.method_46427() + 20)) {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new PokeWikiScreen());
            }
            return true;
        }
        if (button == 0) {
            int zoneX = this.guiLeft + 40 + 27 + 150;
            int zoneY = this.guiTop + 40;
            int zoneWidth = 150;
            int tabsY = zoneY + 5;
            int tabsX = zoneX + zoneWidth - 12 - 5;
            for (int i = 0; i < 4; ++i) {
                InfoTab tab = InfoTab.values()[i];
                int currentTabY = tabsY + i * 14;
                if (!(mouseX >= (double)tabsX) || !(mouseX < (double)(tabsX + 12)) || !(mouseY >= (double)currentTabY) || !(mouseY < (double)(currentTabY + 12))) continue;
                this.selectedTab = tab;
                this.infoContentScroll = 0;
                return true;
            }
            int scrollbarX = this.guiLeft + 16;
            int listY = this.guiTop + 15;
            int listHeight = 200;
            int maxScroll = Math.max(0, this.allPokemon.size() - 5);
            if (maxScroll > 0) {
                int barWidth = 8;
                int visibleEntries = listHeight / 40;
                int totalEntries = this.allPokemon.size();
                int barHeight = Math.max(20, (int)((float)visibleEntries / (float)totalEntries * (float)listHeight));
                int barY = listY + (int)((float)this.leftListScroll / (float)maxScroll * (float)(listHeight - barHeight));
                if (mouseX >= (double)(scrollbarX - 2) && mouseX <= (double)(scrollbarX + barWidth) && mouseY >= (double)barY && mouseY <= (double)(barY + barHeight)) {
                    this.draggingLeftScrollbar = true;
                    this.dragStartY = (int)mouseY;
                    this.dragStartScroll = this.leftListScroll;
                    return true;
                }
            }
            zoneX = this.guiLeft + 40 + 27;
            zoneY = this.guiTop + 40;
            zoneWidth = 145;
            int zoneHeight = 175;
            int contentStartY = zoneY + 19;
            int availableHeight = zoneHeight - 19;
            int totalContentHeight = this.calculateTotalContentHeight(zoneWidth);
            if (totalContentHeight > availableHeight) {
                int scrollbarBiomeX = zoneX + zoneWidth - 2;
                int maxBiomeScroll = Math.max(0, totalContentHeight - availableHeight);
                if (maxBiomeScroll > 0) {
                    int barWidth = 8;
                    int barHeight = Math.max(20, (int)((float)availableHeight / (float)totalContentHeight * (float)availableHeight));
                    int barY = contentStartY + (int)((float)this.biomeZoneScroll / (float)maxBiomeScroll * (float)(availableHeight - barHeight));
                    if (mouseX >= (double)(scrollbarBiomeX - 2) && mouseX <= (double)(scrollbarBiomeX + barWidth) && mouseY >= (double)barY && mouseY <= (double)(barY + barHeight)) {
                        this.draggingBiomeScrollbar = true;
                        this.dragStartY = (int)mouseY;
                        this.dragStartScroll = this.biomeZoneScroll;
                        return true;
                    }
                }
            }
            zoneX = this.guiLeft + 40 + 27 + 150;
            zoneY = this.guiTop + 40;
            zoneWidth = 150;
            int infoContentY = zoneY + 5 + 18 + 12;
            int infoContentHeight = zoneHeight - (infoContentY - zoneY);
            int totalInfoHeight = this.calculateTabContentHeight();
            if (this.selectedTab != InfoTab.INFO && totalInfoHeight > infoContentHeight - 5) {
                int infoScrollbarX = zoneX + zoneWidth - 4;
                int maxInfoScroll = Math.max(0, totalInfoHeight - (infoContentHeight - 5));
                if (maxInfoScroll > 0) {
                    int barWidth = 8;
                    int barHeight = Math.max(20, (int)((float)(infoContentHeight - 5) / (float)totalInfoHeight * (float)(infoContentHeight - 5)));
                    int barY = infoContentY + (int)((float)this.infoContentScroll / (float)maxInfoScroll * (float)(infoContentHeight - 5 - barHeight));
                    if (mouseX >= (double)(infoScrollbarX - 2) && mouseX <= (double)(infoScrollbarX + barWidth) && mouseY >= (double)barY && mouseY <= (double)(barY + barHeight)) {
                        this.draggingInfoScrollbar = true;
                        this.dragStartY = (int)mouseY;
                        this.dragStartScroll = this.infoContentScroll;
                        return true;
                    }
                }
            }
            for (Map.Entry<String, int[]> entry : this.biomeClickZones.entrySet()) {
                int[] r = entry.getValue();
                if (!(mouseX >= (double)r[0]) || !(mouseX <= (double)r[2]) || !(mouseY >= (double)r[1]) || !(mouseY <= (double)r[3])) continue;
                String category = entry.getKey();
                this.selectedBiomeCategory = category.equals(this.selectedBiomeCategory) ? null : category;
                this.biomeZoneScroll = 0;
                return true;
            }
            int listX = this.guiLeft + 22;
            listY = this.guiTop + 15;
            listHeight = 200;
            if (mouseX >= (double)listX && mouseX < (double)(listX + 40) && mouseY >= (double)listY && mouseY < (double)(listY + listHeight)) {
                for (int i = 0; i < this.allPokemon.size(); ++i) {
                    int y = listY + i * 40 - this.leftListScroll * 40;
                    if (y + 40 < listY || y > listY + listHeight || !(mouseY >= (double)y) || !(mouseY < (double)(y + 40))) continue;
                    PokeWikiScreen.PokemonEntry clicked = this.allPokemon.get(i);
                    if (this.field_22787 != null) {
                        this.field_22787.method_1507((class_437)new PokemonDetailScreen(clicked, this.allPokemon));
                    }
                    return true;
                }
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int listX = this.guiLeft + 22;
        int listY = this.guiTop + 15;
        int listHeight = 200;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + 40) && mouseY >= (double)listY && mouseY <= (double)(listY + listHeight)) {
            int maxScroll = Math.max(0, this.allPokemon.size() - 5);
            if (verticalAmount > 0.0) {
                this.leftListScroll = Math.max(0, this.leftListScroll - 1);
            } else if (verticalAmount < 0.0) {
                this.leftListScroll = Math.min(maxScroll, this.leftListScroll + 1);
            }
            return true;
        }
        int zoneX = this.guiLeft + 40 + 27;
        int zoneY = this.guiTop + 40;
        int zoneWidth = 145;
        int zoneHeight = 175;
        if (mouseX >= (double)zoneX && mouseX <= (double)(zoneX + zoneWidth) && mouseY >= (double)zoneY && mouseY <= (double)(zoneY + zoneHeight)) {
            int totalContentHeight = this.calculateTotalContentHeight(zoneWidth);
            int availableHeight = zoneHeight - 19;
            int maxScroll = Math.max(0, totalContentHeight - availableHeight);
            if (verticalAmount > 0.0) {
                this.biomeZoneScroll = Math.max(0, this.biomeZoneScroll - 5);
            } else if (verticalAmount < 0.0) {
                this.biomeZoneScroll = Math.min(maxScroll, this.biomeZoneScroll + 5);
            }
            return true;
        }
        zoneX = this.guiLeft + 40 + 27 + 150;
        zoneY = this.guiTop + 40;
        zoneWidth = 150;
        zoneHeight = 175;
        if (mouseX >= (double)zoneX && mouseX <= (double)(zoneX + zoneWidth) && mouseY >= (double)zoneY && mouseY <= (double)(zoneY + zoneHeight)) {
            if (this.selectedTab == InfoTab.INFO) {
                return false;
            }
            int infoContentY = zoneY + 5 + 18 + 12;
            int infoContentHeight = zoneHeight - (infoContentY - zoneY);
            int totalInfoHeight = this.calculateTabContentHeight();
            int maxScroll = Math.max(0, totalInfoHeight - (infoContentHeight - 5));
            if (verticalAmount > 0.0) {
                this.infoContentScroll = Math.max(0, this.infoContentScroll - 5);
            } else if (verticalAmount < 0.0) {
                this.infoContentScroll = Math.min(maxScroll, this.infoContentScroll + 5);
            }
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.draggingLeftScrollbar = false;
            this.draggingBiomeScrollbar = false;
            this.draggingInfoScrollbar = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0 && this.draggingLeftScrollbar) {
            int listY = this.guiTop + 15;
            int listHeight = 200;
            int maxScroll = Math.max(0, this.allPokemon.size() - 5);
            int visibleEntries = listHeight / 40;
            int totalEntries = this.allPokemon.size();
            int barHeight = Math.max(20, (int)((float)visibleEntries / (float)totalEntries * (float)listHeight));
            int mouseDelta = (int)mouseY - this.dragStartY;
            int scrollableHeight = listHeight - barHeight;
            if (scrollableHeight > 0) {
                int scrollDelta = (int)((float)mouseDelta / (float)scrollableHeight * (float)maxScroll);
                this.leftListScroll = Math.max(0, Math.min(maxScroll, this.dragStartScroll + scrollDelta));
            }
            return true;
        }
        if (button == 0 && this.draggingBiomeScrollbar) {
            int zoneWidth = 145;
            int zoneHeight = 175;
            int totalContentHeight = this.calculateTotalContentHeight(zoneWidth);
            int availableHeight = zoneHeight - 19;
            int maxScroll = Math.max(0, totalContentHeight - availableHeight);
            int barHeight = Math.max(20, (int)((float)availableHeight / (float)totalContentHeight * (float)availableHeight));
            int mouseDelta = (int)mouseY - this.dragStartY;
            int scrollableHeight = availableHeight - barHeight;
            if (scrollableHeight > 0) {
                int scrollDelta = (int)((float)mouseDelta / (float)scrollableHeight * (float)maxScroll);
                this.biomeZoneScroll = Math.max(0, Math.min(maxScroll, this.dragStartScroll + scrollDelta));
            }
            return true;
        }
        if (button == 0 && this.draggingInfoScrollbar) {
            int zoneY = this.guiTop + 40;
            int zoneHeight = 175;
            int infoContentY = zoneY + 5 + 18 + 12;
            int infoContentHeight = zoneHeight - (infoContentY - zoneY);
            int totalInfoHeight = this.calculateTabContentHeight();
            int maxScroll = Math.max(0, totalInfoHeight - (infoContentHeight - 5));
            int barHeight = Math.max(20, (int)((float)(infoContentHeight - 5) / (float)totalInfoHeight * (float)(infoContentHeight - 5)));
            int mouseDelta = (int)mouseY - this.dragStartY;
            int scrollableHeight = infoContentHeight - 5 - barHeight;
            if (scrollableHeight > 0) {
                int scrollDelta = (int)((float)mouseDelta / (float)scrollableHeight * (float)maxScroll);
                this.infoContentScroll = Math.max(0, Math.min(maxScroll, this.dragStartScroll + scrollDelta));
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.searchField.method_25400(chr, modifiers)) {
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256) {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new PokeWikiScreen());
            }
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private String getTranslatedMoveName(String moveName) {
        String moveKey = "cobblemon.move." + moveName.toLowerCase();
        String translated = class_2561.method_43471((String)moveKey).getString();
        if (translated.equals(moveKey)) {
            return moveName;
        }
        return translated;
    }

    private String getMoveDescription(String moveName) {
        String descKey = "cobblemon.move." + moveName.toLowerCase() + ".desc";
        String description = class_2561.method_43471((String)descKey).getString();
        if (description.equals(descKey)) {
            return "Aucune description disponible";
        }
        return description;
    }

    private String getTypeColor(String type) {
        return switch (type.toLowerCase()) {
            case "normal" -> "\u00a77";
            case "fire" -> "\u00a7c";
            case "water" -> "\u00a79";
            case "electric" -> "\u00a7e";
            case "grass" -> "\u00a7a";
            case "ice" -> "\u00a7b";
            case "fighting" -> "\u00a76";
            case "poison" -> "\u00a75";
            case "ground" -> "\u00a76";
            case "flying" -> "\u00a7b";
            case "psychic" -> "\u00a7d";
            case "bug" -> "\u00a7a";
            case "rock" -> "\u00a76";
            case "ghost" -> "\u00a75";
            case "dragon" -> "\u00a75";
            case "dark" -> "\u00a78";
            case "steel" -> "\u00a77";
            case "fairy" -> "\u00a7d";
            default -> "\u00a7f";
        };
    }

    public boolean method_25421() {
        return false;
    }

    private static enum InfoTab {
        INFO,
        EVOLUTIONS,
        DROPS,
        MOVES;

    }

    private static class EvolutionInfo {
        String name;
        String condition;

        EvolutionInfo(String name, String condition) {
            this.name = name;
            this.condition = condition;
        }
    }
}

