/*
 * Decompiled with CFR 0.152.
 */
package com.cupokewiki.gui;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.client.gui.summary.widgets.ModelWidget;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.RenderablePokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cupokewiki.CUPokeWiki;
import com.cupokewiki.data.PokemonSpawnData;
import com.cupokewiki.data.SpawnDataCache;
import com.cupokewiki.gui.PokemonDetailScreen;
import com.cupokewiki.util.DexHelper;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class PokeWikiScreen
extends class_437 {
    private static final class_2960 GUI_TEXTURE = class_2960.method_60655((String)"cupokewiki", (String)"textures/gui/cupokewikigui.png");
    private static final class_2960 CAUGHT_ICON = class_2960.method_60655((String)"cupokewiki", (String)"textures/gui/caught_icon.png");
    private static final int GUI_WIDTH = 390;
    private static final int GUI_HEIGHT = 230;
    private int guiLeft;
    private int guiTop;
    private class_342 searchField;
    private static List<PokemonEntry> cachedAllPokemon = null;
    private List<PokemonEntry> allPokemon;
    private int leftListScroll = 0;
    private static final int LEFT_LIST_WIDTH = 40;
    private static final int LEFT_LIST_ENTRIES = 5;
    private static final int ENTRY_HEIGHT = 40;
    private List<PokemonEntry> searchResults;
    private Map<String, RenderablePokemon> renderableCache;
    private int gridScrollOffset = 0;
    private static final int GRID_COLUMNS = 4;
    private static final int CELL_SIZE = 70;
    private int hoveredIndex = -1;
    private boolean hoveringLeftList = false;
    private final Map<String, ModelWidget> modelWidgetCache = new HashMap<String, ModelWidget>();
    private boolean draggingLeftScrollbar = false;
    private boolean draggingGridScrollbar = false;
    private int dragStartY = 0;
    private int dragStartScroll = 0;

    public PokeWikiScreen() {
        super((class_2561)class_2561.method_43470((String)"Pok\u00e9Wiki"));
        this.searchResults = new ArrayList<PokemonEntry>();
        this.renderableCache = new HashMap<String, RenderablePokemon>();
        if (cachedAllPokemon == null) {
            this.allPokemon = new ArrayList<PokemonEntry>();
            this.loadAllPokemon();
            cachedAllPokemon = new ArrayList<PokemonEntry>(this.allPokemon);
        } else {
            this.allPokemon = new ArrayList<PokemonEntry>(cachedAllPokemon);
        }
    }

    public PokemonEntry findEntryByKey(String key) {
        String normalizedKey = key.replaceAll("[''\u02bc\u055a\u05f3`\u00b4\\u0027\\u2019\\u02BC]", "").toLowerCase();
        for (PokemonEntry entry : this.allPokemon) {
            String entryKey = entry.getCacheKey();
            String normalizedEntryKey = entryKey.replaceAll("[''\u02bc\u055a\u05f3`\u00b4\\u0027\\u2019\\u02BC]", "").toLowerCase();
            if (!normalizedEntryKey.equals(normalizedKey)) continue;
            return entry;
        }
        return null;
    }

    public List<PokemonEntry> getAllPokemonEntries() {
        return new ArrayList<PokemonEntry>(this.allPokemon);
    }

    public static void clearCache() {
        cachedAllPokemon = null;
    }

    private static String normalizeForIdentifier(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        return name.toLowerCase().replace(" ", "_").replace("'", "").replace("'", "").replace("\u00e2\u20ac\u2122", "").replace(".", "").trim();
    }

    private void loadAllPokemon() {
        Map<String, PokemonSpawnData> spawnDataMap = SpawnDataCache.getAllPokemonSorted().stream().collect(Collectors.toMap(data -> {
            if (data.getForm() == null || data.getForm().isEmpty() || data.getForm().equalsIgnoreCase("normal")) {
                return data.getSpecies().toLowerCase();
            }
            return (data.getSpecies() + "_" + data.getForm()).toLowerCase();
        }, data -> data, (a, b) -> a));
        for (PokemonSpawnData spawnData : spawnDataMap.values()) {
            try {
                List forms;
                String normalizedName = PokeWikiScreen.normalizeForIdentifier(spawnData.getSpecies());
                Species species = PokemonSpecies.getByName((String)normalizedName);
                if (species == null) continue;
                HashSet<String> formAspects = new HashSet<String>();
                if (spawnData.getForm() != null && !spawnData.getForm().isEmpty() && !spawnData.getForm().equalsIgnoreCase("normal") && (forms = species.getForms()) != null) {
                    for (FormData form : forms) {
                        if (form.getName() == null || !form.getName().equalsIgnoreCase(spawnData.getForm())) continue;
                        formAspects.addAll(form.getAspects());
                        break;
                    }
                }
                this.allPokemon.add(new PokemonEntry(species, spawnData.getForm(), formAspects, spawnData));
            }
            catch (Exception e2) {
                CUPokeWiki.LOGGER.error("Failed to load pokemon entry for {}", (Object)spawnData.getSpecies(), (Object)e2);
            }
        }
        this.allPokemon.sort(Comparator.comparingInt(e -> e.dexNumber).thenComparing(e -> e.formName != null ? e.formName : ""));
    }

    protected void method_25426() {
        super.method_25426();
        this.guiLeft = (this.field_22789 - 390) / 2;
        this.guiTop = (this.field_22790 - 230) / 2;
        this.searchField = new class_342(this.field_22793, this.guiLeft + 40 + 27, this.guiTop + 15, 295, 20, (class_2561)class_2561.method_43470((String)"Rechercher..."));
        this.searchField.method_1880(32);
        this.searchField.method_47404((class_2561)class_2561.method_43471((String)"gui.cupokewiki.search.placeholder"));
        this.searchField.method_1863(this::onSearchChanged);
        this.searchField.method_1858(true);
        this.method_25429((class_364)this.searchField);
        this.method_48265((class_364)this.searchField);
        this.prepareRenderables();
    }

    private void prepareRenderables() {
        this.renderableCache.clear();
        for (PokemonEntry entry : this.allPokemon) {
            this.createRenderable(entry);
        }
    }

    private boolean createRenderable(PokemonEntry entry) {
        try {
            String cacheKey = entry.getCacheKey();
            if (this.renderableCache.containsKey(cacheKey)) {
                return true;
            }
            HashSet<String> aspects = new HashSet<String>(entry.formAspects);
            RenderablePokemon renderable = new RenderablePokemon(entry.species, aspects, class_1799.field_8037);
            this.renderableCache.put(cacheKey, renderable);
            return true;
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Failed to create renderable for {}: {}", (Object)entry.getFullName(), (Object)e.getMessage());
            return false;
        }
    }

    private String removeAccents(String text) {
        if (text == null) {
            return "";
        }
        String normalized = Normalizer.normalize(text, Normalizer.Form.NFD);
        return normalized.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
    }

    private String getTranslatedName(PokemonEntry entry) {
        try {
            String translatedName = entry.species.getTranslatedName().getString();
            if (entry.formName != null && !entry.formName.isEmpty() && !entry.formName.equalsIgnoreCase("normal")) {
                Object formDisplayName = entry.formName;
                formDisplayName = ((String)formDisplayName).equalsIgnoreCase("alola") || ((String)formDisplayName).equalsIgnoreCase("alolan") ? "Alola" : (((String)formDisplayName).equalsIgnoreCase("galar") || ((String)formDisplayName).equalsIgnoreCase("galarian") ? "Galar" : (((String)formDisplayName).equalsIgnoreCase("hisui") || ((String)formDisplayName).equalsIgnoreCase("hisuian") ? "Hisui" : (((String)formDisplayName).equalsIgnoreCase("paldea") || ((String)formDisplayName).equalsIgnoreCase("paldean") ? "Paldea" : (((String)formDisplayName).toLowerCase().startsWith("mega") ? "Mega" + (((String)formDisplayName).length() > 4 ? ((String)formDisplayName).substring(4) : "") : (((String)formDisplayName).equalsIgnoreCase("gmax") || ((String)formDisplayName).equalsIgnoreCase("gigantamax") ? "Gigamax" : ((String)formDisplayName).substring(0, 1).toUpperCase() + ((String)formDisplayName).substring(1))))));
                return translatedName + " " + (String)formDisplayName;
            }
            return translatedName;
        }
        catch (Exception e) {
            return entry.getFullName();
        }
    }

    private void onSearchChanged(String query) {
        this.searchResults.clear();
        this.gridScrollOffset = 0;
        if (!query.isEmpty()) {
            String normalized = this.removeAccents(query.toLowerCase().trim());
            for (PokemonEntry entry : this.allPokemon) {
                boolean match;
                String englishName = this.removeAccents(entry.getFullName().toLowerCase());
                String translatedName = this.removeAccents(this.getTranslatedName(entry).toLowerCase());
                boolean bl = match = englishName.contains(normalized) || translatedName.contains(normalized);
                if (!match && entry.spawnData != null) {
                    if (entry.spawnData.getTranslatedNameFr() != null) {
                        String frName = this.removeAccents(entry.spawnData.getTranslatedNameFr().toLowerCase());
                        match = frName.contains(normalized);
                    }
                    if (!match && entry.spawnData.getTranslatedNameEn() != null) {
                        String enName = this.removeAccents(entry.spawnData.getTranslatedNameEn().toLowerCase());
                        match = enName.contains(normalized);
                    }
                }
                if (!match) continue;
                this.searchResults.add(entry);
                this.createRenderable(entry);
            }
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        try {
            context.method_25290(GUI_TEXTURE, this.guiLeft, this.guiTop, 0.0f, 0.0f, 390, 230, 390, 230);
        }
        catch (Exception e) {
            context.method_25294(this.guiLeft, this.guiTop, this.guiLeft + 390, this.guiTop + 230, -13948117);
        }
        this.renderLeftList(context, mouseX, mouseY, delta);
        this.searchField.method_25394(context, mouseX, mouseY, delta);
        if (!this.searchResults.isEmpty()) {
            this.renderSearchGrid(context, mouseX, mouseY, delta);
        } else if (this.searchField.method_1882().isEmpty()) {
            this.renderWelcomeMessage(context);
        } else {
            this.renderNoResults(context);
        }
        if (this.hoveringLeftList && this.hoveredIndex >= 0 && this.hoveredIndex < this.allPokemon.size()) {
            PokemonEntry hovered = this.allPokemon.get(this.hoveredIndex);
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)("#" + hovered.dexNumber + " - " + this.getTranslatedName(hovered))), mouseX, mouseY);
        } else if (!this.hoveringLeftList && this.hoveredIndex >= 0 && this.hoveredIndex < this.searchResults.size()) {
            PokemonEntry hovered = this.searchResults.get(this.hoveredIndex);
            context.method_51438(this.field_22793, (class_2561)class_2561.method_43470((String)this.getTranslatedName(hovered)), mouseX, mouseY);
        }
    }

    private void renderLeftList(class_332 context, int mouseX, int mouseY, float delta) {
        this.hoveredIndex = -1;
        this.hoveringLeftList = false;
        int scrollbarX = this.guiLeft + 18;
        int listX = this.guiLeft + 22;
        int listY = this.guiTop + 15;
        int listHeight = 200;
        int maxScroll = Math.max(0, this.allPokemon.size() - 5);
        if (maxScroll > 0) {
            this.renderScrollbar(context, scrollbarX, listY, listHeight, this.leftListScroll, maxScroll, true);
        }
        context.method_44379(listX, listY, listX + 40, listY + listHeight);
        for (int i = 0; i < this.allPokemon.size(); ++i) {
            boolean isHovered;
            int y = listY + i * 40 - this.leftListScroll * 40;
            if (y + 40 < listY || y > listY + listHeight) continue;
            PokemonEntry entry = this.allPokemon.get(i);
            boolean bl = isHovered = mouseX >= listX && mouseX < listX + 40 && mouseY >= y && mouseY < y + 40 && mouseY >= listY && mouseY < listY + listHeight;
            if (isHovered) {
                context.method_25294(listX, y, listX + 40, y + 40, -2130706433);
                this.hoveredIndex = i;
                this.hoveringLeftList = true;
            }
            this.renderModel(context, entry, listX, y, 40, 40, 1.0f, mouseX, mouseY, delta);
            if (!entry.isCaught()) continue;
            try {
                int iconSize = 10;
                int iconX = listX + 40 - iconSize - 2;
                int iconY = y + 2;
                context.method_25290(CAUGHT_ICON, iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
                continue;
            }
            catch (Exception e) {
                CUPokeWiki.LOGGER.warn("Failed to render caught icon for {}", (Object)entry.getFullName());
            }
        }
        context.method_44380();
    }

    private void renderSearchGrid(class_332 context, int mouseX, int mouseY, float delta) {
        int gridStartX = this.guiLeft + 40 + 27;
        int gridStartY = this.guiTop + 45;
        int gridWidth = 305;
        int gridHeight = 170;
        int cols = gridWidth / 70;
        context.method_44379(gridStartX, gridStartY, gridStartX + gridWidth, gridStartY + gridHeight);
        for (int i = 0; i < this.searchResults.size(); ++i) {
            boolean isHovered;
            int row = i / cols;
            int col = i % cols;
            int x = gridStartX + col * 70;
            int y = gridStartY + row * 70 - this.gridScrollOffset;
            if (y + 70 < gridStartY || y > gridStartY + gridHeight) continue;
            PokemonEntry entry = this.searchResults.get(i);
            boolean bl = isHovered = mouseX >= x && mouseX < x + 70 && mouseY >= y && mouseY < y + 70 && mouseY >= gridStartY && mouseY < gridStartY + gridHeight;
            if (isHovered) {
                context.method_25294(x, y, x + 70, y + 70, -2130706433);
                this.hoveredIndex = i;
                this.hoveringLeftList = false;
            } else {
                context.method_25294(x + 2, y + 2, x + 70 - 2, y + 70 - 2, 0x40000000);
            }
            int modelX = x + 10;
            int modelY = y + 5;
            this.renderModel(context, entry, modelX, modelY, 50, 50, 1.5f, mouseX, mouseY, delta);
            String dexNum = "#" + entry.dexNumber;
            int textX = x + 35 - this.field_22793.method_1727(dexNum) / 2;
            context.method_51433(this.field_22793, dexNum, textX, y + 55, 0xFFFFFF, true);
        }
        context.method_44380();
        int rows = (int)Math.ceil((double)this.searchResults.size() / (double)cols);
        int totalContentHeight = rows * 70;
        if (totalContentHeight > gridHeight) {
            int maxScroll = totalContentHeight - gridHeight;
            this.renderScrollbar(context, gridStartX + gridWidth - 6, gridStartY, gridHeight, this.gridScrollOffset, maxScroll, false);
        }
    }

    private void renderScrollbar(class_332 context, int x, int y, int height, int currentScroll, int maxScroll, boolean isLeftList) {
        int barHeight;
        int barWidth = 3;
        if (isLeftList) {
            int visibleEntries = height / 40;
            int totalEntries = this.allPokemon.size();
            barHeight = Math.max(20, (int)((float)visibleEntries / (float)totalEntries * (float)height));
        } else {
            int gridWidth = 305;
            int cols = gridWidth / 70;
            int rows = (int)Math.ceil((double)this.searchResults.size() / (double)cols);
            int totalContentHeight = rows * 70;
            barHeight = Math.max(20, (int)((float)height / (float)totalContentHeight * (float)height));
        }
        int barY = y + (int)((float)currentScroll / (float)maxScroll * (float)(height - barHeight));
        context.method_25294(x, y, x + barWidth, y + height, 0x40FFFFFF);
        boolean isDragging = isLeftList ? this.draggingLeftScrollbar : this.draggingGridScrollbar;
        int barColor = isDragging ? -256 : -1;
        context.method_25294(x, barY, x + barWidth, barY + barHeight, barColor);
    }

    private void renderModel(class_332 context, PokemonEntry entry, int x, int y, int width, int height, float scale, int mouseX, int mouseY, float delta) {
        String cacheKey = entry.getCacheKey();
        RenderablePokemon renderable = this.renderableCache.get(cacheKey);
        if (renderable == null) {
            context.method_25294(x + 5, y + 5, x + width - 5, y + height - 5, 0x40FF0000);
            return;
        }
        String widgetKey = cacheKey + "_" + x + "_" + y + "_" + width + "_" + height;
        ModelWidget widget = this.modelWidgetCache.get(widgetKey);
        if (widget == null) {
            widget = new ModelWidget(x, y, width, height, renderable, scale, 25.0f, 0.0, false, false);
            this.modelWidgetCache.put(widgetKey, widget);
        }
        widget.method_25394(context, mouseX, mouseY, delta);
    }

    private void renderWelcomeMessage(class_332 context) {
        String message = class_2561.method_43471((String)"gui.cupokewiki.welcome.subtitle").getString();
        int textWidth = this.field_22793.method_1727(message);
        int x = this.guiLeft + 40 + (350 - textWidth) / 2 + 15;
        int y = this.guiTop + 115;
        context.method_51433(this.field_22793, message, x, y, 0, false);
    }

    private void renderNoResults(class_332 context) {
        String message = class_2561.method_43471((String)"gui.cupokewiki.no_results").getString();
        int textWidth = this.field_22793.method_1727(message);
        int x = this.guiLeft + 40 + (350 - textWidth) / 2 + 15;
        int y = this.guiTop + 115;
        context.method_51433(this.field_22793, message, x, y, 0, false);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.searchField.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0) {
            int i;
            int scrollbarLeftX = this.guiLeft + 16;
            int listY = this.guiTop + 15;
            int listHeight = 200;
            int maxScroll = Math.max(0, this.allPokemon.size() - 5);
            if (maxScroll > 0) {
                int barWidth = 8;
                int visibleEntries = listHeight / 40;
                int totalEntries = this.allPokemon.size();
                int barHeight = Math.max(20, (int)((float)visibleEntries / (float)totalEntries * (float)listHeight));
                int barY = listY + (int)((float)this.leftListScroll / (float)maxScroll * (float)(listHeight - barHeight));
                if (mouseX >= (double)(scrollbarLeftX - 5) && mouseX <= (double)(scrollbarLeftX + barWidth + 5) && mouseY >= (double)barY && mouseY <= (double)(barY + barHeight)) {
                    this.draggingLeftScrollbar = true;
                    this.dragStartY = (int)mouseY;
                    this.dragStartScroll = this.leftListScroll;
                    return true;
                }
            }
            int gridStartX = this.guiLeft + 40 + 27;
            int gridStartY = this.guiTop + 45;
            int gridWidth = 305;
            int gridHeight = 170;
            int cols = gridWidth / 70;
            int rows = (int)Math.ceil((double)this.searchResults.size() / (double)cols);
            int totalContentHeight = rows * 70;
            if (totalContentHeight > gridHeight) {
                int maxScrollGrid = totalContentHeight - gridHeight;
                int scrollbarGridX = gridStartX + gridWidth - 6;
                if (maxScrollGrid > 0) {
                    int barWidth = 3;
                    int barHeight = Math.max(20, (int)((float)gridHeight / (float)(maxScrollGrid + gridHeight) * (float)gridHeight));
                    int barY = gridStartY + (int)((float)this.gridScrollOffset / (float)maxScrollGrid * (float)(gridHeight - barHeight));
                    if (mouseX >= (double)(scrollbarGridX - 5) && mouseX <= (double)(scrollbarGridX + barWidth + 5) && mouseY >= (double)barY && mouseY <= (double)(barY + barHeight)) {
                        this.draggingGridScrollbar = true;
                        this.dragStartY = (int)mouseY;
                        this.dragStartScroll = this.gridScrollOffset;
                        return true;
                    }
                }
            }
            int listX = this.guiLeft + 22;
            listY = this.guiTop + 15;
            listHeight = 200;
            if (mouseX >= (double)listX && mouseX < (double)(listX + 40) && mouseY >= (double)listY && mouseY < (double)(listY + listHeight)) {
                for (i = 0; i < this.allPokemon.size(); ++i) {
                    int y = listY + i * 40 - this.leftListScroll * 40;
                    if (y + 40 < listY || y > listY + listHeight || !(mouseY >= (double)y) || !(mouseY < (double)(y + 40))) continue;
                    if (this.field_22787 != null) {
                        this.field_22787.method_1507((class_437)new PokemonDetailScreen(this.allPokemon.get(i), this.allPokemon));
                    }
                    return true;
                }
            }
            gridStartX = this.guiLeft + 40 + 27;
            gridStartY = this.guiTop + 45;
            gridWidth = 305;
            gridHeight = 170;
            if (!this.searchResults.isEmpty() && mouseX >= (double)gridStartX && mouseX < (double)(gridStartX + gridWidth) && mouseY >= (double)gridStartY && mouseY < (double)(gridStartY + gridHeight)) {
                for (i = 0; i < this.searchResults.size(); ++i) {
                    int row = i / cols;
                    int col = i % cols;
                    int x = gridStartX + col * 70;
                    int y = gridStartY + row * 70 - this.gridScrollOffset;
                    if (y + 70 < gridStartY || y > gridStartY + gridHeight || !(mouseX >= (double)x) || !(mouseX < (double)(x + 70)) || !(mouseY >= (double)y) || !(mouseY < (double)(y + 70))) continue;
                    if (this.field_22787 != null) {
                        this.field_22787.method_1507((class_437)new PokemonDetailScreen(this.searchResults.get(i), this.allPokemon));
                    }
                    return true;
                }
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int listX = this.guiLeft + 22;
        int listY = this.guiTop + 15;
        int listHeight = 200;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + 40) && mouseY >= (double)listY && mouseY <= (double)(listY + listHeight)) {
            int maxScroll = Math.max(0, this.allPokemon.size() - 5);
            if (verticalAmount > 0.0) {
                this.leftListScroll = Math.max(0, this.leftListScroll - 1);
            } else if (verticalAmount < 0.0) {
                this.leftListScroll = Math.min(maxScroll, this.leftListScroll + 1);
            }
            return true;
        }
        int gridStartX = this.guiLeft + 40 + 27;
        int gridStartY = this.guiTop + 45;
        int gridWidth = 305;
        int gridHeight = 170;
        if (mouseX >= (double)gridStartX && mouseX <= (double)(gridStartX + gridWidth) && mouseY >= (double)gridStartY && mouseY <= (double)(gridStartY + gridHeight)) {
            int cols = gridWidth / 70;
            int rows = (int)Math.ceil((double)this.searchResults.size() / (double)cols);
            int totalContentHeight = rows * 70;
            if (totalContentHeight > gridHeight) {
                int maxScroll = totalContentHeight - gridHeight;
                if (verticalAmount > 0.0) {
                    this.gridScrollOffset = Math.max(0, this.gridScrollOffset - 20);
                } else if (verticalAmount < 0.0) {
                    this.gridScrollOffset = Math.min(maxScroll, this.gridScrollOffset + 20);
                }
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.draggingLeftScrollbar = false;
            this.draggingGridScrollbar = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0) {
            if (this.draggingLeftScrollbar) {
                int listY = this.guiTop + 15;
                int listHeight = 200;
                int maxScroll = Math.max(0, this.allPokemon.size() - 5);
                int visibleEntries = listHeight / 40;
                int totalEntries = this.allPokemon.size();
                int barHeight = Math.max(20, (int)((float)visibleEntries / (float)totalEntries * (float)listHeight));
                int mouseDelta = (int)mouseY - this.dragStartY;
                int scrollableHeight = listHeight - barHeight;
                if (scrollableHeight > 0) {
                    int scrollDelta = (int)((float)mouseDelta / (float)scrollableHeight * (float)maxScroll);
                    this.leftListScroll = Math.max(0, Math.min(maxScroll, this.dragStartScroll + scrollDelta));
                }
                return true;
            }
            if (this.draggingGridScrollbar) {
                int gridStartY = this.guiTop + 45;
                int gridHeight = 170;
                int gridWidth = 305;
                int cols = gridWidth / 70;
                int rows = (int)Math.ceil((double)this.searchResults.size() / (double)cols);
                int totalContentHeight = rows * 70;
                int maxScroll = totalContentHeight - gridHeight;
                int barHeight = Math.max(20, (int)((float)gridHeight / (float)(maxScroll + gridHeight) * (float)gridHeight));
                int mouseDelta = (int)mouseY - this.dragStartY;
                int scrollableHeight = gridHeight - barHeight;
                if (scrollableHeight > 0) {
                    int scrollDelta = (int)((float)mouseDelta / (float)scrollableHeight * (float)maxScroll);
                    this.gridScrollOffset = Math.max(0, Math.min(maxScroll, this.dragStartScroll + scrollDelta));
                }
                return true;
            }
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.searchField.method_25400(chr, modifiers)) {
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchField.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256) {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(null);
            }
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25421() {
        return false;
    }

    public static class PokemonEntry {
        public final Species species;
        public final String formName;
        public final Set<String> formAspects;
        public final int dexNumber;
        public final PokemonSpawnData spawnData;

        public PokemonEntry(Species species, String formName, Set<String> formAspects, PokemonSpawnData spawnData) {
            this.species = species;
            this.formName = formName;
            this.formAspects = formAspects != null ? formAspects : new HashSet();
            this.dexNumber = species.getNationalPokedexNumber();
            this.spawnData = spawnData;
        }

        public String getFullName() {
            if (this.formName != null && !this.formName.isEmpty() && !this.formName.equalsIgnoreCase("normal")) {
                return this.species.getName() + " " + this.formName;
            }
            return this.species.getName();
        }

        public String getCacheKey() {
            if (this.formName == null || this.formName.isEmpty() || this.formName.equalsIgnoreCase("normal")) {
                return this.species.getName().toLowerCase();
            }
            return this.species.getName().toLowerCase() + "_" + this.formName.toLowerCase();
        }

        public boolean isCaught() {
            boolean caught = DexHelper.isCaught(this.species.getName());
            return caught;
        }
    }
}

