/*
 * Decompiled with CFR 0.152.
 */
package com.cupokewiki.data;

import com.cobblemon.mod.common.api.abilities.AbilityPool;
import com.cobblemon.mod.common.api.abilities.PotentialAbility;
import com.cobblemon.mod.common.api.drop.DropEntry;
import com.cobblemon.mod.common.api.drop.DropTable;
import com.cobblemon.mod.common.api.drop.ItemDropEntry;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.moves.Learnset;
import com.cobblemon.mod.common.api.spawning.CobblemonSpawnPools;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Species;
import com.cupokewiki.CUPokeWiki;
import com.cupokewiki.data.BlacklistConfig;
import com.cupokewiki.data.LegendaryFormConfig;
import com.cupokewiki.data.LegendarySpawnHelper;
import com.cupokewiki.data.LegendarySpawnReader;
import com.cupokewiki.data.PokemonSpawnData;
import com.cupokewiki.util.BiomeTagResolver;
import com.cupokewiki.util.SpawnDataCollector;
import com.cupokewiki.util.TranslationLoader;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fr.pepefab.ucgeneralfabric.Config.Config;
import fr.pepefab.ucgeneralfabric.Config.PokemonLootTypesConfig;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.ranges.IntRange;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class SpawnDataCache {
    private static Map<String, PokemonSpawnData> clientCache = new HashMap<String, PokemonSpawnData>();
    private static Map<String, PokemonSpawnData> serverCache = new HashMap<String, PokemonSpawnData>();
    private static boolean initialized = false;
    private static MinecraftServer minecraftServer = null;

    public static void initializeServerCache(MinecraftServer server) {
        minecraftServer = server;
        long totalStartTime = System.currentTimeMillis();
        serverCache.clear();
        initialized = false;
        class_3218 world = server.method_30002();
        LegendaryFormConfig.load();
        BlacklistConfig.reset();
        BlacklistConfig.initialize(server.method_34864());
        int totalSpecies = 0;
        int filteredSpecies = 0;
        int totalForms = 0;
        int filteredForms = 0;
        int successCount = 0;
        int failCount = 0;
        int totalEvolutions = 0;
        int totalMoves = 0;
        int totalDrops = 0;
        int totalBiomes = 0;
        int dropsFromUC = 0;
        int legendarySpawns = 0;
        try {
            TranslationLoader.loadTranslations();
            for (Species species : PokemonSpecies.INSTANCE.getSpecies()) {
                ++totalSpecies;
                if (BlacklistConfig.isBlacklisted(species)) {
                    ++filteredSpecies;
                    continue;
                }
                boolean isLegendaryWithConfig = false;
                List speciesForms = species.getForms();
                if (speciesForms != null && !speciesForms.isEmpty()) {
                    for (FormData formData : speciesForms) {
                        if (!LegendaryFormConfig.isFormVisible(species.getName(), formData.getName())) continue;
                        isLegendaryWithConfig = true;
                        break;
                    }
                }
                if (!isLegendaryWithConfig && !SpawnDataCache.isSpeciesImplemented(species)) {
                    ++filteredSpecies;
                    continue;
                }
                List forms = species.getForms();
                if (forms == null || forms.isEmpty()) {
                    try {
                        PokemonSpawnData pokemonSpawnData = SpawnDataCache.createMinimalData(species, (class_1937)world);
                        String key = SpawnDataCache.generateKey(species.getName(), null);
                        if (pokemonSpawnData != null) {
                            serverCache.put(key, pokemonSpawnData);
                            ++successCount;
                            continue;
                        }
                        ++failCount;
                    }
                    catch (Exception exception) {}
                    continue;
                }
                Iterator iterator = forms.iterator();
                while (iterator.hasNext()) {
                    String key;
                    FormData form = (FormData)iterator.next();
                    ++totalForms;
                    String formName = form.getName();
                    if (BlacklistConfig.isBlacklisted(species, formName)) {
                        ++filteredForms;
                        continue;
                    }
                    if (SpawnDataCache.shouldFilterForm(species, formName, form)) {
                        ++filteredForms;
                        continue;
                    }
                    if (formName != null && formName.equalsIgnoreCase("normal")) {
                        formName = null;
                    }
                    if (formName != null && formName.toLowerCase().endsWith("-striped")) {
                        formName = formName.substring(0, formName.length() - 8);
                    }
                    if (serverCache.containsKey(key = SpawnDataCache.generateKey(species.getName(), formName))) continue;
                    PokemonSpawnData data3 = SpawnDataCache.collectPokemonData(species, form, (class_1937)world);
                    if (data3 != null) {
                        serverCache.put(key, data3);
                        ++successCount;
                        continue;
                    }
                    ++failCount;
                }
            }
            long detectionStart = System.currentTimeMillis();
            SpawnDataCache.detectAndAddMissingForms((class_1937)world);
            SpawnDataCache.addLegendaryFormsFromConfig((class_1937)world);
            long detectionTime = System.currentTimeMillis() - detectionStart;
            for (PokemonSpawnData pokemonSpawnData : serverCache.values()) {
                if (pokemonSpawnData.getEvolutions() != null) {
                    totalEvolutions += pokemonSpawnData.getEvolutions().size();
                }
                if (pokemonSpawnData.getMoves() != null) {
                    totalMoves += pokemonSpawnData.getMoves().size();
                }
                if (pokemonSpawnData.getDrops() != null) {
                    totalDrops += pokemonSpawnData.getDrops().size();
                    for (PokemonSpawnData.DropData drop : pokemonSpawnData.getDrops()) {
                        if (drop.getSource() == null || drop.getSource().isEmpty()) continue;
                        ++dropsFromUC;
                    }
                }
                if (pokemonSpawnData.getBiomes() != null) {
                    totalBiomes += pokemonSpawnData.getBiomes().size();
                }
                try {
                    if (!LegendarySpawnReader.hasLegendarySpawns(pokemonSpawnData.getSpecies())) continue;
                    ++legendarySpawns;
                }
                catch (Exception | NoClassDefFoundError form) {}
            }
            long totalDuration = System.currentTimeMillis() - totalStartTime;
            int totalEntries = serverCache.size();
            long estimatedSize = SpawnDataCache.estimateCacheSize();
            initialized = true;
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Error initializing server cache", (Throwable)e);
        }
    }

    private static PokemonSpawnData createLegendarySpawnData(Species species, FormData form, String formName, String legendaryKey, Map<String, List<String>> legendaryBiomes, Map<String, String> legendaryDescriptions, class_1937 world) {
        try {
            List biomes = legendaryBiomes.getOrDefault(legendaryKey, new ArrayList());
            String description = legendaryDescriptions.get(legendaryKey);
            if (biomes.isEmpty() && description == null) {
                return null;
            }
            String speciesName = species.getName();
            ArrayList<String> eggGroups = new ArrayList<String>();
            ArrayList<PokemonSpawnData.AbilityData> abilities = new ArrayList<PokemonSpawnData.AbilityData>();
            ArrayList<String> types = new ArrayList<String>();
            try {
                HashSet speciesEggGroups = species.getEggGroups();
                if (speciesEggGroups instanceof Iterable) {
                    for (Object eggGroupObj : (Iterable)speciesEggGroups) {
                        if (eggGroupObj == null) continue;
                        eggGroups.add(eggGroupObj.toString());
                    }
                }
            }
            catch (Exception speciesEggGroups) {
                // empty catch block
            }
            try {
                Iterable formTypes;
                AbilityPool formAbilities = form.getAbilities();
                if (formAbilities instanceof Iterable) {
                    for (Object obj : (Iterable)formAbilities) {
                        if (!(obj instanceof PotentialAbility)) continue;
                        PotentialAbility potentialAbility = (PotentialAbility)obj;
                        boolean isHidden = obj.getClass().getSimpleName().contains("Hidden");
                        String descriptionKey = potentialAbility.getTemplate().getDescription();
                        abilities.add(new PokemonSpawnData.AbilityData(potentialAbility.getTemplate().getName(), descriptionKey, isHidden));
                    }
                }
                if ((formTypes = form.getTypes()) instanceof Iterable) {
                    for (Object typeObj : formTypes) {
                        if (!(typeObj instanceof ElementalType)) continue;
                        ElementalType type = (ElementalType)typeObj;
                        types.add(type.getName());
                    }
                }
            }
            catch (Exception formAbilities) {
                // empty catch block
            }
            Map<String, List<String>> realBiomesByCategory = BiomeTagResolver.resolveAllBiomeTags(biomes, world);
            List<PokemonSpawnData.MoveData> moves = SpawnDataCache.extractMoves(form);
            List<PokemonSpawnData.DropData> drops = SpawnDataCache.getAllDrops(speciesName, types, form);
            List<PokemonSpawnData.EvolutionData> evolutions = SpawnDataCache.extractEvolutions(species);
            ArrayList<String> timeRanges = new ArrayList<String>();
            try {
                List<String> legendaryTimings;
                List<String> cobblemonTimeRanges = SpawnDataCollector.collectTimeRangesForSpecies(speciesName, formName);
                if (cobblemonTimeRanges != null) {
                    timeRanges.addAll(cobblemonTimeRanges);
                }
                if ((legendaryTimings = LegendarySpawnHelper.getTimingsForLegendary(legendaryKey)) != null) {
                    for (String timing : legendaryTimings) {
                        if (timeRanges.contains(timing)) continue;
                        timeRanges.add(timing);
                    }
                }
            }
            catch (Exception e) {
                CUPokeWiki.LOGGER.error("Error collecting time ranges for {}: {}", (Object)legendaryKey, (Object)e.getMessage());
            }
            return new PokemonSpawnData(speciesName, formName, biomes, eggGroups, abilities, types, species.getNationalPokedexNumber(), description, realBiomesByCategory, moves, drops, evolutions, timeRanges);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void detectAndAddMissingForms(class_1937 world) {
        try {
            String speciesName;
            CobblemonSpawnPools spawnPools = CobblemonSpawnPools.INSTANCE;
            Method method = spawnPools.getClass().getMethod("getWORLD_SPAWN_POOL", new Class[0]);
            Object worldPool = method.invoke((Object)spawnPools, new Object[0]);
            if (worldPool == null) {
                return;
            }
            Method getDetailsMethod = worldPool.getClass().getMethod("getDetails", new Class[0]);
            Object details = getDetailsMethod.invoke(worldPool, new Object[0]);
            if (!(details instanceof Collection)) {
                return;
            }
            Collection spawns = (Collection)details;
            HashMap detectedForms = new HashMap();
            for (Object e : spawns) {
                speciesName = SpawnDataCollector.extractSpeciesName(e);
                String formName = SpawnDataCollector.extractFormName(e);
                if (speciesName == null || formName == null || formName.isEmpty() || formName.equalsIgnoreCase("normal")) continue;
                String speciesLower = speciesName.toLowerCase();
                detectedForms.putIfAbsent(speciesLower, new HashSet());
                ((Set)detectedForms.get(speciesLower)).add(formName.toLowerCase());
            }
            for (Map.Entry entry : detectedForms.entrySet()) {
                speciesName = (String)entry.getKey();
                Species species = PokemonSpecies.getByName((String)speciesName);
                if (species == null || !SpawnDataCache.isSpeciesImplemented(species)) continue;
                for (String formName : (Set)entry.getValue()) {
                    PokemonSpawnData data;
                    String key;
                    if (!LegendaryFormConfig.isFormVisible(speciesName, formName) || serverCache.containsKey(key = SpawnDataCache.generateKey(speciesName, formName)) || (data = SpawnDataCache.createDataForMissingForm(species, formName, world)) == null) continue;
                    serverCache.put(key, data);
                }
            }
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Erreur d\u00e9tection formes manquantes", (Throwable)e);
        }
    }

    private static void addLegendaryFormsFromConfig(class_1937 world) {
        try {
            if (!LegendarySpawnReader.loaded) {
                LegendarySpawnReader.loadLegendarySpawns();
            }
            Map<String, List<String>> legendaryBiomes = LegendarySpawnReader.getAllLegendaryBiomes();
            Map<String, String> legendaryDescriptions = LegendarySpawnReader.getAllLegendaryDescriptions();
            Map<String, Map<String, Boolean>> configForms = LegendaryFormConfig.getAllVisibleForms();
            for (Map.Entry<String, Map<String, Boolean>> entry : configForms.entrySet()) {
                String speciesName = entry.getKey();
                Map<String, Boolean> forms = entry.getValue();
                Species species = PokemonSpecies.getByName((String)speciesName);
                if (species == null) continue;
                boolean hasAnyDescription = false;
                for (String string : forms.keySet()) {
                    Object testKey = string.equalsIgnoreCase("normal") ? speciesName.toLowerCase() : speciesName.toLowerCase() + "_" + string.toLowerCase();
                    if (!legendaryDescriptions.containsKey(testKey)) continue;
                    hasAnyDescription = true;
                    break;
                }
                if (!SpawnDataCache.isSpeciesImplemented(species) && !hasAnyDescription) continue;
                for (Map.Entry entry2 : forms.entrySet()) {
                    PokemonSpawnData data;
                    String formName = (String)entry2.getKey();
                    boolean visible = (Boolean)entry2.getValue();
                    if (!visible) continue;
                    String normalizedForm = formName.equalsIgnoreCase("normal") ? null : formName;
                    String cacheKey = SpawnDataCache.generateKey(speciesName, normalizedForm);
                    String legendaryKey = normalizedForm != null ? speciesName.toLowerCase() + "_" + formName.toLowerCase() : speciesName.toLowerCase();
                    String description = legendaryDescriptions.get(legendaryKey);
                    if (serverCache.containsKey(cacheKey)) {
                        if (description == null || description.isEmpty()) continue;
                        PokemonSpawnData existingData = serverCache.get(cacheKey);
                        PokemonSpawnData updatedData = new PokemonSpawnData(existingData.getSpecies(), existingData.getForm(), existingData.getTranslatedNameFr(), existingData.getTranslatedNameEn(), existingData.getBiomes(), existingData.getEggGroups(), existingData.getAbilities(), existingData.getTypes(), existingData.getDexNumber(), description, existingData.getRealBiomesByCategory(), existingData.getMoves(), existingData.getDrops(), existingData.getEvolutions(), existingData.getTimeRanges());
                        serverCache.put(cacheKey, updatedData);
                        continue;
                    }
                    FormData targetForm = SpawnDataCache.findFormData(species, formName);
                    if (targetForm == null || (data = SpawnDataCache.createLegendaryDataFromConfig(species, targetForm, normalizedForm, legendaryKey, legendaryBiomes, legendaryDescriptions, world)) == null) continue;
                    serverCache.put(cacheKey, data);
                }
            }
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Error adding legendary forms from config: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    private static FormData findFormData(Species species, String formName) {
        List forms = species.getForms();
        if (forms == null || forms.isEmpty()) {
            try {
                FormData standardForm = species.getStandardForm();
                if (standardForm != null) {
                    return standardForm;
                }
            }
            catch (Exception e) {
                CUPokeWiki.LOGGER.error("Error getting standard form for {}: {}", (Object)species.getName(), (Object)e.getMessage());
            }
            return null;
        }
        if (formName == null || formName.isEmpty() || formName.equalsIgnoreCase("normal")) {
            for (FormData form : forms) {
                if (form.getName() != null && !form.getName().isEmpty() && !form.getName().equalsIgnoreCase("normal")) continue;
                return form;
            }
            try {
                FormData standardForm = species.getStandardForm();
                if (standardForm != null) {
                    return standardForm;
                }
            }
            catch (Exception standardForm) {
                // empty catch block
            }
            return (FormData)forms.iterator().next();
        }
        String searchForm = formName.toLowerCase();
        for (FormData form : forms) {
            String normalized;
            String cobblemonFormName = form.getName();
            if (cobblemonFormName == null || !(normalized = cobblemonFormName.toLowerCase()).equals(searchForm) && !normalized.contains(searchForm) && !searchForm.contains(normalized)) continue;
            return form;
        }
        return null;
    }

    private static PokemonSpawnData createLegendaryDataFromConfig(Species species, FormData form, String formName, String legendaryKey, Map<String, List<String>> legendaryBiomes, Map<String, String> legendaryDescriptions, class_1937 world) {
        try {
            String speciesName = species.getName();
            List biomes = legendaryBiomes.getOrDefault(legendaryKey, new ArrayList());
            String description = legendaryDescriptions.get(legendaryKey);
            ArrayList<String> eggGroups = new ArrayList<String>();
            ArrayList<PokemonSpawnData.AbilityData> abilities = new ArrayList<PokemonSpawnData.AbilityData>();
            ArrayList<String> types = new ArrayList<String>();
            try {
                HashSet speciesEggGroups = species.getEggGroups();
                if (speciesEggGroups instanceof Iterable) {
                    for (Object eggGroupObj : (Iterable)speciesEggGroups) {
                        if (eggGroupObj == null) continue;
                        eggGroups.add(eggGroupObj.toString());
                    }
                }
            }
            catch (Exception speciesEggGroups) {
                // empty catch block
            }
            try {
                Iterable formTypes;
                AbilityPool formAbilities = form.getAbilities();
                if (formAbilities instanceof Iterable) {
                    for (Object obj : (Iterable)formAbilities) {
                        if (!(obj instanceof PotentialAbility)) continue;
                        PotentialAbility potentialAbility = (PotentialAbility)obj;
                        boolean isHidden = obj.getClass().getSimpleName().contains("Hidden");
                        String descriptionKey = potentialAbility.getTemplate().getDescription();
                        abilities.add(new PokemonSpawnData.AbilityData(potentialAbility.getTemplate().getName(), descriptionKey, isHidden));
                    }
                }
                if ((formTypes = form.getTypes()) instanceof Iterable) {
                    for (Object typeObj : formTypes) {
                        if (!(typeObj instanceof ElementalType)) continue;
                        ElementalType type = (ElementalType)typeObj;
                        types.add(type.getName());
                    }
                }
            }
            catch (Exception formAbilities) {
                // empty catch block
            }
            Map<String, List<String>> realBiomesByCategory = BiomeTagResolver.resolveAllBiomeTags(biomes, world);
            List<PokemonSpawnData.MoveData> moves = SpawnDataCache.extractMoves(form);
            List<PokemonSpawnData.DropData> drops = SpawnDataCache.getAllDrops(speciesName, types, form);
            List<PokemonSpawnData.EvolutionData> evolutions = SpawnDataCache.extractEvolutions(species);
            ArrayList<String> timeRanges = new ArrayList<String>();
            try {
                List<String> legendaryTimings;
                List<String> cobblemonTimeRanges = SpawnDataCollector.collectTimeRangesForSpecies(speciesName, formName);
                if (cobblemonTimeRanges != null) {
                    timeRanges.addAll(cobblemonTimeRanges);
                }
                if ((legendaryTimings = LegendarySpawnHelper.getTimingsForLegendary(legendaryKey)) != null) {
                    for (String timing : legendaryTimings) {
                        if (timeRanges.contains(timing)) continue;
                        timeRanges.add(timing);
                    }
                }
            }
            catch (Exception cobblemonTimeRanges) {
                // empty catch block
            }
            String normalizedForTranslation = species.getName().toLowerCase().replaceAll("[''\u02bc\u055a\u05f3`\u00b4]", "").replaceAll("\\u0027", "").replaceAll("\\u2019", "").replaceAll("\\u02BC", "");
            String translationKey = "cobblemon.species." + normalizedForTranslation;
            if (formName != null && !formName.isEmpty()) {
                translationKey = translationKey + "." + formName.toLowerCase();
            }
            translationKey = translationKey + ".name";
            String translatedNameFr = TranslationLoader.getFrenchTranslation(translationKey);
            String translatedNameEn = TranslationLoader.getEnglishTranslation(translationKey);
            if ((translatedNameFr == null || translatedNameFr.isEmpty() || translatedNameEn == null || translatedNameEn.isEmpty()) && formName != null && !formName.isEmpty()) {
                String baseTranslationKey = "cobblemon.species." + normalizedForTranslation + ".name";
                if (translatedNameFr == null || translatedNameFr.isEmpty()) {
                    translatedNameFr = TranslationLoader.getFrenchTranslation(baseTranslationKey);
                }
                if (translatedNameEn == null || translatedNameEn.isEmpty()) {
                    translatedNameEn = TranslationLoader.getEnglishTranslation(baseTranslationKey);
                }
            }
            return new PokemonSpawnData(speciesName, formName, translatedNameFr, translatedNameEn, biomes, eggGroups, abilities, types, species.getNationalPokedexNumber(), description, realBiomesByCategory, moves, drops, evolutions, timeRanges);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static PokemonSpawnData createDataForMissingForm(Species species, String formName, class_1937 world) {
        try {
            String normalizedNameForSearch = species.getName().replaceAll("[''\u02bc\u055a\u05f3`\u00b4]", "").replaceAll("\\u0027", "").replaceAll("\\u2019", "").replaceAll("\\u02BC", "");
            List<String> biomes = SpawnDataCollector.collectBiomesForSpecies(normalizedNameForSearch, formName, world);
            if (biomes.isEmpty()) {
                return null;
            }
            FormData targetForm = null;
            List forms = species.getForms();
            if (forms != null) {
                String[] formVariants;
                for (String variant : formVariants = new String[]{formName, formName.toLowerCase(), formName.replace("alolan", "alola"), formName.replace("galarian", "galar"), formName.replace("hisuian", "hisui"), formName.replace("paldean", "paldea"), formName + "ian"}) {
                    for (FormData form : forms) {
                        if (form.getName() == null || !form.getName().equalsIgnoreCase(variant)) continue;
                        targetForm = form;
                        break;
                    }
                    if (targetForm != null) break;
                }
            }
            if (targetForm == null) {
                for (FormData form : forms) {
                    if (form.getName() == null || form.getName().equalsIgnoreCase("normal")) continue;
                    targetForm = form;
                    break;
                }
            }
            if (targetForm == null && forms != null && !forms.isEmpty()) {
                targetForm = (FormData)forms.iterator().next();
            }
            if (targetForm == null) {
                CUPokeWiki.LOGGER.warn("No form available for species {} form {}", (Object)species.getName(), (Object)formName);
                return null;
            }
            ArrayList<String> eggGroups = new ArrayList<String>();
            ArrayList<PokemonSpawnData.AbilityData> abilities = new ArrayList<PokemonSpawnData.AbilityData>();
            ArrayList<String> types = new ArrayList<String>();
            try {
                Set formEggGroups = targetForm.getEggGroups();
                if (formEggGroups != null && formEggGroups instanceof Iterable) {
                    for (Object eggGroupObj : (Iterable)formEggGroups) {
                        if (eggGroupObj == null) continue;
                        eggGroups.add(eggGroupObj.toString());
                    }
                }
            }
            catch (Exception formEggGroups) {
                // empty catch block
            }
            try {
                AbilityPool formAbilities = targetForm.getAbilities();
                if (formAbilities != null && formAbilities instanceof Iterable) {
                    for (Object obj : (Iterable)formAbilities) {
                        if (!(obj instanceof PotentialAbility)) continue;
                        PotentialAbility potentialAbility = (PotentialAbility)obj;
                        boolean isHidden = obj.getClass().getSimpleName().contains("Hidden");
                        abilities.add(new PokemonSpawnData.AbilityData(potentialAbility.getTemplate().getName(), potentialAbility.getTemplate().getDescription(), isHidden));
                    }
                }
            }
            catch (Exception formAbilities) {
                // empty catch block
            }
            try {
                Iterable formTypes = targetForm.getTypes();
                if (formTypes != null && formTypes instanceof Iterable) {
                    for (Object typeObj : formTypes) {
                        if (!(typeObj instanceof ElementalType)) continue;
                        ElementalType type = (ElementalType)typeObj;
                        types.add(type.getName());
                    }
                }
            }
            catch (Exception e) {
                CUPokeWiki.LOGGER.error("Error getting types for missing form {} {}: {}", new Object[]{species.getName(), formName, e.getMessage()});
            }
            String description = LegendarySpawnHelper.getDescriptionForLegendary(species.getName());
            Map<String, List<String>> realBiomesByCategory = BiomeTagResolver.resolveAllBiomeTags(biomes, world);
            List<PokemonSpawnData.MoveData> moves = SpawnDataCache.extractMoves(targetForm);
            List<PokemonSpawnData.DropData> drops = SpawnDataCache.getAllDrops(species.getName(), types, targetForm);
            String normalizedFormForEvolutions = formName;
            if (normalizedFormForEvolutions != null) {
                String lower = normalizedFormForEvolutions.toLowerCase().replace("-", "").replace("bias", "").trim();
                normalizedFormForEvolutions = lower.contains("alola") ? "alolan" : (lower.contains("galar") ? "galarian" : (lower.contains("hisui") ? "hisuian" : (lower.contains("paldea") ? "paldean" : null)));
            }
            List<PokemonSpawnData.EvolutionData> evolutions = SpawnDataCache.extractEvolutions(species, normalizedFormForEvolutions, targetForm);
            ArrayList<String> timeRanges = new ArrayList<String>();
            try {
                List<String> cobblemonTimeRanges = SpawnDataCollector.collectTimeRangesForSpecies(species.getName(), formName);
                if (cobblemonTimeRanges != null) {
                    timeRanges.addAll(cobblemonTimeRanges);
                }
            }
            catch (Exception e) {
                CUPokeWiki.LOGGER.error("Error collecting time ranges for {} {}: {}", new Object[]{species.getName(), formName, e.getMessage()});
            }
            String normalizedForTranslation = species.getName().toLowerCase().replaceAll("[''\u02bc\u055a\u05f3`\u00b4]", "").replaceAll("\\u0027", "").replaceAll("\\u2019", "").replaceAll("\\u02BC", "");
            String normalizedFormNameLower = normalizedFormForEvolutions != null ? normalizedFormForEvolutions.toLowerCase() : null;
            String translationKey = "cobblemon.species." + normalizedForTranslation;
            if (normalizedFormNameLower != null && !normalizedFormNameLower.isEmpty()) {
                translationKey = translationKey + "." + normalizedFormNameLower;
            }
            translationKey = translationKey + ".name";
            String translatedNameFr = TranslationLoader.getFrenchTranslation(translationKey);
            String translatedNameEn = TranslationLoader.getEnglishTranslation(translationKey);
            if ((translatedNameFr == null || translatedNameFr.isEmpty() || translatedNameEn == null || translatedNameEn.isEmpty()) && normalizedFormNameLower != null && !normalizedFormNameLower.isEmpty()) {
                String baseTranslationKey = "cobblemon.species." + normalizedForTranslation + ".name";
                if (translatedNameFr == null || translatedNameFr.isEmpty()) {
                    translatedNameFr = TranslationLoader.getFrenchTranslation(baseTranslationKey);
                }
                if (translatedNameEn == null || translatedNameEn.isEmpty()) {
                    translatedNameEn = TranslationLoader.getEnglishTranslation(baseTranslationKey);
                }
            }
            return new PokemonSpawnData(species.getName(), formName, translatedNameFr, translatedNameEn, biomes, eggGroups, abilities, types, species.getNationalPokedexNumber(), description, realBiomesByCategory, moves, drops, evolutions, timeRanges);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean isSpeciesImplemented(Species species) {
        try {
            return species.getImplemented();
        }
        catch (Exception e) {
            return true;
        }
    }

    private static boolean shouldFilterForm(Species species, String formName, FormData form) {
        if (formName == null || formName.isEmpty()) {
            return false;
        }
        String lowerForm = formName.toLowerCase();
        String speciesLower = species.getName().toLowerCase();
        if (lowerForm.equals("f") || lowerForm.equals("m") || lowerForm.equals("female") || lowerForm.equals("male")) {
            return true;
        }
        if (lowerForm.equals("galar") || lowerForm.equals("galarian") || lowerForm.equals("alola") || lowerForm.equals("alolan") || lowerForm.equals("hisui") || lowerForm.equals("hisuian") || lowerForm.equals("paldea") || lowerForm.equals("paldean")) {
            try {
                if (LegendarySpawnReader.hasLegendarySpawns(species.getName())) {
                    return true;
                }
            }
            catch (Exception | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
        if (lowerForm.startsWith("mega") || lowerForm.contains("mega")) {
            return true;
        }
        if (lowerForm.startsWith("primal") || lowerForm.contains("primal")) {
            return true;
        }
        if (lowerForm.equals("origin") || lowerForm.equals("origin-dialga") || lowerForm.equals("origin-palkia")) {
            return true;
        }
        if (lowerForm.equals("black") || lowerForm.equals("white")) {
            return true;
        }
        if (lowerForm.equals("therian") || lowerForm.contains("therian")) {
            return true;
        }
        if (lowerForm.equals("resolute")) {
            return true;
        }
        if (lowerForm.equals("sky")) {
            return true;
        }
        if (lowerForm.equals("crowned") || lowerForm.contains("crowned")) {
            return true;
        }
        if (lowerForm.equals("dusk") || lowerForm.equals("dawn") || lowerForm.equals("ultra") || lowerForm.equals("dusk-mane") || lowerForm.equals("dawn-wings")) {
            return true;
        }
        if (lowerForm.equals("eternamax")) {
            return true;
        }
        if (speciesLower.equals("arceus") && !lowerForm.equals("normal") && !lowerForm.isEmpty()) {
            return true;
        }
        if (lowerForm.equals("ice") || lowerForm.equals("shadow") || lowerForm.equals("ice-rider") || lowerForm.equals("shadow-rider")) {
            return true;
        }
        if (lowerForm.equals("10") || lowerForm.equals("complete") || lowerForm.equals("10-percent") || lowerForm.equals("cell") || lowerForm.equals("10percent")) {
            return true;
        }
        if (lowerForm.equals("hero")) {
            return true;
        }
        if (lowerForm.equals("gmax") || lowerForm.equals("gigantamax") || lowerForm.contains("gigantamax")) {
            return true;
        }
        if (speciesLower.equals("unown") && !lowerForm.equals("normal") && !formName.isEmpty()) {
            return true;
        }
        if (speciesLower.equals("aegislash") && lowerForm.equals("blade")) {
            return true;
        }
        if (speciesLower.equals("cramorant") && (lowerForm.equals("gulping") || lowerForm.equals("gorging"))) {
            return true;
        }
        if (speciesLower.equals("darmanitan") && (lowerForm.equals("zen") || lowerForm.equals("galar-zen"))) {
            return true;
        }
        if (speciesLower.equals("eiscue") && lowerForm.contains("noice")) {
            return true;
        }
        if (speciesLower.equals("wishiwashi") && lowerForm.equals("school")) {
            return true;
        }
        if (speciesLower.equals("squawkabilly") && (lowerForm.equals("blue") || lowerForm.equals("yellow") || lowerForm.equals("white"))) {
            return true;
        }
        if ((speciesLower.equals("flabebe") || speciesLower.equals("floette") || speciesLower.equals("florges")) && (lowerForm.equals("yellow") || lowerForm.equals("orange") || lowerForm.equals("blue") || lowerForm.equals("white") || lowerForm.equals("eternal"))) {
            return true;
        }
        if ((speciesLower.equals("pumpkaboo") || speciesLower.equals("gourgeist")) && (lowerForm.equals("small") || lowerForm.equals("large") || lowerForm.equals("super"))) {
            return true;
        }
        if ((speciesLower.equals("deerling") || speciesLower.equals("sawsbuck")) && (lowerForm.equals("summer") || lowerForm.equals("autumn") || lowerForm.equals("winter"))) {
            return true;
        }
        if (speciesLower.equals("alcremie") && (lowerForm.contains("cream") || lowerForm.contains("swirl"))) {
            return true;
        }
        if (speciesLower.equals("gimmighoul") && lowerForm.equals("roaming")) {
            return true;
        }
        return speciesLower.equals("vivillon") && lowerForm.equals("pokeball");
    }

    private static PokemonSpawnData createMinimalData(Species species, class_1937 world) {
        try {
            String speciesName = species.getName();
            String normalizedNameForSearch = speciesName.replaceAll("[''\u02bc\u055a\u05f3`\u00b4]", "").replaceAll("\\u0027", "").replaceAll("\\u2019", "").replaceAll("\\u02BC", "");
            List<Object> biomes = new ArrayList();
            try {
                biomes = SpawnDataCollector.collectBiomesForSpecies(normalizedNameForSearch, null, world);
            }
            catch (Exception e) {
                CUPokeWiki.LOGGER.error("Error collecting spawn data for {}: {}", (Object)speciesName, (Object)e.getMessage());
            }
            if (biomes.isEmpty()) {
                return null;
            }
            ArrayList<String> eggGroups = new ArrayList<String>();
            ArrayList<PokemonSpawnData.AbilityData> abilities = new ArrayList<PokemonSpawnData.AbilityData>();
            ArrayList<String> types = new ArrayList<String>();
            try {
                HashSet speciesEggGroups = species.getEggGroups();
                if (speciesEggGroups != null && speciesEggGroups instanceof Iterable) {
                    for (Object eggGroupObj : (Iterable)speciesEggGroups) {
                        if (eggGroupObj == null) continue;
                        eggGroups.add(eggGroupObj.toString());
                    }
                }
            }
            catch (Exception speciesEggGroups) {
                // empty catch block
            }
            FormData standardForm = null;
            try {
                standardForm = species.getStandardForm();
                if (standardForm != null) {
                    Iterable formTypes;
                    AbilityPool formAbilities = standardForm.getAbilities();
                    if (formAbilities != null && formAbilities instanceof Iterable) {
                        for (Iterator<Object> obj : (Iterable)formAbilities) {
                            if (!(obj instanceof PotentialAbility)) continue;
                            PotentialAbility potentialAbility = (PotentialAbility)obj;
                            boolean isHidden = obj.getClass().getSimpleName().contains("Hidden");
                            String descriptionKey = potentialAbility.getTemplate().getDescription();
                            abilities.add(new PokemonSpawnData.AbilityData(potentialAbility.getTemplate().getName(), descriptionKey, isHidden));
                        }
                    }
                    if ((formTypes = standardForm.getTypes()) != null && formTypes instanceof Iterable) {
                        for (Object typeObj : formTypes) {
                            if (!(typeObj instanceof ElementalType)) continue;
                            ElementalType type = (ElementalType)typeObj;
                            types.add(type.getName());
                        }
                    }
                }
            }
            catch (Exception formAbilities) {
                // empty catch block
            }
            String description = LegendarySpawnHelper.getDescriptionForLegendary(species.getName());
            Map<String, List<String>> realBiomesByCategory = BiomeTagResolver.resolveAllBiomeTags(biomes, world);
            ArrayList<PokemonSpawnData.MoveData> moves = new ArrayList();
            try {
                if (standardForm != null) {
                    moves = SpawnDataCache.extractMoves(standardForm);
                }
            }
            catch (Exception e) {
                CUPokeWiki.LOGGER.error("Error extracting moves for {}: {}", (Object)species.getName(), (Object)e.getMessage());
            }
            ArrayList<PokemonSpawnData.DropData> drops = new ArrayList();
            try {
                if (standardForm != null) {
                    drops = SpawnDataCache.getAllDrops(species.getName(), types, standardForm);
                }
            }
            catch (Exception e) {
                CUPokeWiki.LOGGER.error("Error extracting drops for {}: {}", (Object)species.getName(), (Object)e.getMessage());
            }
            ArrayList<PokemonSpawnData.EvolutionData> evolutions = new ArrayList();
            try {
                evolutions = SpawnDataCache.extractEvolutions(species, null, standardForm);
            }
            catch (Exception e) {
                CUPokeWiki.LOGGER.error("Error extracting evolutions for {}: {}", (Object)species.getName(), (Object)e.getMessage());
            }
            ArrayList<String> timeRanges = new ArrayList<String>();
            try {
                String legendaryKey;
                List<String> legendaryTimings;
                List<String> cobblemonTimeRanges = SpawnDataCollector.collectTimeRangesForSpecies(species.getName(), null);
                if (cobblemonTimeRanges != null) {
                    timeRanges.addAll(cobblemonTimeRanges);
                }
                if ((legendaryTimings = LegendarySpawnHelper.getTimingsForLegendary(legendaryKey = species.getName().toLowerCase())) != null) {
                    for (String timing : legendaryTimings) {
                        if (timeRanges.contains(timing)) continue;
                        timeRanges.add(timing);
                    }
                }
            }
            catch (Exception e) {
                CUPokeWiki.LOGGER.error("Error collecting time ranges for {}: {}", (Object)species.getName(), (Object)e.getMessage());
            }
            String normalizedForTranslation = species.getName().toLowerCase().replaceAll("[''\u02bc\u055a\u05f3`\u00b4]", "").replaceAll("\\u0027", "").replaceAll("\\u2019", "").replaceAll("\\u02BC", "");
            String translatedNameFr = TranslationLoader.getFrenchTranslation("cobblemon.species." + normalizedForTranslation + ".name");
            String translatedNameEn = TranslationLoader.getEnglishTranslation("cobblemon.species." + normalizedForTranslation + ".name");
            PokemonSpawnData data = new PokemonSpawnData(speciesName, null, translatedNameFr, translatedNameEn, biomes, eggGroups, abilities, types, species.getNationalPokedexNumber(), description, realBiomesByCategory, moves, drops, evolutions, timeRanges);
            return data;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static PokemonSpawnData collectPokemonData(Species species, FormData form, class_1937 world) {
        String speciesName = species.getName();
        String formName = form.getName();
        try {
            if (formName != null && formName.equalsIgnoreCase("normal")) {
                formName = null;
            }
            String normalizedNameForSearch = speciesName.replaceAll("[''\u02bc\u055a\u05f3`\u00b4]", "").replaceAll("\\u0027", "").replaceAll("\\u2019", "").replaceAll("\\u02BC", "");
            List<Object> biomes = new ArrayList();
            try {
                biomes = SpawnDataCollector.collectBiomesForSpecies(normalizedNameForSearch, formName, world);
            }
            catch (Exception e) {
                CUPokeWiki.LOGGER.error("Error collecting spawn data for {} {}: {}", new Object[]{speciesName, formName, e.getMessage()});
            }
            if (biomes.isEmpty()) {
                return null;
            }
            String normalizedFormName = formName;
            if (normalizedFormName != null) {
                if (normalizedFormName.equalsIgnoreCase("alola")) {
                    normalizedFormName = "alolan";
                } else if (normalizedFormName.equalsIgnoreCase("galar")) {
                    normalizedFormName = "galarian";
                } else if (normalizedFormName.equalsIgnoreCase("hisui")) {
                    normalizedFormName = "hisuian";
                } else if (normalizedFormName.equalsIgnoreCase("paldea")) {
                    normalizedFormName = "paldean";
                }
            }
            ArrayList<String> eggGroups = new ArrayList<String>();
            try {
                Set formEggGroups = form.getEggGroups();
                if (formEggGroups != null && formEggGroups instanceof Iterable) {
                    for (Object eggGroupObj : (Iterable)formEggGroups) {
                        if (eggGroupObj == null) continue;
                        eggGroups.add(eggGroupObj.toString());
                    }
                }
            }
            catch (Exception formEggGroups) {
                // empty catch block
            }
            ArrayList<PokemonSpawnData.AbilityData> abilities = new ArrayList<PokemonSpawnData.AbilityData>();
            try {
                AbilityPool formAbilities = form.getAbilities();
                if (formAbilities != null && formAbilities instanceof Iterable) {
                    for (Object obj : (Iterable)formAbilities) {
                        if (!(obj instanceof PotentialAbility)) continue;
                        PotentialAbility potentialAbility = (PotentialAbility)obj;
                        boolean isHidden = obj.getClass().getSimpleName().contains("Hidden");
                        String abilityName = potentialAbility.getTemplate().getName();
                        String descriptionKey = potentialAbility.getTemplate().getDescription();
                        abilities.add(new PokemonSpawnData.AbilityData(abilityName, descriptionKey, isHidden));
                    }
                }
            }
            catch (Exception formAbilities) {
                // empty catch block
            }
            ArrayList<String> types = new ArrayList<String>();
            try {
                Iterable formTypes = form.getTypes();
                if (formTypes != null && formTypes instanceof Iterable) {
                    for (Object typeObj : formTypes) {
                        if (!(typeObj instanceof ElementalType)) continue;
                        ElementalType type = (ElementalType)typeObj;
                        types.add(type.getName());
                    }
                }
            }
            catch (Exception e) {
                CUPokeWiki.LOGGER.error("Error getting types for {} {}: {}", new Object[]{speciesName, normalizedFormName, e.getMessage()});
            }
            Object legendaryKey = speciesName;
            if (formName != null && !formName.isEmpty() && !formName.equalsIgnoreCase("normal")) {
                legendaryKey = speciesName + "_" + formName.toLowerCase();
            }
            String description = LegendarySpawnHelper.getDescriptionForLegendary((String)legendaryKey);
            Map<String, List<String>> realBiomesByCategory = BiomeTagResolver.resolveAllBiomeTags(biomes, world);
            List<PokemonSpawnData.MoveData> moves = SpawnDataCache.extractMoves(form);
            List<PokemonSpawnData.DropData> drops = SpawnDataCache.getAllDrops(speciesName, types, form);
            List<PokemonSpawnData.EvolutionData> evolutions = SpawnDataCache.extractEvolutions(species, normalizedFormName, form);
            ArrayList<String> timeRanges = new ArrayList<String>();
            try {
                List<String> legendaryTimings;
                List<String> cobblemonTimeRanges = SpawnDataCollector.collectTimeRangesForSpecies(speciesName, formName);
                if (cobblemonTimeRanges != null) {
                    timeRanges.addAll(cobblemonTimeRanges);
                }
                if ((legendaryTimings = LegendarySpawnHelper.getTimingsForLegendary((String)legendaryKey)) != null) {
                    for (String timing : legendaryTimings) {
                        if (timeRanges.contains(timing)) continue;
                        timeRanges.add(timing);
                    }
                }
            }
            catch (Exception e) {
                CUPokeWiki.LOGGER.error("Error collecting time ranges for {} {}: {}", new Object[]{speciesName, formName, e.getMessage()});
            }
            String normalizedForTranslation = species.getName().toLowerCase().replaceAll("[''\u02bc\u055a\u05f3`\u00b4]", "").replaceAll("\\u0027", "").replaceAll("\\u2019", "").replaceAll("\\u02BC", "");
            String translationKey = "cobblemon.species." + normalizedForTranslation;
            if (normalizedFormName != null && !normalizedFormName.isEmpty()) {
                translationKey = translationKey + "." + normalizedFormName.toLowerCase();
            }
            translationKey = translationKey + ".name";
            String translatedNameFr = TranslationLoader.getFrenchTranslation(translationKey);
            String translatedNameEn = TranslationLoader.getEnglishTranslation(translationKey);
            if ((translatedNameFr == null || translatedNameFr.isEmpty() || translatedNameEn == null || translatedNameEn.isEmpty()) && normalizedFormName != null && !normalizedFormName.isEmpty()) {
                String baseTranslationKey = "cobblemon.species." + normalizedForTranslation + ".name";
                if (translatedNameFr == null || translatedNameFr.isEmpty()) {
                    translatedNameFr = TranslationLoader.getFrenchTranslation(baseTranslationKey);
                }
                if (translatedNameEn == null || translatedNameEn.isEmpty()) {
                    translatedNameEn = TranslationLoader.getEnglishTranslation(baseTranslationKey);
                }
            }
            PokemonSpawnData data = new PokemonSpawnData(speciesName, normalizedFormName, translatedNameFr, translatedNameEn, biomes, eggGroups, abilities, types, species.getNationalPokedexNumber(), description, realBiomesByCategory, moves, drops, evolutions, timeRanges);
            return data;
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error(">>> CRITICAL ERROR: {} {}", (Object)speciesName, (Object)formName);
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, PokemonSpawnData> getServerCache() {
        return serverCache;
    }

    private static long estimateCacheSize() {
        long size = 0L;
        for (Map.Entry<String, PokemonSpawnData> entry : serverCache.entrySet()) {
            size += (long)(entry.getKey().length() * 2);
            PokemonSpawnData data = entry.getValue();
            size += (long)(data.getSpecies().length() * 2);
            size += (long)(data.getForm() != null ? data.getForm().length() * 2 : 0);
            size += (long)(data.getBiomes().size() * 30);
            size += (long)(data.getEggGroups().size() * 20);
            size += (long)(data.getAbilities().size() * 80);
            size += (long)(data.getTypes().size() * 15);
            size += (long)(data.getMoves().size() * 40);
            size += (long)(data.getDrops().size() * 30);
            size += (long)(data.getDescriptionSpawnNonNaturel() != null ? data.getDescriptionSpawnNonNaturel().length() * 2 : 0);
            for (List<String> biomes : data.getRealBiomesByCategory().values()) {
                size += (long)(biomes.size() * 30);
            }
        }
        return size;
    }

    public static void setClientCache(Map<String, PokemonSpawnData> cache) {
        clientCache.clear();
        clientCache.putAll(cache);
    }

    public static Map<String, PokemonSpawnData> getClientCache() {
        return clientCache;
    }

    public static void clearClientCache() {
        clientCache.clear();
    }

    public static String generateKey(String species, String form) {
        String normalizedSpecies = species.toLowerCase().replaceAll("[''\u02bc\u055a\u05f3`\u00b4]", "").replaceAll("\\u0027", "").replaceAll("\\u2019", "").replaceAll("\\u02BC", "");
        if (form == null || form.isEmpty() || form.equalsIgnoreCase("normal")) {
            return normalizedSpecies;
        }
        String normalizedForm = form.toLowerCase().replaceAll("[''\u02bc\u055a\u05f3`\u00b4]", "").replaceAll("\\u0027", "").replaceAll("\\u2019", "").replaceAll("\\u02BC", "");
        return normalizedSpecies + "_" + normalizedForm;
    }

    public static PokemonSpawnData getPokemonData(String searchTerm) {
        String normalized = searchTerm.toLowerCase().trim();
        PokemonSpawnData exact = clientCache.get(normalized.replace(" ", "_"));
        if (exact != null) {
            return exact;
        }
        for (Map.Entry<String, PokemonSpawnData> entry : clientCache.entrySet()) {
            PokemonSpawnData data = entry.getValue();
            String fullName = data.getFullName().toLowerCase();
            if (!fullName.equals(normalized)) continue;
            return data;
        }
        return null;
    }

    public static List<PokemonSpawnData> searchPokemon(String query) {
        String normalized = query.toLowerCase().trim();
        if (normalized.isEmpty()) {
            return new ArrayList<PokemonSpawnData>(clientCache.values());
        }
        return clientCache.values().stream().filter(data -> data.getFullName().toLowerCase().contains(normalized)).sorted(Comparator.comparingInt(PokemonSpawnData::getDexNumber)).collect(Collectors.toList());
    }

    public static List<PokemonSpawnData> getAllPokemonSorted() {
        return clientCache.values().stream().sorted(Comparator.comparingInt(PokemonSpawnData::getDexNumber)).collect(Collectors.toList());
    }

    public static PokemonSpawnData getPreviousPokemon(PokemonSpawnData current) {
        List<PokemonSpawnData> sorted = SpawnDataCache.getAllPokemonSorted();
        int index = sorted.indexOf(current);
        if (index > 0) {
            return sorted.get(index - 1);
        }
        return null;
    }

    public static PokemonSpawnData getNextPokemon(PokemonSpawnData current) {
        List<PokemonSpawnData> sorted = SpawnDataCache.getAllPokemonSorted();
        int index = sorted.indexOf(current);
        if (index >= 0 && index < sorted.size() - 1) {
            return sorted.get(index + 1);
        }
        return null;
    }

    private static List<PokemonSpawnData.MoveData> extractMoves(FormData form) {
        ArrayList<PokemonSpawnData.MoveData> moves = new ArrayList<PokemonSpawnData.MoveData>();
        try {
            Learnset moveset = form.getMoves();
            if (moveset == null) {
                return moves;
            }
            Map levelUpMoves = moveset.getLevelUpMoves();
            for (Map.Entry entry : levelUpMoves.entrySet()) {
                int level = (Integer)entry.getKey();
                List templates = (List)entry.getValue();
                for (MoveTemplate template : templates) {
                    try {
                        String name = template.getName();
                        String type = template.getElementalType() != null ? template.getElementalType().getName().toLowerCase() : "normal";
                        String category = template.getDamageCategory() != null ? template.getDamageCategory().toString().toLowerCase() : "status";
                        int power = (int)template.getPower();
                        int accuracy = (int)template.getAccuracy();
                        int pp = template.getPp();
                        moves.add(new PokemonSpawnData.MoveData(name, type, category, power, accuracy, pp, "level", level));
                    }
                    catch (Exception e) {
                        CUPokeWiki.LOGGER.error("Error extracting level move: {}", (Object)e.getMessage());
                    }
                }
            }
            List tmMoves = moveset.getTmMoves();
            for (MoveTemplate template : tmMoves) {
                try {
                    String name = template.getName();
                    String type = template.getElementalType() != null ? template.getElementalType().getName().toLowerCase() : "normal";
                    String category = template.getDamageCategory() != null ? template.getDamageCategory().toString().toLowerCase() : "status";
                    int power = (int)template.getPower();
                    int accuracy = (int)template.getAccuracy();
                    int pp = template.getPp();
                    moves.add(new PokemonSpawnData.MoveData(name, type, category, power, accuracy, pp, "tm", 0));
                }
                catch (Exception e) {
                    CUPokeWiki.LOGGER.error("Error extracting TM move: {}", (Object)e.getMessage());
                }
            }
            List list = moveset.getEggMoves();
            for (MoveTemplate template : list) {
                try {
                    String name = template.getName();
                    String type = template.getElementalType() != null ? template.getElementalType().getName().toLowerCase() : "normal";
                    String category = template.getDamageCategory() != null ? template.getDamageCategory().toString().toLowerCase() : "status";
                    int power = (int)template.getPower();
                    int accuracy = (int)template.getAccuracy();
                    int pp = template.getPp();
                    moves.add(new PokemonSpawnData.MoveData(name, type, category, power, accuracy, pp, "egg", 0));
                }
                catch (Exception e) {
                    CUPokeWiki.LOGGER.error("Error extracting egg move: {}", (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Error extracting moves: {}", (Object)e.getMessage());
        }
        return moves;
    }

    private static List<PokemonSpawnData.DropData> extractDrops(FormData form) {
        ArrayList<PokemonSpawnData.DropData> drops = new ArrayList<PokemonSpawnData.DropData>();
        try {
            List entries;
            DropTable dropTable = form.getDrops();
            if (dropTable != null && (entries = dropTable.getEntries()) != null) {
                for (DropEntry entry : entries) {
                    try {
                        double percentage;
                        ItemDropEntry itemEntry;
                        class_2960 itemId;
                        if (!(entry instanceof ItemDropEntry) || (itemId = (itemEntry = (ItemDropEntry)entry).getItem()) == null) continue;
                        int minQty = 1;
                        int maxQty = 1;
                        IntRange quantityRange = itemEntry.getQuantityRange();
                        if (quantityRange != null) {
                            minQty = quantityRange.getFirst();
                            maxQty = quantityRange.getLast();
                        } else {
                            minQty = itemEntry.getQuantity();
                            maxQty = itemEntry.getQuantity();
                        }
                        if (!((percentage = (double)itemEntry.getPercentage()) > 0.0)) continue;
                        drops.add(new PokemonSpawnData.DropData(itemId.toString(), minQty, maxQty, percentage, ""));
                    }
                    catch (Exception e) {
                        CUPokeWiki.LOGGER.error("Error extracting drop entry: {}", (Object)e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Error extracting drops: {}", (Object)e.getMessage());
        }
        return drops;
    }

    private static List<PokemonSpawnData.DropData> getAllDrops(String speciesName, List<String> pokemonTypes, FormData form) {
        ArrayList<PokemonSpawnData.DropData> allDrops = new ArrayList<PokemonSpawnData.DropData>();
        allDrops.addAll(SpawnDataCache.extractDrops(form));
        allDrops.addAll(SpawnDataCache.extractTypeDrops(pokemonTypes));
        allDrops.addAll(SpawnDataCache.extractKillDrops(speciesName));
        allDrops.addAll(SpawnDataCache.extractCaptureDrops(speciesName));
        SpawnDataCache.loadSpawnPoolDrops(speciesName, allDrops);
        return allDrops;
    }

    private static void loadSpawnPoolDrops(String speciesName, List<PokemonSpawnData.DropData> allDrops) {
        try {
            Gson gson = new Gson();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String cleanName = speciesName.toLowerCase().replaceAll("[^a-z0-9_]", "");
            Species species = PokemonSpecies.getByName((String)cleanName);
            if (species == null) {
                return;
            }
            String speciesPath = species.getResourceIdentifier().method_12832().toLowerCase();
            int dexNumber = species.getNationalPokedexNumber();
            String filename = String.format("%04d_%s.json", dexNumber, speciesPath);
            try (InputStream stream = classLoader.getResourceAsStream("data/cobblemon/spawn_pool_world/" + filename);){
                if (stream == null) {
                    return;
                }
                String content = new String(stream.readAllBytes());
                SpawnDataCache.processSpawnPoolJson(content, gson, speciesPath, allDrops);
            }
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Error loading spawn pool drops: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    private static String extractDimensionFromSpawn(JsonObject spawn) {
        try {
            JsonObject condition;
            if (spawn.has("condition") && (condition = spawn.getAsJsonObject("condition")).has("biomes")) {
                JsonArray biomes = condition.getAsJsonArray("biomes");
                for (JsonElement biome : biomes) {
                    String biomeStr = biome.getAsString().toLowerCase();
                    if (biomeStr.contains("is_nether") || biomeStr.contains("nether")) {
                        return "Nether";
                    }
                    if (biomeStr.contains("is_end") || biomeStr.contains("end")) {
                        return "End";
                    }
                    if (!biomeStr.contains("is_aether") && !biomeStr.contains("aether")) continue;
                    return "Aether";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    private static void processSpawnPoolJson(String content, Gson gson, String speciesName, List<PokemonSpawnData.DropData> allDrops) {
        try {
            JsonObject root = (JsonObject)gson.fromJson(content, JsonObject.class);
            if (!root.has("spawns")) {
                return;
            }
            JsonArray spawns = root.getAsJsonArray("spawns");
            for (JsonElement spawnElement : spawns) {
                JsonObject drops;
                String expectedName;
                JsonObject spawn = spawnElement.getAsJsonObject();
                if (!spawn.has("pokemon") || !spawn.has("drops")) continue;
                Object pokemonName = spawn.get("pokemon").getAsString().toLowerCase();
                if (!((String)pokemonName).contains(":")) {
                    pokemonName = "cobblemon:" + (String)pokemonName;
                }
                if (!((String)pokemonName).equals(expectedName = "cobblemon:" + speciesName.toLowerCase())) continue;
                String dimension = SpawnDataCache.extractDimensionFromSpawn(spawn);
                if (spawn.has("condition")) {
                    JsonObject jsonObject = spawn.getAsJsonObject("condition");
                }
                if (!(drops = spawn.getAsJsonObject("drops")).has("entries")) continue;
                JsonArray entries = drops.getAsJsonArray("entries");
                for (JsonElement entryElement : entries) {
                    double percentage;
                    JsonObject entry = entryElement.getAsJsonObject();
                    if (!entry.has("item")) continue;
                    Object itemId = entry.get("item").getAsString();
                    if (!((String)itemId).contains(":")) {
                        itemId = "minecraft:" + ((String)itemId).toLowerCase();
                    } else {
                        String[] parts = ((String)itemId).split(":", 2);
                        itemId = parts[0].toLowerCase() + ":" + parts[1].toLowerCase();
                    }
                    int minQty = 1;
                    int maxQty = 1;
                    if (entry.has("quantityRange")) {
                        String range = entry.get("quantityRange").getAsString();
                        String[] rangeParts = range.split("-");
                        minQty = Integer.parseInt(rangeParts[0]);
                        maxQty = Integer.parseInt(rangeParts[1]);
                        percentage = 100.0;
                    } else {
                        if (!entry.has("percentage")) continue;
                        percentage = entry.get("percentage").getAsDouble();
                    }
                    boolean alreadyExists = false;
                    for (PokemonSpawnData.DropData existing : allDrops) {
                        if (!existing.getItemId().equals(itemId) || existing.getMinQuantity() != minQty || existing.getMaxQuantity() != maxQty || !(Math.abs(existing.getPercentage() - percentage) < 0.01)) continue;
                        alreadyExists = true;
                        break;
                    }
                    if (alreadyExists) continue;
                    allDrops.add(new PokemonSpawnData.DropData((String)itemId, minQty, maxQty, percentage, dimension));
                }
            }
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Error processing spawn JSON: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    private static List<PokemonSpawnData.DropData> extractTypeDrops(List<String> pokemonTypes) {
        ArrayList<PokemonSpawnData.DropData> typeDrops = new ArrayList<PokemonSpawnData.DropData>();
        try {
            List entries;
            if (PokemonLootTypesConfig.INSTANCE == null) {
                try {
                    PokemonLootTypesConfig.load();
                    if (PokemonLootTypesConfig.INSTANCE == null) {
                        return typeDrops;
                    }
                }
                catch (Exception loadEx) {
                    return typeDrops;
                }
            }
            if ((entries = PokemonLootTypesConfig.INSTANCE.entries) == null) {
                return typeDrops;
            }
            List pokemonTypesLower = pokemonTypes.stream().map(String::toLowerCase).collect(Collectors.toList());
            for (PokemonLootTypesConfig.LootEntry entry : entries) {
                try {
                    String entryType = entry.type.toLowerCase();
                    if (!pokemonTypesLower.contains(entryType)) continue;
                    double chance = entry.chance;
                    for (String itemId : entry.item) {
                        typeDrops.add(new PokemonSpawnData.DropData(itemId, 1, 1, chance, ""));
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return typeDrops;
    }

    private static List<PokemonSpawnData.DropData> extractKillDrops(String speciesName) {
        ArrayList<PokemonSpawnData.DropData> killDrops = new ArrayList<PokemonSpawnData.DropData>();
        try {
            if (Config.INSTANCE == null) {
                return killDrops;
            }
            List loots = Config.INSTANCE.customLootsKillPokemon;
            if (loots == null) {
                return killDrops;
            }
            for (Config.PokemonLoot loot : loots) {
                try {
                    String pokemon = loot.pokemon.toLowerCase();
                    if (!pokemon.equals(speciesName.toLowerCase())) continue;
                    byte quantity = loot.quantity;
                    double chance = loot.chance * 100.0;
                    for (String itemId : loot.items) {
                        killDrops.add(new PokemonSpawnData.DropData(itemId, quantity, quantity, chance, "Kill"));
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return killDrops;
    }

    private static List<PokemonSpawnData.DropData> extractCaptureDrops(String speciesName) {
        ArrayList<PokemonSpawnData.DropData> captureDrops = new ArrayList<PokemonSpawnData.DropData>();
        try {
            if (Config.INSTANCE == null) {
                return captureDrops;
            }
            List loots = Config.INSTANCE.customLootsCapturePokemon;
            if (loots == null) {
                return captureDrops;
            }
            for (Config.PokemonLoot loot : loots) {
                try {
                    String pokemon = loot.pokemon.toLowerCase();
                    if (!pokemon.equals(speciesName.toLowerCase())) continue;
                    byte quantity = loot.quantity;
                    double chance = loot.chance * 100.0;
                    for (String itemId : loot.items) {
                        captureDrops.add(new PokemonSpawnData.DropData(itemId, quantity, quantity, chance, "Capture"));
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return captureDrops;
    }

    private static List<PokemonSpawnData.EvolutionData> extractEvolutions(Species species) {
        return SpawnDataCache.extractEvolutions(species, null, null);
    }

    private static List<PokemonSpawnData.EvolutionData> extractEvolutions(Species species, String currentFormName) {
        return SpawnDataCache.extractEvolutions(species, currentFormName, null);
    }

    private static List<PokemonSpawnData.EvolutionData> extractEvolutions(Species species, String currentFormName, FormData currentForm) {
        ArrayList<PokemonSpawnData.EvolutionData> evolutions = new ArrayList<PokemonSpawnData.EvolutionData>();
        try {
            Set evolutionChain = null;
            if (currentForm != null) {
                try {
                    evolutionChain = currentForm.getEvolutions();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (evolutionChain == null || evolutionChain instanceof Collection && ((Collection)evolutionChain).isEmpty()) {
                evolutionChain = species.getEvolutions();
            }
            if (evolutionChain == null) {
                return evolutions;
            }
            for (Object evolutionObj : evolutionChain) {
                try {
                    String evolvedForm;
                    String evolvedSpeciesName;
                    String condition;
                    block28: {
                        condition = SpawnDataCache.extractEvolutionCondition(evolutionObj);
                        Object result = evolutionObj.getClass().getMethod("getResult", new Class[0]).invoke(evolutionObj, new Object[0]);
                        evolvedSpeciesName = (String)result.getClass().getMethod("getSpecies", new Class[0]).invoke(result, new Object[0]);
                        Object aspects = result.getClass().getMethod("getAspects", new Class[0]).invoke(result, new Object[0]);
                        evolvedForm = null;
                        try {
                            if (!(aspects instanceof Iterable)) break block28;
                            for (Object aspect : (Iterable)aspects) {
                                if (aspect == null) continue;
                                String aspectStr = aspect.toString().toLowerCase();
                                if (aspectStr.contains("alola")) {
                                    evolvedForm = "alolan";
                                } else if (aspectStr.contains("galar")) {
                                    evolvedForm = "galarian";
                                } else if (aspectStr.contains("hisui")) {
                                    evolvedForm = "hisuian";
                                } else {
                                    if (!aspectStr.contains("paldea")) continue;
                                    evolvedForm = "paldean";
                                }
                                break;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    boolean matchesForm = true;
                    if (currentFormName != null && !currentFormName.isEmpty()) {
                        String evolvedNorm;
                        String currentNorm = currentFormName.toLowerCase().replace("-", "").replace("bias", "").trim();
                        String string = evolvedNorm = evolvedForm != null ? evolvedForm.toLowerCase().replace("-", "").replace("bias", "").trim() : "";
                        if (currentNorm.contains("alola")) {
                            matchesForm = evolvedForm == null || evolvedNorm.contains("alola");
                        } else if (currentNorm.contains("galar")) {
                            matchesForm = evolvedForm == null || evolvedNorm.contains("galar");
                        } else if (currentNorm.contains("hisui")) {
                            matchesForm = evolvedForm == null || evolvedNorm.contains("hisui");
                        } else if (currentNorm.contains("paldea")) {
                            matchesForm = evolvedForm == null || evolvedNorm.contains("paldea");
                        } else {
                            boolean bl = matchesForm = evolvedForm == null || !evolvedNorm.contains("alola") && !evolvedNorm.contains("galar") && !evolvedNorm.contains("hisui") && !evolvedNorm.contains("paldea");
                        }
                    }
                    if (!matchesForm) continue;
                    evolutions.add(new PokemonSpawnData.EvolutionData(evolvedSpeciesName, evolvedForm, condition));
                }
                catch (Exception e) {
                    CUPokeWiki.LOGGER.error("Error extracting evolution for {}: {}", (Object)species.getName(), (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Error extracting evolutions for {}: {}", (Object)species.getName(), (Object)e.getMessage());
        }
        return evolutions;
    }

    private static String extractEvolutionCondition(Object evolution) {
        ArrayList<Object> conditions = new ArrayList<Object>();
        try {
            Object requirements;
            String evolutionClass = evolution.getClass().getSimpleName();
            if (evolutionClass.contains("Trade")) {
                conditions.add("\u00c9change");
            }
            if (evolutionClass.contains("ItemInteraction")) {
                try {
                    Object itemId;
                    Object context = evolution.getClass().getMethod("getRequiredContext", new Class[0]).invoke(evolution, new Object[0]);
                    if (context != null && (itemId = SpawnDataCache.extractItemFromContext(context)) != null) {
                        if (!((String)itemId).contains(":")) {
                            itemId = "cobblemon:" + (String)itemId;
                        }
                        conditions.add("ITEM:" + (String)itemId);
                    }
                }
                catch (Exception e) {
                    CUPokeWiki.LOGGER.warn("Failed to extract item from ItemInteraction: {}", (Object)e.getMessage());
                }
            }
            if ((requirements = evolution.getClass().getMethod("getRequirements", new Class[0]).invoke(evolution, new Object[0])) != null && requirements instanceof Collection) {
                for (Object req : (Collection)requirements) {
                    String extracted = SpawnDataCache.extractRequirement(req);
                    if (extracted == null || extracted.isEmpty()) continue;
                    conditions.add(extracted);
                }
            }
            if (conditions.isEmpty()) {
                CUPokeWiki.LOGGER.warn("Unknown evolution condition for type: {}", (Object)evolutionClass);
                return "???";
            }
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Error extracting evolution condition: {}", (Object)e.getMessage());
        }
        return conditions.isEmpty() ? "???" : String.join((CharSequence)" | ", conditions);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String extractRequirement(Object req) {
        if (req == null) {
            return null;
        }
        String reqClass = req.getClass().getSimpleName();
        try {
            String allMethods;
            if (reqClass.contains("Level")) {
                try {
                    int level = (Integer)req.getClass().getMethod("getMinLevel", new Class[0]).invoke(req, new Object[0]);
                    return "Niveau " + level;
                }
                catch (Exception e) {
                    return "REQ:Level:" + SpawnDataCache.getAllMethodsAsString(req);
                }
            }
            if (reqClass.contains("Trade")) {
                return "\u00c9change";
            }
            if (reqClass.contains("Friendship")) {
                try {
                    int amount = (Integer)req.getClass().getMethod("getAmount", new Class[0]).invoke(req, new Object[0]);
                    return "Bonheur " + amount;
                }
                catch (Exception e) {
                    return "Bonheur";
                }
            }
            if (reqClass.contains("Time")) {
                try {
                    int rangeCount;
                    Object range = req.getClass().getMethod("getRange", new Class[0]).invoke(req, new Object[0]);
                    if (range == null) return "Heure sp\u00e9cifique";
                    String methodsStr = SpawnDataCache.getAllMethodsAsString(range);
                    if (!methodsStr.contains("Ranges=")) return "Heure sp\u00e9cifique";
                    String rangesStr = methodsStr.substring(methodsStr.indexOf("Ranges=") + 7);
                    if (rangesStr.contains("]")) {
                        rangesStr = rangesStr.substring(0, rangesStr.indexOf("]"));
                    }
                    if ((rangeCount = (rangesStr.length() - rangesStr.replace("..", "").length()) / 2) >= 2) {
                        return "Jour";
                    }
                    if (rangeCount != 1) return "Heure sp\u00e9cifique";
                    return "Nuit";
                }
                catch (Exception range) {
                    // empty catch block
                }
                return "Heure sp\u00e9cifique";
            }
            if (reqClass.contains("MoonPhase") || reqClass.contains("Moon")) {
                try {
                    Object phase = req.getClass().getMethod("getMoonPhase", new Class[0]).invoke(req, new Object[0]);
                    if (phase == null) return "Phase lunaire sp\u00e9cifique";
                    String phaseStr = phase.toString().toUpperCase();
                    if (phaseStr.contains("FULL")) {
                        return "Pleine lune";
                    }
                    if (phaseStr.contains("NEW")) {
                        return "Nouvelle lune";
                    }
                    if (phaseStr.contains("FIRST")) {
                        return "Premier quartier";
                    }
                    if (!phaseStr.contains("LAST")) return "Phase lunaire sp\u00e9cifique";
                    return "Dernier quartier";
                }
                catch (Exception phase) {
                    // empty catch block
                }
                return "Phase lunaire sp\u00e9cifique";
            }
            if (reqClass.contains("MoveType")) {
                try {
                    Object typeObj = req.getClass().getMethod("getType", new Class[0]).invoke(req, new Object[0]);
                    if (typeObj != null) {
                        String typeName = typeObj.toString();
                        if (!typeName.contains("ElementalType")) return "MOVETYPE:" + typeName.toLowerCase();
                        try {
                            Object nameObj = typeObj.getClass().getMethod("getName", new Class[0]).invoke(typeObj, new Object[0]);
                            typeName = nameObj.toString();
                            return "MOVETYPE:" + typeName.toLowerCase();
                        }
                        catch (Exception nameObj) {
                            // empty catch block
                        }
                        return "MOVETYPE:" + typeName.toLowerCase();
                    }
                }
                catch (Exception typeObj) {
                    // empty catch block
                }
            }
            if (reqClass.contains("HeldItem")) {
                try {
                    Pattern pattern;
                    Matcher matcher;
                    int equalPos;
                    Pattern pattern2;
                    Method[] matcher2;
                    Object itemCondition = req.getClass().getMethod("getItemCondition", new Class[0]).invoke(req, new Object[0]);
                    if (itemCondition == null) return "Tient un objet";
                    String itemStr = itemCondition.toString();
                    if (itemStr.contains("]=") && (matcher2 = (pattern2 = Pattern.compile("\\]=((?:cobblemon|minecraft):[a-z0-9_]+)")).matcher(itemStr)).find()) {
                        return "ITEM:" + matcher2.group(1);
                    }
                    if ((itemStr.contains("cobblemon:") || itemStr.contains("minecraft:")) && (matcher2 = (pattern2 = Pattern.compile("((?:cobblemon|minecraft):[a-z0-9_]+)")).matcher(itemStr)).find()) {
                        return "ITEM:" + matcher2.group(1);
                    }
                    String[] itemData = null;
                    for (Method method : itemCondition.getClass().getMethods()) {
                        if (method.getParameterCount() != 0 || method.getName().equals("toString") || method.getName().equals("hashCode") || method.getName().equals("getClass")) continue;
                        try {
                            String[] result = method.invoke(itemCondition, new Object[0]);
                            if (result == null) continue;
                            String resultStr = result.toString();
                            if (resultStr.contains("ResourceKey[") && resultStr.contains("]=")) {
                                itemData = result;
                                break;
                            }
                            if (!resultStr.contains("minecraft:") && !resultStr.contains("cobblemon:") && !resultStr.contains("Tag=TagKey[")) continue;
                            itemData = result;
                            break;
                        }
                        catch (Exception result) {
                            // empty catch block
                        }
                    }
                    if (itemData == null) return "Tient un objet";
                    String itemDataStr = itemData.toString();
                    if (itemDataStr.contains("ResourceKey[") && itemDataStr.contains("]=") && (equalPos = itemDataStr.lastIndexOf("]=")) > 0) {
                        int start = equalPos + 2;
                        int end = itemDataStr.length();
                        for (String sep : new String[]{"}", "]"}) {
                            int sepIdx = itemDataStr.indexOf(sep, start);
                            if (sepIdx <= start || sepIdx >= end) continue;
                            end = sepIdx;
                        }
                        String itemId = itemDataStr.substring(start, end).trim();
                        if (itemId.contains(":")) {
                            return "ITEM:" + itemId;
                        }
                    }
                    if ((itemDataStr.contains("minecraft:") || itemDataStr.contains("cobblemon:")) && (matcher = (pattern = Pattern.compile("((?:cobblemon|minecraft):[a-z0-9_]+)")).matcher(itemDataStr)).find()) {
                        String itemId = matcher.group(1);
                        return "ITEM:" + itemId;
                    }
                    if (!itemDataStr.contains("Tag=TagKey[")) return "Tient un objet";
                    int tagStart = itemDataStr.indexOf("Tag=TagKey[") + 11;
                    int tagEnd = itemDataStr.indexOf("]", tagStart);
                    if (tagEnd <= tagStart) return "Tient un objet";
                    String tagContent = itemDataStr.substring(tagStart, tagEnd);
                    if (!tagContent.contains("/")) return "Tient un objet";
                    String[] parts = tagContent.split("/");
                    Object itemId = parts[parts.length - 1].trim();
                    if (((String)itemId).contains(":")) return "ITEM:" + (String)itemId;
                    itemId = "cobblemon:" + (String)itemId;
                    return "ITEM:" + (String)itemId;
                }
                catch (Exception e) {
                    CUPokeWiki.LOGGER.error("Error parsing HeldItemRequirement: {}", (Object)e.getMessage());
                    return "Tient un objet";
                }
            }
            if (reqClass.contains("Biome")) {
                try {
                    Object biomeCondition = req.getClass().getMethod("getBiomeCondition", new Class[0]).invoke(req, new Object[0]);
                    Object biomeAnticondition = req.getClass().getMethod("getBiomeAnticondition", new Class[0]).invoke(req, new Object[0]);
                    Object targetCondition = null;
                    boolean isAnti = false;
                    if (biomeCondition != null) {
                        targetCondition = biomeCondition;
                    } else if (biomeAnticondition != null) {
                        targetCondition = biomeAnticondition;
                        isAnti = true;
                    }
                    if (targetCondition == null) return "Biome sp\u00e9cifique";
                    try {
                        String tagStr;
                        Object tagObj = targetCondition.getClass().getMethod("tag", new Class[0]).invoke(targetCondition, new Object[0]);
                        if (tagObj != null && (tagStr = tagObj.toString()).contains(" / ")) {
                            String tagId = tagStr.substring(tagStr.indexOf(" / ") + 3);
                            if (tagId.contains("]")) {
                                tagId = tagId.substring(0, tagId.indexOf("]"));
                            }
                            String biomesStr = SpawnDataCache.resolveBiomeTag(tagId);
                            if (!isAnti) return "BIOME:" + biomesStr;
                            return "BIOME_ANTI:" + biomesStr;
                        }
                    }
                    catch (Exception tagObj) {
                        // empty catch block
                    }
                    String methodsStr = SpawnDataCache.getAllMethodsAsString(targetCondition);
                    if (!methodsStr.contains("Tag=TagKey[")) return "Biome sp\u00e9cifique";
                    if (!methodsStr.contains(" / ")) return "Biome sp\u00e9cifique";
                    String tagPart = methodsStr.substring(methodsStr.indexOf(" / ") + 3);
                    if (tagPart.contains("]")) {
                        tagPart = tagPart.substring(0, tagPart.indexOf("]"));
                    }
                    String biomesStr = SpawnDataCache.resolveBiomeTag(tagPart);
                    if (!isAnti) return "BIOME:" + biomesStr;
                    return "BIOME_ANTI:" + biomesStr;
                }
                catch (Exception biomeCondition) {
                    // empty catch block
                }
                return "Biome sp\u00e9cifique";
            }
            if (reqClass.contains("Weather")) {
                try {
                    allMethods = SpawnDataCache.getAllMethodsAsString(req);
                    Field[] biomeAnticondition = req.getClass().getDeclaredFields();
                    int targetCondition = biomeAnticondition.length;
                    int isAnti = 0;
                    while (isAnti < targetCondition) {
                        Field field = biomeAnticondition[isAnti];
                        field.setAccessible(true);
                        try {
                            Object value = field.get(req);
                            String fieldName = field.getName().toLowerCase();
                            if (value != null && value.toString().equals("true")) {
                                if (fieldName.contains("raining")) return "M\u00e9t\u00e9o: Pluie";
                                if (fieldName.contains("rain")) {
                                    return "M\u00e9t\u00e9o: Pluie";
                                }
                                if (fieldName.contains("thundering")) return "M\u00e9t\u00e9o: Orage";
                                if (fieldName.contains("thunder")) return "M\u00e9t\u00e9o: Orage";
                                if (fieldName.contains("storm")) {
                                    return "M\u00e9t\u00e9o: Orage";
                                }
                                if (fieldName.contains("snowing")) return "M\u00e9t\u00e9o: Neige";
                                if (fieldName.contains("snow")) {
                                    return "M\u00e9t\u00e9o: Neige";
                                }
                            }
                            if (value != null && value.toString().equals("false")) {
                                if (fieldName.contains("raining")) return "M\u00e9t\u00e9o: Beau temps";
                                if (fieldName.contains("rain")) {
                                    return "M\u00e9t\u00e9o: Beau temps";
                                }
                            }
                        }
                        catch (Exception value) {
                            // empty catch block
                        }
                        ++isAnti;
                    }
                    return "M\u00e9t\u00e9o sp\u00e9cifique";
                }
                catch (Exception e) {
                    CUPokeWiki.LOGGER.error("Error parsing WeatherRequirement: {}", (Object)e.getMessage());
                    return "M\u00e9t\u00e9o sp\u00e9cifique";
                }
            }
            if (reqClass.contains("Move") && !reqClass.contains("MoveType")) {
                try {
                    int end;
                    String moveStr;
                    Object move = req.getClass().getMethod("getMove", new Class[0]).invoke(req, new Object[0]);
                    if (move == null) return "Capacit\u00e9 sp\u00e9cifique";
                    String moveName = null;
                    try {
                        Object nameObj = move.getClass().getMethod("getName", new Class[0]).invoke(move, new Object[0]);
                        if (nameObj != null) {
                            moveName = nameObj.toString();
                        }
                    }
                    catch (Exception nameObj) {
                        // empty catch block
                    }
                    if ((moveName == null || moveName.contains("@")) && (moveStr = move.toString()).contains("(") && moveStr.contains(")")) {
                        int start = moveStr.indexOf("(") + 1;
                        end = moveStr.indexOf(")", start);
                        if (start > 0 && end > start) {
                            moveName = moveStr.substring(start, end);
                        }
                    }
                    if (moveName == null || moveName.contains("@")) {
                        try {
                            Object idObj = move.getClass().getMethod("getIdentifier", new Class[0]).invoke(move, new Object[0]);
                            if (idObj != null) {
                                String idStr = idObj.toString();
                                moveName = idStr.contains(":") ? idStr.substring(idStr.lastIndexOf(":") + 1) : idStr;
                            }
                        }
                        catch (Exception idObj) {
                            // empty catch block
                        }
                    }
                    if (moveName == null || moveName.contains("@")) {
                        String allMethods2 = SpawnDataCache.getAllMethodsAsString(move);
                        if (allMethods2.contains("Name=")) {
                            int start = allMethods2.indexOf("Name=") + 5;
                            end = allMethods2.indexOf(",", start);
                            if (end == -1) {
                                end = allMethods2.length();
                            }
                            moveName = allMethods2.substring(start, end);
                        } else if (allMethods2.contains("Identifier=")) {
                            String idStr;
                            int start = allMethods2.indexOf("Identifier=") + 11;
                            end = allMethods2.indexOf(",", start);
                            if (end == -1) {
                                end = allMethods2.length();
                            }
                            moveName = (idStr = allMethods2.substring(start, end)).contains(":") ? idStr.substring(idStr.lastIndexOf(":") + 1) : idStr;
                        }
                    }
                    if (moveName == null) return "Capacit\u00e9 sp\u00e9cifique";
                    if (moveName.contains("@")) return "Capacit\u00e9 sp\u00e9cifique";
                    return "Capacit\u00e9: " + moveName;
                }
                catch (Exception move) {
                    // empty catch block
                }
                return "Capacit\u00e9 sp\u00e9cifique";
            }
            if (reqClass.contains("Party")) {
                return "REQ:Party:" + SpawnDataCache.getAllMethodsAsString(req);
            }
            if (reqClass.contains("Gender")) {
                try {
                    Object gender = req.getClass().getMethod("getGender", new Class[0]).invoke(req, new Object[0]);
                    if (gender != null) {
                        String g = gender.toString().toLowerCase();
                        if (g.contains("male") && !g.contains("female")) {
                            return "M\u00e2le";
                        }
                        if (!g.contains("female")) return "Genre: " + gender.toString();
                        return "Femelle";
                    }
                }
                catch (Exception e) {
                    return "REQ:Gender:" + SpawnDataCache.getAllMethodsAsString(req);
                }
            }
            if (reqClass.contains("Battle") || reqClass.contains("Defeat") || reqClass.contains("Recoil")) {
                try {
                    int start;
                    int end;
                    String searchStr;
                    block168: {
                        allMethods = SpawnDataCache.getAllMethodsAsString(req);
                        if (reqClass.contains("Critical") || allMethods.contains("Critical")) {
                            try {
                                int crits;
                                Object amountObj = req.getClass().getMethod("getAmount", new Class[0]).invoke(req, new Object[0]);
                                if (amountObj != null && (crits = ((Integer)amountObj).intValue()) > 0) {
                                    String string;
                                    String string2 = crits > 1 ? "s" : "";
                                    if (crits > 1) {
                                        string = "s";
                                        return "Apr\u00e8s combat avec " + crits + " coup" + string2 + " critique" + string;
                                    }
                                    string = "";
                                    return "Apr\u00e8s combat avec " + crits + " coup" + string2 + " critique" + string;
                                }
                            }
                            catch (Exception e) {
                                if (!allMethods.contains("Amount=") && !allMethods.contains("amount=")) break block168;
                                String searchStr2 = allMethods.contains("Amount=") ? "Amount=" : "amount=";
                                int start2 = allMethods.indexOf(searchStr2) + searchStr2.length();
                                int end2 = allMethods.indexOf(",", start2);
                                if (end2 == -1) {
                                    end2 = allMethods.indexOf(")", start2);
                                }
                                if (end2 == -1) {
                                    end2 = allMethods.indexOf("}", start2);
                                }
                                if (end2 <= start2) break block168;
                                String critsStr = allMethods.substring(start2, end2).trim();
                                try {
                                    int crits = Integer.parseInt(critsStr);
                                    if (crits > 0) {
                                        String string;
                                        String string3 = crits > 1 ? "s" : "";
                                        if (crits > 1) {
                                            string = "s";
                                            return "Apr\u00e8s combat avec " + crits + " coup" + string3 + " critique" + string;
                                        }
                                        string = "";
                                        return "Apr\u00e8s combat avec " + crits + " coup" + string3 + " critique" + string;
                                    }
                                }
                                catch (NumberFormatException crits) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    if (allMethods.contains("BattlesRemaining=") || allMethods.contains("battlesRemaining=")) {
                        searchStr = allMethods.contains("BattlesRemaining=") ? "BattlesRemaining=" : "battlesRemaining=";
                        int start3 = allMethods.indexOf(searchStr) + searchStr.length();
                        end = allMethods.indexOf(",", start3);
                        if (end == -1) {
                            end = allMethods.indexOf(")", start3);
                        }
                        if (end == -1) {
                            end = allMethods.indexOf("}", start3);
                        }
                        if (end > start3) {
                            String battlesStr = allMethods.substring(start3, end).trim();
                            try {
                                int battles = Integer.parseInt(battlesStr);
                                if (battles > 0) {
                                    String string;
                                    if (battles > 1) {
                                        string = "s";
                                        return "Apr\u00e8s " + battles + " victoire" + string;
                                    }
                                    string = "";
                                    return "Apr\u00e8s " + battles + " victoire" + string;
                                }
                            }
                            catch (NumberFormatException battles) {
                                // empty catch block
                            }
                        }
                    }
                    if (!reqClass.contains("Recoil")) return "Apr\u00e8s combat";
                    if (!allMethods.contains("Damage=")) {
                        if (!allMethods.contains("damage=")) return "Apr\u00e8s d\u00e9g\u00e2ts de recul";
                    }
                    if ((end = allMethods.indexOf(",", start = allMethods.indexOf(searchStr = allMethods.contains("Damage=") ? "Damage=" : "damage=") + searchStr.length())) == -1) {
                        end = allMethods.indexOf(")", start);
                    }
                    if (end <= start) return "Apr\u00e8s d\u00e9g\u00e2ts de recul";
                    String damageStr = allMethods.substring(start, end).trim();
                    return "Apr\u00e8s " + damageStr + " PV de recul subis";
                }
                catch (Exception e) {
                    CUPokeWiki.LOGGER.error("Error parsing BattleRequirement: {}", (Object)e.getMessage());
                }
                return "Apr\u00e8s combat";
            }
            if (reqClass.contains("Stat")) {
                try {
                    String stat2Display;
                    allMethods = SpawnDataCache.getAllMethodsAsString(req);
                    String stat1 = null;
                    String stat2 = null;
                    String comparison = "=";
                    boolean hasLowStat = allMethods.contains("LowStat=");
                    boolean hasHighStat = allMethods.contains("HighStat=");
                    boolean hasStatOne = allMethods.contains("StatOne=");
                    boolean hasStatTwo = allMethods.contains("StatTwo=");
                    if (hasLowStat && hasHighStat) {
                        comparison = ">";
                        start = allMethods.indexOf("LowStat=") + 8;
                        end = allMethods.indexOf(",", start);
                        if (end == -1) {
                            end = allMethods.length();
                        }
                        stat1 = allMethods.substring(start, end).toLowerCase();
                        start = allMethods.indexOf("HighStat=") + 9;
                        end = allMethods.indexOf(",", start);
                        if (end == -1) {
                            end = allMethods.length();
                        }
                        stat2 = allMethods.substring(start, end).toLowerCase();
                    } else if (hasStatOne && hasStatTwo) {
                        comparison = "=";
                        start = allMethods.indexOf("StatOne=") + 8;
                        end = allMethods.indexOf(",", start);
                        if (end == -1) {
                            end = allMethods.length();
                        }
                        stat1 = allMethods.substring(start, end).toLowerCase();
                        start = allMethods.indexOf("StatTwo=") + 8;
                        end = allMethods.indexOf(",", start);
                        if (end == -1) {
                            end = allMethods.length();
                        }
                        stat2 = allMethods.substring(start, end).toLowerCase();
                    }
                    String stat1Display = stat1 != null ? SpawnDataCache.translateStat(stat1) : "stat1";
                    String string = stat2Display = stat2 != null ? SpawnDataCache.translateStat(stat2) : "stat2";
                    if (stat1 != null && stat2 != null) {
                        return stat1Display + " " + comparison + " " + stat2Display;
                    }
                    if (stat1 == null) return "Stats sp\u00e9cifiques";
                    return "Stat: " + stat1Display;
                }
                catch (Exception allMethods3) {
                    return "Stats sp\u00e9cifiques";
                }
            }
            if (reqClass.contains("Structure")) {
                try {
                    String structureName = null;
                    try {
                        Object structureObj = req.getClass().getMethod("getStructure", new Class[0]).invoke(req, new Object[0]);
                        if (structureObj != null) {
                            structureName = structureObj.toString();
                        }
                    }
                    catch (Exception structureObj) {
                        // empty catch block
                    }
                    if (structureName == null || structureName.contains("@")) {
                        try {
                            Object idObj = req.getClass().getMethod("getIdentifier", new Class[0]).invoke(req, new Object[0]);
                            if (idObj != null) {
                                structureName = idObj.toString();
                            }
                        }
                        catch (Exception e) {
                            try {
                                Object idObj = req.getClass().getMethod("getId", new Class[0]).invoke(req, new Object[0]);
                                if (idObj != null) {
                                    structureName = idObj.toString();
                                }
                            }
                            catch (Exception idObj) {
                                // empty catch block
                            }
                        }
                    }
                    if (structureName == null || structureName.contains("@")) {
                        String allMethods4 = SpawnDataCache.getAllMethodsAsString(req);
                        if (allMethods4.contains("Structure=")) {
                            int start = allMethods4.indexOf("Structure=") + 10;
                            int end = allMethods4.indexOf(",", start);
                            if (end == -1) {
                                end = allMethods4.length();
                            }
                            structureName = allMethods4.substring(start, end);
                        } else if (allMethods4.contains("Identifier=")) {
                            int start = allMethods4.indexOf("Identifier=") + 11;
                            int end = allMethods4.indexOf(",", start);
                            if (end == -1) {
                                end = allMethods4.length();
                            }
                            structureName = allMethods4.substring(start, end);
                        }
                    }
                    if (structureName == null) return "Dans une structure";
                    if (structureName.contains("@")) return "Dans une structure";
                    if (structureName.contains(":")) {
                        structureName = structureName.substring(structureName.lastIndexOf(":") + 1);
                    }
                    if (!structureName.contains("_")) return "Structure: " + structureName;
                    structureName = structureName.replace("_", " ");
                    return "Structure: " + structureName;
                }
                catch (Exception structureName) {
                    // empty catch block
                }
                return "Dans une structure";
            }
            if (reqClass.contains("Properties") || reqClass.contains("PokemonProperties")) {
                try {
                    allMethods = SpawnDataCache.getAllMethodsAsString(req);
                    Object target = req.getClass().getMethod("getTarget", new Class[0]).invoke(req, new Object[0]);
                    if (target == null) return "Propri\u00e9t\u00e9s sp\u00e9cifiques";
                    String targetMethods = SpawnDataCache.getAllMethodsAsString(target);
                    for (Field field : target.getClass().getDeclaredFields()) {
                        field.setAccessible(true);
                        try {
                            Object object = field.get(target);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (targetMethods.contains("Gender=FEMALE")) return "Doit \u00eatre femelle";
                    if (targetMethods.contains("gender=female")) return "Doit \u00eatre femelle";
                    if (targetMethods.contains("Aspects=[female]")) {
                        return "Doit \u00eatre femelle";
                    }
                    if ((targetMethods.contains("Gender=MALE") || targetMethods.contains("gender=male") || targetMethods.contains("Aspects=[male]")) && !targetMethods.contains("FEMALE") && !targetMethods.contains("female")) {
                        return "Doit \u00eatre m\u00e2le";
                    }
                    if (targetMethods.contains("shiny=true")) return "Doit \u00eatre shiny";
                    if (targetMethods.contains("Shiny=true")) {
                        return "Doit \u00eatre shiny";
                    }
                    if (!targetMethods.contains("OriginalString=")) return "Propri\u00e9t\u00e9s sp\u00e9cifiques";
                    int start = targetMethods.indexOf("OriginalString=") + 15;
                    int end = targetMethods.indexOf(",", start);
                    if (end == -1) {
                        end = targetMethods.length();
                    }
                    String originalStr = targetMethods.substring(start, end);
                    return "Propri\u00e9t\u00e9: " + originalStr;
                }
                catch (Exception e) {
                    CUPokeWiki.LOGGER.error("Error parsing PropertiesRequirement: {}", (Object)e.getMessage());
                    return "Propri\u00e9t\u00e9s sp\u00e9cifiques";
                }
            }
            if (!reqClass.contains("Advancement")) {
                if (!reqClass.contains("PlayerHas")) return "REQ:" + reqClass + ":" + SpawnDataCache.getAllMethodsAsString(req);
            }
            try {
                String advancementName = null;
                try {
                    Object advancementObj = req.getClass().getMethod("getAdvancement", new Class[0]).invoke(req, new Object[0]);
                    if (advancementObj != null) {
                        advancementName = advancementObj.toString();
                    }
                }
                catch (Exception e) {
                    try {
                        Object idObj = req.getClass().getMethod("getIdentifier", new Class[0]).invoke(req, new Object[0]);
                        if (idObj != null) {
                            advancementName = idObj.toString();
                        }
                    }
                    catch (Exception idObj) {
                        // empty catch block
                    }
                }
                if (advancementName == null || advancementName.contains("@")) {
                    String allMethods5 = SpawnDataCache.getAllMethodsAsString(req);
                    if (allMethods5.contains("Advancement=")) {
                        int start = allMethods5.indexOf("Advancement=") + 12;
                        int end = allMethods5.indexOf(",", start);
                        if (end == -1) {
                            end = allMethods5.length();
                        }
                        advancementName = allMethods5.substring(start, end);
                    } else if (allMethods5.contains("Identifier=")) {
                        int start = allMethods5.indexOf("Identifier=") + 11;
                        int end = allMethods5.indexOf(",", start);
                        if (end == -1) {
                            end = allMethods5.length();
                        }
                        advancementName = allMethods5.substring(start, end);
                    }
                }
                if (advancementName == null) return "Avec progr\u00e8s sp\u00e9cial";
                if (advancementName.contains("@")) return "Avec progr\u00e8s sp\u00e9cial";
                if (advancementName.contains(":")) {
                    advancementName = advancementName.substring(advancementName.lastIndexOf(":") + 1);
                }
                if (!advancementName.contains("_")) return "Progr\u00e8s: " + advancementName;
                advancementName = advancementName.replace("_", " ");
                return "Progr\u00e8s: " + advancementName;
            }
            catch (Exception advancementName) {
                // empty catch block
            }
            return "Avec progr\u00e8s sp\u00e9cial";
        }
        catch (Exception e) {
            return "REQ:" + reqClass + ":ERROR";
        }
    }

    private static String extractItemFromContext(Object context) {
        try {
            Pattern pattern;
            Matcher matcher;
            for (String methodName : new String[]{"getItem", "item", "getItemStack", "itemStack"}) {
                try {
                    Method method = context.getClass().getMethod(methodName, new Class[0]);
                    Object itemObj = method.invoke(context, new Object[0]);
                    if (itemObj == null) continue;
                    String itemStr = itemObj.toString();
                    if (itemStr.contains("]=") && (matcher = (pattern = Pattern.compile("\\]=((?:cobblemon|minecraft):[a-z0-9_]+)")).matcher(itemStr)).find()) {
                        String result = matcher.group(1);
                        return result;
                    }
                    if (!itemStr.contains("cobblemon:") && !itemStr.contains("minecraft:") || !(matcher = (pattern = Pattern.compile("((?:cobblemon|minecraft):[a-z0-9_]+)")).matcher(itemStr)).find()) continue;
                    String result = matcher.group(1);
                    return result;
                }
                catch (Exception method) {
                    // empty catch block
                }
            }
            for (Class<?> clazz = context.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    field.setAccessible(true);
                    Object value = field.get(context);
                    if (value == null) continue;
                    String valueStr = value.toString();
                    if (valueStr.contains("]=") && (matcher = (pattern = Pattern.compile("\\]=((?:cobblemon|minecraft):[a-z0-9_]+)")).matcher(valueStr)).find()) {
                        String result = matcher.group(1);
                        return result;
                    }
                    if ((valueStr.contains("cobblemon:") || valueStr.contains("minecraft:")) && (matcher = (pattern = Pattern.compile("((?:cobblemon|minecraft):[a-z0-9_]+)")).matcher(valueStr)).find()) {
                        String result = matcher.group(1);
                        return result;
                    }
                    String itemId = SpawnDataCache.extractItemFromMethods(value);
                    if (itemId == null) continue;
                    return itemId;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String extractItemFromMethods(Object obj) {
        try {
            Pattern pattern;
            Matcher matcher;
            String objString = obj.toString();
            if (objString.contains("]=") && (matcher = (pattern = Pattern.compile("\\]=((?:cobblemon|minecraft):[a-z0-9_]+)")).matcher(objString)).find()) {
                String result = matcher.group(1);
                return result;
            }
            if ((objString.contains("cobblemon:") || objString.contains("minecraft:")) && (matcher = (pattern = Pattern.compile("((?:cobblemon|minecraft):[a-z0-9_]+)")).matcher(objString)).find()) {
                String result = matcher.group(1);
                return result;
            }
            for (Method method : obj.getClass().getMethods()) {
                if (method.getParameterCount() != 0 || method.getName().equals("toString")) continue;
                try {
                    Pattern pattern2;
                    Matcher matcher2;
                    Object result = method.invoke(obj, new Object[0]);
                    if (result == null) continue;
                    String str = result.toString();
                    if (str.contains("]=") && (matcher2 = (pattern2 = Pattern.compile("\\]=((?:cobblemon|minecraft):[a-z0-9_]+)")).matcher(str)).find()) {
                        String itemResult = matcher2.group(1);
                        return itemResult;
                    }
                    if ((str.contains("cobblemon:") || str.contains("minecraft:")) && (matcher2 = (pattern2 = Pattern.compile("((?:cobblemon|minecraft):[a-z0-9_]+)")).matcher(str)).find()) {
                        return matcher2.group(1);
                    }
                    if (!str.matches(".*[a-z]+:[a-z0-9_]+.*") || !(matcher2 = (pattern2 = Pattern.compile("([a-z]+:[a-z0-9_]+)")).matcher(str)).find()) continue;
                    Object itemId = matcher2.group(1);
                    if (!((String)itemId).contains(":")) {
                        itemId = "cobblemon:" + (String)itemId;
                    }
                    return itemId;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String searchForItemId(Object obj) {
        Pattern pattern;
        Matcher matcher;
        if (obj == null) {
            return null;
        }
        String str = obj.toString();
        if (str.matches(".*[a-z]+:[a-z_]+.*") && (matcher = (pattern = Pattern.compile("([a-z]+:[a-z_]+)")).matcher(str)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static String resolveBiomeTag(String tagId) {
        if (minecraftServer == null) {
            return tagId;
        }
        try {
            class_5455.class_6890 registryAccess = minecraftServer.method_30611();
            class_2378 biomeRegistry = registryAccess.method_30530(class_7924.field_41236);
            class_2960 tagIdentifier = class_2960.method_60654((String)tagId);
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)tagIdentifier);
            Optional biomesInTag = biomeRegistry.method_40266(tagKey);
            if (biomesInTag.isEmpty()) {
                return tagId;
            }
            ArrayList<String> biomeNames = new ArrayList<String>();
            for (class_6880 entry : (class_6885.class_6888)biomesInTag.get()) {
                class_2960 biomeId = biomeRegistry.method_10221((Object)((class_1959)entry.comp_349()));
                if (biomeId == null) continue;
                String biomeName = biomeId.method_12832();
                biomeName = biomeName.replace("_", " ");
                biomeNames.add(biomeName);
            }
            if (!biomeNames.isEmpty()) {
                return String.join((CharSequence)", ", biomeNames);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tagId;
    }

    private static String translateStat(String stat) {
        return switch (stat.toLowerCase()) {
            case "hp", "health" -> "PV";
            case "attack", "atk" -> "Attaque";
            case "defence", "defense", "def" -> "D\u00e9fense";
            case "special_attack", "spatk", "spa" -> "Att.Sp\u00e9";
            case "special_defence", "special_defense", "spdef", "spd" -> "D\u00e9f.Sp\u00e9";
            case "speed", "spe" -> "Vitesse";
            default -> stat;
        };
    }

    private static String getAllMethodsAsString(Object obj) {
        StringBuilder sb = new StringBuilder();
        try {
            for (Method method : obj.getClass().getMethods()) {
                if (!method.getName().startsWith("get") || method.getParameterCount() != 0) continue;
                try {
                    Object result = method.invoke(obj, new Object[0]);
                    if (result == null) continue;
                    sb.append(method.getName().substring(3)).append("=").append(result).append(",");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "NoData";
    }
}

