/*
 * Decompiled with CFR 0.152.
 */
package com.cupokewiki.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2540;

public class PokemonSpawnData {
    private String species;
    private String form;
    private String translatedNameFr;
    private String translatedNameEn;
    private List<String> biomes;
    private List<String> eggGroups;
    private List<AbilityData> abilities;
    private List<String> types;
    private int dexNumber;
    private String descriptionSpawnNonNaturel;
    private Map<String, List<String>> realBiomesByCategory;
    private List<MoveData> moves;
    private List<DropData> drops;
    private List<EvolutionData> evolutions;
    private List<String> timeRanges;

    public PokemonSpawnData(String species, String form, List<String> biomes, List<String> eggGroups, List<AbilityData> abilities, List<String> types, int dexNumber) {
        this(species, form, null, null, biomes, eggGroups, abilities, types, dexNumber, null, new HashMap<String, List<String>>(), new ArrayList<MoveData>(), new ArrayList<DropData>(), new ArrayList<EvolutionData>(), new ArrayList<String>());
    }

    public PokemonSpawnData(String species, String form, List<String> biomes, List<String> eggGroups, List<AbilityData> abilities, List<String> types, int dexNumber, String descriptionSpawnNonNaturel) {
        this(species, form, null, null, biomes, eggGroups, abilities, types, dexNumber, descriptionSpawnNonNaturel, new HashMap<String, List<String>>(), new ArrayList<MoveData>(), new ArrayList<DropData>(), new ArrayList<EvolutionData>(), new ArrayList<String>());
    }

    public PokemonSpawnData(String species, String form, List<String> biomes, List<String> eggGroups, List<AbilityData> abilities, List<String> types, int dexNumber, String descriptionSpawnNonNaturel, Map<String, List<String>> realBiomesByCategory) {
        this(species, form, null, null, biomes, eggGroups, abilities, types, dexNumber, descriptionSpawnNonNaturel, realBiomesByCategory, new ArrayList<MoveData>(), new ArrayList<DropData>(), new ArrayList<EvolutionData>(), new ArrayList<String>());
    }

    public PokemonSpawnData(String species, String form, List<String> biomes, List<String> eggGroups, List<AbilityData> abilities, List<String> types, int dexNumber, String descriptionSpawnNonNaturel, Map<String, List<String>> realBiomesByCategory, List<MoveData> moves) {
        this(species, form, null, null, biomes, eggGroups, abilities, types, dexNumber, descriptionSpawnNonNaturel, realBiomesByCategory, moves, new ArrayList<DropData>(), new ArrayList<EvolutionData>(), new ArrayList<String>());
    }

    public PokemonSpawnData(String species, String form, List<String> biomes, List<String> eggGroups, List<AbilityData> abilities, List<String> types, int dexNumber, String descriptionSpawnNonNaturel, Map<String, List<String>> realBiomesByCategory, List<MoveData> moves, List<DropData> drops, List<EvolutionData> evolutions, List<String> timeRanges) {
        this(species, form, null, null, biomes, eggGroups, abilities, types, dexNumber, descriptionSpawnNonNaturel, realBiomesByCategory, moves, drops, evolutions, timeRanges);
    }

    public PokemonSpawnData(String species, String form, String translatedNameFr, String translatedNameEn, List<String> biomes, List<String> eggGroups, List<AbilityData> abilities, List<String> types, int dexNumber, String descriptionSpawnNonNaturel, Map<String, List<String>> realBiomesByCategory, List<MoveData> moves, List<DropData> drops, List<EvolutionData> evolutions, List<String> timeRanges) {
        this.species = species;
        this.form = form;
        this.translatedNameFr = translatedNameFr;
        this.translatedNameEn = translatedNameEn;
        this.biomes = biomes;
        this.eggGroups = eggGroups;
        this.abilities = abilities;
        this.types = types;
        this.dexNumber = dexNumber;
        this.descriptionSpawnNonNaturel = descriptionSpawnNonNaturel;
        this.realBiomesByCategory = realBiomesByCategory != null ? realBiomesByCategory : new HashMap();
        this.moves = moves != null ? moves : new ArrayList();
        this.drops = drops != null ? drops : new ArrayList();
        this.evolutions = evolutions != null ? evolutions : new ArrayList();
        this.timeRanges = timeRanges != null ? timeRanges : new ArrayList();
    }

    public String getSpecies() {
        return this.species;
    }

    public String getForm() {
        return this.form;
    }

    public String getTranslatedNameFr() {
        return this.translatedNameFr;
    }

    public String getTranslatedNameEn() {
        return this.translatedNameEn;
    }

    public List<String> getBiomes() {
        return this.biomes;
    }

    public List<String> getEggGroups() {
        return this.eggGroups;
    }

    public List<AbilityData> getAbilities() {
        return this.abilities;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public int getDexNumber() {
        return this.dexNumber;
    }

    public String getDescriptionSpawnNonNaturel() {
        return this.descriptionSpawnNonNaturel;
    }

    public Map<String, List<String>> getRealBiomesByCategory() {
        return this.realBiomesByCategory;
    }

    public List<MoveData> getMoves() {
        return this.moves;
    }

    public List<DropData> getDrops() {
        return this.drops;
    }

    public List<EvolutionData> getEvolutions() {
        return this.evolutions;
    }

    public List<String> getTimeRanges() {
        return this.timeRanges;
    }

    public String getFullName() {
        if (this.form != null && !this.form.isEmpty() && !this.form.equalsIgnoreCase("normal")) {
            return this.species + " " + this.form;
        }
        return this.species;
    }

    public void write(class_2540 buf) {
        buf.method_10814(this.species);
        buf.method_10814(this.form != null ? this.form : "");
        buf.method_52964(this.translatedNameFr != null);
        if (this.translatedNameFr != null) {
            buf.method_10814(this.translatedNameFr);
        }
        buf.method_52964(this.translatedNameEn != null);
        if (this.translatedNameEn != null) {
            buf.method_10814(this.translatedNameEn);
        }
        buf.method_53002(this.biomes.size());
        for (String string : this.biomes) {
            buf.method_10814(string);
        }
        buf.method_53002(this.eggGroups.size());
        for (String string : this.eggGroups) {
            buf.method_10814(string);
        }
        buf.method_53002(this.abilities.size());
        for (AbilityData abilityData : this.abilities) {
            abilityData.write(buf);
        }
        buf.method_53002(this.types.size());
        for (String string : this.types) {
            buf.method_10814(string);
        }
        buf.method_53002(this.dexNumber);
        buf.method_52964(this.descriptionSpawnNonNaturel != null);
        if (this.descriptionSpawnNonNaturel != null) {
            buf.method_10814(this.descriptionSpawnNonNaturel);
        }
        buf.method_53002(this.realBiomesByCategory.size());
        for (Map.Entry entry : this.realBiomesByCategory.entrySet()) {
            buf.method_10814((String)entry.getKey());
            buf.method_53002(((List)entry.getValue()).size());
            for (String biome : (List)entry.getValue()) {
                buf.method_10814(biome);
            }
        }
        buf.method_53002(this.moves.size());
        for (MoveData moveData : this.moves) {
            moveData.write(buf);
        }
        buf.method_53002(this.drops.size());
        for (DropData dropData : this.drops) {
            dropData.write(buf);
        }
        buf.method_53002(this.evolutions.size());
        for (EvolutionData evolutionData : this.evolutions) {
            evolutionData.write(buf);
        }
        buf.method_53002(this.timeRanges.size());
        for (String string : this.timeRanges) {
            buf.method_10814(string);
        }
    }

    public static PokemonSpawnData read(class_2540 buf) {
        String species = buf.method_19772();
        String form = buf.method_19772();
        if (form.isEmpty()) {
            form = null;
        }
        String translatedNameFr = buf.readBoolean() ? buf.method_19772() : null;
        String translatedNameEn = buf.readBoolean() ? buf.method_19772() : null;
        int biomeCount = buf.readInt();
        ArrayList<String> biomes = new ArrayList<String>();
        for (int i = 0; i < biomeCount; ++i) {
            biomes.add(buf.method_19772());
        }
        int eggCount = buf.readInt();
        ArrayList<String> eggGroups = new ArrayList<String>();
        for (int i = 0; i < eggCount; ++i) {
            eggGroups.add(buf.method_19772());
        }
        int abilityCount = buf.readInt();
        ArrayList<AbilityData> abilities = new ArrayList<AbilityData>();
        for (int i = 0; i < abilityCount; ++i) {
            abilities.add(AbilityData.read(buf));
        }
        int typeCount = buf.readInt();
        ArrayList<String> types = new ArrayList<String>();
        for (int i = 0; i < typeCount; ++i) {
            types.add(buf.method_19772());
        }
        int dexNumber = buf.readInt();
        String description = buf.readBoolean() ? buf.method_19772() : null;
        int categoryCount = buf.readInt();
        HashMap<String, List<String>> realBiomesByCategory = new HashMap<String, List<String>>();
        for (int i = 0; i < categoryCount; ++i) {
            String category = buf.method_19772();
            int biomeListCount = buf.readInt();
            ArrayList<String> categoryBiomes = new ArrayList<String>();
            for (int j = 0; j < biomeListCount; ++j) {
                categoryBiomes.add(buf.method_19772());
            }
            realBiomesByCategory.put(category, categoryBiomes);
        }
        int moveCount = buf.readInt();
        ArrayList<MoveData> moves = new ArrayList<MoveData>();
        for (int i = 0; i < moveCount; ++i) {
            moves.add(MoveData.read(buf));
        }
        int dropCount = buf.readInt();
        ArrayList<DropData> drops = new ArrayList<DropData>();
        for (int i = 0; i < dropCount; ++i) {
            drops.add(DropData.read(buf));
        }
        int evolutionCount = buf.readInt();
        ArrayList<EvolutionData> evolutions = new ArrayList<EvolutionData>();
        for (int i = 0; i < evolutionCount; ++i) {
            evolutions.add(EvolutionData.read(buf));
        }
        int timeRangeCount = buf.readInt();
        ArrayList<String> timeRanges = new ArrayList<String>();
        for (int i = 0; i < timeRangeCount; ++i) {
            timeRanges.add(buf.method_19772());
        }
        return new PokemonSpawnData(species, form, translatedNameFr, translatedNameEn, biomes, eggGroups, abilities, types, dexNumber, description, realBiomesByCategory, moves, drops, evolutions, timeRanges);
    }

    public static class AbilityData {
        private String name;
        private String description;
        private boolean hidden;

        public AbilityData(String name, String description, boolean hidden) {
            this.name = name;
            this.description = description;
            this.hidden = hidden;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public void write(class_2540 buf) {
            buf.method_10814(this.name);
            buf.method_10814(this.description);
            buf.method_52964(this.hidden);
        }

        public static AbilityData read(class_2540 buf) {
            return new AbilityData(buf.method_19772(), buf.method_19772(), buf.readBoolean());
        }
    }

    public static class MoveData {
        private String name;
        private String type;
        private String damageCategory;
        private int power;
        private int accuracy;
        private int pp;
        private String learnMethod;
        private int level;

        public MoveData(String name, String type, String damageCategory, int power, int accuracy, int pp, String learnMethod, int level) {
            this.name = name;
            this.type = type;
            this.damageCategory = damageCategory;
            this.power = power;
            this.accuracy = accuracy;
            this.pp = pp;
            this.learnMethod = learnMethod;
            this.level = level;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getDamageCategory() {
            return this.damageCategory;
        }

        public int getPower() {
            return this.power;
        }

        public int getAccuracy() {
            return this.accuracy;
        }

        public int getPp() {
            return this.pp;
        }

        public String getLearnMethod() {
            return this.learnMethod;
        }

        public int getLevel() {
            return this.level;
        }

        public void write(class_2540 buf) {
            buf.method_10814(this.name);
            buf.method_10814(this.type);
            buf.method_10814(this.damageCategory);
            buf.method_53002(this.power);
            buf.method_53002(this.accuracy);
            buf.method_53002(this.pp);
            buf.method_10814(this.learnMethod);
            buf.method_53002(this.level);
        }

        public static MoveData read(class_2540 buf) {
            return new MoveData(buf.method_19772(), buf.method_19772(), buf.method_19772(), buf.readInt(), buf.readInt(), buf.readInt(), buf.method_19772(), buf.readInt());
        }
    }

    public static class DropData {
        private String itemId;
        private int minQuantity;
        private int maxQuantity;
        private double percentage;
        private String source;

        public DropData(String itemId, int minQuantity, int maxQuantity, double percentage, String source) {
            this.itemId = itemId;
            this.minQuantity = minQuantity;
            this.maxQuantity = maxQuantity;
            this.percentage = percentage;
            this.source = source;
        }

        public String getItemId() {
            return this.itemId;
        }

        public int getMinQuantity() {
            return this.minQuantity;
        }

        public int getMaxQuantity() {
            return this.maxQuantity;
        }

        public double getPercentage() {
            return this.percentage;
        }

        public String getSource() {
            return this.source;
        }

        public void write(class_2540 buf) {
            buf.method_10814(this.itemId);
            buf.method_53002(this.minQuantity);
            buf.method_53002(this.maxQuantity);
            buf.method_52940(this.percentage);
            buf.method_10814(this.source);
        }

        public static DropData read(class_2540 buf) {
            return new DropData(buf.method_19772(), buf.readInt(), buf.readInt(), buf.readDouble(), buf.method_19772());
        }
    }

    public static class EvolutionData {
        private String evolvedSpecies;
        private String evolvedForm;
        private String condition;

        public EvolutionData(String evolvedSpecies, String evolvedForm, String condition) {
            this.evolvedSpecies = evolvedSpecies;
            this.evolvedForm = evolvedForm;
            this.condition = condition;
        }

        public String getEvolvedSpecies() {
            return this.evolvedSpecies;
        }

        public String getEvolvedForm() {
            return this.evolvedForm;
        }

        public String getCondition() {
            return this.condition;
        }

        public void write(class_2540 buf) {
            buf.method_10814(this.evolvedSpecies);
            buf.method_52964(this.evolvedForm != null);
            if (this.evolvedForm != null) {
                buf.method_10814(this.evolvedForm);
            }
            buf.method_10814(this.condition);
        }

        public static EvolutionData read(class_2540 buf) {
            String evolvedSpecies = buf.method_19772();
            String evolvedForm = buf.readBoolean() ? buf.method_19772() : null;
            String condition = buf.method_19772();
            return new EvolutionData(evolvedSpecies, evolvedForm, condition);
        }
    }
}

