/*
 * Decompiled with CFR 0.152.
 */
package com.cupokewiki.data;

import com.cupokewiki.CUPokeWiki;
import fr.pepefab.ucgeneralfabric.Config.LegendarySpawnConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LegendarySpawnReader {
    private static Map<String, List<String>> legendaryBiomes = new HashMap<String, List<String>>();
    private static Map<String, String> legendaryDescriptions = new HashMap<String, String>();
    private static Map<String, List<String>> legendaryTimings = new HashMap<String, List<String>>();
    static boolean loaded = false;

    public static void loadLegendarySpawns() {
        if (loaded) {
            return;
        }
        try {
            if (LegendarySpawnConfig.INSTANCE == null || LegendarySpawnConfig.INSTANCE.legendarySpawns == null) {
                CUPokeWiki.LOGGER.warn("LegendarySpawnConfig not loaded yet");
                loaded = true;
                return;
            }
            for (LegendarySpawnConfig.LegendarySpawnEntry entry : LegendarySpawnConfig.INSTANCE.legendarySpawns) {
                if (entry.pokemonName == null) continue;
                String pokemonName = entry.pokemonName.toLowerCase();
                Object storageKey = pokemonName;
                if (pokemonName.contains("-")) {
                    String[] parts = pokemonName.split("-", 2);
                    String species = parts[0];
                    String form = parts[1];
                    storageKey = species + "_" + form;
                }
                if (entry.biome != null && !entry.biome.isEmpty()) {
                    ArrayList<String> validBiomes = new ArrayList<String>();
                    for (String biome : entry.biome) {
                        if (biome == null || biome.trim().isEmpty()) continue;
                        validBiomes.add(biome);
                    }
                    if (!validBiomes.isEmpty()) {
                        legendaryBiomes.put((String)storageKey, validBiomes);
                    }
                }
                if (entry.descriptionSpawnNonNaturel != null && !entry.descriptionSpawnNonNaturel.isEmpty()) {
                    legendaryDescriptions.put((String)storageKey, entry.descriptionSpawnNonNaturel);
                }
                if (entry.timing == null || entry.timing.isEmpty()) continue;
                ArrayList<String> validTimings = new ArrayList<String>();
                for (String timing : entry.timing) {
                    if (timing == null || timing.trim().isEmpty()) continue;
                    validTimings.add(timing);
                }
                if (validTimings.isEmpty()) continue;
                legendaryTimings.put((String)storageKey, validTimings);
            }
            loaded = true;
        }
        catch (NoClassDefFoundError e) {
            loaded = true;
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Error loading legendary spawns from UCLibs: {}", (Object)e.getMessage());
            loaded = true;
        }
    }

    public static List<String> getBiomes(String speciesName) {
        String normalized;
        if (!loaded) {
            LegendarySpawnReader.loadLegendarySpawns();
        }
        if (legendaryBiomes.containsKey(normalized = speciesName.toLowerCase())) {
            return legendaryBiomes.get(normalized);
        }
        for (String key : legendaryBiomes.keySet()) {
            if (!key.startsWith(normalized + "_")) continue;
            return legendaryBiomes.get(key);
        }
        return new ArrayList<String>();
    }

    public static String getDescription(String speciesName) {
        String normalized;
        if (!loaded) {
            LegendarySpawnReader.loadLegendarySpawns();
        }
        if (legendaryDescriptions.containsKey(normalized = speciesName.toLowerCase())) {
            return legendaryDescriptions.get(normalized);
        }
        for (String key : legendaryDescriptions.keySet()) {
            if (!key.startsWith(normalized + "_")) continue;
            return legendaryDescriptions.get(key);
        }
        return null;
    }

    public static List<String> getTimings(String speciesName) {
        String normalized;
        if (!loaded) {
            LegendarySpawnReader.loadLegendarySpawns();
        }
        if (legendaryTimings.containsKey(normalized = speciesName.toLowerCase())) {
            return legendaryTimings.get(normalized);
        }
        for (String key : legendaryTimings.keySet()) {
            if (!key.startsWith(normalized + "_")) continue;
            return legendaryTimings.get(key);
        }
        return new ArrayList<String>();
    }

    public static boolean hasLegendarySpawns(String speciesName) {
        String normalized;
        if (!loaded) {
            LegendarySpawnReader.loadLegendarySpawns();
        }
        if (legendaryBiomes.containsKey(normalized = speciesName.toLowerCase())) {
            return true;
        }
        for (String key : legendaryBiomes.keySet()) {
            if (!key.startsWith(normalized + "_")) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLegendaryDescription(String speciesName) {
        String normalized;
        if (!loaded) {
            LegendarySpawnReader.loadLegendarySpawns();
        }
        if (legendaryDescriptions.containsKey(normalized = speciesName.toLowerCase())) {
            return true;
        }
        for (String key : legendaryDescriptions.keySet()) {
            if (!key.startsWith(normalized + "_")) continue;
            return true;
        }
        return false;
    }

    public static Map<String, List<String>> getAllLegendaryBiomes() {
        if (!loaded) {
            LegendarySpawnReader.loadLegendarySpawns();
        }
        return new HashMap<String, List<String>>(legendaryBiomes);
    }

    public static Map<String, String> getAllLegendaryDescriptions() {
        if (!loaded) {
            LegendarySpawnReader.loadLegendarySpawns();
        }
        return new HashMap<String, String>(legendaryDescriptions);
    }

    public static List<String> getAllLegendaryKeys() {
        if (!loaded) {
            LegendarySpawnReader.loadLegendarySpawns();
        }
        ArrayList<String> allKeys = new ArrayList<String>();
        allKeys.addAll(legendaryBiomes.keySet());
        for (String key : legendaryDescriptions.keySet()) {
            if (allKeys.contains(key)) continue;
            allKeys.add(key);
        }
        return allKeys;
    }
}

