/*
 * Decompiled with CFR 0.152.
 */
package com.cupokewiki.data;

import com.cupokewiki.CUPokeWiki;
import com.cupokewiki.data.LegendarySpawnReader;
import java.util.ArrayList;
import java.util.List;

public class LegendarySpawnHelper {
    private static boolean ucLibsAvailable = false;

    public static void loadLegendarySpawns() {
        if (!ucLibsAvailable) {
            return;
        }
        try {
            LegendarySpawnReader.loadLegendarySpawns();
        }
        catch (NoClassDefFoundError e) {
            CUPokeWiki.LOGGER.warn("Failed to load legendary spawns: {}", (Object)e.getMessage());
        }
    }

    public static List<String> getBiomesForLegendary(String speciesName) {
        if (!ucLibsAvailable) {
            return new ArrayList<String>();
        }
        try {
            return LegendarySpawnReader.getBiomes(speciesName);
        }
        catch (NoClassDefFoundError e) {
            CUPokeWiki.LOGGER.warn("Failed to get biomes for legendary: {}", (Object)e.getMessage());
            return new ArrayList<String>();
        }
    }

    public static String getDescriptionForLegendary(String speciesName) {
        if (!ucLibsAvailable) {
            return null;
        }
        try {
            return LegendarySpawnReader.getDescription(speciesName);
        }
        catch (NoClassDefFoundError e) {
            CUPokeWiki.LOGGER.warn("Failed to get description for legendary: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static List<String> getTimingsForLegendary(String speciesName) {
        if (!ucLibsAvailable) {
            return new ArrayList<String>();
        }
        try {
            return LegendarySpawnReader.getTimings(speciesName);
        }
        catch (NoClassDefFoundError e) {
            CUPokeWiki.LOGGER.warn("Failed to get timings for legendary: {}", (Object)e.getMessage());
            return new ArrayList<String>();
        }
    }

    public static boolean hasLegendarySpawns(String speciesName) {
        if (!ucLibsAvailable) {
            return false;
        }
        try {
            return LegendarySpawnReader.hasLegendarySpawns(speciesName);
        }
        catch (NoClassDefFoundError e) {
            CUPokeWiki.LOGGER.warn("Failed to check legendary spawns: {}", (Object)e.getMessage());
            return false;
        }
    }

    public static boolean hasLegendaryDescription(String speciesName) {
        if (!ucLibsAvailable) {
            return false;
        }
        try {
            return LegendarySpawnReader.hasLegendaryDescription(speciesName);
        }
        catch (NoClassDefFoundError e) {
            CUPokeWiki.LOGGER.warn("Failed to check legendary description: {}", (Object)e.getMessage());
            return false;
        }
    }

    static {
        try {
            Class.forName("fr.pepefab.ucgeneralfabric.Config.LegendarySpawnConfig");
            ucLibsAvailable = true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            ucLibsAvailable = false;
        }
    }
}

