/*
 * Decompiled with CFR 0.152.
 */
package com.cupokewiki.data;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Species;
import com.cupokewiki.CUPokeWiki;
import com.cupokewiki.data.LegendarySpawnReader;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LegendaryFormConfig {
    private static final String CONFIG_FILE = "config/cupokewiki/legendary_form_visibility.json";
    private static Map<String, Map<String, Boolean>> formVisibility = new HashMap<String, Map<String, Boolean>>();
    private static boolean loaded = false;

    public static void load() {
        if (loaded) {
            return;
        }
        Path configPath = Paths.get(CONFIG_FILE, new String[0]);
        if (!Files.exists(configPath, new LinkOption[0])) {
            LegendaryFormConfig.createAutoGeneratedConfig(configPath);
        }
        try (BufferedReader reader = Files.newBufferedReader(configPath, StandardCharsets.UTF_8);){
            Gson gson = new Gson();
            JsonObject root = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            if (root.has("legendaryFormVisibility")) {
                JsonObject legendaryForms = root.getAsJsonObject("legendaryFormVisibility");
                for (String species : legendaryForms.keySet()) {
                    JsonObject forms = legendaryForms.getAsJsonObject(species);
                    HashMap<String, Boolean> formsMap = new HashMap<String, Boolean>();
                    for (String formName : forms.keySet()) {
                        boolean visible = forms.get(formName).getAsBoolean();
                        formsMap.put(formName.toLowerCase(), visible);
                    }
                    formVisibility.put(species.toLowerCase(), formsMap);
                }
            }
            loaded = true;
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Failed to load legendary form config", (Throwable)e);
            LegendaryFormConfig.createAutoGeneratedConfig(configPath);
        }
    }

    private static void createAutoGeneratedConfig(Path configPath) {
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            HashMap root = new HashMap();
            HashMap legendaryForms = new HashMap();
            List<String> legendaryKeys = LegendarySpawnReader.getAllLegendaryKeys();
            for (String legendaryKey : legendaryKeys) {
                Species species;
                String speciesName;
                String formName = null;
                if (legendaryKey.contains("_")) {
                    String[] parts = legendaryKey.split("_", 2);
                    speciesName = parts[0];
                    formName = parts[1];
                } else {
                    speciesName = legendaryKey;
                }
                if ((species = PokemonSpecies.getByName((String)speciesName)) == null) continue;
                if (!legendaryForms.containsKey(speciesName)) {
                    legendaryForms.put(speciesName, new HashMap());
                }
                Map forms = (Map)legendaryForms.get(speciesName);
                List allForms = species.getForms();
                if (allForms != null && !allForms.isEmpty()) {
                    for (FormData formData : allForms) {
                        String cobblemonFormName = formData.getName();
                        if (cobblemonFormName == null || cobblemonFormName.isEmpty() || cobblemonFormName.equalsIgnoreCase("normal")) {
                            forms.put("normal", true);
                            continue;
                        }
                        String normalizedForm = cobblemonFormName.toLowerCase();
                        forms.put(normalizedForm, true);
                    }
                    continue;
                }
                forms.put("normal", true);
            }
            root.put("legendaryFormVisibility", legendaryForms);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try (BufferedWriter writer = Files.newBufferedWriter(configPath, StandardCharsets.UTF_8, new OpenOption[0]);){
                gson.toJson(root, (Appendable)writer);
            }
            for (String species : legendaryForms.keySet()) {
                Map forms = (Map)legendaryForms.get(species);
                HashMap<String, Boolean> formsMap = new HashMap<String, Boolean>();
                for (Map.Entry entry : forms.entrySet()) {
                    formsMap.put(((String)entry.getKey()).toLowerCase(), (Boolean)entry.getValue());
                }
                formVisibility.put(species.toLowerCase(), formsMap);
            }
            loaded = true;
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Failed to create auto-generated config", (Throwable)e);
        }
    }

    public static boolean isFormVisible(String species, String form) {
        String formKey;
        if (!loaded) {
            LegendaryFormConfig.load();
        }
        String speciesKey = species.toLowerCase();
        String string = formKey = form != null ? form.toLowerCase() : "normal";
        if (formVisibility.containsKey(speciesKey)) {
            Map<String, Boolean> forms = formVisibility.get(speciesKey);
            return forms.getOrDefault(formKey, true);
        }
        return true;
    }

    public static Map<String, Map<String, Boolean>> getAllVisibleForms() {
        if (!loaded) {
            LegendaryFormConfig.load();
        }
        return new HashMap<String, Map<String, Boolean>>(formVisibility);
    }
}

