/*
 * Decompiled with CFR 0.152.
 */
package com.cupokewiki.data;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Species;
import com.cupokewiki.CUPokeWiki;
import com.cupokewiki.data.LegendarySpawnReader;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class BlacklistConfig {
    private static final String CONFIG_FILE = "config/cupokewiki/blacklist_species.json";
    private static final Set<String> customSpeciesPaths = new HashSet<String>();
    private static Map<String, Map<String, Boolean>> speciesVisibility = new HashMap<String, Map<String, Boolean>>();
    private static boolean loaded = false;

    public static void initialize(class_3300 resourceManager) {
        BlacklistConfig.scanCustomFolder(resourceManager);
        Path configPath = Paths.get(CONFIG_FILE, new String[0]);
        if (!Files.exists(configPath, new LinkOption[0])) {
            BlacklistConfig.generateConfig(configPath);
        } else {
            BlacklistConfig.loadConfig(configPath);
        }
        loaded = true;
    }

    public static void reset() {
        loaded = false;
        speciesVisibility.clear();
        customSpeciesPaths.clear();
    }

    private static void scanCustomFolder(class_3300 resourceManager) {
        customSpeciesPaths.clear();
        try {
            Map resources = resourceManager.method_14488("species/custom", path -> path.method_12832().endsWith(".json"));
            for (class_2960 id : resources.keySet()) {
                String path2 = id.method_12832();
                String fileName = path2.substring(path2.lastIndexOf(47) + 1);
                String speciesPath = fileName.replace(".json", "");
                customSpeciesPaths.add(speciesPath);
            }
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Failed to scan custom folder", (Throwable)e);
        }
    }

    private static void generateConfig(Path configPath) {
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            LinkedHashMap<String, Map<String, Boolean>> config = new LinkedHashMap<String, Map<String, Boolean>>();
            HashSet<String> legendaryKeys = new HashSet<String>(LegendarySpawnReader.getAllLegendaryKeys());
            for (Species species : PokemonSpecies.INSTANCE.getSpecies()) {
                boolean isCustomSpecies;
                String speciesName = species.getName().toLowerCase();
                if (legendaryKeys.contains(speciesName)) continue;
                LinkedHashMap<String, Boolean> forms = new LinkedHashMap<String, Boolean>();
                class_2960 resourceId = species.getResourceIdentifier();
                String path = resourceId != null ? resourceId.method_12832() : null;
                String namespace = resourceId != null ? resourceId.method_12836() : null;
                boolean bl = isCustomSpecies = namespace != null && !namespace.equals("cobblemon") || path != null && customSpeciesPaths.contains(path);
                if (isCustomSpecies && path != null && legendaryKeys.contains(path)) continue;
                List allForms = species.getForms();
                if (allForms != null && !allForms.isEmpty()) {
                    for (FormData formData : allForms) {
                        String formName = formData.getName();
                        if (BlacklistConfig.shouldExcludeForm(formName)) continue;
                        if (formName == null || formName.isEmpty() || formName.equalsIgnoreCase("normal")) {
                            forms.put("normal", isCustomSpecies);
                            continue;
                        }
                        String normalizedForm = formName.toLowerCase().replace(" ", "_").replace("-", "_");
                        boolean isCustomForm = isCustomSpecies || BlacklistConfig.isCustomFormKeyword(formName);
                        forms.put(normalizedForm, isCustomForm);
                    }
                } else {
                    forms.put("normal", isCustomSpecies);
                }
                if (forms.isEmpty()) continue;
                String configKey = isCustomSpecies && path != null ? path : speciesName;
                config.put(configKey, forms);
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try (BufferedWriter writer = Files.newBufferedWriter(configPath, StandardCharsets.UTF_8, new OpenOption[0]);){
                gson.toJson(config, (Appendable)writer);
            }
            speciesVisibility = config;
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Failed to generate blacklist config", (Throwable)e);
        }
    }

    private static boolean shouldExcludeForm(String formName) {
        if (formName == null || formName.isEmpty()) {
            return false;
        }
        String lower = formName.toLowerCase().replaceAll("[ -]", "");
        return lower.contains("mega") || lower.contains("gmax") || lower.contains("gigantamax") || lower.contains("dynamax") || lower.contains("eternamax");
    }

    private static void loadConfig(Path configPath) {
        try (BufferedReader reader = Files.newBufferedReader(configPath, StandardCharsets.UTF_8);){
            Gson gson = new Gson();
            JsonObject root = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            speciesVisibility.clear();
            for (String speciesKey : root.keySet()) {
                JsonObject forms = root.getAsJsonObject(speciesKey);
                LinkedHashMap<String, Boolean> formsMap = new LinkedHashMap<String, Boolean>();
                for (String formName : forms.keySet()) {
                    boolean blacklisted = forms.get(formName).getAsBoolean();
                    formsMap.put(formName.toLowerCase(), blacklisted);
                }
                speciesVisibility.put(speciesKey.toLowerCase(), formsMap);
            }
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.error("Failed to load blacklist config", (Throwable)e);
            BlacklistConfig.generateConfig(configPath);
        }
    }

    private static boolean isCustomFormKeyword(String formName) {
        String lower = formName.toLowerCase().replaceAll("[ -]", "");
        return lower.contains("holiday") || lower.contains("costume") || lower.contains("party") || lower.contains("style") || lower.contains("halloween") || lower.contains("christmas") || lower.contains("noel") || lower.contains("easter") || lower.contains("valentine") || lower.contains("noble") || lower.contains("dark") || lower.contains("magician") || lower.contains("pokemon") || lower.contains("ash");
    }

    public static boolean isBlacklisted(Species species) {
        if (species == null) {
            return false;
        }
        if (!loaded) {
            return false;
        }
        try {
            class_2960 resourceId = species.getResourceIdentifier();
            if (resourceId != null) {
                String path = resourceId.method_12832();
                String namespace = resourceId.method_12836();
                String speciesName = species.getName().toLowerCase();
                if (namespace != null && !namespace.equals("cobblemon")) {
                    return !BlacklistConfig.isVisible(path != null ? path : speciesName, "normal");
                }
                if (path != null && customSpeciesPaths.contains(path)) {
                    return !BlacklistConfig.isVisible(path, "normal");
                }
                return !BlacklistConfig.isVisible(speciesName, "normal");
            }
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.warn("Error checking blacklist for {}", (Object)species.getName());
        }
        return false;
    }

    public static boolean isBlacklisted(Species species, String formName) {
        if (species == null) {
            return false;
        }
        if (!loaded) {
            return false;
        }
        if (BlacklistConfig.isBlacklisted(species)) {
            return true;
        }
        if (formName == null || formName.isEmpty() || formName.equalsIgnoreCase("normal")) {
            return false;
        }
        try {
            class_2960 resourceId = species.getResourceIdentifier();
            if (resourceId != null) {
                String path = resourceId.method_12832();
                String speciesName = species.getName().toLowerCase();
                String normalizedForm = formName.toLowerCase().replace(" ", "_").replace("-", "_");
                String lookupKey = path != null && customSpeciesPaths.contains(path) ? path : speciesName;
                return !BlacklistConfig.isVisible(lookupKey, normalizedForm);
            }
        }
        catch (Exception e) {
            CUPokeWiki.LOGGER.warn("Error checking form blacklist for {} - {}", (Object)species.getName(), (Object)formName);
        }
        return false;
    }

    private static boolean isVisible(String speciesKey, String formName) {
        if (speciesVisibility.containsKey(speciesKey)) {
            Map<String, Boolean> forms = speciesVisibility.get(speciesKey);
            boolean blacklisted = forms.getOrDefault(formName, false);
            return !blacklisted;
        }
        return true;
    }
}

