/*
 * Decompiled with CFR 0.152.
 */
package com.cupokewiki.command;

import com.cupokewiki.data.PokemonSpawnData;
import com.cupokewiki.data.SpawnDataCache;
import com.cupokewiki.network.OpenWikiPacket;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class WikiCommand {
    private static final SuggestionProvider<class_2168> POKEMON_SUGGESTIONS = (context, builder) -> {
        List allPokemon = SpawnDataCache.getServerCache().values().stream().sorted(Comparator.comparingInt(PokemonSpawnData::getDexNumber)).collect(Collectors.toList());
        String input = WikiCommand.normalizeForSearch(builder.getRemaining());
        HashSet<String> uniqueSpecies = new HashSet<String>();
        ArrayList<String> suggestions = new ArrayList<String>();
        for (PokemonSpawnData data : allPokemon) {
            String displayEn;
            String species = data.getSpecies();
            if (uniqueSpecies.contains(species.toLowerCase())) continue;
            uniqueSpecies.add(species.toLowerCase());
            String frName = data.getTranslatedNameFr();
            String enName = data.getTranslatedNameEn();
            boolean hasFr = frName != null && !frName.isEmpty() && !frName.equalsIgnoreCase(species);
            String string = displayEn = enName != null && !enName.isEmpty() ? enName : WikiCommand.capitalizeFirst(species);
            if (hasFr && WikiCommand.normalizeForSearch(frName).startsWith(input)) {
                suggestions.add(WikiCommand.cleanForDisplay(frName));
            } else if (WikiCommand.normalizeForSearch(displayEn).startsWith(input)) {
                suggestions.add(WikiCommand.cleanForDisplay(displayEn));
            } else if (WikiCommand.normalizeForSearch(species).startsWith(input)) {
                suggestions.add(WikiCommand.cleanForDisplay(displayEn));
            }
            String string2 = WikiCommand.normalizeForSearch(species);
        }
        return class_2172.method_9265((Iterable)suggestions.stream().distinct().limit(20L).collect(Collectors.toList()), (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<class_2168> FORM_SUGGESTIONS = (context, builder) -> {
        try {
            String pokemonName = StringArgumentType.getString((CommandContext)context, (String)"pokemon");
            String input = WikiCommand.normalizeForSearch(builder.getRemaining());
            List<String> searchVariants = WikiCommand.generateSearchVariants(pokemonName);
            List forms = SpawnDataCache.getServerCache().values().stream().filter(data -> {
                for (String variant : searchVariants) {
                    String speciesNorm = WikiCommand.normalizeForSearch(data.getSpecies());
                    if (speciesNorm.equals(variant) || speciesNorm.startsWith(variant)) {
                        return true;
                    }
                    String frName = data.getTranslatedNameFr();
                    String enName = data.getTranslatedNameEn();
                    if (frName != null && !frName.isEmpty() && WikiCommand.normalizeForSearch(frName).equals(variant)) {
                        return true;
                    }
                    if (enName == null || enName.isEmpty() || !WikiCommand.normalizeForSearch(enName).equals(variant)) continue;
                    return true;
                }
                return false;
            }).filter(data -> data.getForm() != null && !data.getForm().isEmpty()).map(data -> WikiCommand.cleanForDisplay(data.getForm())).filter(form -> WikiCommand.normalizeForSearch(form).startsWith(input)).distinct().limit(20L).collect(Collectors.toList());
            return class_2172.method_9265(forms, (SuggestionsBuilder)builder);
        }
        catch (Exception e) {
            return class_2172.method_9265(Collections.emptyList(), (SuggestionsBuilder)builder);
        }
    };

    private static String normalizeForSearch(String text) {
        if (text == null) {
            return "";
        }
        String normalized = Normalizer.normalize(text, Normalizer.Form.NFD);
        normalized = normalized.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        normalized = normalized.toLowerCase().replaceAll("[^a-z0-9]", "");
        return normalized;
    }

    private static String cleanForDisplay(String text) {
        if (text == null) {
            return "";
        }
        text = text.replace("\u00e2\u20ac\u2122", "'").replace("\u00e2\u20ac\u02dc", "'").replace("\u00e2\u20ac\u0153", "\"").replace("\u00e2\u20ac", "\"").replace("\u00c3\u00a9", "\u00e9").replace("\u00c3\u00a8", "\u00e8").replace("\u00c3 ", "\u00e0").replace("\u00c3\u00b4", "\u00f4").replace("\u00c3\u00ae", "\u00ee").replace("\u00c3\u00a7", "\u00e7").replace("\u00c3\u00bb", "\u00fb").replace("\u00c3\u00a2", "\u00e2").replace("\u00c3\u00aa", "\u00ea");
        text = Normalizer.normalize(text, Normalizer.Form.NFD);
        text = text.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
        if ((text = text.replaceAll("[''\u02bc\u055a\u05f3`\u00b4\\u0027\\u2019\\u02BC]", "").replace(" ", "").replace(".", "").replace("-", "")).isEmpty()) {
            return text;
        }
        return text.substring(0, 1).toUpperCase() + text.substring(1).toLowerCase();
    }

    private static String capitalizeFirst(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return text.substring(0, 1).toUpperCase() + text.substring(1).toLowerCase();
    }

    private static List<String> generateSearchVariants(String text) {
        String withoutDashes;
        String withoutApostrophes;
        ArrayList<String> variants = new ArrayList<String>();
        String base = WikiCommand.normalizeForSearch(text);
        variants.add(base);
        String withoutSpaces = text.replaceAll("\\s+", "");
        if (!withoutSpaces.equals(text)) {
            variants.add(WikiCommand.normalizeForSearch(withoutSpaces));
        }
        if (!(withoutApostrophes = text.replaceAll("['']", "")).equals(text)) {
            variants.add(WikiCommand.normalizeForSearch(withoutApostrophes));
        }
        if (!(withoutDashes = text.replaceAll("-", "")).equals(text)) {
            variants.add(WikiCommand.normalizeForSearch(withoutDashes));
        }
        if (base.endsWith("d") && base.length() > 2) {
            variants.add(base.substring(0, base.length() - 1));
        }
        return variants.stream().distinct().collect(Collectors.toList());
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pwiki").executes(WikiCommand::executeOpen)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pokemon", (ArgumentType)StringArgumentType.string()).suggests(POKEMON_SUGGESTIONS).executes(WikiCommand::executeOpenPokemon)).then(class_2170.method_9244((String)"form", (ArgumentType)StringArgumentType.greedyString()).suggests(FORM_SUGGESTIONS).executes(WikiCommand::executeOpenPokemonForm))));
    }

    private static int executeOpen(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            ServerPlayNetworking.send((class_3222)player, (class_8710)new OpenWikiPacket(null));
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a").method_10852((class_2561)class_2561.method_43471((String)"command.cupokewiki.open")), false);
        }
        return 1;
    }

    private static int executeOpenPokemon(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            String pokemonName = StringArgumentType.getString(context, (String)"pokemon");
            List<String> searchVariants = WikiCommand.generateSearchVariants(pokemonName);
            PokemonSpawnData pokemon = null;
            String normalizedName = null;
            for (String variant : searchVariants) {
                ArrayList<Map.Entry<String, PokemonSpawnData>> matches = new ArrayList<Map.Entry<String, PokemonSpawnData>>();
                for (Map.Entry<String, PokemonSpawnData> entry : SpawnDataCache.getServerCache().entrySet()) {
                    PokemonSpawnData data = entry.getValue();
                    String speciesNorm = WikiCommand.normalizeForSearch(data.getSpecies());
                    if (speciesNorm.equals(variant) || speciesNorm.startsWith(variant)) {
                        matches.add(entry);
                        continue;
                    }
                    String frName = data.getTranslatedNameFr();
                    String enName = data.getTranslatedNameEn();
                    if (frName != null && !frName.isEmpty() && WikiCommand.normalizeForSearch(frName).equals(variant)) {
                        matches.add(entry);
                        continue;
                    }
                    if (enName == null || enName.isEmpty() || !WikiCommand.normalizeForSearch(enName).equals(variant)) continue;
                    matches.add(entry);
                }
                if (matches.isEmpty()) continue;
                matches.sort((a, b) -> {
                    boolean bHasForm;
                    boolean bExact;
                    PokemonSpawnData dataA = (PokemonSpawnData)a.getValue();
                    PokemonSpawnData dataB = (PokemonSpawnData)b.getValue();
                    boolean aExact = WikiCommand.normalizeForSearch(dataA.getSpecies()).equals(variant) || dataA.getTranslatedNameFr() != null && WikiCommand.normalizeForSearch(dataA.getTranslatedNameFr()).equals(variant) || dataA.getTranslatedNameEn() != null && WikiCommand.normalizeForSearch(dataA.getTranslatedNameEn()).equals(variant);
                    boolean bl = bExact = WikiCommand.normalizeForSearch(dataB.getSpecies()).equals(variant) || dataB.getTranslatedNameFr() != null && WikiCommand.normalizeForSearch(dataB.getTranslatedNameFr()).equals(variant) || dataB.getTranslatedNameEn() != null && WikiCommand.normalizeForSearch(dataB.getTranslatedNameEn()).equals(variant);
                    if (aExact && !bExact) {
                        return -1;
                    }
                    if (!aExact && bExact) {
                        return 1;
                    }
                    boolean aHasForm = dataA.getForm() != null && !dataA.getForm().isEmpty();
                    boolean bl2 = bHasForm = dataB.getForm() != null && !dataB.getForm().isEmpty();
                    if (!aHasForm && bHasForm) {
                        return -1;
                    }
                    if (aHasForm && !bHasForm) {
                        return 1;
                    }
                    return 0;
                });
                Map.Entry bestMatch = (Map.Entry)matches.get(0);
                pokemon = (PokemonSpawnData)bestMatch.getValue();
                normalizedName = (String)bestMatch.getKey();
                break;
            }
            if (pokemon != null) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new OpenWikiPacket(normalizedName));
                String cleanName = WikiCommand.cleanForDisplay(pokemon.getFullName());
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a").method_10852((class_2561)class_2561.method_43469((String)"command.cupokewiki.open_pokemon", (Object[])new Object[]{cleanName})), false);
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c").method_10852((class_2561)class_2561.method_43469((String)"command.cupokewiki.not_found", (Object[])new Object[]{pokemonName})), false);
            }
        }
        return 1;
    }

    private static int executeOpenPokemonForm(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            String pokemonName = StringArgumentType.getString(context, (String)"pokemon");
            String formName = StringArgumentType.getString(context, (String)"form");
            List<String> nameVariants = WikiCommand.generateSearchVariants(pokemonName);
            List<String> formVariants = WikiCommand.generateSearchVariants(formName);
            PokemonSpawnData pokemon = null;
            String foundKey = null;
            for (String nameVariant : nameVariants) {
                for (Map.Entry<String, PokemonSpawnData> entry : SpawnDataCache.getServerCache().entrySet()) {
                    PokemonSpawnData data = entry.getValue();
                    boolean speciesMatch = false;
                    String speciesNorm = WikiCommand.normalizeForSearch(data.getSpecies());
                    if (speciesNorm.equals(nameVariant) || speciesNorm.startsWith(nameVariant)) {
                        speciesMatch = true;
                    } else {
                        String frName = data.getTranslatedNameFr();
                        String enName = data.getTranslatedNameEn();
                        if (frName != null && !frName.isEmpty() && WikiCommand.normalizeForSearch(frName).equals(nameVariant)) {
                            speciesMatch = true;
                        } else if (enName != null && !enName.isEmpty() && WikiCommand.normalizeForSearch(enName).equals(nameVariant)) {
                            speciesMatch = true;
                        }
                    }
                    if (!speciesMatch) continue;
                    for (String formVariant : formVariants) {
                        String normalizedDataForm;
                        if (data.getForm() == null && (formVariant.equals("normal") || formVariant.equals("normale"))) {
                            pokemon = data;
                            foundKey = entry.getKey();
                            break;
                        }
                        if (data.getForm() == null || !(normalizedDataForm = WikiCommand.normalizeForSearch(data.getForm())).equals(formVariant) && !normalizedDataForm.contains(formVariant) && !formVariant.contains(normalizedDataForm)) continue;
                        pokemon = data;
                        foundKey = entry.getKey();
                        break;
                    }
                    if (pokemon == null) continue;
                    break;
                }
                if (pokemon == null) continue;
                break;
            }
            if (pokemon != null) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new OpenWikiPacket(foundKey));
                String string = WikiCommand.cleanForDisplay(pokemon.getFullName());
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c").method_10852((class_2561)class_2561.method_43469((String)"command.cupokewiki.not_found", (Object[])new Object[]{pokemonName + " " + formName})), false);
            }
        }
        return 1;
    }
}

