/*
 * Decompiled with CFR 0.152.
 */
package fr.pepefab.cubrowser.Chat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_3965;
import net.minecraft.class_408;

@Environment(value=EnvType.CLIENT)
public class NewChat
extends class_408 {
    private int historyIndex = -1;
    private List<String> chatHistory = new ArrayList<String>();
    private String password = "";
    private ChatTabCompleter tabCompleter;
    private String defaultInputFieldText = "";

    public NewChat(String defaultText) {
        super(String.valueOf(class_2561.method_30163((String)defaultText)));
        this.defaultInputFieldText = defaultText;
    }

    protected void method_25426() {
        super.method_25426();
        this.tabCompleter = new ChatTabCompleter(this.field_2382);
        this.field_2382.method_1852(this.defaultInputFieldText);
        this.chatHistory = new ArrayList<String>((Collection<String>)this.field_22787.field_1705.method_1743().method_1809());
        this.historyIndex = this.chatHistory.size();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean isMaskedCommand;
        if (this.field_2382 == null) {
            return false;
        }
        this.tabCompleter.resetRequested();
        String consoleText = this.field_2382.method_1882();
        boolean bl = isMaskedCommand = consoleText.toLowerCase().startsWith("/login ") || consoleText.toLowerCase().startsWith("/l ");
        if (keyCode == 258) {
            if (!this.tabCompleter.getCompletions().isEmpty()) {
                this.tabCompleter.complete();
                return true;
            }
        } else {
            if (keyCode == 256) {
                this.field_22787.method_1507(null);
                return true;
            }
            if (keyCode == 257 || keyCode == 335) {
                this.handleChatCommand();
                return true;
            }
            if (keyCode == 86 && (modifiers & 2) != 0) {
                if (isMaskedCommand) {
                    this.pasteAndMask();
                    return true;
                }
            } else {
                if (keyCode == 265) {
                    if (this.historyIndex > 0) {
                        --this.historyIndex;
                        this.field_2382.method_1852(this.chatHistory.get(this.historyIndex));
                    }
                    return true;
                }
                if (keyCode == 264) {
                    if (this.historyIndex < this.chatHistory.size() - 1) {
                        ++this.historyIndex;
                        this.field_2382.method_1852(this.chatHistory.get(this.historyIndex));
                    } else {
                        this.field_2382.method_1852("");
                        this.historyIndex = this.chatHistory.size();
                    }
                    return true;
                }
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char typedChar, int modifiers) {
        boolean isMaskedCommand;
        if (this.field_2382 == null) {
            return false;
        }
        String consoleText = this.field_2382.method_1882();
        boolean bl = isMaskedCommand = consoleText.toLowerCase().startsWith("/login ") || consoleText.toLowerCase().startsWith("/l ");
        if (isMaskedCommand) {
            this.password = this.password + typedChar;
            this.updateMaskedText(consoleText);
            return true;
        }
        return super.method_25400(typedChar, modifiers);
    }

    private void pasteAndMask() {
        boolean isMaskedCommand;
        String clipboardText = class_310.method_1551().field_1774.method_1460();
        if (clipboardText == null || clipboardText.isEmpty()) {
            return;
        }
        this.password = this.password + clipboardText;
        String consoleText = this.field_2382.method_1882();
        boolean bl = isMaskedCommand = consoleText.toLowerCase().startsWith("/login ") || consoleText.toLowerCase().startsWith("/l ");
        if (isMaskedCommand) {
            this.updateMaskedText(consoleText);
        }
    }

    private void handleChatCommand() {
        String consoleText = this.field_2382.method_1882();
        if (consoleText.toLowerCase().startsWith("/login ") || consoleText.toLowerCase().startsWith("/l ")) {
            this.method_44056("/login " + this.password, false);
        } else {
            this.method_44056(consoleText, false);
            this.addToChatHistory(consoleText);
        }
        this.password = "";
        this.field_22787.method_1507(null);
    }

    private void addToChatHistory(String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        this.chatHistory.add(message);
        this.historyIndex = this.chatHistory.size();
        this.field_22787.field_1705.method_1743().method_1803(message);
    }

    private void updateMaskedText(String consoleText) {
        String maskedText = consoleText.split(" ")[0] + " " + "*".repeat(this.password.length());
        this.field_2382.method_1852(maskedText);
    }

    @Environment(value=EnvType.CLIENT)
    public static class ChatTabCompleter {
        private final class_310 client;
        private final class_342 chatField;
        private List<String> completions = new ArrayList<String>();
        private int completionIndex = -1;

        public ChatTabCompleter(class_342 chatField) {
            this.client = class_310.method_1551();
            this.chatField = chatField;
        }

        public void complete() {
            if (this.completions.isEmpty()) {
                return;
            }
            this.completionIndex = (this.completionIndex + 1) % this.completions.size();
            String suggestion = this.completions.get(this.completionIndex);
            String currentText = this.chatField.method_1882();
            int lastSpaceIndex = currentText.lastIndexOf(" ");
            if (lastSpaceIndex == -1) {
                this.chatField.method_1852(suggestion);
            } else {
                this.chatField.method_1852(currentText.substring(0, lastSpaceIndex + 1) + suggestion);
            }
            this.chatField.method_1872(true);
        }

        public void setCompletions(String ... completions) {
            this.completions.clear();
            this.completions.addAll(List.of(completions));
            this.completionIndex = -1;
        }

        public void resetRequested() {
            this.completionIndex = -1;
        }

        public List<String> getCompletions() {
            return this.completions;
        }

        public void resetDidComplete() {
        }

        public class_2338 getTargetBlockPos() {
            if (this.client.field_1765 != null && this.client.field_1765.method_17783() == class_239.class_240.field_1332) {
                return ((class_3965)this.client.field_1765).method_17777();
            }
            return null;
        }
    }
}

