/*
 * Decompiled with CFR 0.152.
 */
package derp.immersivehotbar.mixin.client;

import derp.immersivehotbar.ImmersiveHotbarClient;
import derp.immersivehotbar.InGameHudAnimationHandler;
import derp.immersivehotbar.config.ImmersiveHotbarConfig;
import derp.immersivehotbar.util.ItemChecker;
import derp.immersivehotbar.util.SlotAnimationState;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_329.class})
public abstract class ItemAnimationsMixin
implements InGameHudAnimationHandler {
    @Mutable
    @Final
    @Shadow
    private final class_310 field_2035;
    @Unique
    private int currentHotbarSlot = 0;
    @Unique
    private long lastRenderTime = System.nanoTime();
    @Unique
    private float deltaSeconds = 0.0f;
    @Unique
    private class_1799 lastOffhandStack = class_1799.field_8037;
    @Unique
    private int lastOffhandCount = 0;
    @Unique
    private int lastOffhandDamage = 0;
    @Unique
    private boolean suppressOffhandPickup = false;
    @Unique
    private boolean initialized = false;

    public ItemAnimationsMixin(class_310 client) {
        this.field_2035 = client;
    }

    @Override
    public void immersive_hotbar$triggerSlotAnimation(int slotIndex) {
        if (slotIndex >= 0 && slotIndex < SlotAnimationState.slotScales.length) {
            SlotAnimationState.slotScales[slotIndex] = ImmersiveHotbarConfig.nonSelectedItemSize - 0.1f;
        }
    }

    @Unique
    public void immersive_hotbar$triggerOffhandAnimation(int slotIndex) {
        SlotAnimationState.slotScales[slotIndex] = ImmersiveHotbarConfig.animationIntensity;
    }

    @Inject(method={"renderHotbar"}, at={@At(value="HEAD")})
    private void onRenderHotbarStart(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        this.currentHotbarSlot = 0;
        long currentTime = System.nanoTime();
        this.deltaSeconds = (float)(currentTime - this.lastRenderTime) / 1.0E9f;
        this.deltaSeconds = class_3532.method_15363((float)this.deltaSeconds, (float)0.0f, (float)0.05f);
        this.lastRenderTime = currentTime;
        if (!this.initialized) {
            Arrays.fill(SlotAnimationState.slotScales, ImmersiveHotbarConfig.nonSelectedItemSize);
            Arrays.fill(SlotAnimationState.selectorScales, 1.0f);
            Arrays.fill(SlotAnimationState.slotVelocities, 0.0f);
            Arrays.fill(SlotAnimationState.shrinkProgress, 0.0f);
            Arrays.fill(SlotAnimationState.isShrinking, false);
            Arrays.fill(SlotAnimationState.previousStacks, class_1799.field_8037);
            this.initialized = true;
        }
    }

    @Inject(method={"renderHotbarItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderHotbarItem(class_332 context, int x, int y, class_9779 tickCounter, class_1657 player, class_1799 stack, int seed, CallbackInfo ci) {
        this.handleHotbarSlotRender(context, x, y, player, stack, seed, ci);
    }

    @Unique
    private void handleHotbarSlotRender(class_332 context, int x, int y, class_1657 player, class_1799 stack, int seed, CallbackInfo ci) {
        boolean isSelected;
        int slotIndex = this.currentHotbarSlot++;
        SlotAnimationState.ensureCapacity(slotIndex);
        int centerX = x + 8;
        int centerY = y + 8;
        boolean bl = isSelected = slotIndex == player.method_31548().field_7545;
        if (this.shouldTriggerShrink(stack, slotIndex)) {
            this.startShrinkAnimation(slotIndex);
        }
        if (SlotAnimationState.isShrinking[slotIndex] && this.handleShrinkAnimation(context, x, y, seed, player, slotIndex, ci)) {
            return;
        }
        if (stack.method_7960()) {
            this.handleEmptySlot(slotIndex);
            ci.cancel();
            return;
        }
        this.handleItemChangeAnimations(stack, slotIndex);
        this.updateLastSlotData(stack, slotIndex);
        this.updateSelectorScales(slotIndex);
        this.applySlotBounceOrSmoothScale(stack, slotIndex, isSelected);
        this.drawDurabilityGlow(stack, context, x, y);
        this.drawSlotBackground(context, x, y, isSelected);
        this.drawItemStack(context, player, stack, x, y, seed, centerX, centerY, slotIndex);
        this.handleOffhandSlotAnimations();
        ci.cancel();
    }

    @Unique
    private boolean shouldTriggerShrink(class_1799 stack, int slotIndex) {
        return (stack == null || stack.method_7960()) && !SlotAnimationState.lastSlotStacks[slotIndex].method_7960() && !SlotAnimationState.isShrinking[slotIndex];
    }

    @Unique
    private void startShrinkAnimation(int slotIndex) {
        SlotAnimationState.isShrinking[slotIndex] = true;
        SlotAnimationState.shrinkProgress[slotIndex] = 0.0f;
        SlotAnimationState.slotScales[slotIndex] = 1.3f;
    }

    @Unique
    private void handleEmptySlot(int slotIndex) {
        SlotAnimationState.previousStacks[slotIndex] = class_1799.field_8037;
        SlotAnimationState.lastSlotStacks[slotIndex] = class_1799.field_8037;
        SlotAnimationState.lastSlotCounts[slotIndex] = 0;
        int n = slotIndex;
        SlotAnimationState.slotScales[n] = SlotAnimationState.slotScales[n] + (ImmersiveHotbarConfig.nonSelectedItemSize - SlotAnimationState.slotScales[slotIndex]) * ImmersiveHotbarConfig.animationSpeed * this.deltaSeconds * 60.0f;
    }

    @Unique
    private void handleOffhandSlotAnimations() {
        assert (this.field_2035.field_1724 != null);
        class_1799 offhandStack = this.field_2035.field_1724.method_6079();
        boolean isToolItem = ItemChecker.isTool(offhandStack);
        boolean isWeaponItem = ItemChecker.isWeapon(offhandStack);
        boolean shouldAnimate = !(isToolItem && !ImmersiveHotbarConfig.toolAnimates || isWeaponItem && !ImmersiveHotbarConfig.weaponAnimates);
        boolean changed = !class_1799.method_7984((class_1799)offhandStack, (class_1799)this.lastOffhandStack) || !class_1799.method_31577((class_1799)offhandStack, (class_1799)this.lastOffhandStack) || offhandStack.method_7947() != this.lastOffhandCount;
        boolean wasUsed = false;
        if (ImmersiveHotbarConfig.durabilityAnimates && offhandStack.method_7963()) {
            int currentDamage = offhandStack.method_7919();
            if (currentDamage > this.lastOffhandDamage && !wasUsed && shouldAnimate) {
                if (ImmersiveHotbarClient.IS_DOUBLEHOTBAR_LOADED) {
                    this.immersive_hotbar$triggerOffhandAnimation(18);
                } else {
                    this.immersive_hotbar$triggerOffhandAnimation(9);
                }
                this.suppressOffhandPickup = true;
            }
            this.lastOffhandDamage = currentDamage;
        }
        if (changed && !this.suppressOffhandPickup && shouldAnimate) {
            if (ImmersiveHotbarClient.IS_DOUBLEHOTBAR_LOADED) {
                this.immersive_hotbar$triggerOffhandAnimation(18);
            } else {
                this.immersive_hotbar$triggerOffhandAnimation(9);
            }
        }
        this.lastOffhandStack = offhandStack.method_7972();
        this.lastOffhandCount = offhandStack.method_7947();
        this.suppressOffhandPickup = false;
    }

    @Unique
    private void handleItemChangeAnimations(class_1799 stack, int slotIndex) {
        boolean countIncreased;
        boolean isToolItem = ItemChecker.isTool(stack);
        boolean isWeaponItem = ItemChecker.isWeapon(stack);
        boolean isDamageable = stack.method_7963();
        boolean shouldAnimate = !(isToolItem && !ImmersiveHotbarConfig.toolAnimates || isWeaponItem && !ImmersiveHotbarConfig.weaponAnimates);
        boolean wasEmpty = SlotAnimationState.lastSlotStacks[slotIndex].method_7960();
        boolean itemChanged = !class_1799.method_7984((class_1799)stack, (class_1799)SlotAnimationState.lastSlotStacks[slotIndex]);
        boolean bl = countIncreased = stack.method_7947() > SlotAnimationState.lastSlotCounts[slotIndex];
        if (!stack.method_7960() && (wasEmpty || (itemChanged || countIncreased) && !SlotAnimationState.suppressNextPickup[slotIndex])) {
            SlotAnimationState.slotScales[slotIndex] = ImmersiveHotbarConfig.animationIntensity;
        }
        if (ImmersiveHotbarConfig.durabilityAnimates && isDamageable) {
            int lastDamage;
            int currentDamage = stack.method_7919();
            if (currentDamage > (lastDamage = SlotAnimationState.lastSlotDamage[slotIndex]) && !SlotAnimationState.wasUsed[slotIndex] && shouldAnimate) {
                SlotAnimationState.slotScales[slotIndex] = ImmersiveHotbarConfig.nonSelectedItemSize - 0.1f;
                SlotAnimationState.suppressNextPickup[slotIndex] = true;
            }
            SlotAnimationState.lastSlotDamage[slotIndex] = currentDamage;
        }
        if (!isDamageable && stack.method_7947() < SlotAnimationState.lastSlotCounts[slotIndex] && !SlotAnimationState.wasUsed[slotIndex]) {
            SlotAnimationState.slotScales[slotIndex] = ImmersiveHotbarConfig.nonSelectedItemSize - 0.1f;
            SlotAnimationState.suppressNextPickup[slotIndex] = true;
        }
        SlotAnimationState.previousStacks[slotIndex] = stack;
        SlotAnimationState.wasUsed[slotIndex] = false;
    }

    @Unique
    private void updateLastSlotData(class_1799 stack, int slotIndex) {
        if (!SlotAnimationState.isShrinking[slotIndex]) {
            SlotAnimationState.lastSlotStacks[slotIndex] = stack.method_7972();
            SlotAnimationState.lastSlotCounts[slotIndex] = stack.method_7947();
        }
        SlotAnimationState.suppressNextPickup[slotIndex] = false;
    }

    @Unique
    private void updateSelectorScales(int slotIndex) {
        float current = SlotAnimationState.selectorScales[slotIndex];
        int n = slotIndex;
        SlotAnimationState.selectorScales[n] = SlotAnimationState.selectorScales[n] + (slotIndex == this.currentHotbarSlot - 1 ? 1.2f : 1.0f - current) * 0.3f * this.deltaSeconds * 60.0f;
    }

    @Unique
    private void applySlotBounceOrSmoothScale(class_1799 stack, int slotIndex, boolean isSelected) {
        boolean shouldBounce;
        float targetScale = isSelected && ImmersiveHotbarConfig.shouldItemGrowWhenSelected ? ImmersiveHotbarConfig.selectedItemSize : ImmersiveHotbarConfig.nonSelectedItemSize;
        boolean bl = shouldBounce = !(!ImmersiveHotbarConfig.bouncyAnimation || ItemChecker.isTool(stack) && ImmersiveHotbarConfig.toolsIgnoreBounce || ItemChecker.isWeapon(stack) && ImmersiveHotbarConfig.weaponsIgnoreBounce);
        if (shouldBounce) {
            float scale = SlotAnimationState.slotScales[slotIndex];
            float velocity = SlotAnimationState.slotVelocities[slotIndex];
            float force = (targetScale - scale) * ImmersiveHotbarConfig.bouncyStiffness;
            velocity += force * this.deltaSeconds * 60.0f;
            SlotAnimationState.slotScales[slotIndex] = scale += (velocity *= (float)Math.pow(1.0f - ImmersiveHotbarConfig.bouncyDamping, this.deltaSeconds * 60.0f)) * this.deltaSeconds * 60.0f;
            SlotAnimationState.slotVelocities[slotIndex] = velocity;
        } else {
            float factor = 1.0f - (float)Math.pow(1.0f - ImmersiveHotbarConfig.animationSpeed, this.deltaSeconds * 60.0f);
            int n = slotIndex;
            SlotAnimationState.slotScales[n] = SlotAnimationState.slotScales[n] + (targetScale - SlotAnimationState.slotScales[slotIndex]) * factor;
        }
    }

    @Unique
    private boolean handleShrinkAnimation(class_332 context, int x, int y, int seed, class_1657 player, int slotIndex, CallbackInfo ci) {
        int centerX = x + 8;
        int centerY = y + 8;
        int n = slotIndex;
        SlotAnimationState.shrinkProgress[n] = SlotAnimationState.shrinkProgress[n] + this.deltaSeconds * ImmersiveHotbarConfig.shrinkAnimationSpeed;
        float progress = SlotAnimationState.shrinkProgress[slotIndex];
        if (ImmersiveHotbarConfig.bouncyAnimation) {
            float bounce = (float)Math.sin((double)progress * Math.PI) * 0.15f;
            float eased = 1.0f - progress * progress;
            SlotAnimationState.slotScales[slotIndex] = ImmersiveHotbarConfig.nonSelectedItemSize * eased + bounce;
        } else {
            float eased = 1.0f - progress * progress;
            SlotAnimationState.slotScales[slotIndex] = ImmersiveHotbarConfig.nonSelectedItemSize * eased;
        }
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)centerX, (float)centerY, 0.0f);
        context.method_51448().method_22905(SlotAnimationState.slotScales[slotIndex], SlotAnimationState.slotScales[slotIndex], SlotAnimationState.slotScales[slotIndex]);
        context.method_51448().method_46416((float)(-centerX), (float)(-centerY), 0.0f);
        context.method_51423((class_1309)player, SlotAnimationState.lastSlotStacks[slotIndex], x, y, seed);
        context.method_51431(this.field_2035.field_1772, SlotAnimationState.lastSlotStacks[slotIndex], x, y);
        context.method_51448().method_22909();
        if (progress >= 1.0f) {
            SlotAnimationState.isShrinking[slotIndex] = false;
            SlotAnimationState.lastSlotStacks[slotIndex] = class_1799.field_8037;
            SlotAnimationState.lastSlotCounts[slotIndex] = 0;
            SlotAnimationState.slotScales[slotIndex] = ImmersiveHotbarConfig.nonSelectedItemSize;
        }
        ci.cancel();
        return true;
    }

    @Unique
    private void drawDurabilityGlow(class_1799 stack, class_332 context, int x, int y) {
        float percent;
        if (ImmersiveHotbarConfig.lowDurabilityGlow && stack.method_7963() && (percent = (float)stack.method_7919() / (float)stack.method_7936()) >= ImmersiveHotbarConfig.durabilityGlowThreshold) {
            float intensity = (percent - ImmersiveHotbarConfig.durabilityGlowThreshold) / (1.0f - ImmersiveHotbarConfig.durabilityGlowThreshold);
            intensity = Math.min(intensity, 1.0f);
            float baseAlpha = 0.6f + 0.4f * intensity;
            float maxPulse = 0.3f;
            if (percent >= 0.95f) {
                double pulse = Math.sin((double)System.currentTimeMillis() / 80.0);
                baseAlpha += maxPulse * (float)pulse;
            }
            float alpha = Math.min(Math.max(baseAlpha, 0.0f), 1.0f);
            int redGlow = (int)(alpha * 255.0f) << 24 | 0xFF0000;
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 100.0f);
            context.method_25294(x - 2, y - 2, x + 18, y, redGlow);
            context.method_25294(x - 2, y + 16, x + 18, y + 18, redGlow);
            context.method_25294(x - 2, y, x, y + 16, redGlow);
            context.method_25294(x + 16, y, x + 18, y + 16, redGlow);
            context.method_51448().method_22909();
        }
    }

    @Unique
    private void drawSlotBackground(class_332 context, int x, int y, boolean isSelected) {
        if (ImmersiveHotbarConfig.showBackground == ImmersiveHotbarConfig.shouldShowBackground.ENABLED || ImmersiveHotbarConfig.showBackground == ImmersiveHotbarConfig.shouldShowBackground.ONLY_WHEN_SELECTED && isSelected) {
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 50.0f);
            context.method_25294(x - 2, y - 2, x + 18, y + 18, ImmersiveHotbarConfig.hotbarSelectionColor.getRGB());
            context.method_51448().method_22909();
        }
    }

    @Unique
    private void drawItemStack(class_332 context, class_1657 player, class_1799 stack, int x, int y, int seed, int centerX, int centerY, int slotIndex) {
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)centerX, (float)centerY, 0.0f);
        context.method_51448().method_22905(SlotAnimationState.slotScales[slotIndex], SlotAnimationState.slotScales[slotIndex], SlotAnimationState.slotScales[slotIndex]);
        context.method_51448().method_46416((float)(-centerX), (float)(-centerY), 0.0f);
        context.method_51423((class_1309)player, stack, x, y, seed);
        context.method_51448().method_22909();
        context.method_51448().method_22903();
        if (ImmersiveHotbarConfig.textScales) {
            context.method_51448().method_46416((float)centerX, (float)centerY, 0.0f);
            context.method_51448().method_22905(SlotAnimationState.slotScales[slotIndex], SlotAnimationState.slotScales[slotIndex], SlotAnimationState.slotScales[slotIndex]);
            context.method_51448().method_46416((float)(-centerX), (float)(-centerY), 0.0f);
            context.method_51431(this.field_2035.field_1772, stack, x, y);
        } else {
            context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            context.method_51431(this.field_2035.field_1772, stack, x, y);
        }
        context.method_51448().method_22909();
    }
}

