/*
 * Decompiled with CFR 0.152.
 */
package derp.immersivehotbar;

import derp.immersivehotbar.config.ImmersiveHotbarConfig;
import derp.immersivehotbar.config.ImmersiveHotbarConfigHandler;
import derp.immersivehotbar.util.SlotAnimationState;
import derp.immersivehotbar.util.TooltipAnimationState;
import java.util.Arrays;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.event.client.player.ClientPlayerBlockBreakEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;

@Environment(value=EnvType.CLIENT)
public class ImmersiveHotbarClient
implements ClientModInitializer {
    private boolean wasUsingItem = false;
    private class_1799 lastUsedItem = class_1799.field_8037;
    private boolean wasCrossbowChargedMainhand = false;
    private boolean wasCrossbowChargedOffhand = false;
    public static final boolean IS_DOUBLEHOTBAR_LOADED = FabricLoader.getInstance().isModLoaded("double_hotbar");

    public void onInitializeClient() {
        ImmersiveHotbarConfigHandler.load();
        ClientPlayConnectionEvents.DISCONNECT.register((client, world) -> Arrays.fill(SlotAnimationState.lastSlotStacks, class_1799.field_8037));
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> TooltipAnimationState.reset());
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null) {
                return;
            }
            boolean isUsing = client.field_1724.method_6115();
            if (isUsing) {
                this.lastUsedItem = client.field_1724.method_6030();
            } else if (this.wasUsingItem && !this.lastUsedItem.method_7960()) {
                class_1792 item = this.lastUsedItem.method_7909();
                if (ImmersiveHotbarConfig.weaponAnimates && (item instanceof class_1753 || item instanceof class_1764)) {
                    int slot = client.field_1724.method_6047() == this.lastUsedItem ? client.field_1724.method_31548().field_7545 : 9;
                    this.triggerShrink(slot);
                }
                this.lastUsedItem = class_1799.field_8037;
            }
            this.wasUsingItem = isUsing;
            class_1799 mainHandStack = client.field_1724.method_6047();
            if (mainHandStack.method_7909() instanceof class_1764) {
                boolean isCharged = class_1764.method_7781((class_1799)mainHandStack);
                if (this.wasCrossbowChargedMainhand && !isCharged && ImmersiveHotbarConfig.weaponAnimates) {
                    int slot = client.field_1724.method_31548().field_7545;
                    this.triggerShrink(slot);
                }
                this.wasCrossbowChargedMainhand = isCharged;
            } else {
                this.wasCrossbowChargedMainhand = false;
            }
            class_1799 offHandStack = client.field_1724.method_6079();
            if (offHandStack.method_7909() instanceof class_1764) {
                boolean isCharged = class_1764.method_7781((class_1799)offHandStack);
                if (this.wasCrossbowChargedOffhand && !isCharged && ImmersiveHotbarConfig.weaponAnimates) {
                    this.triggerShrink(9);
                }
                this.wasCrossbowChargedOffhand = isCharged;
            } else {
                this.wasCrossbowChargedOffhand = false;
            }
        });
        ClientPlayerBlockBreakEvents.AFTER.register((world, player, pos, state) -> {
            class_1799 stack = player.method_6047();
            if (stack.method_7909() instanceof class_1831 && ImmersiveHotbarConfig.toolAnimates) {
                int slot = player.method_31548().field_7545;
                this.triggerShrink(slot);
            }
        });
    }

    private void triggerShrink(int slot) {
        if (slot >= 0 && slot < 9) {
            SlotAnimationState.wasUsed[slot] = true;
            SlotAnimationState.slotScales[slot] = ImmersiveHotbarConfig.nonSelectedItemSize - (ImmersiveHotbarConfig.shouldItemGrowWhenSelected ? 0.03f : 0.2f);
        } else if (slot == 9) {
            SlotAnimationState.wasUsed[slot] = true;
            SlotAnimationState.slotScales[slot] = ImmersiveHotbarConfig.nonSelectedItemSize - 0.2f;
        }
    }
}

