/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.features.egg;

import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.cobblemon.mod.common.api.pokemon.Natures;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.Nature;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import java.util.List;
import ludichat.cobbreeding.PokemonEgg;
import me.justahuman.more_cobblemon_tweaks.config.ModConfig;
import me.justahuman.more_cobblemon_tweaks.features.LoreEnhancements;
import me.justahuman.more_cobblemon_tweaks.features.egg.EncryptedEggLore;
import me.justahuman.more_cobblemon_tweaks.features.egg.EnhancedEggLore;
import me.justahuman.more_cobblemon_tweaks.utils.Utils;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class CobbreedingIntegration
extends EnhancedEggLore {
    private final PokemonProperties properties;
    private final IVs ivs;

    public CobbreedingIntegration(String eggInfo) {
        this(PokemonProperties.Companion.parse(eggInfo));
    }

    public CobbreedingIntegration(PokemonProperties properties) {
        this.properties = properties;
        this.ivs = properties.getIvs();
    }

    @Override
    public class_2561 getName(List<class_2561> lore) {
        if (lore.size() > 2) {
            String name = lore.remove(1).getString();
            if (name.equals("Bad egg")) {
                return class_2561.method_43470((String)"Bad Egg");
            }
            return class_2561.method_43470((String)(name + " Egg"));
        }
        return super.getName(lore);
    }

    @Override
    public boolean isShiny() {
        return Boolean.TRUE.equals(this.properties.getShiny());
    }

    @Override
    public String getGender() {
        Gender gender = this.properties.getGender();
        return gender == null ? null : gender.name();
    }

    @Override
    public List<class_2561> getHatchProgress(List<class_2561> lore) {
        String hatchProgress;
        String[] parts;
        if (lore.size() > 1 && (parts = (hatchProgress = lore.get(1).getString()).split(":")).length == 2) {
            try {
                int minutes = Integer.parseInt(parts[0].trim());
                int seconds = Integer.parseInt(parts[1].trim());
                lore.remove(1);
                return List.of(LoreEnhancements.translate("egg.cobbreeding.hatch_progress", minutes, seconds));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getNature() {
        String natureId = this.properties.getNature();
        if (natureId == null) {
            return null;
        }
        class_2960 id = natureId.contains(":") ? class_2960.method_12829((String)natureId) : MiscUtilsKt.cobblemonResource((String)natureId);
        Nature nature = id == null ? null : Natures.getNature((class_2960)id);
        return nature == null ? null : class_2561.method_43471((String)nature.getDisplayName()).getString();
    }

    @Override
    public String getAbility() {
        String abilityId = this.properties.getAbility();
        AbilityTemplate ability = abilityId == null ? null : Abilities.get((String)abilityId);
        return ability == null ? null : class_2561.method_43471((String)ability.getDisplayName()).getString();
    }

    @Override
    public String getForm() {
        return null;
    }

    @Override
    public String getPokeBall() {
        String pokeBallId = this.properties.getPokeball();
        return pokeBallId == null ? null : this.pokeBallFromId(pokeBallId);
    }

    @Override
    public boolean hasIVs() {
        if (this.ivs == null) {
            return false;
        }
        return this.getHpIV() != null || this.getAtkIV() != null || this.getDefIV() != null || this.getSpAtkIV() != null || this.getSpDefIV() != null || this.getSpeedIV() != null;
    }

    @Override
    public Integer getHpIV() {
        return this.ivs.get((Stat)Stats.HP);
    }

    @Override
    public Integer getAtkIV() {
        return this.ivs.get((Stat)Stats.ATTACK);
    }

    @Override
    public Integer getDefIV() {
        return this.ivs.get((Stat)Stats.DEFENCE);
    }

    @Override
    public Integer getSpAtkIV() {
        return this.ivs.get((Stat)Stats.SPECIAL_ATTACK);
    }

    @Override
    public Integer getSpDefIV() {
        return this.ivs.get((Stat)Stats.SPECIAL_DEFENCE);
    }

    @Override
    public Integer getSpeedIV() {
        return this.ivs.get((Stat)Stats.SPEED);
    }

    public static EnhancedEggLore get(class_1799 itemStack) {
        block7: {
            if (itemStack.method_7909() instanceof PokemonEgg) {
                try {
                    if (itemStack.method_57826(PokemonEgg.Companion.getVERSION())) {
                        if (itemStack.method_57826(PokemonEgg.Companion.getPOKEMON_PROPERTIES())) {
                            return new CobbreedingIntegration((String)itemStack.method_57824(PokemonEgg.Companion.getPOKEMON_PROPERTIES()));
                        }
                        if (itemStack.method_57826(PokemonEgg.Companion.getEGG_INFO()) && ModConfig.isEnabled("egg_encryption_warning")) {
                            return new EncryptedEggLore(List.of(LoreEnhancements.translate("egg.cobbreeding_encryption_warning" + (Utils.isSinglePlayer() ? "_singleplayer" : ""), new Object[0]).method_27692(class_124.field_1061)));
                        }
                    }
                }
                catch (NoSuchMethodError e) {
                    if (itemStack.method_57826(PokemonEgg.Companion.getEGG_INFO()) && CobbreedingIntegration.isString(itemStack.method_57824(PokemonEgg.Companion.getEGG_INFO()))) {
                        return new CobbreedingIntegration((String)itemStack.method_57824(PokemonEgg.Companion.getEGG_INFO()));
                    }
                    if (!itemStack.method_57826(PokemonEgg.Companion.getPOKEMON_PROPERTIES())) break block7;
                    return new CobbreedingIntegration((String)itemStack.method_57824(PokemonEgg.Companion.getPOKEMON_PROPERTIES()));
                }
            }
        }
        return null;
    }

    private static boolean isString(Object value) {
        return value instanceof String;
    }
}

