/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.features;

import java.awt.Color;
import java.util.List;
import me.justahuman.more_cobblemon_tweaks.config.ModConfig;
import me.justahuman.more_cobblemon_tweaks.features.egg.EnhancedEggLore;
import me.justahuman.more_cobblemon_tweaks.utils.Utils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.apache.commons.lang3.StringUtils;

public class LoreEnhancements {
    private static final String BASE_KEY = "more_cobblemon_tweaks.lore_enhancements.";

    public static void enhanceEggLore(List<class_2561> lore, List<class_2561> newLore, EnhancedEggLore enhancedEggLore) {
        class_2561 name = enhancedEggLore.getName(lore);
        boolean shiny = ModConfig.isEnabled("shiny_egg_indicator") && enhancedEggLore.isShiny();
        boolean perfect = ModConfig.isEnabled("perfect_iv_egg_indicator") && enhancedEggLore.hasIVs(31);
        boolean minimum = ModConfig.isEnabled("minimum_iv_egg_indicator") && enhancedEggLore.hasIVs(0);
        boolean textIndicators = ModConfig.isEnabled("text_egg_indicators");
        if (shiny && !textIndicators) {
            name = name.method_27661().method_10852((class_2561)LoreEnhancements.translate("egg.shiny.symbol", new Object[0]).method_27692(class_124.field_1054));
        }
        if (perfect && !textIndicators) {
            name = name.method_27661().method_10852((class_2561)LoreEnhancements.translate("egg.perfect.symbol", new Object[0]).method_27692(class_124.field_1075));
        } else if (minimum && !textIndicators) {
            name = name.method_27661().method_10852((class_2561)LoreEnhancements.translate("egg.minimum.symbol", new Object[0]).method_27692(class_124.field_1061));
        }
        String gender = enhancedEggLore.getGender();
        if (gender != null && (gender.equals("MALE") || gender.equals("FEMALE"))) {
            boolean male = gender.equals("MALE");
            name = name.method_27661().method_10852((class_2561)class_2561.method_43470((String)(male ? " \u2642" : " \u2640")).method_27694(style -> style.method_36139(male ? 3329023 : 16536660)));
        }
        lore.set(0, name);
        if (shiny && textIndicators) {
            newLore.add((class_2561)LoreEnhancements.translate("egg.shiny.text", new Object[0]).method_27692(class_124.field_1054));
            newLore.add((class_2561)class_2561.method_43470((String)" "));
        }
        List<class_2561> hatchProgress = enhancedEggLore.getHatchProgress(lore);
        boolean spacer = false;
        if (hatchProgress != null && !hatchProgress.isEmpty()) {
            newLore.addAll(hatchProgress);
            spacer = true;
        }
        String nature = enhancedEggLore.getNature();
        String abilityName = enhancedEggLore.getAbility();
        String form = enhancedEggLore.getForm();
        String pokeBall = enhancedEggLore.getPokeBall();
        if ((nature != null || abilityName != null || form != null || pokeBall != null) && spacer) {
            newLore.add((class_2561)class_2561.method_43470((String)" "));
            spacer = false;
        }
        if (nature != null) {
            if (nature.contains(":")) {
                nature = StringUtils.capitalize((String)nature.substring(nature.indexOf(58) + 1));
            }
            newLore.add((class_2561)LoreEnhancements.translate("egg.nature", new Object[0]).method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)nature).method_27692(class_124.field_1068)));
            spacer = true;
        }
        if (abilityName != null) {
            newLore.add((class_2561)LoreEnhancements.translate("egg.ability", new Object[0]).method_54663(new Color(16766976).getRGB()).method_10852((class_2561)class_2561.method_43470((String)StringUtils.capitalize((String)abilityName)).method_27692(class_124.field_1068)));
            spacer = true;
        }
        if (form != null) {
            newLore.add((class_2561)LoreEnhancements.translate("egg.form", new Object[0]).method_54663(new Color(0xFFBB00).getRGB()).method_10852((class_2561)class_2561.method_43470((String)StringUtils.capitalize((String)form)).method_27692(class_124.field_1068)));
            spacer = true;
        }
        if (pokeBall != null) {
            newLore.add((class_2561)LoreEnhancements.translate("egg.pokeball", new Object[0]).method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)StringUtils.capitalize((String)pokeBall)).method_27692(class_124.field_1068)));
            spacer = true;
        }
        if (enhancedEggLore.hasIVs()) {
            Integer hp = enhancedEggLore.getHpIV();
            Integer attack = enhancedEggLore.getAtkIV();
            Integer defense = enhancedEggLore.getDefIV();
            Integer spAttack = enhancedEggLore.getSpAtkIV();
            Integer spDefense = enhancedEggLore.getSpDefIV();
            Integer speed = enhancedEggLore.getSpeedIV();
            if (spacer) {
                newLore.add((class_2561)class_2561.method_43470((String)" "));
            }
            Integer sum = null;
            if (hp != null && hp != -1) {
                newLore.add((class_2561)LoreEnhancements.iv("hp", class_124.field_1060, hp.intValue()));
                sum = hp;
            }
            if (attack != null && attack != -1) {
                newLore.add((class_2561)LoreEnhancements.iv("attack", class_124.field_1061, attack.intValue()));
                sum = sum == null ? attack : sum + attack;
            }
            if (defense != null && defense != -1) {
                newLore.add((class_2561)LoreEnhancements.iv("defense", class_124.field_1065, defense.intValue()));
                sum = sum == null ? defense : sum + defense;
            }
            if (spAttack != null && spAttack != -1) {
                newLore.add((class_2561)LoreEnhancements.iv("sp_attack", class_124.field_1076, spAttack.intValue()));
                sum = sum == null ? spAttack : sum + spAttack;
            }
            if (spDefense != null && spDefense != -1) {
                newLore.add((class_2561)LoreEnhancements.iv("sp_defense", class_124.field_1054, spDefense.intValue()));
                sum = sum == null ? spDefense : sum + spDefense;
            }
            if (speed != null && speed != -1) {
                newLore.add((class_2561)LoreEnhancements.iv("speed", class_124.field_1075, speed.intValue()));
                sum = sum == null ? speed : sum + speed;
            }
            if (sum != null) {
                double average = (double)sum.intValue() / 6.0;
                newLore.add((class_2561)LoreEnhancements.iv("average", class_124.field_1068, average));
            }
            if (perfect && textIndicators) {
                newLore.add((class_2561)LoreEnhancements.translate("egg.perfect.text", new Object[0]).method_27692(class_124.field_1068));
            } else if (minimum && textIndicators) {
                newLore.add((class_2561)LoreEnhancements.translate("egg.minimum.text", new Object[0]).method_27692(class_124.field_1068));
            }
        }
    }

    public static class_5250 iv(String stat, class_124 color, double iv) {
        return LoreEnhancements.translate("egg.iv." + stat, new Object[0]).method_27692(color).method_10852((class_2561)class_2561.method_43470((String)(class_437.method_25442() ? Utils.ivPercent(iv) : Integer.toString((int)iv))).method_27692(class_124.field_1068));
    }

    public static class_5250 translate(String key, Object ... args) {
        return class_2561.method_43469((String)(BASE_KEY + key), (Object[])args);
    }
}

